<%--
 * Copyright 2016 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<jsp:include page="/jsp/hardware/HardwareSpecTemplate.jsp"/>

<jsp:include page="/jsp/common/template/ActionMessages.jsp"/>

<%-- Show hardware search form. --%>
<form action="${formSearchAction}" id="hardwareMemberForm" method="post" onsubmit="return false;">
<html:hidden name="form" property="hardwareId"/>
<input type="hidden" name="searchType" value="hardwareId"/>
<table class="standard listTable">
    <tr class="themeHeader">
        <td colspan="2"><b><k:message key="hardware.cmd.hardwareMemberAdd"/></b></td>
    </tr>
    <tr>
        <th><k:message key="itMgmt.index.searchHeader"/>:</th>
        <td><k:message key="common.column.hardware_id"/>&nbsp;<input type="text" name="searchPhrase" autofocus>
            <div id="hardwareSelectList"></div>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td>
            <button type="button" name="save" disabled onclick="App.submitFormUpdate(this.form, {'url': '${formSaveAction}', 'disable': this})"}><k:message key="form.button.save"/></button>
            ${formCancelLink}
        </td>
    </tr>
</table>
</form>

<script type="text/javascript">
var formElem = document.forms['hardwareMemberForm'];

var autosuggestInst = Js.AutoSuggest.newInstance();

autosuggestInst.formField = formElem.elements['searchPhrase'];
autosuggestInst.setFunction(function(formElem) {
        document.forms['hardwareMemberForm'].elements['save'].disabled = true;
        App.submitFormUpdate(formElem, {loadElemId: 'hardwareSelectList', targetElemId: 'hardwareSelectList', allowResubmit: true});
    }, formElem
);

function enableSave() {
	document.forms['hardwareMemberForm'].elements['data-form-submit-disabled'] = null;
	
	var disabled = !document.getElementById('hardwareMemberForm').elements['formSelectedHardwareId'].checked;
    document.forms['hardwareMemberForm'].elements['save'].disabled = disabled;
}

</script>
