<%--
 * Copyright 2015 Kwoksys
 *
 * http://www.kwoksys.com/LICENSE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
--%>
<%@ taglib uri="http://www.kwoksys.com/tags" prefix="k" %>

<k:define id="customFieldsTemplate" name="CustomFieldsTemplate" type="com.kwoksys.action.common.template.CustomFieldsTemplate"/>
<k:define id="customFields" name="customFieldsTemplate" property="customFields"/>

<jsp:include page="/jsp/issues/IssueSpecTemplate.jsp"/>

<jsp:include page="/jsp/common/template/CustomFieldsTableToggle.jsp"/>

<jsp:include page="/jsp/common/template/Tabs.jsp"/>

<table class="standard listTable stripedList">
    <tr class="themeHeader">
        <th class="rownum">#</th><th><k:message key="issueMgmt.issueDetail.historyModifierHeader"/></th>
        <th>${issueChangeCreationDateHeader}</th><th><k:message key="issueMgmt.issueDetail.historyCommentHeader"/></th>
    </tr>

    <k:notEmpty name="issueHistoryList">
        <k:foreach id="row" name="issueHistoryList" indexId="index">
            <tr class="dataRow">
                <td><k:write value="${row.rownum}"/></td>
                <td width="20%" colspan="2">
                    ${row.changeCreator}
                    <k:if test="${row.changeCreatorEmail != null}">
                        <br>(<k:write value="${row.changeCreatorEmail}"/>)
                    </k:if>
                    <br><k:write value="${row.changeCreationDate}"/>
                </td>
                <td width="80%">
                <k:if test="${row.changeComment != null}">
                    ${row.changeComment}<p>
                </k:if>
                <k:if test="${row.changeFile != null}">
                    ${row.changeFile}<br>
                </k:if>
                <k:if test="${row.changeSubject != null}">
                    ${row.changeSubject}<br>
                </k:if>
                <k:if test="${row.changeType != null}">
                    ${row.changeType}<br>
                </k:if>
                <k:if test="${row.changeStatus != null}">
                    ${row.changeStatus}<br>
                </k:if>
                <k:if test="${row.changePriority != null}">
                    ${row.changePriority}<br>
                </k:if>
                <k:if test="${row.changeResolution != null}">
                    ${row.changeResolution}<br>
                </k:if>
                <k:if test="${row.changeAssignee != null}">
                    ${row.changeAssignee}<br>
                </k:if>
            </td></tr>
        </k:foreach>
    </k:notEmpty>
    <%-- Show some message when there is no data --%>
    <k:isEmpty name="issueHistoryList">
        <jsp:include page="/jsp/common/template/TableEmpty.jsp"/>
    </k:isEmpty>
</table>
