<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

	/*
 *	@author 	: Red Planet Computer Team
 *	date		: 30 May, 2017
 *	Laundry Management System
 *	rpcits2013@gmail.com
 
	 * This source code not use without licenses and permission for Red Planet Computers. http://laundry.redplanetcomputers.com
	*/
 
	public function __construct()
    {   parent::__construct();
        $this->load->helper(array('form','url','html'));
        $this->load->library(array('session', 'form_validation','googlemaps'));
        $this->load->database();
      	$this->output->set_header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT');
        $this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');
        $this->output->set_header("Expires: Sat, 11 Jun 1983 05:00:00 GMT");
		
    }
	
	public function index()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','dashboard');
		
		$this->db->from('customer_order');
		$this->db->order_by("total_paid", "desc");
		$desktop['order_data'] = $this->db->get();
		
		$desktop['userdata'] = $this->db->get('users');
		$desktop['today']=date('d-m-Y');
		$this->load->view('admin/header');
		$this->load->view('admin/main',$desktop);
		$this->load->view('admin/footer');
	}
	
	
	// Customer Controller = = >
	
	function customers()
	{	
		if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		
		$this->session->set_userdata('menu','master');
		$this->session->set_userdata('submenu','customers');
		$data['userdata'] = $this->db->get('users');
		$data['last_id']=0;	
		$result=$this->db->select('*')->from('users')->order_by('id',"desc")->limit(1)->get()->result();
		if (count($result) > 0)	$data['last_id'] = $result[0]->id;
		$this->load->view('admin/users',$data);
	}
	
	// customer Profile Controller --->
	
	function customer_profile($CustID='')
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		
		$this->session->set_userdata('menu','master');
		$this->session->set_userdata('submenu','customers');
		
		$UserID=$CustID;
		$data['userdata'] = $this->db->get_where('users' , array('id' => $UserID) );
		
		//$data['userdata'] = $this->db->get('users');
		$this->load->view('admin/customer_profile',$data);
		
	}
	
	
	function customer_crud($param1='', $param2='')
	{	if($param1=='create')
		{	$join_date=$this->input->post('join_date');
			$first_name=ucwords($this->input->post('first_name'));
			$last_name=ucwords($this->input->post('last_name'));
			$email_id=$this->input->post('email');
			$phone=$this->input->post('phone');
			$daddress=$this->input->post('address');
			$password=$this->input->post('password');
			$status=$this->input->post('status');
			
			$customer_data = array('join_date' => $join_date, 'first_name' => $first_name, 'last_name' => $last_name, 'address1' => $daddress, 'email_id' => $email_id, 'mobile' => $phone, 'password' => $password, 'status' => $status);
			if($this->db->insert('users', $customer_data)===TRUE)		// using direct parameter
			{
			?>
			<script> alert("Record Added Successfully"); </script>
			<?php
			redirect('admin/customers','refresh');
			}	
		}
		
		if($param1=='do_update')
		{	$query['custmoer_edit'] = $this->db->get_where('users' , array('id' => $param2) )->result();
			$this->load->view('admin/customer_update',$query);
		}

		if($param1=='modify')
		{	redirect('admin/disable_demo','refresh');
		}
		
		
				
		if($param1=='delete')
		{	echo '<script> alert(" Record Deleted Successfully"); </script>';
			
			redirect('admin/customers','refresh');
				
		}
	}
	
		
	
	
	
	// Employee Controller = = >
	
	function employee()
	{
		if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		
		$this->session->set_userdata('menu','master');
		$this->session->set_userdata('submenu','employee');
		$data['empdata'] = $this->db->get('employee');
		$data['last_id']=0;	
		$result=$this->db->select('*')->from('employee')->order_by('emp_id',"desc")->limit(1)->get()->result();
		if (count($result) > 0)	$data['last_id'] = $result[0]->emp_id;
		$this->load->view('admin/employee',$data);
	}
	
	function employee_crud($param1='', $param2='')
	{	if($param1=='new')
		{	$join_date=$this->input->post('join_date');
			$first_name=ucwords($this->input->post('first_name'));
			$last_name=ucwords($this->input->post('last_name'));
			$email_id=$this->input->post('email');
			$gender=$this->input->post('gender');
			$birth_date=$this->input->post('birth_date');
			$phone=$this->input->post('phone');
			$address=$this->input->post('address');
			$password=$this->input->post('password');
			$status=$this->input->post('status');
			
			$database_data = array('join_date' => $join_date, 'first_name' => $first_name, 'last_name' => $last_name, 'mobile' => $phone, 'email_id' => $email_id, 'emp_add1' => $address,  'birth_date' => $birth_date,  'gender' => $gender, 'password' => $password, 'status' => $status);
			if($this->db->insert('employee', $database_data)===TRUE)		// using direct parameter
			{
			?>
			<script> alert("Employee Added Successfully"); </script>
			<?php
			redirect('admin/employee','refresh');
			}	
		}
		
		if($param1=='do_update')
		{	$query['employee_edit'] = $this->db->get_where('employee' , array('emp_id' => $param2) )->result();
			$this->load->view('admin/employee_update',$query);
		}
		
		if($param1=='modify')
		{	redirect('admin/disable_demo','refresh');
		}		
		if($param1=='delete')
		{	
			echo '<script> alert(" Record Deleted Successfully"); </script>';
			redirect('admin/employee','refresh');
				
		}
	}
	
	// Cloth Controller ==>
	function cloth_type()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','services');
		$this->session->set_userdata('submenu','cloths');
		$data['cloth'] = $this->db->get('cloths');
		$data['last_id']=0;	
		$result=$this->db->select('*')->from('cloths')->order_by('id',"desc")->limit(1)->get()->result();
		if (count($result) > 0)	$data['last_id'] = $result[0]->id;
		$this->load->view('admin/cloth',$data);
	}
	
	function cloth_crud($param1='', $param2='')
	{	if($param1=='create')
		{	$cloth_type=$this->input->post('cloth_name');
			$cloth_code=$this->input->post('cloth_code');
			$data = array('cloth_type' => $cloth_type, 'cloth_code' => $cloth_code );
			if($this->db->insert('cloths', $data)===TRUE)		// using direct parameter
			{
			?>
			<script> alert(" Record Added Successfully"); </script>
			<?php
			redirect('admin/cloth_type','refresh');
			}	
		}
		
		if($param1=='do_update')
		{	$query['cloths_edit'] = $this->db->get_where('cloths' , array('id' => $param2) )->result();
			$this->load->view('admin/cloths_update',$query);
		}

		if($param1=='modify')
		{	redirect('admin/disable_demo','refresh');
		}
		
		
		if($param1=='delete')
		{	echo '<script> alert(" Record Deleted Successfully"); </script>';
			redirect('admin/cloth_type','refresh');
				
		}
	}
	
	// Expeses Type Controller ==>
	
	function expenses_type()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','services');
		$this->session->set_userdata('submenu','expensestype');
		$data['expenstype'] = $this->db->get('expense_type');
		$data['last_id']=0;	
		$result=$this->db->select('*')->from('expense_type')->order_by('exps_id',"desc")->limit(1)->get()->result();
		if (count($result) > 0)	$data['last_id'] = $result[0]->exps_id;
		$this->load->view('admin/expenses_type',$data);
	}
	
	function expenses_crud($param1='', $param2='')
	{	if($param1=='create')
		{	$expse_type=$this->input->post('expse_type');
			$expse_code=$this->input->post('expse_code');
			$data = array('exps_type' => $expse_type, 'exps_code' => $expse_code );
			if($this->db->insert('expense_type', $data)===TRUE)		// using direct parameter
			{
			?>
			<script> alert(" Record Added Successfully"); </script>
			<?php
			redirect('admin/expenses_type','refresh');
			}	
		}
		
		if($param1=='do_update')
		{	$query['exps_edit'] = $this->db->get_where('expense_type' , array('exps_id' => $param2) )->result();
			$this->load->view('admin/exps_type_update',$query);
		}

		if($param1=='modify')
		{	redirect('admin/disable_demo','refresh');
		}
		
		if($param1=='delete')
		{	echo '<script> alert(" Record Deleted Successfully"); </script>';
			redirect('admin/expenses_type','refresh');
				
		}
	}

	// Services Controller ==>
	function laundry_services()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','services');
		$this->session->set_userdata('submenu','services');
		$data['service'] = $this->db->get('services');
		$data['last_id']=0;	
		$result=$this->db->select('*')->from('services')->order_by('id',"desc")->limit(1)->get()->result();
		if (count($result) > 0)	$data['last_id'] = $result[0]->id;
		$this->load->view('admin/services',$data);
	}
	
	function service_crud($param1='', $param2='')
	{	if($param1=='create')
		{	$service_name=$this->input->post('service_name');
			$service_code=$this->input->post('service_code');
			$data = array('service_name' => $service_name, 'service_code' => $service_code );
			if($this->db->insert('services', $data)===TRUE)		// using direct parameter
			{
			?>
			<script> alert(" Record Added Successfully"); </script>
			<?php
			redirect('admin/laundry_services','refresh');
			}	
		}
		
		if($param1=='do_update')
		{	$Serviice['service_edit'] = $this->db->get_where('services' , array('id' => $param2) )->result();
			$this->load->view('admin/service_update',$Serviice);
		}
		
		if($param1=='modify')
		{	redirect('admin/disable_demo','refresh');
		}
				
		if($param1=='delete')
		{	echo '<script> alert(" Record Deleted Successfully"); </script>';
			redirect('admin/laundry_services','refresh');
				
		}
	}
	
	
	// Assing Cloth Service Prices --->
	
	function cloth_prices()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','dashboard');
		$this->session->set_userdata('submenu','');
		
		$this->load->view('admin/price_list');
	}

	function check_item()
	{			
		$short_code=$this->input->post('productcode');
		$data=$this->db->get_where('price_list' , array('id' => $short_code) )->result();
		foreach($data as $datarow)
		{
			 //echo $datarow->service_id;			 
			 $return_data['service']=$datarow->service_id;			 
			 $return_data['cloth']=$datarow->cloth_id;			 
		}
		echo json_encode($return_data);exit;
	}
	// Exepnsese List ----------->
	
	function expenses()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','job_order');
		$this->session->set_userdata('submenu','expenses');
		$data['expensetype'] = $this->db->get('expense_type');
		$data['expenses'] = $this->db->get('expenses');
		$data['last_id']=0;	
		$result=$this->db->select('*')->from('expenses')->order_by('exp_id',"desc")->limit(1)->get()->result();
		if (count($result) > 0)	$data['last_id'] = $result[0]->exp_id;
		$this->load->view('admin/expenses_list',$data);
	}
	
	function expense_crud($param1='', $param2='')
	{	if($param1=='create')
		{	$ExpDate=$this->input->post('exp_date');
			$PayeeName=$this->input->post('payee_name');
			$ExpType=$this->input->post('exp_type');
			$ExpAmt=$this->input->post('exp_amt');
			$ExpAmtPaidBy=$this->input->post('exp_amt_paid_by');
			$ExpChequeNo=$this->input->post('exp_cheque_no');
			$ExpChequeDate=$this->input->post('exp_cheque_date');
			$ExpRemark=$this->input->post('exp_remark');
			
			$data = array('exps_date' => $ExpDate, 'exp_payee_name' => $PayeeName, 'exp_type' => $ExpType, 'exp_amt' => $ExpAmt, 'exp_paidby' => $ExpAmtPaidBy, 'exp_chequeno' => $ExpChequeNo, 'exp_cheque_date' => $ExpChequeDate, 'exp_remarks' => $ExpRemark );
			if($this->db->insert('expenses', $data)===TRUE)		// using direct parameter
			{
			?>
			<script> alert(" Record Added Successfully"); </script>
			<?php
			redirect('admin/expenses','refresh');
			}	
		}
		
		if($param1=='do_update')
		{	
			$query['expensetype'] = $this->db->get('expense_type');
			$query['expenses_edit'] = $this->db->get_where('expenses' , array('exp_id' => $param2) )->result();
			$this->load->view('admin/expenses_edit',$query);
		}
		
		if($param1=='modify')
		{	redirect('admin/disable_demo','refresh');
		}
		
		if($param1=='delete')
		{	echo '<script> alert(" Record Deleted Successfully"); </script>';
			redirect('admin/expenses','refresh');
				
		}
	}
	
	// Invoice Orders

	function customer_orders($order1='',$order2='')
	{	
		if($order1=='invoice_list')
		{
			$this->session->set_userdata('order_date','');
			$this->session->set_userdata('party_name','');
			$this->session->set_userdata('menu','job_order');
			$this->session->set_userdata('submenu','invoicelist');
			$data['userdata'] = $this->db->get('users');
			$this->db->order_by('auto_id desc');
			$data['invoiceorder'] = $this->db->get('customer_order');
			$data['view'] = $order2;
			$this->load->view('admin/customer_invoice_list',$data);
			
		}

		if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		
		$this->session->set_userdata('menu','job_order');
		$this->session->set_userdata('submenu','neworder');
		
		if($order1=='neworder')
		{
			$data['partyname'] = $this->db->get('users');
			
			$this->load->view('admin/customer_order_party_name',$data);
			
		}

		if($order1=='session_partyname')
		{	
			$Order_Date = $this->input->post('order_date');
			$Order_Date = date('Y-m-d',strtotime($Order_Date));
			$Party_Name = $this->input->post('party_name');
			$this->session->set_userdata('order_date',$Order_Date);
			$this->session->set_userdata('party_name',$Party_Name);
			redirect('admin/customer_orders/add_order','refresh');
		}		
			
		if($order1=='add_order')
		{	
			$session['price_data'] = $this->db->get('price_list');
			$session['laundry_service'] = $this->db->get('services');
			$session['laundry_cloth'] = $this->db->get('cloths');
			$session['Order_Date']=$this->session->userdata('order_date');
			$session['Party_Name']=$this->session->userdata('party_name');
			
			$Order_Date=$this->session->userdata('order_date');
			$Party_Name=$this->session->userdata('party_name');
			
			
			$session['userdata'] = $this->db->get('users');
			$session['order_temp'] = $this->db->get_where('order_temp' , array('order_date' => $Order_Date,'customer_id' => $Party_Name) )->result();
			
			$session['last_id']=0;	
			$result=$this->db->select('*')->from('customer_order')->order_by('auto_id',"desc")->limit(1)->get()->result();
			if (count($result) > 0)	$session['last_id'] = $result[0]->auto_id;
		
			
			$this->load->view('admin/customer_order',$session);
			
		}

		if($order1=='add_item')
		{
			$data['price_data'] = $this->db->get('price_list');
			$data['laundry_service'] = $this->db->get('services');
			$data['laundry_cloth'] = $this->db->get('cloths');
			$data['UpdateOrder'] = $order2;
			$this->load->view('admin/add_item',$data);
		}

		if($order1=='add_item_order')
		{
			
			$OrderDateTemp=$this->session->userdata('order_date');
			$PartyNameTemp=$this->session->userdata('party_name');
			
			$Short_ID = $this->input->post('short_code');
						
			$ItemData = $this->db->get_where('price_list' , array('id' => $Short_ID) )->result();
			
			foreach($ItemData as $ItemRow) :
			{
				//Service Name
				$ServiceID=$ItemRow->service_id;
				$ServiceData = $this->db->get_where('services' , array('id' => $ServiceID) )->result();
				foreach($ServiceData as $ServiceRow) :
				{
					$ItemServiceName=$ServiceRow->service_name;
				}
				endforeach;
				
				//Cloth Name
				$ClothID=$ItemRow->cloth_id;
				$ClothData = $this->db->get_where('cloths' , array('id' => $ClothID) )->result();
				foreach($ClothData as $ClothRow) :
				{
					$ItemClothType=$ClothRow->cloth_type;
				}
				endforeach;
				
				//Cloth Price
				$ItemPrice=$ItemRow->price;
				
			}
			endforeach;
			
			$Qty = $this->input->post('qty');
			
			$order = array('order_date' => $OrderDateTemp, 'customer_id' => $PartyNameTemp, 'price_shortcode' => $Short_ID, 'order_service' => $ItemServiceName, 'order_cloth' => $ItemClothType, 'order_qty' => $Qty, 'order_price' => $ItemPrice);
			if($this->db->insert('order_temp', $order)===TRUE)		// using direct parameter
			{
					redirect('admin/customer_orders/add_order','refresh');
			}	
		
		}

		if($order1=='delete_item_order')
		{	
			$this->db->where('order_id' , $order2);
            if($this->db->delete('order_temp')===TRUE)		// using direct parameter
			{
			redirect('admin/customer_orders/add_order','refresh');
			}
		}
		if($order1=='insert_order_final')
		{
			redirect('admin/disable_demo','refresh');
		}
		
		
		if($order1=='update_order')
		{	redirect('admin/disable_demo','refresh');
		}	

		if($order1=='delete_order')
		{	$this->db->where('auto_id' , $order2);
            if($this->db->delete('customer_order')===TRUE)		// using direct parameter
			{
			redirect('admin/customer_orders/invoice_list','refresh');
			}	
		}

		if($order1=='invoice_order')
		{				
			$Invoice['customer_data'] = $this->db->get('users');
			$Invoice['price_data'] = $this->db->get('price_list');
			$Invoice['laundry_service'] = $this->db->get('services');
			$Invoice['laundry_cloth'] = $this->db->get('cloths');
			
			$Invoice['order_data'] = $this->db->get_where('customer_order' , array('auto_id' => $order2) )->result();
			$this->load->view('admin/customer_invoice',$Invoice);
		}

	} 

	// Order Report Controller --->
	
	function orderreport($report='',$report2='')
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','reports');
		
		if($report=='date_view')
		{	
			$this->session->set_userdata('submenu','daterep');
			
			  $Today=date('01-07-2017');
			  $data['fromdate']=$Today;
			  $data['todate']=$Today;
			
			$this->session->set_userdata('order_date','');
			$this->session->set_userdata('party_name','');

			$FromDate=$Today;
			$ToDate=date('j-m-Y');
			
			$data['userdata'] = $this->db->get('users');
			
			  if(isset($_POST['from_date']))
			  {
			  $FromDate = $this->input->post('from_date');	
			  $ToDate = $this->input->post('to_date');
			  }	
			  $data['fromdate']=$FromDate;
			  $data['todate']=$ToDate;
			
			
			$this->db->where('order_date BETWEEN "'. date('Y-m-d', strtotime($FromDate)). '" and "'. date('Y-m-d', strtotime($ToDate)).'"');
			
			$data['invoiceorder'] = $this->db->get('customer_order');
			
			$this->load->view('admin/reports_invoice_list',$data);
		}
		
		if($report=='month_view')
		{	
			$this->session->set_userdata('submenu','monthrep');
			
			  $Month=date('M');
			  $data['mont']=$Month;
			
			
			$this->session->set_userdata('order_date','');
			$this->session->set_userdata('party_name','');
			
			$data['userdata'] = $this->db->get('users');
			
			$Monthsel = $this->input->post('month');	
			$data['mont']=$Monthsel;
			  
			
			
			$data['invoiceorder'] = $this->db->get_where('customer_order' , array('order_month' => $Monthsel) );
			
			$this->load->view('admin/reports_invoice_month_list',$data);
		}
		
		
		
	}
	
	// Admin Profile Controller --->
	
	function profile()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','settings');
		$this->session->set_userdata('submenu','adminprofile');
		$data['admindata'] = $this->db->get('admin');
		$this->load->view('admin/admin_profile',$data);
		
	}
	
	function edit_profile($id="")
	{	
		$data['admindata'] = $this->db->get('admin');
		$this->load->view('admin/edit_profile',$data);
		
	}
	
	function systemset()
	{	if ($this->session->userdata('admin_login') == 0) redirect('login/logout');
		$this->session->set_userdata('menu','settings');
		$this->session->set_userdata('submenu','sysset');
		$sdata['sysdata'] = $this->db->get('settings');
		$sdata['world_curr'] = $this->db->get('currencies');
		
		// Google Map Location
		
		$sys_map_pos = $this->db->get_where('settings' , array('id' =>'1'))->row()->shop_gmap;
		
		$config['center'] = $sys_map_pos;
		$config['zoom'] = '17';
		$this->googlemaps->initialize($config);

		$marker = array();
		$marker['position'] = $sys_map_pos;
		$marker['draggable'] = true;
		//$marker['ondragend'] = 'alert(\'Please Copy and Paste into Position Box : \' + event.latLng.lat() + \', \' + event.latLng.lng()); ';
		$marker['ondragend'] = 'document.getElementById(\'shop_gmap\').value= event.latLng.lat() + \', \' + event.latLng.lng()';
		$this->googlemaps->add_marker($marker);
		$sdata['sysmap'] = $this->googlemaps->create_map();
				
		$this->load->view('admin/system_settings',$sdata);
		
	}

	function systemset_update()
	{
		redirect('admin/disable_demo','refresh');
	}

	function disable_demo()
	{
		echo '<script>
		alert("Sorry in Demo Version You Cannot Change It !!!");
		window.location.replace("cloth_prices");
		</script>';
	}
	
}	// main controller
	
	
	
	
	
	
	
		
