<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace SolidInvoice\CoreBundle\Test\Traits;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use SolidInvoice\InstallBundle\Test\EnsureApplicationInstalled;

/**
 * @codeCoverageIgnore
 */
trait DoctrineTestTrait
{
    use EnsureApplicationInstalled;

    protected ManagerRegistry $registry;

    protected EntityManagerInterface $em;

    /**
     * @before
     */
    public function setupDoctrine(): void
    {
        $this->registry = static::getContainer()->get('doctrine');
        $em = $this->registry->getManager();
        assert($em instanceof EntityManagerInterface);
        $this->em = $em;
    }
}
