<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace SolidInvoice\CoreBundle\Tests\Listener;

use Mockery\Adapter\Phpunit\MockeryPHPUnitIntegration;
use Mockery as M;
use PHPUnit\Framework\TestCase;
use SolidInvoice\CoreBundle\Listener\TemplateListener;
use SolidInvoice\CoreBundle\Templating\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ViewEvent;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Twig\Environment;
use Twig\Loader\ArrayLoader;

class TemplateListenerTest extends TestCase
{
    use MockeryPHPUnitIntegration;

    public function testOnKernelView(): void
    {
        $twig = new Environment(new ArrayLoader(['Foo' => 'foo bar baz']));

        $listener = new TemplateListener($twig);

        $event = new ViewEvent(M::mock(HttpKernelInterface::class), Request::createFromGlobals(), HttpKernelInterface::MAIN_REQUEST, new Template('Foo', ['bar' => 'baz']));

        $listener->onKernelView($event);

        self::assertInstanceOf(Response::class, $event->getResponse());
        self::assertSame('foo bar baz', $event->getResponse()->getContent());
    }

    public function testOnKernelViewWithoutResponse(): void
    {
        $twig = new Environment(new ArrayLoader());

        $listener = new TemplateListener($twig);

        $event = new ViewEvent(M::mock(HttpKernelInterface::class), Request::createFromGlobals(), HttpKernelInterface::MAIN_REQUEST, []);

        $listener->onKernelView($event);

        self::assertNull($event->getResponse());
    }

    public function testOnKernelViewWithCustomResponse(): void
    {
        $twig = new Environment(new ArrayLoader(['Foo' => 'foo bar baz']));
        $response = new Response();
        $response->headers->add(['one' => 'two']);

        $listener = new TemplateListener($twig);

        $event = new ViewEvent(M::mock(HttpKernelInterface::class), Request::createFromGlobals(), HttpKernelInterface::MAIN_REQUEST, new Template('Foo', ['bar' => 'baz'], $response));

        $listener->onKernelView($event);

        self::assertSame($response, $event->getResponse());
        self::assertSame('foo bar baz', $event->getResponse()->getContent());
    }
}
