<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\AmazonSnsType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class AmazonSnsConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'AmazonSns';
    }

    public static function getType(): string
    {
        return 'chatter';
    }

    public function getForm(): string
    {
        return AmazonSnsType::class;
    }

    /**
     * @param array{ access_key: string, secret_key: string, region: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('sns://%s:%s@default?region=%s', urlencode($config['access_key']), urlencode($config['secret_key']), urlencode($config['region'])));
    }
}
