<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\GoogleChatType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class GoogleChatConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'GoogleChat';
    }

    public static function getType(): string
    {
        return 'chatter';
    }

    public function getForm(): string
    {
        return GoogleChatType::class;
    }

    /**
     * @param array{ access_key: string, access_token: string, space: string, thread_key: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('googlechat://%s:%s@default/%s?thread_key=%s', urlencode($config['access_key']), urlencode($config['access_token']), urlencode($config['space']), urlencode($config['thread_key'])));
    }
}
