<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\MessageMediaType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class MessageMediaConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'MessageMedia';
    }

    public static function getType(): string
    {
        return 'texter';
    }

    public function getForm(): string
    {
        return MessageMediaType::class;
    }

    /**
     * @param array{ api_key: string, api_secret: string, from: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('messagemedia://%s:%s@default?from=%s', urlencode($config['api_key']), urlencode($config['api_secret']), urlencode($config['from'])));
    }
}
