<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\MicrosoftTeamsType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class MicrosoftTeamsConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'MicrosoftTeams';
    }

    public static function getType(): string
    {
        return 'chatter';
    }

    public function getForm(): string
    {
        return MicrosoftTeamsType::class;
    }

    /**
     * @param array{ path: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('microsoftteams://default/%s', urlencode($config['path'])));
    }
}
