<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\OctopushType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class OctopushConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'Octopush';
    }

    public static function getType(): string
    {
        return 'texter';
    }

    public function getForm(): string
    {
        return OctopushType::class;
    }

    /**
     * @param array{ userlogin: string, apikey: string, from: string, type: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('octopush://%s:%s@default?from=%s&amp;type=%s', urlencode($config['userlogin']), urlencode($config['apikey']), urlencode($config['from']), urlencode($config['type'])));
    }
}
