<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\SlackType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class SlackConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'Slack';
    }

    public static function getType(): string
    {
        return 'chatter';
    }

    public function getForm(): string
    {
        return SlackType::class;
    }

    /**
     * @param array{ token: string, channel: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('slack://%s@default?channel=%s', urlencode($config['token']), urlencode($config['channel'])));
    }
}
