<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\TelnyxType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class TelnyxConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'Telnyx';
    }

    public static function getType(): string
    {
        return 'texter';
    }

    public function getForm(): string
    {
        return TelnyxType::class;
    }

    /**
     * @param array{ api_key: string, from: string, messaging_profile_id: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('telnyx://%s@default?from=%s&amp;messaging_profile_id=%s', urlencode($config['api_key']), urlencode($config['from']), urlencode($config['messaging_profile_id'])));
    }
}
