<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

// !! This file is autogenerated. Do not edit. !!

namespace SolidInvoice\NotificationBundle\Configurator;

use SolidInvoice\NotificationBundle\Form\Type\Transport\YunpianType;
use Symfony\Component\Notifier\Transport\Dsn;
use function sprintf;
use function urlencode;

/**
 * @codeCoverageIgnore
 */
final class YunpianConfigurator implements ConfiguratorInterface
{
    public static function getName(): string
    {
        return 'Yunpian';
    }

    public static function getType(): string
    {
        return 'texter';
    }

    public function getForm(): string
    {
        return YunpianType::class;
    }

    /**
     * @param array{ apikey: string } $config
     */
    public function configure(array $config): Dsn
    {
        return new Dsn(sprintf('yunpian://%s@default', urlencode($config['apikey'])));
    }
}
