<?php

declare(strict_types=1);

/*
 * This file is part of SolidInvoice project.
 *
 * (c) Pierre du Plessis <open-source@solidworx.co>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace SolidInvoice\TaxBundle\Form\Type;

use SolidInvoice\TaxBundle\Entity\Tax;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @see \SolidInvoice\TaxBundle\Tests\Form\Type\TaxTypeTest
 */
class TaxType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('name', null, ['sanitize_html' => true, 'allow_single_quotes' => true]);
        $builder->add('rate', PercentType::class, ['scale' => 2, 'type' => 'integer']);

        $builder->add(
            'type',
            ChoiceType::class,
            [
                'choices' => array_map('ucwords', Tax::getTypes()),
                'help' => 'tax.rates.explanation',
                'help_html' => true,
                'placeholder' => 'tax.rates.type.select',
            ]
        );
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults(['data_class' => Tax::class]);
    }
}
