/**
 * A module to help with toggle select/deselect all.
 *
 * @module     core/checkbox-toggleall
 * @copyright  2019 Andrew Nicols <andrew@nicols.co.uk>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/checkbox-toggleall",["jquery","core/pubsub"],(function($,PubSub){var registered=!1,events={checkboxToggled:"core/checkbox-toggleall:checkboxToggled"},getToggleGroupElements=function(root,toggleGroup,exactMatch){return exactMatch?root.find('[data-action="toggle"][data-togglegroup="'+toggleGroup+'"]'):root.find('[data-action="toggle"][data-togglegroup^="'+toggleGroup+'"]')},getAllSlaveCheckboxes=function(root,toggleGroup){return getToggleGroupElements(root,toggleGroup,!1).filter('[data-toggle="slave"]')},getControlCheckboxes=function(root,toggleGroup,exactMatch){return getToggleGroupElements(root,toggleGroup,exactMatch).filter('[data-toggle="master"]')},toggleSlavesFromMasters=function(e){var targetState,root=e.data.root,target=$(e.target),toggleGroupName=target.data("togglegroup");targetState=target.is(":checkbox")?target.is(":checked"):1===target.data("checkall"),toggleSlavesToState(root,toggleGroupName,targetState)},toggleMastersAndActionElements=function(root,toggleGroupName){var toggleGroupSlaves=getAllSlaveCheckboxes(root,toggleGroupName);if(toggleGroupSlaves.length>0){var toggleGroupCheckedSlaves=toggleGroupSlaves.filter(":checked"),targetState=toggleGroupSlaves.length===toggleGroupCheckedSlaves.length;setMasterStates(root,toggleGroupName,targetState,!0),setActionElementStates(root,toggleGroupName,!toggleGroupCheckedSlaves.length)}},getToggleGroupLevels=function(toggleGroupName){var toggleGroups=toggleGroupName.split(" "),toggleGroupLevels=[],toggleGroupLevel="";return toggleGroups.forEach((function(toggleGroupName){toggleGroupLevel+=" "+toggleGroupName,toggleGroupLevels.push(toggleGroupLevel.trim())})),toggleGroupLevels},toggleSlavesToState=function(root,toggleGroupName,targetState){var slaves=getAllSlaveCheckboxes(root,toggleGroupName);slaves.prop("checked",targetState).trigger("change");var checkedSlaves=slaves.filter(":checked");setMasterStates(root,toggleGroupName,targetState,!1),setActionElementStates(root,toggleGroupName,!checkedSlaves.length),getToggleGroupLevels(toggleGroupName).filter((function(toggleGroupLevel){return toggleGroupLevel!==toggleGroupName})).forEach((function(toggleGroupLevel){toggleMastersAndActionElements(root,toggleGroupLevel)})),PubSub.publish(events.checkboxToggled,{root:root,toggleGroupName:toggleGroupName,slaves:slaves,checkedSlaves:checkedSlaves,anyChecked:targetState})},toggleMastersFromSlaves=function(e){var root=e.data.root,toggleGroupName=$(e.target).data("togglegroup"),slaves=getAllSlaveCheckboxes(root,toggleGroupName),checkedSlaves=slaves.filter(":checked");getToggleGroupLevels(toggleGroupName).forEach((function(toggleGroupLevel){toggleMastersAndActionElements(root,toggleGroupLevel)})),PubSub.publish(events.checkboxToggled,{root:root,toggleGroupName:toggleGroupName,slaves:slaves,checkedSlaves:checkedSlaves,anyChecked:!!checkedSlaves.length})},setActionElementStates=function(root,toggleGroupName,disableActionElements){(function(root,toggleGroup){return getToggleGroupElements(root,toggleGroup,!0).filter('[data-toggle="action"]')})(root,toggleGroupName).prop("disabled",disableActionElements)},setMasterStates=function(root,toggleGroupName,targetState,exactMatch){var masters=getControlCheckboxes(root,toggleGroupName,exactMatch);masters.prop("checked",targetState),masters.each((function(i,masterElement){var targetString;if(masterElement=$(masterElement),targetString=targetState?masterElement.data("toggle-deselectall"):masterElement.data("toggle-selectall"),masterElement.is(":checkbox")){var masterLabel=root.find('[for="'+masterElement.attr("id")+'"]');masterLabel.length&&masterLabel.html()!==targetString&&masterLabel.html(targetString)}else masterElement.text(targetString),masterElement.data("checkall",targetState?0:1)}))};return{init:function(){!function(){if(!registered){registered=!0;var root=$(document.body);root.on("click",'[data-action="toggle"][data-toggle="master"]',{root:root},toggleSlavesFromMasters),root.on("click",'[data-action="toggle"][data-toggle="slave"]',{root:root},toggleMastersFromSlaves)}}()},events:events,setGroupState:function(root,toggleGroupName,targetState){root=$(root),setMasterStates(root,toggleGroupName,targetState,!0),toggleSlavesToState(root,toggleGroupName,targetState)},updateSlavesFromMasterState:function(root,toggleGroupName){root=$(root);var targetState,target=getControlCheckboxes(root,toggleGroupName,!1);targetState=target.is(":checkbox")?target.is(":checked"):1===target.data("checkall"),toggleSlavesToState(root,toggleGroupName,targetState)}}}));

//# sourceMappingURL=checkbox-toggleall.min.js.map