/**
 * Javascript to load and render the list of calendar events for a
 * given day range.
 *
 * @module     block_timeline/event_list
 * @package    block_timeline
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_timeline/event_list",["jquery","core/notification","core/templates","core/paged_content_factory","core/str","core/user_date","block_timeline/calendar_events_repository"],(function($,Notification,Templates,PagedContentFactory,Str,UserDate,CalendarEventsRepository){var SELECTORS_EMPTY_MESSAGE='[data-region="empty-message"]',SELECTORS_EVENT_LIST_CONTENT='[data-region="event-list-content"]',SELECTORS_EVENT_LIST_LOADING_PLACEHOLDER='[data-region="event-list-loading-placeholder"]',TEMPLATES_EVENT_LIST_CONTENT="block_timeline/event-list-content",DEFAULT_PAGED_CONTENT_CONFIG={ignoreControlWhileLoading:!0,controlPlacementBottom:!0,ariaLabels:{itemsperpagecomponents:"ariaeventlistpagelimit, block_timeline"}},render=function(calendarEvents,midnight){var templateContext=function(calendarEvents,midnight){var eventsByDay={},templateContext={eventsbyday:[]};return calendarEvents.forEach((function(calendarEvent){var dayTimestamp=UserDate.getUserMidnightForTimestamp(calendarEvent.timesort,midnight);eventsByDay[dayTimestamp]?eventsByDay[dayTimestamp].push(calendarEvent):eventsByDay[dayTimestamp]=[calendarEvent]})),Object.keys(eventsByDay).forEach((function(dayTimestamp){var events=eventsByDay[dayTimestamp];templateContext.eventsbyday.push({past:dayTimestamp<midnight,dayTimestamp:dayTimestamp,events:events})})),templateContext}(calendarEvents,midnight),templateName=TEMPLATES_EVENT_LIST_CONTENT;return Templates.render(templateName,templateContext)},loadEventsFromPageData=function(pageData,actions,midnight,lastIds,preloadedPages,courseId,daysOffset,daysLimit){for(var pageNumber=pageData.pageNumber,limit=pageData.limit,lastPageNumber=pageNumber;!lastIds.hasOwnProperty(lastPageNumber);)lastPageNumber--;var lastId=lastIds[lastPageNumber],eventsPromise=null;return eventsPromise=preloadedPages&&preloadedPages.hasOwnProperty(pageNumber)?preloadedPages[pageNumber]:function(midnight,limit,daysOffset,daysLimit,lastId,courseId){var endTime=null!=daysLimit&&midnight+86400*daysLimit,args={starttime:midnight+86400*daysOffset,limit:limit};return lastId&&(args.aftereventid=lastId),endTime&&(args.endtime=endTime),courseId?(args.courseid=courseId,CalendarEventsRepository.queryByCourse(args)):CalendarEventsRepository.queryByTime(args)}(midnight,limit+1,daysOffset,daysLimit,lastId,courseId),eventsPromise.then((function(result){if(!result.events.length)return actions.allItemsLoaded(pageNumber),[];var calendarEvents=result.events.filter((function(event){return"open"!=event.eventtype&&"opensubmission"!=event.eventtype||UserDate.getUserMidnightForTimestamp(event.timesort,midnight)>midnight}));return calendarEvents.length<=limit?actions.allItemsLoaded(pageNumber):calendarEvents.pop(),calendarEvents}))};return{init:function(root,pageLimit,preloadedPages,paginationAriaLabel,additionalConfig){root=$(root);var firstLoad=$.Deferred(),eventListContent=root.find(SELECTORS_EVENT_LIST_CONTENT),loadingPlaceholder=root.find(SELECTORS_EVENT_LIST_LOADING_PLACEHOLDER),courseId=root.attr("data-course-id"),daysOffset=parseInt(root.attr("data-days-offset"),10),daysLimit=root.attr("data-days-limit"),midnight=parseInt(root.attr("data-midnight"),10);return function(root){root.find(SELECTORS_EVENT_LIST_CONTENT).empty()}(root),function(root){root.find(SELECTORS_EVENT_LIST_CONTENT).removeClass("hidden"),root.find(SELECTORS_EMPTY_MESSAGE).addClass("hidden")}(root),loadingPlaceholder.removeClass("hidden"),null!=daysLimit&&(daysLimit=parseInt(daysLimit,10)),function(pageLimit,preloadedPages,midnight,firstLoad,courseId,daysOffset,daysLimit,paginationAriaLabel,additionalConfig){var lastIds={1:0},hasContent=!1,config=$.extend({},DEFAULT_PAGED_CONTENT_CONFIG,additionalConfig);return Str.get_string("ariaeventlistpagelimit","block_timeline",$.isArray(pageLimit)?pageLimit[0].value:pageLimit).then((function(string){return config.ariaLabels.itemsperpage=string,config.ariaLabels.paginationnav=paginationAriaLabel,string})).then((function(){return PagedContentFactory.createWithLimit(pageLimit,(function(pagesData,actions){var promises=[];return pagesData.forEach((function(pageData){var pageNumber=pageData.pageNumber,pagePromise=loadEventsFromPageData(pageData,actions,midnight,lastIds,preloadedPages,courseId,daysOffset,daysLimit).then((function(calendarEvents){if(calendarEvents.length){hasContent=!0;var lastEventId=calendarEvents[calendarEvents.length-1].id;return lastIds[pageNumber+1]=lastEventId,render(calendarEvents,midnight)}return calendarEvents})).catch(Notification.exception);promises.push(pagePromise)})),$.when.apply($,promises).then((function(){firstLoad.resolve(hasContent)})).catch((function(){firstLoad.resolve(hasContent)})),promises}),config)}))}(pageLimit,preloadedPages,midnight,firstLoad,courseId,daysOffset,daysLimit,paginationAriaLabel,additionalConfig).then((function(html,js){return(html=$(html)).addClass("hidden"),Templates.replaceNodeContents(eventListContent,html,js),firstLoad.then((function(hasContent){return html.removeClass("hidden"),loadingPlaceholder.addClass("hidden"),hasContent||function(root){root.find(SELECTORS_EVENT_LIST_CONTENT).addClass("hidden"),root.find(SELECTORS_EMPTY_MESSAGE).removeClass("hidden")}(root),hasContent})).catch((function(){return!1})),html})).catch(Notification.exception)},rootSelector:'[data-region="event-list-container"]'}}));

//# sourceMappingURL=event_list.min.js.map