/**
 * This module allows to enhance the form elements MoodleQuickForm_filetypes
 *
 * @module     core_form/filetypes
 * @package    core_form
 * @copyright  2017 David Mudrak <david@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.3
 */
define("core_form/filetypes",["jquery","core/log","core/str","core/modal_factory","core/modal_events","core/ajax","core/templates","core/tree"],(function($,Log,Str,ModalFactory,ModalEvents,Ajax,Templates,Tree){var FileTypes=function(elementId,elementLabel,onlyTypes,allowAll){this.elementId=elementId,this.elementLabel=elementLabel,this.onlyTypes=onlyTypes,this.allowAll=allowAll,this.inputField=$("#"+elementId),this.wrapperBrowserTrigger=$('[data-filetypesbrowser="'+elementId+'"]'),this.wrapperDescriptions=$('[data-filetypesdescriptions="'+elementId+'"]'),this.wrapperBrowserTrigger.length&&(this.inputField.length&&this.wrapperDescriptions.length?this.prepareBrowserTrigger().then(function(){return this.prepareBrowserModal()}.bind(this)).then(function(){return this.prepareBrowserTree()}.bind(this)):Log.error("core_form/filetypes: Unexpected DOM structure, unable to enhance filetypes field "+elementId))};return FileTypes.prototype.prepareBrowserTrigger=function(){return Templates.render("core_form/filetypes-trigger",{}).then(function(html){this.wrapperBrowserTrigger.html(html),this.browserTrigger=this.wrapperBrowserTrigger.find('[data-filetypeswidget="browsertrigger"]')}.bind(this))},FileTypes.prototype.prepareBrowserModal=function(){return ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:this.elementLabel}).then(function(modal){this.browserModal=modal}.bind(this)).then(function(){this.browserModal.getRoot().on(ModalEvents.hidden,function(){this.browserTrigger.focus()}.bind(this)),this.browserModal.getRoot().on(ModalEvents.save,function(){this.saveBrowserModal()}.bind(this))}.bind(this))},FileTypes.prototype.prepareBrowserTree=function(){return this.browserTrigger.on("click",function(e){if(e.preventDefault(),!this.inputField.is("[disabled]")){var bodyContent=this.loadBrowserModalBody();bodyContent.then(function(){this.browserTree=new Tree(this.browserModal.getBody()),this.browserTree.handleKeyDown=function(item,e){e.keyCode==this.browserTree.keys.enter||e.keyCode==this.browserTree.keys.space?(e.preventDefault(),e.stopPropagation(),this.toggleCheckbox(item.attr("data-filetypesbrowserkey"))):Tree.prototype.handleKeyDown.call(this.browserTree,item,e)}.bind(this),this.allowAll&&(this.hideOrShowItemsDependingOnAllowAll(this.browserModal.getRoot().find('input[type="checkbox"][data-filetypesbrowserkey="*"]').first()),this.browserModal.getRoot().on("change",'input[type="checkbox"][data-filetypesbrowserkey="*"]',function(e){this.hideOrShowItemsDependingOnAllowAll($(e.currentTarget))}.bind(this))),this.browserModal.getRoot().on("change",'input[type="checkbox"][data-filetypesbrowserkey]',function(e){var checkbox=$(e.currentTarget),key=checkbox.attr("data-filetypesbrowserkey");this.browserModal.getRoot().find('input[type="checkbox"][data-filetypesbrowserkey="'+key+'"]').prop("checked",checkbox.prop("checked"))}.bind(this))}.bind(this)).then(function(){this.browserModal.show()}.bind(this)),this.browserModal.setBody(bodyContent)}}.bind(this)),$.when()},FileTypes.prototype.loadBrowserModalBody=function(){var args={onlytypes:this.onlyTypes.join(),allowall:this.allowAll,current:this.inputField.val()};return Ajax.call([{methodname:"core_form_get_filetypes_browser_data",args:args}])[0].then(function(browserData){return Templates.render("core_form/filetypes-browser",{elementid:this.elementId,groups:browserData.groups})}.bind(this))},FileTypes.prototype.toggleCheckbox=function(key){var checkbox=this.browserModal.getRoot().find('input[type="checkbox"][data-filetypesbrowserkey="'+key+'"]').first();checkbox.prop("checked",!checkbox.prop("checked"))},FileTypes.prototype.saveBrowserModal=function(){if(this.allowAll){var allcheckbox=this.browserModal.getRoot().find('input[type="checkbox"][data-filetypesbrowserkey="*"]');if(allcheckbox.length&&allcheckbox.prop("checked"))return this.inputField.val("*"),void this.updateDescriptions(["*"])}var newvalue=[];this.browserModal.getRoot().find('input[type="checkbox"]').each((function(){var checkbox=$(this),key=checkbox.attr("data-filetypesbrowserkey");checkbox.prop("checked")&&newvalue.push(key)})),newvalue=newvalue.filter((function(x,i,a){return a.indexOf(x)==i})),this.inputField.val(newvalue.join(" ")),this.updateDescriptions(newvalue)},FileTypes.prototype.updateDescriptions=function(keys){var descriptions=[];keys.forEach(function(key){descriptions.push({description:this.browserModal.getRoot().find('[data-filetypesname="'+key+'"]').first().text().trim(),extensions:this.browserModal.getRoot().find('[data-filetypesextensions="'+key+'"]').first().text().trim()})}.bind(this));var templatedata={hasdescriptions:descriptions.length>0,descriptions:descriptions};return Templates.render("core_form/filetypes-descriptions",templatedata).then(function(html){this.wrapperDescriptions.html(html)}.bind(this))},FileTypes.prototype.hideOrShowItemsDependingOnAllowAll=function(allcheckbox){var others=this.browserModal.getRoot().find('[role="treeitem"][data-filetypesbrowserkey!="*"]');allcheckbox.prop("checked")?others.hide():others.show()},{init:function(elementId,elementLabel,onlyTypes,allowAll){new FileTypes(elementId,elementLabel,onlyTypes,allowAll)}}}));

//# sourceMappingURL=filetypes.min.js.map