/**
 * Controls the contacts section of the contacts page.
 *
 * @module     core_message/message_drawer_view_contacts_section_contacts
 * @package    message
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_contacts_section_contacts",["jquery","core/notification","core/pubsub","core/templates","core_message/message_repository","core_message/message_drawer_events","core_message/message_drawer_lazy_load_list"],(function($,Notification,PubSub,Templates,MessageRepository,Events,LazyLoadList){var SELECTORS_BLOCK_ICON_CONTAINER='[data-region="block-icon-container"]',SELECTORS_CONTACT='[data-region="contact"]',TEMPLATES_CONTACTS_LIST="core_message/message_drawer_contacts_list",findContact=function(body,userId){return body.find('[data-contact-user-id="'+userId+'"]')},render=function(contentContainer,contacts){var formattedContacts=contacts.map((function(contact){return $.extend(contact,{id:contact.userid})}));return Templates.render(TEMPLATES_CONTACTS_LIST,{contacts:formattedContacts}).then((function(html){return contentContainer.append(html),html})).catch(Notification.exception)},registerEventListeners=function(root){PubSub.subscribe(Events.CONTACT_ADDED,(function(profile){var listContentContainer=LazyLoadList.getContentContainer(root);render(listContentContainer,[profile]),LazyLoadList.hideEmptyMessage(root),LazyLoadList.showContent(root)})),PubSub.subscribe(Events.CONTACT_REMOVED,(function(userId){!function(body,userId){findContact(body,userId).remove()}(root,userId),root.find(SELECTORS_CONTACT).length||(LazyLoadList.hideContent(root),LazyLoadList.showEmptyMessage(root))})),PubSub.subscribe(Events.CONTACT_BLOCKED,(function(userId){!function(body,userId){var contact=findContact(body,userId);contact.length&&contact.find(SELECTORS_BLOCK_ICON_CONTAINER).removeClass("hidden")}(root,userId)})),PubSub.subscribe(Events.CONTACT_UNBLOCKED,(function(userId){!function(body,userId){var contact=findContact(body,userId);contact.length&&contact.find(SELECTORS_BLOCK_ICON_CONTAINER).addClass("hidden")}(root,userId)}))};return{show:function(root){var offset;root.attr("data-contacts-init")||(registerEventListeners(root),root.attr("data-contacts-init",!0)),LazyLoadList.show(root,(offset=0,function(listRoot,userId){return MessageRepository.getContacts(userId,101,offset).then((function(result){return result})).then((function(contacts){return contacts.length>100?contacts.pop():LazyLoadList.setLoadedAll(listRoot,!0),contacts})).then((function(contacts){return offset+=100,contacts})).catch(Notification.exception)}),render)}}}));

//# sourceMappingURL=message_drawer_view_contacts_section_contacts.min.js.map