define("core/local/reactive/reactive",["exports","core/log","core/local/reactive/statemanager","core/pending"],(function(_exports,_log,_statemanager,_pending){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * A generic single state reactive module.
   *
   * @module     core/reactive/local/reactive/reactive
   * @class     core/reactive/local/reactive/reactive
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_log=_interopRequireDefault(_log),_statemanager=_interopRequireDefault(_statemanager),_pending=_interopRequireDefault(_pending);let pendingCount=0;return _exports.default=class{constructor(description){var _description$target,_description$mutation;if(void 0===description.eventName||void 0===description.eventDispatch)throw new Error("Reactivity event required");void 0!==description.name&&(this.name=description.name),this.target=null!==(_description$target=description.target)&&void 0!==_description$target?_description$target:document.createTextNode(null),this.eventName=description.eventName,this.eventDispatch=description.eventDispatch,this.stateManager=new _statemanager.default(this.eventDispatch,this.target),this.watchers=new Map([]),this.components=new Set([]),this.mutations=null!==(_description$mutation=description.mutations)&&void 0!==_description$mutation?_description$mutation:{},this.target.addEventListener(this.eventName,this.callWatchersHandler.bind(this)),this.pendingState=new _pending.default("core/reactive:registerInstance".concat(pendingCount++)),void 0!==description.state&&this.setInitialState(description.state),void 0!==M.reactive&&M.reactive.registerNewInstance(this)}callWatchersHandler(event){this.target.dispatchEvent(new CustomEvent(event.detail.action,{bubbles:!1,detail:event.detail}))}setInitialState(stateData){this.pendingState.resolve(),this.stateManager.setInitialState(stateData)}addMutations(newFunctions){void 0!==newFunctions.init&&newFunctions.init(this.stateManager);for(const[mutation,mutationFunction]of Object.entries(newFunctions))this.mutations[mutation]=mutationFunction.bind(newFunctions)}setMutations(manager){this.mutations=manager,void 0!==manager.init&&manager.init(this.stateManager)}get state(){return this.stateManager.state}get(name,id){return this.stateManager.get(name,id)}getInitialStatePromise(){return this.stateManager.getInitialPromise()}registerComponent(component){var _component$name;const componentName=null!==(_component$name=component.name)&&void 0!==_component$name?_component$name:"Unkown component";let dispatchSuccess=()=>{},dispatchFail=dispatchSuccess;if(void 0!==component.dispatchRegistrationSuccess&&(dispatchSuccess=component.dispatchRegistrationSuccess.bind(component)),void 0!==component.dispatchRegistrationFail&&(dispatchFail=component.dispatchRegistrationFail.bind(component)),this.components.has(component))return dispatchSuccess(),component;const pendingPromise=new _pending.default("core/reactive:registerComponent".concat(pendingCount++));let listeners=[],handlers=[];return void 0!==component.getWatchers&&(handlers=component.getWatchers()),handlers.forEach((_ref=>{let{watch:watch,handler:handler}=_ref;if(void 0===watch)throw dispatchFail(),new Error("Missing watch attribute in ".concat(componentName," watcher"));if(void 0===handler)throw dispatchFail(),new Error("Missing handler for watcher ".concat(watch," in ").concat(componentName));const listener=event=>{const currentFocus=document.activeElement;handler.apply(component,[event.detail]),document.activeElement===document.body&&document.body.contains(currentFocus)&&currentFocus.focus()};listeners.push({target:this.target,watch:watch,listener:listener}),this.target.addEventListener(watch,listener)})),void 0!==component.stateReady&&this.getInitialStatePromise().then((state=>(component.stateReady(state),pendingPromise.resolve(),!0))).catch((reason=>{pendingPromise.resolve(),_log.default.error("Initial state in ".concat(componentName," rejected due to: ").concat(reason)),_log.default.error(reason)})),this.watchers.set(component,listeners),this.components.add(component),this.target.dispatchEvent(new CustomEvent("registerComponent:success",{bubbles:!1,detail:{component:component}})),dispatchSuccess(),component}unregisterComponent(component){if(!this.components.has(component))return component;this.components.delete(component);const listeners=this.watchers.get(component);return void 0===listeners||(listeners.forEach((_ref2=>{let{target:target,watch:watch,listener:listener}=_ref2;target.removeEventListener(watch,listener)})),this.watchers.delete(component)),component}async dispatch(actionName){if("string"!=typeof actionName)throw new Error("Dispatch action name must be a string");if("_"===actionName.charAt(0))throw new Error("Illegal Private ".concat(actionName," mutation method dispatch"));if(void 0===this.mutations[actionName])throw new Error("Unkown ".concat(actionName," mutation"));const pendingPromise=new _pending.default("core/reactive:".concat(actionName).concat(pendingCount++)),mutationFunction=this.mutations[actionName];try{for(var _len=arguments.length,params=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)params[_key-1]=arguments[_key];await mutationFunction.apply(this.mutations,[this.stateManager,...params]),pendingPromise.resolve()}catch(error){throw this.stateManager.setReadOnly(!0),pendingPromise.resolve(),error}}},_exports.default}));

//# sourceMappingURL=reactive.min.js.map