<?php
/**
 * index.php
 *
 * Summary page of the Admin tab
 *
 * Licensed under the GNU GPL. For full terms see the file LICENSE.
 *
 * @package   OpenClinic
 * @copyright 2002-2008 jact
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @version   CVS: $Id: index.php,v 1.13 2008/03/23 11:58:56 jact Exp $
 * @author    jact <jachavar@gmail.com>
 */

  /**
   * Controlling vars
   */
  $tab = "admin";
  $nav = "summary";

  /**
   * Checking permissions
   */
  require_once("../auth/login_check.php");
  loginCheck(OPEN_PROFILE_ADMINISTRATOR);

  /**
   * Show page
   */
  $title = _("Admin");
  require_once("../layout/header.php");

  echo HTML::section(1, $title, array('class' => 'icon icon_admin'));
  echo HTML::para(_("Use the following functions located in the left hand navigation area to manage your clinic's staff and administrative records."));

  echo HTML::section(2, HTML::link(_("Config settings"), '../admin/setting_edit_form.php'),
    array('class' => 'icon icon_config')
  );
  echo HTML::para(_("Update config settings."));

  echo HTML::rule();

  echo HTML::section(2, HTML::link(_("Staff Members"), '../admin/staff_list.php'), array('class' => 'icon icon_staff'));
  echo HTML::para(_("View the clinic staff member list.") . ' ' . _("From this list you can:"));

  $array = array(
    _("build a new staff member"),
    _("edit the staff member information"),
    _("build or edit the clinic user associated"),
    _("delete a staff member")
  );
  echo HTML::itemList($array);

  echo HTML::rule();

  echo HTML::section(2, HTML::link(_("Users"), '../admin/user_list.php'), array('class' => 'icon icon_user'));
  echo HTML::para(_("View the list of clinic users.") . ' ' . _("From this list you can:"));

  $array = array(
    _("build a new clinic user"),
    _("edit a existing clinic user"),
    _("edit the staff member information"),
    _("reset a user's password"),
    _("delete a clinic user")
  );
  echo HTML::itemList($array);

  echo HTML::rule();

  echo HTML::section(2, HTML::link(_("Themes"), '../admin/theme_list.php'), array('class' => 'icon icon_theme'));
  echo HTML::para(_("View the list of site look and feel themes.") . ' ' . _("From this list you can:"));

  $array = array(
    _("set the theme in use by default for your site"),
    _("build a new site theme"),
    _("edit an existing theme"),
    _("delete a theme")
  );
  echo HTML::itemList($array);

  echo HTML::rule();

  echo HTML::section(2, HTML::link(_("Dumps"), '../admin/dump_view_form.php'), array('class' => 'icon icon_dump'));
  echo HTML::para(_("From this option you can:"));

  $array = array(
    _("install dump from file"),
    sprintf(_("export database dump to %s format"), "MySQL"),
    sprintf(_("export database dump to %s format"), "XML"),
    sprintf(_("export database dump to %s format"), "CSV"),
    _("optimize database")
  );
  echo HTML::itemList($array);

  echo HTML::rule();

  echo HTML::section(2, HTML::link(_("Logs"), '../admin/log_stats.php'), array('class' => 'icon icon_log'));
  echo HTML::para(_("View logs generated by the program:"));

  $array = array(
    _("user's accesses logs"),
    _("operations with medical records logs"),
    _("statistics for years, months, days and hours")
  );
  echo HTML::itemList($array);

  require_once("../layout/footer.php");
?>
