SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

CREATE TABLE `pr__address` (
  `id` int(8) UNSIGNED NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` int(8) UNSIGNED NOT NULL,
  `username` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `line1` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `line2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__adminright` (
  `id` tinyint(3) UNSIGNED NOT NULL,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `pr__adminright` (`id`, `name`, `description`) VALUES
(1, 'admin', 'All rights +  Manage configuration / Log as / Log as password / Users admin rights.'),
(2, 'accounts', 'Access to Accounts, account details, send email to users.'),
(3, 'accounts-delete', 'Delete an account.'),
(4, 'translations', 'Manage translations (Add variable, modify a translation, display website Translates Ids)'),
(5, 'helpdesk', 'Access to Help Desk and reply to tickets / delete tickets'),
(10, '404Redirections', 'Create  and delete 404 redirections.'),
(12, 'sitemaps', 'Generate Sitemaps file \"sitemaps-mainpages.xml\" from Home page');

CREATE TABLE `pr__country` (
  `id` int(8) UNSIGNED NOT NULL,
  `code` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `en` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fr` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `es` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `display` tinyint(4) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `pr__country` (`id`, `code`, `en`, `fr`, `es`, `display`) VALUES
(1, 'AL', 'Albania', 'Albanie', 'Albania', 1),
(2, 'DZ', 'Algeria', 'Algérie', 'Argelia', 1),
(3, 'AS', 'Samoa, USA', 'Samoa, USA', 'Samoa, USA', 1),
(4, 'AD', 'Andorra', 'Andorre', 'Andorra', 0),
(5, 'AO', 'Angola', 'Angola', 'Angola', 1),
(6, 'AI', 'Anguilla', 'Anguilla', 'Anguilla', 1),
(7, 'AQ', 'Antarctica', 'Antarctique', 'Antarctica', 1),
(8, 'AG', 'Antigua and Barbuda', 'Antigua-et-Barbuda', 'Antigua y Barbuda', 1),
(9, 'AR', 'Argentina', 'Argentine', 'Argentina', 1),
(10, 'AM', 'Armenia', 'Arménie', 'Armenia', 1),
(11, 'AW', 'Aruba', 'Aruba', 'Aruba', 1),
(12, 'AU', 'Australia', 'Australie', 'Australia', 1),
(13, 'AT', 'Austria', 'Autriche', 'Austria', 1),
(14, 'AZ', 'Azerbaijan', 'Azerbaïdjan', 'Azerbaiyán', 1),
(15, 'BS', 'Bahamas', 'Bahamas', 'Bahamas', 1),
(16, 'BH', 'Bahrain', 'Bahreïn', 'Baréin', 1),
(17, 'BD', 'Bangladesh', 'Bangladesh', 'Bangladesh', 1),
(18, 'BB', 'Barbados', 'Barbade', 'Barbados', 1),
(19, 'BY', 'Belarus', 'Biélorussie', 'Bielorrusia', 1),
(20, 'BE', 'Belgium', 'Belgique', 'Bélgica', 1),
(21, 'BZ', 'Belize', 'Bélize', 'Belice', 1),
(22, 'BJ', 'Benin', 'Bénin', 'Benin', 1),
(23, 'BM', 'Bermuda', 'Bermudes', 'Bermuda', 1),
(24, 'BT', 'Bhutan', 'Bhoutan', 'Bután', 1),
(25, 'BO', 'Bolivia', 'Bolivie', 'Bolivia', 1),
(26, 'BQ', 'Bonaire, Saint Eustatius and Saba', 'Bonaire, Saint Eustatius et Saba', 'Bonaire, Saint Eustatius and Saba', 1),
(27, 'BA', 'Bosnia and Herzegovina', 'Bosnie-Herzégovine', 'Bosnia y Herzegovina', 1),
(28, 'BW', 'Botswana', 'Botswana', 'Botsuana', 1),
(29, 'BV', 'Bouvet Island', 'Ile Bouvet', 'Bouvet Island', 1),
(30, 'BR', 'Brazil', 'Brésil', 'Brasil', 1),
(31, 'IO', 'British Indian Ocean Territory', 'Territoire britannique de l\'océan Indien', 'British Indian Ocean Territory', 1),
(32, 'BN', 'Brunei Darussalam', 'Brunéi Darussalam', 'Brunéi', 1),
(33, 'BG', 'Bulgaria', 'Bulgarie', 'Bulgaria', 1),
(34, 'BF', 'Burkina Faso', 'Burkina Faso', 'Burkina Faso', 1),
(35, 'BI', 'Burundi', 'Burundi', 'Burundi', 1),
(36, 'KH', 'Cambodia', 'Cambodge', 'Camboya', 1),
(37, 'CM', 'Cameroon', 'Cameroun', 'Camerún', 1),
(38, 'CA', 'Canada', 'Canada', 'Canadá', 1),
(39, 'CV', 'Cape Verde', 'Cap Vert', 'Cabo Verde', 1),
(40, 'KY', 'Cayman Islands', 'Iles Caïmans', 'Cayman Islands', 1),
(41, 'CF', 'Central African Republic', 'République centrafricaine', 'República Centroafricana', 1),
(42, 'TD', 'Chad', 'Tchad', 'Chad', 1),
(43, 'CL', 'Chile', 'Chili', 'Chile', 1),
(44, 'CN', 'China', 'Chine', 'China', 1),
(45, 'CX', 'Christmas Island', 'Ile Christmas', 'Christmas Island', 1),
(46, 'CC', 'Cocos (Keeling) Islands', 'Iles Cocos (Keeling)', 'Cocos (Keeling) Islands', 1),
(47, 'CO', 'Colombia', 'Colombie', 'Colombia', 1),
(48, 'KM', 'Comoros', 'Comores', 'Comoras', 1),
(49, 'CG', 'Congo', 'Congo, Rep du ', 'Congo, Rep del', 1),
(50, 'CD', 'Congo, DRC', 'Congo, RDC', 'Congo, RDC', 1),
(51, 'CK', 'Cook Islands', 'Iles Cook', 'Cook Islands', 1),
(52, 'CR', 'Costa Rica', 'Costa Rica', 'Costa Rica', 1),
(53, 'HR', 'Croatia', 'Croatie', 'Croacia', 1),
(54, 'CW', 'Curaçao', 'Curaçao', 'Curaçao', 1),
(55, 'CY', 'Cyprus', 'Chypre', 'Cyprus', 1),
(56, 'CZ', 'Czech Republic', 'République Tchèque', 'República Checa', 1),
(57, 'DK', 'Denmark', 'Danemark', 'Dinamarca', 1),
(58, 'DJ', 'Djibouti', 'Djibouti', 'Yibuti', 1),
(59, 'DM', 'Dominica', 'Dominique', 'Dominica', 1),
(60, 'DO', 'Dominican Republic', 'République dominicaine', 'República Dominicana', 1),
(61, 'TL', 'East Timor', 'Timor-leste', 'Timor Oriental', 1),
(62, 'EC', 'Ecuador', 'Equateur', 'Ecuador', 1),
(63, 'EG', 'Egypt', 'Egypte', 'Egipto', 1),
(64, 'SV', 'Salvador', 'Salvador', 'Salvador', 1),
(65, 'GQ', 'Equatorial Guinea', 'Guinée équatoriale', 'Equatorial Guinea', 1),
(66, 'ER', 'Eritrea', 'Erythrée', 'Eritrea', 1),
(67, 'EE', 'Estonia', 'Estonie', 'Estonia', 1),
(68, 'ET', 'Ethiopia', 'Ethiopie', 'Etiopía', 1),
(69, 'FK', 'Falkland Islands', 'Iles Falkland (Malouines)', 'Falkland Islands', 1),
(70, 'FO', 'Faroe Islands', 'Iles Féroé', 'Faroe Islands', 1),
(71, 'FJ', 'Fiji', 'Fidji', 'Fiyi', 1),
(72, 'FI', 'Finland', 'Finlande', 'Finlandia', 1),
(73, 'FR', 'France', 'France', 'Francia', 1),
(74, 'GF', 'French Guiana', 'Guyane française', 'Guyana Francès', 1),
(75, 'PF', 'French Polynesia (Fr)', 'Polynésie française', 'Polinesia Francés (Fr)', 1),
(76, 'TF', 'French Southern Territories', 'Terres australes et antarctiques françaises', 'French Southern Territories', 1),
(77, 'GA', 'Gabon', 'Gabon', 'Gabón', 1),
(78, 'GM', 'Gambia', 'Gambie', 'Gambia', 1),
(79, 'GE', 'Georgia', 'Géorgie', 'Georgia', 1),
(80, 'DE', 'Germany', 'Allemagne', 'Alemania', 1),
(81, 'GH', 'Ghana', 'Ghana', 'Ghana', 1),
(82, 'GI', 'Gibraltar', 'Gibraltar', 'Gibraltar', 1),
(83, 'GR', 'Greece', 'Grèce', 'Grecia', 1),
(84, 'GL', 'Greenland', 'Groenland', 'Groenlandia', 1),
(85, 'GD', 'Grenada', 'Grenade', 'Granada', 1),
(86, 'GP', 'Guadeloupe', 'Guadeloupe', 'Guadeloupe', 1),
(87, 'GU', 'Guam', 'Guam', 'Guam', 1),
(88, 'GT', 'Guatemala', 'Guatemala', 'Guatemala', 1),
(89, 'GG', 'Guernsey', 'Guernsey', 'Guernsey', 1),
(90, 'GN', 'Guinea', 'Guinée', 'Guinea', 1),
(91, 'GW', 'Guinea-Bissau', 'Guinée-Bissau', 'Guinea-Bissau', 1),
(92, 'GY', 'Guyana', 'Guyana', 'Guyana', 1),
(93, 'HT', 'Haiti', 'Haïti', 'Haití', 1),
(94, 'HM', 'Heard Island and the McDonald Islands', 'Ile Heard et îles McDonald', 'Heard Island and the McDonald Islands', 1),
(95, 'VA', 'Vatican', 'Vatican', 'Vaticano', 1),
(96, 'HN', 'Honduras', 'Honduras', 'Honduras', 1),
(97, 'HK', 'Hong Kong', 'Hong Kong', 'Hong Kong', 1),
(98, 'HU', 'Hungary', 'Hongrie', 'Hungría', 1),
(99, 'IS', 'Iceland', 'Islande', 'Islandia', 1),
(100, 'IN', 'India', 'Inde', 'India', 1),
(101, 'ID', 'Indonesia', 'Indonésie', 'Indonesia', 1),
(102, 'IE', 'Ireland', 'Irlande', 'Irlanda', 1),
(103, 'IM', 'Isle of Man', 'Ile de Man', 'Isle of Man', 1),
(104, 'IL', 'Israel', 'Israël', 'Israel', 1),
(105, 'IT', 'Italy', 'Italie', 'Italia', 1),
(106, 'CI', 'Ivory Coast (Côte D\'ivoire)', 'Côte d\'ivoire', 'Costa de Marfil (Côte D\'ivoire)', 1),
(107, 'JM', 'Jamaica', 'Jamaïque', 'Jamaica', 1),
(108, 'JP', 'Japan', 'Japon', 'Japón', 1),
(109, 'JE', 'Jersey', 'Jersey', 'Jersey', 1),
(110, 'JO', 'Jordan', 'Jordanie', 'Jordania', 1),
(111, 'KZ', 'Kazakhstan', 'Kazakhstan', 'Kazajistán', 1),
(112, 'KE', 'Kenya', 'Kenya', 'Kenia', 1),
(113, 'KI', 'Kiribati', 'Kiribati', 'Kiribati', 1),
(114, 'KR', 'Korea', 'Corée', 'Corea', 1),
(115, 'XK', 'Kosovo', 'Kosovo', 'Kosovo', 1),
(116, 'KW', 'Kuwait', 'Koweït', 'Kuwait', 1),
(117, 'KG', 'Kyrgyzstan', 'Kirghizistan', 'Kirguistán', 1),
(118, 'LA', 'Laos', 'Laos', 'Laos', 1),
(119, 'LV', 'Latvia', 'Lettonie', 'Letonia', 1),
(120, 'LB', 'Lebanon', 'Liban', 'Líbano', 1),
(121, 'LS', 'Lesotho', 'Lesotho', 'Lesoto', 1),
(122, 'LR', 'Liberia', 'Liberia', 'Liberia', 1),
(123, 'LY', 'Libya', 'Libye ', 'Libya', 1),
(124, 'LI', 'Liechtenstein', 'Liechtenstein', 'Liechtenstein', 1),
(125, 'LT', 'Lithuania', 'Lituanie', 'Lituania', 1),
(126, 'LU', 'Luxembourg', 'Luxembourg', 'Luxembourgo', 1),
(127, 'MO', 'Macao', 'Macao', 'Macao', 1),
(128, 'MK', 'Macedonia', 'Macédoine', 'Macedonia', 1),
(129, 'MG', 'Madagascar', 'Madagascar', 'Madagascar', 1),
(130, 'MW', 'Malawi', 'Malawi', 'Malawi', 1),
(131, 'MY', 'Malaysia', 'Malaisie', 'Malasia', 1),
(132, 'MV', 'Maldives', 'Maldives', 'Maldivas', 1),
(133, 'ML', 'Mali', 'Mali', 'Mali', 1),
(134, 'MT', 'Malta', 'Malte', 'Malta', 1),
(135, 'MH', 'Marshall Islands', 'Iles Marshall', 'Marshall Islands', 1),
(136, 'MQ', 'Martinique France', 'Martinique France', 'Martinique France', 1),
(137, 'MR', 'Mauritania', 'Mauritanie', 'Mauritania', 1),
(138, 'MU', 'Mauritius', 'Maurice, Ile', 'Isla Mauricio', 1),
(139, 'YT', 'Mayotte (Fr)', 'Mayotte (Fr)', 'Mayotte (Fr)', 1),
(140, 'MX', 'Mexico', 'Mexique', 'Mexico', 1),
(141, 'FM', 'Micronesia, Federated States of', 'Micronésie, Etats fédérés de', 'Micronesia, Federated States of', 1),
(142, 'MD', 'Moldova, Republic of', 'République de Moldavie', 'Moldavia', 1),
(143, 'MC', 'Monaco', 'Monaco', 'Monaco', 1),
(144, 'MN', 'Mongolia', 'Mongolie', 'Mongolia', 1),
(145, 'ME', 'Montenegro', 'Montenegro', 'Montenegro', 1),
(146, 'MS', 'Montserrat', 'Montserrat', 'Montserrat', 1),
(147, 'MA', 'Morocco', 'Maroc', 'Marruecos', 1),
(148, 'MZ', 'Mozambique', 'Mozambique', 'Mozambique', 1),
(149, 'MM', 'Myanmar', 'Birmanie', 'Birmania', 1),
(150, 'NA', 'Namibia', 'Namibie', 'Namibia', 1),
(151, 'NR', 'Nauru', 'Nauru', 'Nauru', 1),
(152, 'NP', 'Nepal', 'Népal', 'Nepal', 1),
(153, 'NL', 'Netherlands', 'Pays-Bas', 'Países Bajos', 1),
(154, 'AN', 'Netherlands Antilles', 'Antilles néerlandaises', 'Antillas Neerlandesas', 1),
(155, 'NC', 'New Caledonia', 'Nouvelle-Calédonie', 'New Caledonia', 1),
(156, 'NZ', 'New Zealand', 'Nouvelle-Zélande', 'Nueva Zelanda', 1),
(157, 'NI', 'Nicaragua', 'Nicaragua', 'Nicaragua', 1),
(158, 'NE', 'Niger', 'Niger', 'Niger', 1),
(159, 'NG', 'Nigeria', 'Nigeria', 'Nigeria', 1),
(160, 'NU', 'Niue', 'Niué', 'Niue', 1),
(161, 'NF', 'Norfolk Island', 'Ile Norfolk', 'Norfolk Island', 1),
(162, 'MP', 'Northern Mariana Islands', 'Iles Mariannes du Nord', 'Northern Mariana Islands', 1),
(163, 'NO', 'Norway', 'Norvège', 'Noruega', 1),
(164, 'OM', 'Oman', 'Oman', 'Omán', 1),
(165, 'PK', 'Pakistan', 'Pakistan', 'Pakistan', 1),
(166, 'PW', 'Palau', 'Palaos', 'Palau', 1),
(167, 'PA', 'Panama', 'Panama', 'Panama', 1),
(168, 'PG', 'Papua New Guinea', 'Papouasie-Nouvelle-Guinée', 'Papúa Nueva Guinea', 1),
(169, 'PY', 'Paraguay', 'Paraguay', 'Paraguay', 1),
(170, 'PE', 'Peru', 'Pérou', 'Peru', 1),
(171, 'PH', 'Philippines', 'Philippines', 'Filipinas', 1),
(172, 'PN', 'Pitcairn', 'Pitcairn', 'Pitcairn', 1),
(173, 'PL', 'Poland', 'Pologne', 'Polonia', 1),
(174, 'PT', 'Portugal', 'Portugal', 'Portugal', 1),
(175, 'PR', 'Puerto Rico', 'Porto Rico', 'Puerto Rico', 1),
(176, 'QA', 'Qatar', 'Qatar', 'Catar', 1),
(177, 'RE', 'Reunion', 'Réunion', 'Reunion', 1),
(178, 'RO', 'Romania', 'Roumanie', 'Rumanía', 1),
(179, 'RU', 'Russia', 'Russie', 'Rusia', 1),
(180, 'RW', 'Rwanda', 'Rwanda', 'Ruanda', 1),
(181, 'SH', 'Saint Helena, Ascension and Tristan da Cunha', 'Sainte-Hélène, Ascension et Tristan da Cunha', 'Saint Helena, Ascension and Tristan da Cunha', 1),
(182, 'LC', 'Saint Lucia', 'Sainte-Lucie', 'Santa Lucía', 1),
(183, 'PM', 'Saint Pierre and Miquelon', 'Saint-Pierre-et-Miquelon', 'Saint Pierre and Miquelon', 1),
(184, 'VC', 'Saint Vincent and the Grenadines', 'Saint-Vincent-et-les Grenadines', 'San Vicente y las Granadinas', 1),
(185, 'BL', 'Saint-Barthélemy (Fr)', 'Saint-Barthélemy (Fr)', 'Saint-Barthélemy (Fr)', 1),
(186, 'MF', 'Saint Martin (Fr)', 'Saint-Martin (Fr)', 'Saint Martin (Fr)', 1),
(187, 'WS', 'Samoa', 'Samoa', 'Samoa', 1),
(188, 'SM', 'San Marino', 'Saint-Marin', 'San Marino', 1),
(189, 'ST', 'Sao Tome and Principe', 'Sao-Tomé-et-Principe', 'Santo Tomé y Príncipe', 1),
(190, 'SA', 'Saudi Arabia', 'Arabie Saoudite', 'Arabia Saudita', 1),
(191, 'SN', 'Senegal', 'Sénégal', 'Senegal', 1),
(192, 'RS', 'Serbia', 'Serbie', 'Serbia', 1),
(193, 'SC', 'Seychelles', 'Seychelles', 'Seychelles', 1),
(194, 'SL', 'Sierra Leone', 'Sierra Leone', 'Sierra Leone', 1),
(195, 'SG', 'Singapore', 'Singapour', 'Singapur', 1),
(196, 'SX', 'Sint Maarten', 'Saint-Martin (Pays Bas)', 'Sint Maarten', 1),
(197, 'SK', 'Slovakia', 'Slovaquie', 'Eslovaquia', 1),
(198, 'SI', 'Slovenia', 'Slovénie', 'Slovenia', 1),
(199, 'SB', 'Solomon Islands', 'Iles Salomon', 'Solomon Islands', 1),
(200, 'SO', 'Somalia', 'Somalie', 'Somalia', 1),
(201, 'ZA', 'South Africa', 'Afrique du Sud', 'República Sudafricana', 1),
(202, 'GS', 'South Georgia and the South Sandwich Islands', 'Géorgie du Sud et les Iles Sandwich du Sud', 'South Georgia and the South Sandwich Islands', 1),
(203, 'ES', 'Spain', 'Espagne', 'España', 1),
(204, 'LK', 'Sri Lanka', 'Sri Lanka', 'Sri Lanka', 1),
(205, 'SR', 'Suriname', 'Surinam', 'Surinam', 1),
(206, 'SJ', 'Svalbard and Jan Mayen', 'Svalbard et Jan Mayen', 'Svalbard and Jan Mayen', 1),
(207, 'SZ', 'Swaziland', 'Swaziland', 'Suazilandia', 1),
(208, 'SE', 'Sweden', 'Suède', 'Suecia', 1),
(209, 'CH', 'Switzerland', 'Suisse', 'Suiza', 1),
(210, 'TW', 'Taiwan', 'Taïwan', 'Taiwan', 1),
(211, 'TJ', 'Tajikistan', 'Tadjikistan', 'Tayikistán', 1),
(212, 'TZ', 'Tanzania', 'Tanzanie', 'Tanzania', 1),
(213, 'TH', 'Thailand', 'Thaïlande', 'Tailandia', 1),
(214, 'TG', 'Togo', 'Togo', 'Togo', 1),
(215, 'TK', 'Tokelau', 'Tokelau', 'Tokelau', 1),
(216, 'TO', 'Tonga', 'Tonga', 'Tonga', 1),
(217, 'TT', 'Trinidad and Tobago', 'Trinité-et-Tobago', 'Trinidad y Tobago', 1),
(218, 'TN', 'Tunisia', 'Tunisie', 'Túnez', 1),
(219, 'TR', 'Turkey', 'Turquie', 'Turquía', 1),
(220, 'TM', 'Turkmenistan', 'Turkménistan', 'Turkmenistán', 1),
(221, 'TC', 'Turks and Caicos Islands', 'Iles Turques-et-Caïques', 'Turks and Caicos Islands', 1),
(222, 'TV', 'Tuvalu', 'Tuvalu', 'Tuvalu', 1),
(223, 'UG', 'Uganda', 'Ouganda', 'Uganda', 1),
(224, 'UA', 'Ukraine', 'Ukraine', 'Ucrania', 1),
(225, 'AE', 'United Arab Emirates', 'Emirats arabes unis', 'Emiratos Árabes Unidos', 1),
(226, 'GB', 'United Kingdom', 'Angleterre', 'Inglaterra', 1),
(227, 'US', 'USA', 'USA', 'USA', 1),
(228, 'UM', 'United States Minor Outlying Islands', 'Iles mineures éloignées des Etats-Unis', 'United States Minor Outlying Islands', 1),
(229, 'UY', 'Uruguay', 'Uruguay', 'Uruguay', 1),
(230, 'UZ', 'Uzbekistan', 'Ouzbékistan', 'Uzbekistan', 1),
(231, 'VU', 'Vanuatu', 'Vanuatu', 'Vanuatu', 1),
(232, 'VE', 'Venezuela', 'Venezuela', 'Venezuela', 1),
(233, 'VN', 'Vietnam', 'Vietnam', 'Vietnam', 1),
(234, 'VG', 'BVI', 'Iles Vierges britanniques', 'Virgin Islands, British', 1),
(235, 'VI', 'Virgin Islands, US', 'Iles Vierges américaines', 'Virgin Islands, US', 1),
(236, 'WF', 'Wallis and Futuna (Fr)', 'Wallis-et-Futuna (Fr)', 'Wallis y Futuna (Fr)', 1),
(237, 'EH', 'Western Sahara', 'Sahara occidental', 'Sáhara Occidental', 1),
(238, 'YE', 'Yemen', 'Yémen', 'Yemen', 1),
(239, 'ZM', 'Zambia', 'Zambie', 'Zambia', 1),
(240, 'ZW', 'Zimbabwe', 'Zimbabwe', 'Zimbabue', 1),
(241, 'CU', 'Cuba', 'Cuba', 'Cuba', 1);

CREATE TABLE `pr__ticket` (
  `id` int(8) UNSIGNED NOT NULL,
  `user_id` int(8) UNSIGNED NOT NULL,
  `status` varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'opened',
  `date` datetime NOT NULL,
  `date_closed` datetime DEFAULT NULL,
  `subject` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `next` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'support'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DELIMITER $$
CREATE TRIGGER `pr__ticket_delete` BEFORE DELETE ON `pr__ticket` FOR EACH ROW BEGIN
DELETE FROM pr__ticket_reply
    WHERE pr__ticket_reply.ticket_id = OLD.id;
END
$$
DELIMITER ;

CREATE TABLE `pr__ticket_reply` (
  `id` int(8) UNSIGNED NOT NULL,
  `user_id` int(8) UNSIGNED NOT NULL,
  `ticket_id` int(8) UNSIGNED NOT NULL,
  `showname` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` datetime NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `reply_as` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'support'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__translation` (
  `id` int(8) UNSIGNED NOT NULL,
  `length` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'small',
  `page` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(87) COLLATE utf8_unicode_ci NOT NULL,
  `en` text COLLATE utf8_unicode_ci,
  `fr` text COLLATE utf8_unicode_ci,
  `es` text COLLATE utf8_unicode_ci
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `pr__translation` (`id`, `length`, `page`, `name`, `en`, `fr`, `es`) VALUES
(1, 'small', 'Signup', 'Sign up with', 'Sign up with', 'S\'inscrire avec', 'Registrarse en'),
(2, 'small', 'Admin', 'Reopen the ticket', 'Reopen the ticket', 'Réouvrir le ticket', 'Reabrir el ticket'),
(3, 'large', 'Global', 'Email address', 'Email address', 'Adresse Email', 'Dirección Correo electrónico'),
(4, 'small', 'Global', 'Lastname', 'Lastname', 'Nom', 'Apellido'),
(5, 'small', 'Global', 'Password', 'Password', 'Mot de passe', 'Contraseña'),
(6, 'small', 'Global', 'Firstname', 'Firstname', 'Prénom', 'Nombre'),
(7, 'small', 'Global', 'Email', 'E-mail', 'Email', 'Email'),
(8, 'small', 'Signup', 'Confirm password', 'Confirm password', 'Confirmer le mot de passe', 'Confirmar contraseña'),
(9, 'small', 'Signup', 'Create my account', 'Create my account', 'Créer mon compte', 'Crear mi cuenta'),
(10, 'small', 'Signup', 'Minimum 6 characters, with at least 1 digit and a special character such as: ! # @ - _.', 'Minimum 6 characters, with at least 1 digit and a special character such as: ! # @ - _.', '﻿Minimum 6 caractères, avec au moins 1 chiffre et un caractère spécial comme: ! # @ - _.', 'Mínimo 6 caracteres, con al menos 1 dígito y un carácter especial como: ! # @ - _.'),
(11, 'small', 'Signup', 'With an email and password', 'With an email and password', 'Avec un email et un mot de passe', 'Con un email y contraseña'),
(12, 'small', 'Signup', 'In only one click with one social network', 'In only one click with one social network', 'En un seul clic avec un réseau social', 'En un solo clic con una red social'),
(13, 'small', 'Global', 'Send', 'Send', 'Envoyer', 'Enviar'),
(14, 'small', 'Global', 'Sending', 'Send in progress', 'Envoi en cours', 'Enviar en curso'),
(15, 'large', 'Terms', 'Terms of use - Content', '<p>Your use of WebsiteName (\"Website\") is subject to your acceptance of these legal terms of use, including our privacy policy.</p>\r\n<p>WebsiteName reserves the right, at its sole discretion, to modify or update these legal terms of use from time to time with immediate effect and without notice. It is your responsibility to periodically review these legal terms of use for updates. </p>\r\n<p>APRESS TO READ THESE TERMS AND CONDITIONS OF USE, IF FOR ANY REASON THAT YOU DO NOT AGREE OR THAT YOU CANNOT COMPLY WITH THESE TERMS AND CONFIDENTIALITY POLICY, PLEASE PUT THIS SITE OUT IMMEDIATELY. OTHERWISE, BY ACCESSING AND USING THIS WEBSITE, YOU AGREE TO THESE TERMS AND CONDITIONS OF USE AND OUR CONFIDENTIALITY POLICY. </p>\r\n\r\n<h2>Content rights and intellectual property</h2>\r\n\r\n<p>Copyright in all original documents, content, selection and layout of the website (including text, user and visual interfaces, images, appearance, design, sound, etc.) is owned by WebsiteName, its parents, affiliates, subsidiaries or third-party licensors. You may not copy, reproduce, publish on another website, republish, download, encode, modify, publicly translate, publicly display, commercially exploit, distribute or transmit any part of this website or do derivative works of this website in any way without the prior written consent of WebsiteName.</p>  \r\n\r\n<p>Any name, logo, trademark, service mark, patent, design, copyright, domain name or other intellectual property appearing on this site is the property of WebsiteName or its parents, affiliates or subsidiaries and may not be used by You without the prior written consent of WebsiteName or the appropriate owner. Your use of this website does not grant you any right, title, interest or license to any such intellectual property appearing on this website. Any unauthorized use of the content of this website may subject you to civil or criminal penalties. </p>\r\n\r\n<h2>Use of this website</h2>\r\n\r\n<p>WebsiteName maintains this website for your personal purchases, entertainment, information and education. You should feel free to browse the website. However, any copy (electronic, hard copy or other format) is prohibited and may violate intellectual property and other laws worldwide. Any commercial use of all or part of this site is prohibited except with the written consent of WebsiteName. All rights not expressly granted herein are reserved to WebsiteName.</p>  \r\n\r\n<p>You may not use any computer program tool, including, but not limited to, web spiders, bots, indexers, robots, crawlers, harvesters, or any other automatic or similar device, program, algorithm or methodology (\") to access, acquire, copy or monitor any part of the Site or content, or reproduce or circumvent in any way the navigation structure or presentation of the Site or its content, to obtain or attempt to obtain material, documents or information. means not intentionally made available on the website. The tools that use the website should be considered as intermediaries of the people who control or write them. </p>\r\n\r\n<h2>Limitation of warranty</h2>\r\n\r\n<p>WebsiteName DOES NOT REPRESENT THAT THIS WEB SITE OR ANY CONTENT, SERVICE OR FUNCTIONALITY OF THIS WEB SITE WILL BE EXEMPT ERROR OR ININTERRUPTED, OR THAT ANY FAULT WILL BE CORRECTED, OR THAT YOUR USE OF THIS WEB SITE WILL BE PROVIDED OF SPECIFIC RESULTS. THIS WEBSITE AND ITS CONTENT ARE PROVIDED \"AS IS\" AND \"AS AVAILABLE\" WITHOUT ANY REPRESENTATION OR WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT OR ACCURACY.</p>\r\n\r\n<p>WebsiteName assumes no responsibility and shall not be liable for any damages caused by viruses or other forms of contamination or destructive features that may affect your computer equipment, software, data or other property due to your access, use or browsing of the Website or your downloading of any material, text, images, video or audio from the Website or linked websites. </p>\r\n\r\n<h2>Limitation of liability</h2>\r\n\r\n<p>In no case WebsiteName, its parents, affiliates, subsidiaries or service providers, its licensors, or the officers, directors, employees, shareholders or agents of each of them, shall not be liable for damages of any kind, including without limitation direct, special, incidental or indirect damages, exemplary, punitive or consequential damages, including lost profits, whether or not they have been advised of the possibility of such damages, as well as the theory of liability arising out of or in connection with the use or performance of, or Your browsing in, or your linking to, other sites from, this website. By using this website, you acknowledge that your use of this website is at your own risk. Some laws do not allow limitations on implied warranties or the exclusion or limitation of certain damages: if they apply to you, some or all of the above exclusions may not apply, and you may have additional rights. </p>\r\n\r\n<h2>Indemnity</h2>\r\n\r\n<p>You agree to defend, indemnify and hold WebsiteName harmless from and against all claims, damages, costs and expenses, including reasonable attorneys\' fees, arising out of or in connection with your use of the Website.</p>\r\n\r\n<h2>Supplementary terms and conditions</h2>\r\n\r\n<p>Additional terms and conditions may apply to purchases of goods and services and to certain parts of the features of the Website, including, but not limited to, sales, licenses, contests, sweepstakes, invitations or other similar features (each an \"Application\"). whose additional terms and conditions form part of these legal terms of use by this reference. You agree to comply with these terms of use. In the event of any conflict between these Terms of Use and the terms of the Application, the terms of the Application shall be used with respect to the Application. </p>\r\n\r\n<h2>Communications with this website</h2>\r\n\r\n<p>You are prohibited from publishing or transmitting any unlawful, threatening, libelous, defamatory, obscene, scandalous, inflammatory, pornographic or profane material or any material that could constitute or encourage conduct that would be considered a criminal offence, give rise to civil liability, or otherwise violate the law. WebsiteName will fully cooperate, including but not limited to, maintaining and disclosing any transmissions or communications you have had with this website, disclosing your identity or helping to identify you, with any applicable law or regulation, law enforcement authorities, court order or governmental authority.\r\n\r\n<p>Any communication or material you transmit to the Website by electronic mail or otherwise, including any data, questions, comments or suggestions, or otherwise, is and will be treated as non-confidential and non-proprietary. WebsiteName cannot prevent the collection of information such as your first and last name or artist name or any other information you disclose on this website, and you may be contacted by WebsiteName or unrelated parties, by email or otherwise, inside or outside this website. Anything you transmit may be edited by or on behalf of WebsiteName, may or may not be published on this site at WebsiteName\'s sole discretion and may be used by WebsiteName or its affiliates for any purpose, including but not limited to, reproduction, disclosure, transmission, publication, broadcast and publication. In addition, WebsiteName is free to use any ideas, concepts, know-how or techniques contained in any communication you send to the website for any purpose whatsoever, including, but not limited to, developing, manufacturing and marketing products using such information. If you transmit ideas, concepts, materials or other communications to the Site, you agree that it will not be treated as confidential and may be used by WebsiteName without compensation in any manner whatsoever, including without limitation reproduction, transmission, publication, marketing, product development, etc. </p>  \r\n\r\n<p>Although WebsiteName may, from time to time, monitor or review discussions, chats, postings, transmissions, bulletin boards, etc. on the Website, WebsiteName is under no obligation to do so and assumes no responsibility for the content of such sites, nor for any error, defamation, libel, slander, omission, falsehood, obscenity, pornography, blasphemy, danger or inaccuracy contained in any information within such sites, on the Website. WebsiteName assumes no responsibility for any action or communication by You or any third party linked within or outside this website.\r\n\r\n<h2>Termination</h2>\r\n\r\n<p>WebsiteName may, in its sole discretion, modify or discontinue the Website, or modify or terminate your account or access to this Website, for any reason, with or without notice, and without liability to you or any third party.\r\n\r\n<h2>Unaffiliated products and websites</h2>\r\n\r\n<p>The description or references to products, publications or websites that are not the property of WebsiteName or its subsidiaries do not imply endorsement of such product, publication or website. WebsiteName has not reviewed all the materials linked to the website and is not responsible for the content of any such materials. Your linking to other websites is at your own risk. </p> \r\n\r\n<h2>Link policy</h2>\r\n\r\n<p>This website may provide you, as a convenience, with links to websites owned or operated by parties other than WebsiteName. Each linked website may have its own terms and conditions of use, as described in the legal notice / terms of use of this website. These terms and conditions may differ from these legal terms of use, and we encourage you to carefully read the legal terms of each website before using this website. WebsiteName does not control and is not responsible for the availability, content or security of these external websites, nor for your experience interacting with or using these external websites. WebsiteName does not endorse the content or products or services available on these websites.', '﻿<p>Votre utilisation de WebsiteName («Site Web») est conditionnée par votre acceptation de ces conditions légales d\'utilisation, y compris notre politique de confidentialité.</p>\r\n<p>WebsiteName se réserve le droit, à sa seule discrétion, de modifier ou de mettre à jour ces conditions légales d\'utilisation de temps en temps avec effet immédiat et sans préavis. Il est de votre responsabilité de consulter périodiquement ces conditions d\'utilisation légales pour les mises à jour.</p>\r\n<p>APRÈS AVOIR LU CES CONDITIONS D\'UTILISATION, SI POUR QUELQUE RAISON QUE VOUS N\'ACCEPTEZ PAS OU QUE VOUS NE POUVEZ PAS RESPECTER CES CONDITIONS D\'UTILISATION OU NOTRE POLITIQUE DE CONFIDENTIALITÉ, VEUILLEZ SORTIR CE SITE IMMÉDIATEMENT. AUTREMENT, EN ACCÉDANT ET EN UTILISANT CE SITE WEB, VOUS ACCEPTEZ LES PRÉSENTES CONDITIONS D\'UTILISATION ET NOTRE POLITIQUE DE CONFIDENTIALITÉ.</p>\r\n\r\n<h2>Droits au contenu et propriété intellectuelle</h2>\r\n\r\n<p>Les droits d\'auteur sur tous les documents originaux, le contenu, la sélection et la disposition du site Web (y compris le texte, les interfaces utilisateur et visuelles, les images, l\'apparence, le design, le son, etc.) sont la propriété de WebsiteName, ses parents, affiliés, filiales ou concédants de licence tiers. Vous ne pouvez pas copier, reproduire, publier sur un autre site Web, republier, télécharger, encoder, modifier, traduire publiquement, afficher publiquement, exploiter commercialement, distribuer ou transmettre une partie de ce site Web ou faire des travaux dérivés de ce site Web de quelque façon que ce soit. sans le consentement écrit préalable et écrit de WebsiteName.</p>  \r\n\r\n<p>Tout nom, logo, marque commerciale, marque de service, brevet, design, droit d\'auteur, nom de domaine ou autre propriété intellectuelle apparaissant sur ce site est la propriété de WebsiteName ou de ses parents, affiliés ou filiales et ne peut être utilisé par Vous sans le consentement écrit préalable de WebsiteName ou du propriétaire approprié. Votre utilisation de ce site Web ne vous accorde aucun droit, titre, intérêt ou licence à une telle propriété intellectuelle apparaissant sur ce site Web. Toute utilisation non autorisée du contenu de ce site Web peut vous exposer à des sanctions civiles ou pénales.</p>\r\n\r\n<h2>Utilisation de ce site Web</h2>\r\n\r\n<p>WebsiteName maintient ce site Web pour vos achats personnels, divertissement, information et éducation. Vous devriez vous sentir libre de naviguer sur le site Web. Cependant, toute copie (électronique, copie papier ou autre format) est interdite et peut enfreindre les lois sur la propriété intellectuelle et d\'autres lois dans le monde entier. Toute utilisation commerciale de tout ou partie de ce site est interdite sauf avec le consentement écrit de WebsiteName. Tous les droits non expressément accordés ici sont réservés à WebsiteName.</p>  \r\n\r\n<p>Vous ne pouvez utiliser aucun outil de programme informatique, y compris, mais sans s\'y limiter, des araignées Web, des bots, des indexeurs, des robots, des crawlers, des moissonneuses, ou tout autre appareil, programme, algorithme ou méthodologie automatique ou similaire ( \") pour accéder, acquérir, copier ou surveiller toute partie du Site ou du contenu, ou reproduire ou contourner de quelque manière que ce soit la structure de navigation ou la présentation du Site ou de son contenu, pour obtenir ou tenter d\'obtenir du matériel, des documents ou des informations. moyens non intentionnellement mis à disposition sur le site Web. Les outils qui utilisent le site Web doivent être considérés comme des intermédiaires des personnes qui les contrôlent ou les rédigent.</p>\r\n\r\n<h2>Limitation de la garantie</h2>\r\n\r\n<p>WebsiteName NE REPRÉSENTE PAS QUE CE SITE WEB OU TOUT CONTENU, SERVICE OU FONCTIONNALITÉ DE CE SITE WEB SERA EXEMPT D\'ERREUR OU ININTERROMPU, OU QUE TOUT DÉFAUT SERA CORRIGÉ, OU QUE VOTRE UTILISATION DE CE SITE WEB FOURNIRA DES RÉSULTATS SPÉCIFIQUES. CE SITE WEB ET SON CONTENU SONT FOURNIS «TELS QUELS» ET «TELS QUE DISPONIBLES» SANS DÉCLARATION OU GARANTIE D\'AUCUNE SORTE, EXPRESSE OU IMPLICITE, Y COMPRIS, MAIS SANS S\'Y LIMITER, LES GARANTIES IMPLICITES DE QUALITÉ MARCHANDE, D\'ADAPTATION À UN USAGE PARTICULIER, D\'ABSENCE DE CONTREFAÇON OU EXACTITUDE.</p>\r\n\r\n<p>WebsiteName n\'assume aucune responsabilité et ne sera pas responsable des dommages causés par des virus ou autres formes de contamination ou des caractéristiques destructrices qui pourraient affecter votre équipement informatique, logiciel, données ou autres biens en raison de votre accès, utilisation ou naviguer dans le site Web ou votre téléchargement de tout matériel, texte, images, vidéo ou audio à partir du site Web ou des sites Web liés.</p>\r\n\r\n<h2>Limitation de responsabilité</h2>\r\n\r\n<p>En aucun cas WebsiteName, ses parents, affiliés, filiales ou fournisseurs de services, ses concédants de licence, ou les dirigeants, administrateurs, employés, actionnaires ou agents de chacun d\'entre eux, ne seront responsables des dommages de toute nature, y compris sans limitation les dommages directs, spéciaux, accessoires, indirects, exemplaires, punitifs ou consécutifs, y compris les profits perdus, qu\'ils aient ou non été avisés de la possibilité de tels dommages, ainsi que la théorie de la responsabilité découlant ou liée à l\'utilisation ou la performance de, ou Votre navigation dans, ou vos liens vers d\'autres sites à partir de, ce site Web. Vous reconnaissez, en utilisant ce site Web, que vous utilisez ce site Web à vos risques et périls. Certaines lois n\'autorisent pas les limitations sur les garanties implicites ou l\'exclusion ou la limitation de certains dommages: si elles s\'appliquent à vous, certaines ou la totalité des exclusions ci-dessus peuvent ne pas s\'appliquer, et vous pourriez avoir des droits supplémentaires.</p>\r\n\r\n<h2>Indemnité</h2>\r\n\r\n<p>Vous acceptez de défendre, d\'indemniser et de dégager WebsiteName de toute responsabilité à l\'égard de toutes réclamations, dommages, coûts et dépenses, y compris les honoraires d\'avocat raisonnables, découlant de ou liés à votre utilisation du site Web.</p>\r\n\r\n<h2>Termes et conditions supplémentaires</h2>\r\n\r\n<p>Des modalités et conditions supplémentaires peuvent s\'appliquer aux achats de biens et de services et à certaines parties des caractéristiques du site Web, y compris, mais sans s\'y limiter, les ventes, licences, concours, tirages au sort, invitations ou autres caractéristiques similaires (chacune une «Application»). dont les termes et conditions supplémentaires font partie de ces conditions légales d\'utilisation par cette référence. Vous acceptez de vous conformer à ces conditions d\'utilisation. En cas de conflit entre les présentes Conditions d\'utilisation et les conditions de l\'Application, les conditions de l\'Application seront utilisés en ce qui concerne l\'Application.</p>\r\n\r\n<h2>Communications avec ce site Web</h2>\r\n\r\n<p>Il vous est interdit de publier ou de transmettre tout matériel illégal, menaçant, diffamatoire, obscène, scandaleux, incendiaire, pornographique ou profane ou tout matériel pouvant constituer ou encourager une conduite qui serait considérée comme une infraction criminelle, engager la responsabilité civile, ou violer autrement la loi. WebsiteName coopérera pleinement, y compris mais sans s\'y limiter, maintenir et divulguer les transmissions ou communications que vous avez eu avec ce site Web, divulguer votre identité ou aider à vous identifier, avec toute loi ou règlement applicable, les autorités d\'application de la loi, ordonnance du tribunal ou autorité gouvernementale.</p>\r\n\r\n<p>Toute communication ou tout matériel que vous transmettez au site Web par courrier électronique ou autre, y compris les données, questions, commentaires ou suggestions, ou autres, est et sera traité comme non confidentiel et non exclusif. WebsiteName ne peut pas empêcher la collecte d\'informations comme votre nom et prénom ou votre nom d\'artiste ou tout autre information que vous divulguez sur ce site Web, et vous pouvez être contacté par WebsiteName ou des parties non liées, par courriel ou autrement, à l\'intérieur ou à l\'extérieur de ce site Web. Tout ce que vous transmettez peut être édité par ou au nom de WebsiteName, peut ou non être publié sur ce site à la seule discrétion de WebsiteName et peut être utilisé par WebsiteName ou ses affiliés à toute fin, y compris mais pas limité à, reproduction, divulgation, transmission, publication, diffusion et publication. En outre, WebsiteName est libre d\'utiliser toutes les idées, concepts, savoir-faire ou techniques contenus dans toute communication que vous envoyez sur le site Web à quelque fin que ce soit, y compris, mais sans s\'y limiter, le développement, la fabrication et la commercialisation des produits utilisant ces informations. Si vous transmettez des idées, concepts, matériels ou autres communications sur le Site, vous acceptez qu\'il ne soit pas traité comme confidentiel et puisse être utilisé par WebsiteName sans compensation de quelque manière que ce soit, y compris sans limitation à la reproduction, transmission, publication , marketing, développement de produits, etc.</p>  \r\n\r\n<p>Bien que WebsiteName puisse, de temps à autre, surveiller ou examiner des discussions, des chats, des affichages, des transmissions et des tableaux d\'affichage, etc. sur le site Web, WebsiteName n\'est nullement tenue de le faire et décline toute responsabilité sur le contenu de ces emplacements, ni pour toute erreur, diffamation, calomnie, omission, mensonge, obscénité, pornographie, blasphème, danger ou inexactitude contenue dans toute information à l\'intérieur de ces sites, sur le site Web. WebsiteName n\'assume aucune responsabilité pour toute action ou communication de Vous ou de tout tiers lié à l\'intérieur ou à l\'extérieur de ce site Web.</p>\r\n\r\n\r\n<h2>Résiliation</h2>\r\n\r\n<p>À sa seule discrétion, WebsiteName peut modifier ou interrompre le site Web, ou modifier ou résilier votre compte ou votre accès à ce site Web, pour quelque raison que ce soit, avec ou sans préavis, et sans engager votre responsabilité envers vous ou un tiers.</p>\r\n\r\n<h2>Produits et sites Web non affiliés</h2>\r\n\r\n<p>La description ou les références à des produits, des publications ou des sites Web qui ne sont pas la propriété de WebsiteName ou de ses filiales n\'impliquent pas l\'approbation de ce produit, de cette publication ou de ce site Web. WebsiteName n\'a pas examiné tout le matériel lié au site Web et n\'est pas responsable du contenu d\'un tel matériel. Votre lien vers d\'autres sites Web est à vos risques et périls.</p> \r\n\r\n<h2>Politique des liens</h2>\r\n\r\n<p>Ce site Web peut vous fournir, à titre de commodité, des liens vers des sites Web détenus ou exploités par des parties autres que WebsiteName. Chaque site Web lié peut avoir ses propres termes et conditions d\'utilisation, tels que décrits dans les mentions légales / conditions d\'utilisation de ce site Web. Ces termes et conditions peuvent être différents de ces termes légaux d\'utilisation, et nous vous invitons à lire attentivement les termes légaux de chaque site Web avant d\'utiliser ce site Web. WebsiteName ne contrôle pas et n\'est pas responsable de la disponibilité, du contenu ou de la sécurité de ces sites Web externes, ni de votre expérience d\'interaction ou d\'utilisation de ces sites Web externes. WebsiteName ne cautionne pas le contenu ou les produits ou services disponibles sur ces sites Web.</p>', '﻿<p>Su uso de WebsiteName (\"Sitio web\") está sujeto a su aceptación de estos términos legales de uso, incluyendo nuestra política de privacidad.</p>\r\n<p>WebsiteName se reserva el derecho, a su sola discreción, de modificar o actualizar estos términos legales de uso de vez en cuando con efecto inmediato y sin previo aviso. Es su responsabilidad revisar periódicamente estos términos legales de uso para ver si hay actualizaciones. </p>\r\n<p>SI POR ALGUNA RAZÓN NO ESTÁ DE ACUERDO O NO PUEDE CUMPLIR ESTOS TÉRMINOS Y POLÍTICA DE CONFIDENCIALIDAD, POR FAVOR SACA INMEDIATAMENTE ESTE SITIO. DE OTRA MANERA, AL ACCEDER Y USAR ESTA PÁGINA WEB, USTED ACEPTA ESTOS TÉRMINOS Y CONDICIONES DE USO Y NUESTRA POLÍTICA DE CONFIDENCIALIDAD. </p>\r\n\r\n<h2>Derechos de contenido y propiedad intelectual </h2>\r\n\r\n<p>Los derechos de autor en todos los documentos originales, contenido, selección y diseño del sitio web (incluyendo texto, interfaces de usuario y visuales, imágenes, apariencia, diseño, sonido, etc.) son propiedad de WebsiteName, sus empresas matrices, filiales, subsidiarias o terceros licenciantes. Usted no puede copiar, reproducir, publicar en otro sitio web, republicar, descargar, codificar, modificar, traducir públicamente, mostrar públicamente, explotar comercialmente, distribuir o transmitir cualquier parte de este sitio web o realizar trabajos derivados de este sitio web de ninguna manera sin el consentimiento previo por escrito de WebsiteName.</p>.  \r\n\r\n<p>Cualquier nombre, logotipo, marca comercial, marca de servicio, patente, diseño, derechos de autor, nombre de dominio u otra propiedad intelectual que aparezca en este sitio es propiedad de WebsiteName o de sus empresas matrices, filiales o subsidiarias y no podrá ser utilizado por Usted sin el consentimiento previo por escrito de WebsiteName o del propietario correspondiente. Su uso de este sitio web no le otorga ningún derecho, título, interés o licencia sobre dicha propiedad intelectual que aparezca en este sitio web. Cualquier uso no autorizado del contenido de este sitio web puede estar sujeto a sanciones civiles o penales.</p>\r\n\r\n<h2>Uso de este sitio web </h2>\r\n\r\n<p>WebsiteName mantiene este sitio web para sus compras personales, entretenimiento, información y educación. Usted debe sentirse libre de navegar por el sitio web. Sin embargo, cualquier copia (electrónica, impresa u otro formato) está prohibida y puede violar la propiedad intelectual y otras leyes en todo el mundo. Cualquier uso comercial de todo o parte de este sitio está prohibido, excepto con el consentimiento escrito de WebsiteName. Todos los derechos no expresamente concedidos en este documento están reservados a WebsiteName.</p>.  \r\n\r\n<p>Usted no puede utilizar ninguna herramienta de programa de computadora, incluyendo, pero no limitado a, arañas web, robots, indexadores, robots, rastreadores, cosechadores, o cualquier otro dispositivo automático o similar, programa, algoritmo o metodología (\") para acceder, adquirir, copiar o monitorear cualquier parte del Sitio o contenido, o reproducir o eludir de cualquier manera la estructura de navegación o presentación del Sitio o su contenido, para obtener o intentar obtener material, documentos o información. significa que no se ha puesto intencionadamente a disposición en el sitio web. Las herramientas que utilizan el sitio web deben ser consideradas como intermediarios de las personas que las controlan o escriben. </p>\r\n\r\n<h2>Limitación de la garantía </h2>\r\n\r\n<p>WebsiteName NO REPRESENTA QUE ESTE SITIO WEB O CUALQUIER CONTENIDO, SERVICIO O FUNCIONALIDAD DE ESTE SITIO WEB SERÁN EXCLUSIVAMENTE ERRORES O ININTERRUPTOS, O QUE CUALQUIER FALLA SERÁ CORREGIDA, O QUE SU USO DE ESTE SITIO WEB SERÁN PROPORCIONADOS DE RESULTADOS ESPECÍFICOSITOS. ESTE SITIO WEB Y SU CONTENIDO SE PROPORCIONAN \"TAL CUAL\" Y \"SEGÚN DISPONIBILIDAD\" SIN NINGUNA REPRESENTACIÓN O GARANTÍA DE NINGÚN TIPO, EXPRESA O IMPLÍCITA, INCLUYENDO, PERO SIN LIMITARSE A, LAS GARANTÍAS IMPLÍCITAS DE COMERCIABILIDAD, IDONEIDAD PARA UN PROPÓSITO PARTICULAR, NO INFRACCIÓN O EXACTITUD.</p>\r\n\r\n<p>WebsiteName no asume ninguna responsabilidad y no será responsable de ningún daño causado por virus u otras formas de contaminación o características destructivas que puedan afectar a su equipo informático, software, datos u otra propiedad debido a su acceso, uso o navegación por el sitio web o a la descarga de cualquier material, texto, imágenes, vídeo o audio del sitio web o de los sitios web enlazados. </p>.\r\n\r\n<h2>Limitación de responsabilidad </h2>\r\n\r\n<p>En ningún caso WebsiteName, sus empresas matrices, filiales, subsidiarias o proveedores de servicios, sus licenciatarios, o los funcionarios, directores, empleados, accionistas o agentes de cada uno de ellos, no serán responsables de daños de ningún tipo, incluidos, entre otros, daños directos, especiales, incidentales o indirectos, daños ejemplares, punitivos o consecuentes, incluido el lucro cesante, independientemente de que se les haya advertido o no de la posibilidad de tales daños, así como de la teoría de responsabilidad que surja de, o en relación con, el uso o el rendimiento de, o su navegación en, o su vinculación a, otros sitios desde, este sitio web. Al utilizar este sitio web, usted reconoce que el uso de este sitio web es bajo su propio riesgo. Algunas leyes no permiten limitaciones en las garantías implícitas o la exclusión o limitación de ciertos daños: si se aplican a usted, algunas o todas las exclusiones anteriores pueden no aplicarse, y usted puede tener derechos adicionales.\r\n\r\n<h2>Indemnización </h2>\r\n\r\n<p>Usted acepta defender, indemnizar y mantener indemne a WebsiteName de y contra todo reclamo, daño, costo y gasto, incluyendo honorarios razonables de abogados, que surjan de o en conexión con su uso del Sitio Web.\r\n\r\n<h2>Términos y condiciones complementarias </h2>\r\n\r\n\r\n\r\n<p>Los términos y condiciones adicionales pueden aplicarse a las compras de bienes y servicios y a ciertas partes de las características del Sitio Web, incluyendo, pero no limitándose a, ventas, licencias, concursos, sorteos, invitaciones u otras características similares (cada una de las cuales es una \"Solicitud\"). cuyos términos y condiciones adicionales forman parte de estos términos y condiciones legales de uso de esta referencia. Usted acepta cumplir con estos términos de uso. En caso de conflicto entre estos Términos de Uso y los términos de la Aplicación, los términos de la Aplicación se utilizarán con respecto a la Aplicación. </p>.\r\n\r\n<h2>Comunicaciones con este sitio web </h2>\r\n\r\n<p>Se le prohíbe publicar o transmitir cualquier material ilegal, amenazante, calumnioso, difamatorio, obsceno, escandaloso, inflamatorio, pornográfico o profano o cualquier material que pueda constituir o alentar conductas que puedan ser consideradas un delito penal, dar lugar a responsabilidad civil o violar de otro modo la ley. WebsiteName cooperará plenamente, incluyendo pero no limitándose a, mantener y revelar cualquier transmisión o comunicación que haya tenido con este sitio web, revelando su identidad o ayudando a identificarlo, con cualquier ley o regulación aplicable, autoridades de aplicación de la ley, orden judicial o autoridad gubernamental.\r\n\r\n<p>Cualquier comunicación o material que usted transmita al Sitio Web por correo electrónico o de otro modo, incluyendo cualquier dato, pregunta, comentario o sugerencia, o de otro modo, es y será tratada como no confidencial y no propietaria. WebsiteName no puede impedir la recopilación de información como su nombre y apellido o nombre de artista o cualquier otra información que usted revele en este sitio web, y usted puede ser contactado por WebsiteName o partes no relacionadas, por correo electrónico o de otra manera, dentro o fuera de este sitio web. Cualquier cosa que usted transmita puede ser editada por o en nombre de WebsiteName, puede o no ser publicada en este sitio a discreción de WebsiteName y puede ser utilizada por WebsiteName o sus afiliados para cualquier propósito, incluyendo pero no limitado a, reproducción, divulgación, transmisión, publicación, difusión y publicación. Además, WebsiteName es libre de utilizar cualquier idea, concepto, conocimiento o técnica contenida en cualquier comunicación que usted envíe al sitio web para cualquier propósito, incluyendo, pero no limitado a, desarrollar, fabricar y comercializar productos utilizando dicha información. Si usted transmite ideas, conceptos, materiales u otras comunicaciones al Sitio, usted acepta que no serán tratadas como confidenciales y que pueden ser utilizadas por WebsiteName sin compensación de ninguna manera, incluyendo, sin limitación, la reproducción, transmisión, publicación, comercialización, desarrollo de productos, etc. </p>.  \r\n\r\n<p>Aunque WebsiteName puede, de vez en cuando, monitorear o revisar discusiones, chats, publicaciones, transmisiones, tablones de anuncios, etc. en el Sitio Web, WebsiteName no tiene ninguna obligación de hacerlo y no asume ninguna responsabilidad por el contenido de tales sitios, ni por ningún error, difamación, difamación, difamación, calumnia, omisión, falsedad, obscenidad, pornografía, blasfemia, peligro o inexactitud contenida en cualquier información dentro de tales sitios, en el Sitio Web. WebsiteName no asume ninguna responsabilidad por cualquier acción o comunicación de Usted o de cualquier tercero vinculado dentro o fuera de este sitio web.</p>\r\n\r\n\r\n<h2>Terminación</h2>\r\n\r\n<p>WebsiteName puede, a su sola discreción, modificar o descontinuar el sitio web, o modificar o terminar su cuenta o acceso a este sitio web, por cualquier razón, con o sin previo aviso, y sin responsabilidad hacia usted o cualquier tercero.\r\n\r\n<h2>Productos y sitios web no afiliados </h2>\r\n\r\n<p>La descripción o las referencias a productos, publicaciones o sitios web que no son propiedad de WebsiteName o de sus filiales no implican la aprobación de dicho producto, publicación o sitio web. WebsiteName no ha revisado todos los materiales enlazados a la página web y no es responsable del contenido de dichos materiales. Su enlace a otros sitios web es bajo su propio riesgo. </p> \r\n\r\n<h2>Política de enlace</h2>\r\n\r\n<p>Este sitio web puede proporcionarle, para su comodidad, enlaces a sitios web propiedad de terceros o gestionados por terceros distintos de WebsiteName. Cada sitio web enlazado puede tener sus propios términos y condiciones de uso, tal y como se describe en el aviso legal / términos de uso de este sitio web. Estos términos y condiciones pueden diferir de estos términos legales de uso, por lo que le recomendamos que lea atentamente los términos legales de cada sitio web antes de utilizarlo. WebsiteName no controla ni es responsable de la disponibilidad, contenido o seguridad de estos sitios web externos, ni de su experiencia en la interacción o uso de estos sitios web externos. WebsiteName no respalda el contenido ni los productos o servicios disponibles en estos sitios web.</p>'),
(16, 'small', 'Global', 'Files PHP/JS/CSS', 'Files PHP/JS/CSS', 'Fichiers PHP/JS/CSS', 'Archivos PHP/JS/CSS'),
(17, 'small', 'Global', 'Ajax calls', 'Ajax calls', 'Appels Ajax', 'Ajax llama'),
(18, 'small', 'Sample', 'Sample page!', 'Sample page!', 'Page échantillon !', 'Página de muestra!'),
(19, 'small', 'Sample', 'Header Title', 'Title of sample page!', 'Titre de la page échantillon', 'Título de la página de muestra!'),
(20, 'small', 'Sample', 'Header Desc', 'Description of the sample page', 'Description de la page échantillon', 'Descripción de la página de muestra'),
(21, 'small', 'Admin', 'Session', 'Session', 'Session', 'Sesión'),
(22, 'small', 'Contact', 'Your name', 'Your name', 'Votre nom', 'Su nombre'),
(23, 'small', 'Contact', 'Contact Form', 'Contact Form', 'Formulaire de contact', 'Formulario de contacto'),
(24, 'small', 'Contact', 'Your email address', 'Your email address', 'Votre adresse email', 'Su dirección de email'),
(25, 'small', 'Contact', 'Subject of the message', 'Subject of the message', 'Objet du message', 'Asunto del mensaje'),
(26, 'small', 'Contact', 'Message', 'Message', 'Message', 'Mensaje'),
(27, 'small', 'Contact', 'Message sent!', 'Message sent!', 'Message envoyé !', 'Mensaje enviado!'),
(28, 'small', 'Global', 'Edit variable', 'Edit variable', 'Editer varible', 'Editar variable'),
(29, 'small', 'Global', 'Close', 'Close', 'Fermer', 'Cerrar'),
(30, 'small', 'Global', 'Home', 'Home', 'Accueil', 'Página principal'),
(31, 'medium', 'Signup', 'By signing up, you agree to the <a href=\"#/\" data-toggle=\"modal\" data-target=\"#Modal...', 'By signing up, you agree to the <a href=\"#/\" data-toggle=\"modal\" data-target=\"#ModalTerms\">Terms of use</a>.', 'En vous inscrivant, vous acceptez <a href=\"#/\" data-toggle=\"modal\" data-target=\"#ModalTerms\">Les conditions d\'utilisation</a>.', 'Al registrarse, usted acepta las <a href=\"#/\" data-toggle=\"modal\" data-target=\"#ModalTerms\">Términos de uso</a>.'),
(32, 'small', 'Global', 'Log in', 'Log in', 'Connexion', 'Iniciar sesión'),
(33, 'small', 'Signup', 'Welcome to WebsiteName! Please confirm your email', 'Welcome to WebsiteName! Please confirm your email', 'Bienvenue chez WebsiteName ! Merci de confirmer votre adresse mail', 'Bienvenido a WebsiteName! Por favor, confirme su email '),
(34, 'small', 'Signup', 'You\'re on your way! <br>Let\'s confirm your email address.', 'You\'re on your way! <br>Let\'s confirm your email address.', 'On y est presque, <br>Confirmons votre adresse email.', 'Ya casi estamos, <br>Confirma tu dirección de email.'),
(35, 'small', 'Signup', 'Please confirm the email address of your account by clicking on the following link:', 'Please confirm the email address of your account by clicking on the following link:', 'Veuillez confirmer l\'adresse email de votre compte en cliquant sur le lien suivant:', 'Por favor, confirme el email de su cuenta haciendo clic en el siguiente enlace:'),
(36, 'small', 'Signup', 'Confirm email address', 'Confirm email address', 'Confirmez votre adresse email', 'Confirme su email '),
(37, 'small', 'Signup', 'Your account has been created', 'Your account has been created', 'Votre compte a été créé', 'Su cuenta ha sido creada'),
(38, 'small', 'Signup', 'An email has been sent to', 'An email has been sent to', 'Un email a été envoyé à', 'Se envió un email a'),
(39, 'small', 'Signup', 'with a link to activate your account.', 'with a link to activate your account.', 'avec un lien pour activer votre compte.', 'con un enlace para activar su cuenta.'),
(40, 'small', 'Signup', 'If you can\'t find it, please check the spam folder in your mailbox.', 'If you can\'t find it, please check the spam folder in your mailbox.', 'Si vous ne le trouvez pas, veuillez vérifier les spams de votre boite email.', 'Si no lo encuentra, por favor revise la carpeta de spam en su buzón de correo. '),
(41, 'small', 'Signup', 'No account created, error when sending the email:', '﻿No account created, error when sending the email:', '﻿Aucun compte créé, erreur lors de l\'envoi de l\'email:', '﻿No se ha creado ninguna cuenta, error al enviar el email:'),
(42, 'small', 'Signup', 'This email is already registered.', 'This email is already registered.', '﻿Cet email est déjà enregistré.', 'Este email ya está registrado.'),
(43, 'small', 'Signup', 'Go to log in page', 'Go to log in page', 'Aller à la page de connexion', 'Ir a la página de inicio de sesión '),
(44, 'small', 'Signup', 'This email is incorrect', 'This email is incorrect', 'Cet email est incorrect', 'Este email es incorrecto'),
(45, 'small', 'Log in', 'Password forgotten? ', 'Password forgotten?', 'Mot de passe oublié ?', '¿Olvidó su contraseña?'),
(46, 'small', 'Global', 'Sign up', 'Sign up', 'Inscription', 'Suscribirse'),
(47, 'small', 'Log in', 'Reset password', 'Reset password', 'Réinitialiser le mot de passe', 'Restablecer contraseña'),
(48, 'small', 'Log in', 'An email with a link to create a new password will be sent to you.', 'An email with a link to create a new password will be sent to you.', 'Un email avec un lien pour créer un nouveau mot de passe vous sera envoyé.', 'Se le enviará un email con un enlace para crear una nueva contraseña. '),
(49, 'small', 'Log in', 'Account activation', 'Account activation', 'Activation du compte', 'Activación de la cuenta '),
(50, 'small', 'Log in', 'Invalid email or password', 'Invalid email or password', 'Email ou mot de passe invalide', 'Email o contraseña inválidos'),
(51, 'small', 'Log in', 'This email is also associated to the Social Network:', 'This email is also associated to the Social Network:', '﻿Cet email est aussi associé au réseau social:', ''),
(52, 'small', 'Log in', 'You have not activated your account', 'You have not activated your account', '﻿Vous n\'avez pas activé votre compte', 'No ha activado su cuenta'),
(53, 'medium', 'Log in', 'Please check your emails and your spam folder in your inbox to activate your account...', 'Please check your emails and your spam folder in your inbox to activate your account on WebsiteName', '﻿Veuillez vérifier vos emails ainsi que votre boite de spams pour activer votre compte WebsiteName', 'Por favor, compruebe sus emails y su carpeta de spam en su bandeja de entrada para activar su cuenta en WebsiteName'),
(54, 'small', 'Log in', 'Email not received?', 'Email not received?', 'Email non reçu ?', '¿No ha recibido el email?'),
(55, 'small', 'Log in', 'Resend the activation email', 'Resend the activation email', '﻿Réenvoyer l\'email d\'activation du compte', 'Reenviar el email de activación'),
(56, 'small', 'Log in', 'Send email in progress', 'Send email in progress', 'Envoi de l\'email en cours', 'Enviar email en progreso'),
(57, 'small', 'Log in', 'Back to Log in page', 'Back to Log in page', 'Revenir à la page de connexion', 'Volver a la página de acceso'),
(58, 'medium', 'Log in', 'Your account is associated to at least one Social Network and the Log in is through...', 'Your account is associated to at least one Social Network and the Log in is through the Social Network button.', '﻿Votre compte est associé à au moins un réseau social et la connexion passe par le bouton du réseau social.', 'Su cuenta está asociada a al menos una Red Social y el inicio de sesión se realiza a través del botón Red Social.'),
(59, 'small', 'Log in', 'You have to click on this button to Log in. Your account is associated to:', 'You have to click on this button to Log in. Your account is associated to:', '﻿Vous devez cliquer sur ce bouton pour vous connecter. Votre compte est associé à:', 'Debe hacer clic en este botón para iniciar sesión. Su cuenta está asociada a:'),
(60, 'small', 'Log in', 'This account does not exist or the link used is invalid.', 'This account does not exist or the link used is invalid.', '﻿Ce compte n\'existe pas ou le lien utilisé pour l\'activer est éronné.', 'Esta cuenta no existe o el enlace utilizado no es válido.'),
(61, 'medium', 'Log in', 'Your account cannot be activated with the link used, please check your messaging too...', 'Your account cannot be activated with the link used, please check your messaging tool and if the link is well used.', '﻿Votre compte ne peut pas être activé avec le lien utilisé, veuillez vérifier votre outil de messagerie et si le lien d\'activation est bien employé.', 'Su cuenta no puede ser activada con el enlace utilizado, por favor, compruebe su herramienta de mensajería y si el enlace está bien utilizado.'),
(62, 'large', 'Log in', 'Your account has been activated and you are connected.', 'Your account has been activated and you are connected.', '﻿Votre compte a été activé et vous êtes connecté.', 'Su cuenta ha sido activada y usted está conectado.'),
(63, 'small', 'Home', 'Deletion of your account', 'Deletion of your account', 'Suppression de votre compte', 'Eliminación de su cuenta'),
(64, 'medium', 'Log in', 'Your account is already activated, you can Log in with your <span class=\"underline-m...', 'Your account is already activated, you can Log in with your <span class=\"underline-mytheme\">email</span> and <span class=\"underline-mytheme\">password</span>.', '﻿Votre compte est déjà activé, vous pouvez vous identifier avec votre <span class=\"underline-mytheme\">email</span> et <span class=\"underline-mytheme\">mot de passe</span>.', 'Su cuenta ya está activada, puede iniciar sesión con su <span class=\"underline-mytheme\">email</span> y <span class=\"underline-mytheme\">contraseña</span>.'),
(65, 'small', 'Log in', 'There is no account with this email', 'There is no account with this email', 'Il n\'y a pas de compte avec cet email', 'No hay ninguna cuenta con este email'),
(66, 'small', 'Log in', 'This account is already activated', 'This account is already activated', '﻿Ce compte est déjà activé', 'Esta cuenta ya está activada'),
(67, 'small', 'Log in', 'This email is associated to the Social Network:', 'This email is associated to the Social Network:', 'Cet email est associé au réseau social:', 'Este email está asociado a la Red Social:'),
(68, 'small', 'Log in', 'You must use the Social Network button to log in.', 'You must use the Social Network button to log in.', 'Vous devez utiliser le bouton du réseau social pour vous connecter.', 'Debe utilizar el botón de Red Social para iniciar sesión.'),
(69, 'small', 'Log in', 'Reset password on WebsiteName', 'Reset password on WebsiteName', 'Réinitialisation du mot de passe de WebsiteName', 'Restablecer contraseña en WebsiteName'),
(70, 'small', 'Global', 'Hello', 'Hello', 'Bonjour', 'Hola'),
(71, 'small', 'Log in', 'A request was received for reseting the password of your account on WebsiteName', 'A request was received for reseting the password of your account on phpRegister', 'Une demande a été reçue pour réinitialiser le mot de passe de votre compte phpRegister', 'Se ha recibido una solicitud para restablecer la contraseña de su cuenta en phpRegister'),
(72, 'small', 'Log in', 'Email with a link to reset password sent to', 'Email with a link to reset password sent to', 'Email avec un lien pour créer un nouveau mot de passe envoyé à', 'Email con un enlace para crear una nueva contraseña enviado a '),
(73, 'small', 'Global', 'This link can only be used once and must be used within the next 2 hours.', 'This link can only be used once and must be used within the next 2 hours.', 'Ce lien ne peut être utilisé qu&#39;une fois et doit être utilisé pendant les 2 prochaines heures.', 'Este enlace sólo puede utilizarse una vez y debe utilizarse en las próximas 2 horas. '),
(74, 'small', 'Log in', 'Account activation on', 'Account activation on', 'Activation de votre compte', 'Activación de la cuenta en'),
(75, 'medium', 'Log in', 'You asked for a new link to activate your account on WebsiteName. <br>By clicking ...', 'You asked for a new link to activate your account on phpRegister.\r\n<br>By clicking on the following link, you are confirming your email address.', 'Vous avez demandé à recevoir de nouveau un lien d\'activation de votre compte sur phpRegister. \r\n<br>En cliquant sur le lien suivant, confirmez votre adresse email.', 'Usted pidió un nuevo enlace para activar su cuenta en phpRegister.\r\n<Al hacer clic en el siguiente enlace, usted está confirmando su dirección de email.'),
(76, 'small', 'Log in', 'Confirm email address', 'Confirm email address', 'Confirmez votre adresse email', 'Confirme su email'),
(77, 'medium', 'Log in', 'In case of problem using the link, you can copy-paste in your browser this link:', 'In case of problem using the link, you can copy-paste in your browser this link:', 'En cas de problème d\'utilisation du lien, vous pouvez copier-coller dans votre navigateur ce lien:', 'En caso de problemas al utilizar el enlace, puede copiar-pegar en su navegador este enlace: '),
(78, 'small', 'Log in', 'An email with a link to activate your account has been resent to ', 'An email with a link to activate your account has been resent to ', 'Un email contenant un lien pour activer votre compte vous a été renvoyé à ', 'Un email con un enlace para activar su cuenta ha sido reenviado a '),
(79, 'medium', 'Log in', 'If you don\'t find any mail from WebsiteName, please check also your spam folder in ...', 'If you don\'t find any mail from phpRegister, please check also your spam folder in your inbox email.\r\n<br>This email might take few minutes to arrive.', 'Si vous ne trouvez pas d\'email de la part de phpRegister, vérifiez aussi votre dossier des spams. \r\n<br>Cet email peut mettre plusieurs minutes pour arriver.', 'Si no encuentra ningún email de phpRegister, por favor revise también su carpeta de spam en su bandeja de entrada.\r\n<br>Este email puede tardar unos minutos en llegar.'),
(80, 'small', 'Log in', 'HeaderTitle', 'User account | phpRegister', 'Compte utilisateur | phpRegister', 'Cuenta de usuario | phpRegister'),
(81, 'medium', 'Home', 'This link to change your password on WebsiteName is no longer valid or is incorrect.', 'This link to change your password on WebsiteName is no longer valid or is incorrect.', 'Ce lien pour changer votre mot de passe sur WebsiteName a expiré ou est erroné.', 'Este enlace para cambiar su contraseña en WebsiteName ya no es válido o es incorrecto. '),
(82, 'small', 'Home', 'You can create a new one:', 'You can create a new one:', 'Vous pouvez en créer un autre:', 'Puede crear uno nuevo:'),
(83, 'small', 'Home', 'Create a new link', 'Create a new link', 'Créer un autre lien', 'Crear un nuevo enlace'),
(84, 'small', 'Home', 'Please, enter your new password twice.', 'Please, enter your new password twice.', 'Veuillez saisir par deux fois votre nouveau mot de passe.', 'Por favor, introduzca su nueva contraseña dos veces. '),
(85, 'small', 'Home', 'Your password has been changed, you can now log in with that new password.', 'Your password has been changed, you can now log in with that new password.', 'Votre mot de passe a bien été changé, vous pouvez maintenant vous connecter avec ce nouveau mot de passe.', 'Su contraseña ha sido cambiada, ahora puede iniciar sesión con esa nueva contraseña.'),
(86, 'small', 'Signup', 'Header Title', 'User account | WebsiteName', 'Compte utilisateur | WebsiteName', 'Cuenta de usuario | WebsiteName'),
(87, 'small', '404', 'Page not found', 'Page not found', 'Page non trouvée', ''),
(88, 'small', 'Global', 'Log out', 'Log out', 'Déconnexion', 'Cerrar sesión'),
(89, 'small', 'Global', 'My profile', 'My profile', 'Mon profil', 'Mi perfil');
INSERT INTO `pr__translation` (`id`, `length`, `page`, `name`, `en`, `fr`, `es`) VALUES
(90, 'small', 'Profile', 'Delete this image', 'Delete this image', 'Supprimer cette image', 'Eliminar esta imagen'),
(91, 'small', 'Global', 'Contact', 'Contact', 'Contact', 'Contacto'),
(92, 'small', 'Home', 'Your new email', 'Your new email', 'Votre nouvel e-mail', 'Su nuevo email'),
(93, 'small', 'Home', 'has been validated and you are connected.', 'has been validated and you are connected.', 'a été validé et vous êtes connecté.', 'ha sido validado y usted está conectado.'),
(94, 'medium', 'Home', 'This link to change the WebisteName email does not correspond to this session.', 'This link to change the phpRegister email does not correspond to this session.', 'Ce lien pour changer l\'email de phpRegister ne correspond pas à cette session.', 'Este enlace para cambiar el email de phpRegister no corresponde a esta sesión.'),
(95, 'small', 'Home', 'To change the email of your account, you must connect with this browser.', 'To change the email of your account, you must connect with this browser.', 'Pour changer l\'e-mail de votre compte, vous devez vous connecter sur ce navigateur.', 'Para cambiar el email de tu cuenta, debes conectarte con este navegador.'),
(96, 'small', 'Home', 'Your account is associated to the social network:', 'Your account is associated to the social network:', 'Votre compte est associé au réseau social:', 'Su cuenta está asociada a la red social:'),
(97, 'small', 'Home', 'Please enter your WebsiteName password to validate the new email', 'Please enter your phpRegister password to validate the new email', 'Veuillez entre votre mot de passe phpRegister pour valider le nouvel email', 'Por favor, introduzca su contraseña de phpRegister para validar el nuevo email'),
(98, 'small', 'Home', 'Invalid password', 'Invalid password', 'Mot de passe invalide', 'Contraseña inválida'),
(99, 'medium', 'Home', 'This link to change the WebsiteName email is no longer valid or is incorrect.', 'This link to change the WebsiteName email is no longer valid or is incorrect.', 'Ce lien pour changer d\'e-mail sur WebsiteName n\'est plus valide ou est erroné.', 'Este enlace para cambiar el email de WebsiteName ya no es válido o es incorrecto.'),
(100, 'small', 'Home', 'Change your WebsiteName password', 'Change your WebsiteName password', 'Modifier votre mot de passe sur WebsiteName', 'Cambiar su contraseña de WebsiteName'),
(101, 'small', 'Home', 'Change your WebsiteName email', 'Change your phpRegister email', 'Modifier votre email sur phpRegister', 'Cambie su email de phpRegister'),
(102, 'small', 'Profile', 'Change your email address', 'Change your email address', 'Modifier votre adresse e-mail', 'Cambiar su dirección de email'),
(103, 'small', 'Profile', 'An email was sent to you at', 'An email was sent to you at ', '﻿Un email vous a été envoyé à ', 'Se le envió un email a '),
(104, 'small', 'Profile', 'with a link to validate it', 'with a link to validate it', 'avec un lien pour le valider', 'con un enlace para validarlo'),
(105, 'small', 'Profile', 'Delete activation?', 'Delete activation?', 'Supprimer activation ?', '¿Borrar la activación?'),
(106, 'small', 'Profile', 'Yes, delete', 'Yes, delete', 'Oui, supprimer', 'Sí, borrar'),
(107, 'small', 'Profile', 'No address registered', 'No address registered', 'Aucune adresse enregistrée', 'No hay dirección registrada'),
(108, 'small', 'Profile', 'ChangeYourPassword', 'Change your password', 'Modifiez votre mot de passe', 'Cambiar su contraseña'),
(109, 'small', 'Profile', 'Current', 'Current', 'Actuel', 'Actual'),
(110, 'small', 'Profile', 'New', 'New', 'Nouveau', 'Nuevo'),
(111, 'small', 'Profile', 'Confirm', 'Confirm', 'Confirmez', 'Confirmar'),
(112, 'small', 'Profile', 'Are you sure you want to delete your account?', 'Are you sure you want to delete your account?', 'Êtes-vous sûr de vouloir supprimer votre compte ?', '¿Estás seguro de que quieres borrar tu cuenta?'),
(113, 'small', 'Profile', 'Error sending email, please try again later.', 'Error sending email, please try again later.', 'Erreur envoie email, veuillez rééssayer plus tard.', 'Error al enviar un email, por favor inténtelo de nuevo más tarde.'),
(114, 'small', 'Profile', 'Your new email on WebsiteName', 'Your new email on WebsiteName', 'Votre nouvel email sur WebsiteName', 'Su nuevo email en WebsiteName'),
(115, 'medium', 'Profile', '﻿A request has been received to change the email address of your WebsiteName account...', '﻿A request has been received to change the email address of your phpRegister account. To confirm this change, please click on the following link:', '﻿Une demande a été reçue pour modifier l\'adresse email de votre compte phpRegister. Pour confirmer ce changement, veuillez cliquer sur le lien suivant:', '﻿Se ha recibido una solicitud para cambiar la dirección de email de su cuenta de phpRegister. Para confirmar este cambio, haga clic en el siguiente enlace:'),
(116, 'small', 'Profile', 'This email is not valid', 'This email is not valid', 'Cet email n\'est pas valide', 'Este email no es válido'),
(117, 'small', 'Profile', 'There is already an account with this email', 'There is already an account with this email', 'Il y a déjà un compte avec cet email', 'Ya hay una cuenta con este email'),
(118, 'small', 'Profile', 'Delete account', 'Delete account', 'Supprimer le compte', 'Borrar la cuenta'),
(119, 'small', 'Profile', '﻿Successfully changed password', '﻿Successfully changed password', '﻿Mot de passe modifié avec succès', '﻿Contraseña cambiada con éxito'),
(120, 'small', 'Profile', 'The new password and its confirmation are not identical', 'The new password and its confirmation are not identical', 'Le nouveau mot de passe et sa confirmation ne sont pas identiques', 'La nueva contraseña y su confirmación no son idénticas'),
(121, 'small', 'Profile', 'Incorrect current password', '﻿Incorrect current password', '﻿Mot de passe actuel erroné', '﻿Contraseña actual incorrecta'),
(122, 'small', 'Global', 'You must Log in to access this page', 'You must Log in to access this page', 'Vous devez vous connecter pour accéder à cette page', 'Debe iniciar sesión para acceder a esta página'),
(123, 'small', 'Profile', 'Modify this address', 'Modify this address', 'Modifier cette addresse', 'Cambiar esta dirección'),
(124, 'small', 'Profile', 'Delete this address', 'Delete this address', 'Supprime cette adresse', 'Borrar esta dirección'),
(125, 'small', 'Profile', 'Your delivery addresses', 'Your delivery addresses', 'Vos adresses de livraison', 'Sus direcciones de entrega'),
(126, 'small', 'Profile', 'Add an address', 'Add an address', 'Ajouter une adresse', 'Añadir una dirección'),
(127, 'small', 'Profile', 'Your delivery address', 'Your delivery address', 'Votre adresse de livraison', 'Su dirección de entrega'),
(128, 'small', 'Profile', 'New password not long enough', 'New password not long enough', 'Nouveau mot de passe pas assez long', 'La nueva contraseña no es lo suficientemente larga'),
(129, 'small', 'Profile', 'Validate this email', 'Validate this email', 'Valider cet email', 'Validar este email'),
(130, 'small', 'Global', 'Thank you, <br> The WebsiteName team', 'Thank you, <br> The WebsiteName team', 'Merci, <br> L\'équipe WebsiteName', 'Gracias, <br> El equipo de WebsiteName'),
(131, 'small', 'Global', 'Unable to determine the type of file', 'Unable to determine the type of file', 'Impossible de déterminé le type de ficher', 'No se puede determinar el tipo de archivo'),
(132, 'small', 'Global', 'Modify', 'Modify', 'Modifier', 'Modificar'),
(133, 'small', 'Global', 'Cancel', 'Cancel', 'Annuler', 'Cancelar'),
(134, 'small', 'Global', 'Please upload a photo in .jpg format', '﻿Please upload a photo in .jpg format', '﻿Veuillez télécharger une photo au format .jpg', 'Por favor, suba una foto en formato .jpg'),
(135, 'small', 'Global', '﻿Please wait until the current download is complete. ', '﻿Please wait until the current download is complete.', '﻿Veuillez attendre que le téléchargement en cours soit terminé.', 'Por favor, espere hasta que la descarga actual esté completa. '),
(136, 'small', 'Global', 'File too large, maximum size:', 'File too large, maximum size:', 'Fichier trop volumineux, taille maximale:', 'Archivo demasiado grande, tamaño máximo:'),
(137, 'small', 'Global', 'Please fill out this field', 'Please fill out this field', 'Veuillez saisir ce champs', 'Por favor, rellene este campo'),
(138, 'small', 'Global', 'CancelUpload', 'Cancel upload', 'Annuler téléchargement', 'Cancelar la carga'),
(139, 'small', 'Global', 'Demos', 'Demos', 'Démos', 'Demos'),
(140, 'small', 'Global', 'Logout in progress', 'Logout in progress', 'Déconnexion en cours', 'Desconexión en curso'),
(141, 'small', 'Global', 'Save', 'Save', 'Enregistrer', 'Registrarse'),
(142, 'small', 'Global', 'Delete', 'Delete', 'Supprimer', 'Borrar'),
(143, 'small', 'Global', 'Submit', 'Submit', 'Soumettre', 'Regístrese'),
(144, 'small', 'Global', 'About us', 'About us', 'Qui sommes-nous', 'Acerca de nosotros'),
(145, 'small', 'Global', 'Contact us', 'Contact us', 'Contactez-nous', 'Contáctenos'),
(146, 'small', 'Global', 'Terms of use', 'Terms and Conditions', 'Conditions générales d\'utilisation', 'Condiciones generales de uso'),
(147, 'small', 'Admin', 'Please confirm the reopening of the ticket', 'Please confirm the reopening of the ticket', 'Veuillez confirmer la réouverture du ticket', 'Por favor, confirme la reapertura del billete'),
(148, 'small', 'Admin', 'Reopen', 'Reopen', 'Réouvrir', 'Reabrir'),
(149, 'small', 'Helpdesk', 'Ticket resolved', 'Ticket resolved', 'Ticket résolu', 'Ticket resuelto'),
(150, 'small', 'Admin', 'Please confirm the ticket resolution', 'Please confirm the ticket resolution', 'Veuillez confirmer la résolution du ticket', 'Por favor, confirme la resolución del billete'),
(151, 'small', 'Admin', 'Delete this ticket', 'Delete this ticket', 'Supprimer ce ticket', 'Borrar este ticket'),
(152, 'small', 'Admin', 'Account without email', 'Account without email', 'Compte sans email', 'Cuenta sin email'),
(153, 'small', 'Admin', 'Please confirm the deletion of the ticket and its replies.', 'Please confirm the deletion of the ticket and its replies.', 'Veuillez confirmer la suppression du ticket et de ses réponses', 'Veuillez confirmer la suppression du ticket et ses réponses.'),
(154, 'small', 'Admin', '﻿Total number of replies', '﻿Total number of replies', '﻿Nombre total de réponses', '﻿Número total de respuestas'),
(155, 'small', 'Admin', 'Total number of tickets', 'Total number of tickets', 'Nombre total de tickets', 'Número total de tickets'),
(156, 'small', 'Admin', 'Your signature', 'Your signature', 'Votre signature', 'Su firma'),
(157, 'small', 'Admin', 'Reply as', 'Reply as', 'Répondre en tant que', 'Responder como'),
(158, 'small', 'Admin', 'Pre-filling of ticket replies', 'Pre-filling of ticket replies', 'Pré-remplissage des réponses aux tickets', 'Pre-llenado de las respuestas de los tickets'),
(159, 'small', 'Admin', 'Environment variables', 'Environment variables', 'Variables d\'environnement', 'Variables de entorno'),
(160, 'small', 'Admin', 'Delete ticket', 'Delete ticket', 'Supprimer le ticket', 'Borrar ticket'),
(161, 'small', 'Admin', 'Account details', 'Account details', 'Détails du compte', 'Datos de la cuenta'),
(162, 'small', 'Helpdesk', 'Resolved', 'Resolved', 'Résolu', 'Resuelto'),
(163, 'small', 'Helpdesk', 'In progress', 'In progress', 'En cours', 'En curso'),
(164, 'small', 'Helpdesk', 'Sent', 'Sent', 'Envoyé', 'Enviado'),
(165, 'small', 'Profile', 'Receive the newsletter', 'Receive the newsletter', 'Recevoir la newsletter', 'Recibir el boletín de noticias'),
(166, 'medium', 'Profile', 'I would like to receive the WebsiteName newsletter and be informed of new features a...', 'I would like to receive the WebsiteName newsletter and be informed of new features and upcoming events', 'Je souhaite recevoir la newsletter WebsiteName et être informé des nouveautés et des événements à venir', 'Me gustaría recibir el boletín de WebsiteName y estar informado de las nuevas características y los próximos eventos.'),
(167, 'small', 'Profile', 'with a link to delete your account.', 'with a link to delete your account.', 'avec un lien pour supprimer votre compte.', 'con un enlace para eliminar su cuenta.'),
(168, 'small', 'Profile', 'Cancel the account deletion?', 'Cancel the account deletion?', 'Annuler la suppression du compte ?', '¿Cancelar la eliminación de la cuenta?'),
(169, 'small', 'Profile', 'Yes, cancel', 'Yes, cancel', 'Oui, annuler', 'Sí, cancelar'),
(170, 'small', 'Profile', 'For an account deletion, an email must be attached to your account.', 'For an account deletion, an email must be attached to your account.', 'Pour une suppression de compte, un email doit être joint à votre compte.', 'Para eliminar una cuenta, debe adjuntarse un correo electrónico a su cuenta.'),
(171, 'small', 'Profile', 'An email was sent to', 'An email was sent to', 'Un email a été envoyé à', 'Un email fue enviado a'),
(172, 'medium', 'Profile', 'Click on <i class=\"fa fa-plus fnt-1-2 px-2 pointer\" onClick=\"addressModalOpen();\" ><...', 'Click on <i class=\"fa fa-plus fnt-1-2 px-2 pointer\" onClick=\"addressModalOpen();\" ></i> to add an address.', 'Cliquez sur <i class=\"fa fa-plus fnt-1-2 px-2 pointer\" onClick=\"addressModalOpen();\" ></i> pour ajouter une adresse.', 'Haga clic en <i class=\"fa fa-plus fnt-1-2 px-2 pointer\" onClick=\"addressModalOpen();\" ></i> para añadir una dirección'),
(173, 'small', 'Profile', 'Please check to confirm', 'Please check to confirm', 'Veuillez cocher pour confirmer', 'Por favor, compruebe para confirmar'),
(174, 'small', 'Profile', 'Deleting your WebsiteName account', 'Deleting your WebsiteName account', 'Suppression de votre compte sur WebsiteName', 'Eliminación de su cuenta de WebsiteName'),
(175, 'medium', 'Profile', 'You have asked to delete your WebsiteName account <br>Clicking on the following link...', 'You have asked to delete your WebsiteName account <br>Clicking on the following link will allow you to delete your account.', 'Vous avez demandé de supprimer votre compte de phpRegister <br>En cliquant sur le lien suivant, vous pourrez supprimer votre compte.', 'Usted ha solicitado borrar su cuenta de WebsiteName <br>Haciendo clic en el siguiente enlace le permitirá borrar su cuenta.'),
(176, 'small', 'Profile', 'The deletion will be final', 'The deletion will be final', 'La suppression sera définitive', 'La eliminación será definitiva'),
(177, 'small', 'Profile', 'Your name', 'Your name', 'Votre nom', 'Su nombre'),
(178, 'small', 'Profile', 'Line', 'Line', 'Ligne', 'Línea'),
(179, 'small', 'Profile', 'City', 'City', 'Ville', 'Ciudad'),
(180, 'small', 'Profile', 'Postal code', 'Postal code', 'Code postal', 'Código postal'),
(181, 'small', 'Profile', 'Country', 'Country', 'Pays', 'País'),
(182, 'small', 'Profile', 'Address name', 'Address name', 'Nom de l\'adresse', 'Nombre de la dirección'),
(183, 'small', 'Profile', 'Home, Work, Billing, Holidays...', 'Home, Work, Billing, Holidays...', 'Maison, Travail, Facturation, Vacances....', 'Hogar, Trabajo, Facturación, Vacaciones......'),
(184, 'small', 'Signup', 'The password must contain at least one special character such as: ! # @ - _', 'The password must contain at least one special character such as: ! # @ - _', '﻿Le mot de passe doit contenir au moins un caractère spécial tel que : ! # @ - _', 'La contraseña debe contener al menos un carácter especial como: ! # @ - _'),
(185, 'small', 'Home', 'Your account and all details of your account have been deleted.', 'Your account and all details of your account have been deleted.', 'Votre compte et tous les détails de votre compte ont été supprimés.', 'Su cuenta y todos los detalles de su cuenta han sido eliminados.'),
(186, 'small', 'Signup', 'The password must contain at least one letter.', 'The password must contain at least one letter.', 'Le mot de passe doit contenir au moins une lettre.', 'La contraseña debe contener al menos una letra.'),
(187, 'small', 'Signup', 'The password must contain at least one number.', 'The password must contain at least one number.', 'Le mot de passe doit contenir au moins un chiffre.', 'La contraseña debe contener al menos un número.'),
(188, 'small', 'Signup', 'Password not long enough.', 'Password not long enough.', 'Mot de passe pas assez long.', 'La contraseña no es lo suficientemente larga.'),
(189, 'small', 'Global', 'My account', 'My account', 'Mon compte', 'Mi cuenta'),
(190, 'small', 'Global', 'User support', 'User support', 'Support utilisateur', 'Soporte de usuarios'),
(191, 'small', 'Log in', 'NEW AT', 'NEW AT', 'NOUVEAU CHEZ', 'NUEVO EN'),
(192, 'small', 'Log in', '<p>Free and fast registration.<br>Get the latest news and security alerts.</p>', '<p>Free and fast registration.<br>Get the latest news and security alerts.</p>', '<p>Inscription rapide et gratuite.<br>Obtenez les dernières nouveautés et les alertes de sécurité.</p>', '<p>Registro gratuito y rápido.<br>Obtener las últimas noticias y alertas de seguridad.</p>'),
(193, 'small', 'Log in', 'Create an account', '﻿Create an account', 'Créer un compte', 'Crear una cuenta'),
(194, 'small', 'Log in', 'ALREADY REGISTERED?', 'ALREADY REGISTERED?', 'DÉJÀ INSCRIT ?', 'YA ESTÁ REGISTRADO?'),
(195, 'medium', 'Admin', '<b>Countries</b> ordered by their codes. Countries which are not \"Displayed\" will no...', '<b>Countries</b> ordered by their codes. Countries which are not \"Displayed\" will not appear in the countries list proposed to users when they fill a new address.', '<b>Pays</b> classés par leur code. Les pays qui ne sont pas \" Displayed\" n\'apparaîtront pas dans la liste des pays proposés aux utilisateurs lorsqu\'ils remplissent une nouvelle adresse.', '<b>Países</b> ordenados por sus códigos. Los países que no son \"Displayed\" no aparecerán en la lista de países propuestos a los usuarios cuando rellenen una nueva dirección.'),
(402, 'small', 'Admin', 'Select year', 'Select year', 'Sélectionner année', 'Seleccione el año');
INSERT INTO `pr__translation` (`id`, `length`, `page`, `name`, `en`, `fr`, `es`) VALUES
(403, 'large', 'Terms', 'Privacy Policy - Content', '﻿<h2>How We Collect and Use Information</h2>\r\n\r\n<p>We ask for certain information such as your username, real name, birthdate, address, phone number and e-mail address when you register for a WebsiteName account, or if you correspond with us. We may also retain any messages you send through the Service, and may collect information you provide in User Content you post to the Service. We use this information to operate, maintain, and provide to you the features and functionality of the Service. Your username and if you choose to disclose it, your real name, will be published publicly. Once published your username and / or real name may not be able to be removed.</p>\r\n\r\n<h2>Information we may receive from third parties:</h2>\r\n\r\n<p>We may receive information about you from third parties. For example, if you access our websites or Service through a third-party connection or log-in, for example, through Facebook Connect, by “following,” “liking,” adding the WebsiteName application, linking your account to the WebsiteName Service, etc., that third party may pass certain information about your use of its service to WebsiteName. This information could include, but is not limited to, the user ID associated with your account (for example, your Facebook UID), an access token necessary to access that service, any information that you have permitted the third party to share with us, and any information you have made public in connection with that service. If you allow us access to your friends list, your friends’ user IDs, and your connection to those friends, may be used and stored to make your experience more social, and to allow you to invite your friends to use our Service as well as provide you with updates if and when your friends join WebsiteName. You should always review, and if necessary, adjust your privacy settings on third-party websites and services before linking or connecting them to the WebsiteName Service. You may also unlink your third party account from the Service by adjusting your settings on the third party service.</p>\r\n\r\n<h2>Inviting a friend to use WebsiteName:</h2>\r\n\r\n<p>WebsiteName may, in its sole discretion, develop a feature that allows you to invite third parties to the Service. If you choose to use our invitation service to invite a third party to the Service through our “Invite friends” feature, you may directly choose a friend to invite through your mobile device’s native contact list – but we do not require that you import your contacts list to the Service, and we do not retain the information contained in your contacts list. You understand that by inviting a friend to WebsiteName through the “Invite friends” feature, you are directly sending a text or email from your personal accounts and that we are not storing your contact list. In addition, you understand and agree that normal carrier charges apply to communications sent from you phone. Since this invitation is coming directly from your email or phone, we do not have access to or control this communication.</p>\r\n\r\n<h2>Finding your friends on the Service:</h2>\r\n\r\n<p>WebsiteName may, in its sole discretion, develop a feature that allows you to locate your friends with WebsiteName accounts through a “Find friends” feature. The “Find friends” feature allows you to choose to locate friends either through (i) your contact list, (ii) social media sites (such as Twitter or Facebook) or (iii) through a search of names and usernames on WebsiteName. If you choose to find your friends through your contact list, then you agree to provide WebsiteName access to your contact list such that we can perform the search necessary to determine whether or not someone associated with the information you provide is using WebsiteName. If you choose to find your friends through social media sites, then you understand that the information these sites provide to use to conduct this type of search is governed by their privacy policies and your account settings on those sites. If you choose to find your friends through a search of names or usernames, then simply type a name to search and see if that name or username appears on our Service. Note that we do not retain any information contained in your contacts list, or information from social media sites about your contacts, and we do not use such information for any purpose other than to help you find your friends on WebsiteName.</p>\r\n\r\n<h2>Analytics information:</h2>\r\n\r\n<p>We may directly collect analytics data, or use third-party analytics tools and services, to help us measure traffic and usage trends for the Service. These tools collect information sent by your browser or mobile device, including the pages you visit and other information that assists us in improving the Service. We collect and use this analytics information in aggregate form such that it cannot reasonably be manipulated to identify any particular individual user.</p>\r\n\r\n<h2>Cookies information:</h2>\r\n\r\n<p>Full details can be found on our Cookie Policy. When you visit the Service, we may send one or more cookies — a small text file containing a string of alphanumeric characters — to your computer that uniquely identifies your browser and lets WebsiteName help you log in faster and enhance your navigation through the site. A cookie may also convey information to us about how you use the Service (e.g., the pages you view, the links you click and other actions you take on the Service), and allow us or our business partners to track your usage of the Service over time. A persistent cookie remains on your hard drive after you close your browser. Persistent cookies may be used by your browser on subsequent visits to the site. Persistent cookies can be removed by following your web browser’s directions. A session cookie is temporary and disappears after you close your browser. You can reset your web browser to refuse all cookies or to indicate when a cookie is being sent. However, some features of the Service may not function properly if the ability to accept cookies is disabled. Full details can be found on our Cookie Policy.</p>\r\n\r\n<h2>Log file information:</h2>\r\n\r\n<p>Log file information is automatically reported by your browser or mobile device each time you access the Service. When you use our Service, our servers automatically record certain log file information. These server logs may include anonymous information such as your web request, Internet Protocol (“IP”) address, browser type, referring / exit pages and URLs, number of clicks and how you interact with links on the Service, domain names, landing pages, pages viewed, and other such information.</p>\r\n\r\n<h2>Clear gifs/web beacons information:</h2>\r\n\r\n<p>When you use the Service, we may employ clear gifs (also known as web beacons) which are used to anonymously track the online usage patterns of our Users. In addition, we may also use clear gifs in HTML-based emails sent to our users to track which emails are opened and which links are clicked by recipients. The information is allows for more accurate reporting and improvement of the Service.</p>\r\n\r\n<h2>Device identifiers:</h2>\r\n\r\n<p>When you access the Service by or through a mobile device (including but not limited to smart-phones or tablets), we may access, collect, monitor and/or remotely store one or more “device identifiers,” such as a universally unique identifier (“UUID”). Device identifiers are small data files or similar data structures stored on or associated with your mobile device, which uniquely identify your mobile device. A device identifier may be data stored in connection with the device hardware, data stored in connection with the device’s operating system or other software, or data sent to the device by WebsiteName. A device identifier may convey information to us about how you browse and use the Service. A device identifier may remain persistently on your device, to help you log in faster and enhance your navigation through the Service. Some features of the Service may not function properly if use or availability of device identifiers is impaired or disabled.</p>\r\n\r\n<h2>Location data:</h2>\r\n\r\n<p>When you access the Service by or through a mobile device, we may access, collect, monitor and/or remotely store “location data,” which may include GPS coordinates (e.g. latitude and/or longitude) or similar information regarding the location of your mobile device. Location data may convey to us information about how you browse and use the Service. Some features of the Service, particularly location-based services, may not function properly if use or availability of location data is impaired or disabled.</p>\r\n\r\n<h2>Commercial and marketing communications:</h2>\r\n\r\n<p>We use the information we collect or receive, such as your email address, to communicate directly with you. We may send you emails containing newsletters, promotions, and special offers. If you do not want to receive such email messages, you will be given the option to opt out or change your preferences. We also use your information to send you Service-related emails (e.g., account verification, purchase and billing confirmations and reminders, changes/updates to features of the Service, technical and security notices). You may not opt out of Service-related emails. You may also be able to be “found” on WebsiteName based on information that you provide (see “Find friends on WebsiteName”) above.</p>\r\n\r\n<h2>Use of certain service type information we collect about you:</h2>\r\n\r\n<p>We use or may use cookies, log file, device identifiers, location data and clear gifs information to: (a) remember information so that you will not have to re-enter it during your visit or the next time you visit the site; (b) provide custom, personalized content and information; (c) to provide and monitor the effectiveness of our Service; (d) monitor aggregate metrics such as total number of visitors, traffic, and demographic patterns; (e) diagnose or fix technology problems; (f) help you efficiently access your information after you sign in; (g) to provide advertising to your browser or device, and (h) automatically update the WebsiteName application on your mobile devices.</p>\r\n\r\n<h2>Sharing of Your Information</h2>\r\n\r\n<p>We will not rent or sell your information into third parties outside WebsiteName and its group companies (including any parent, subsidiaries and affiliates) without your consent, except as noted below:</p>\r\n\r\n<p>Who we may share your information with: We may share your information with third-party business partners and Trusted Users for the purpose of providing the Service to you. Third party business partners will be given limited access to your information as is reasonably necessary to deliver the Service, and we will require that such third parties comply with this Privacy Policy, or operate under a similar privacy policy.</p>\r\n\r\n<p>Who can see User Content: Any User Content that you voluntarily disclose for posting to the Service becomes available to the public and cannot be removed, except by WebsiteName in its sole discretion. Once posted on WebsiteName, User Content may not be removable from public view, as copies may remain viewable in cached and archived pages of the Service, on other sites that have republished us, or if other Users have copied or saved that information. If you do not wish your User Content to be available to the public, please don’t post it on WebsiteName. Your username and if you choose to disclose it, your real name, will be published publicly. Once published your username and / or real name may not be able to be removed.</p>\r\n\r\n<p>Who can see your IP address: If you post User Content on the Service while not logged in, your IP address will be published with your User Content in order to attribute your contribution to the Service. A selection of Trusted Users with administrative powers on WebsiteName have the ability to review IP addresses of users to reduce abusive behavior. Any third party service embedded on WebsiteName such as an advertiser, video provider, social network or other third party will also have access to your IP address.</p>\r\n\r\n<p>Who can see your email address: If you enter an email address, you will enable communication from WebsiteName and other Users. If you reply to users or participate in group WebsiteName activities such as meetups, your email address will be shared with these users.</p>\r\n\r\n<h2>What happens in the event of a change of control:</h2>\r\n\r\n<p>We may buy or sell/divest/transfer the company (including any shares in the company), or any combination of its products, services, assets and/or businesses. Your information such as customer names and email addresses, User Content and other user information related to the Service may be among the items sold or otherwise transferred in these types of transactions. We may also sell, assign or otherwise transfer such information in the course of corporate divestitures, mergers, acquisitions, bankruptcies, dissolutions, reorganizations, liquidations, similar transactions or proceedings involving all or a portion of the company.</p>\r\n\r\n<h2>Instances where we are required to share your information:</h2>\r\n\r\n<p>WebsiteName will disclose your information where required to do so by law or subpoena or if we reasonably believe that such action is necessary to (a) comply with the law and the reasonable requests of law enforcement; (b) to enforce our Terms of Use or to protect the security, quality or integrity of our Service; and/or (c) to exercise or protect the rights, property, or personal safety of WebsiteName, our Users, or others.</p>\r\n\r\n<h2>Sharing certain service type information we collect about you:</h2>\r\n\r\n<p>We may share certain service type information, including information obtained through tools such as cookies, log files, device identifiers, location data and clear gifs (such as anonymous usage data, referring/exit pages and URLs, platform types, number of clicks, etc.): (i) with our third-party business partners for the purposes described in the section above on “How We Collect and Use Information.” We may also aggregate or otherwise strip data of all personally identifying characteristics and may share that aggregated, anonymized data with third parties.</p>\r\n\r\n<h2>Ads on WebsiteName:</h2>\r\n\r\n<p>We may also share certain information such as your location, browser, and cookie data and other data relating to your use of our Service with our business partners to deliver advertisements (“ads”) that may be of interest to you. WebsiteName may allow third-party ad servers or ad networks to serve advertisements on the Service. These third-party ad servers or ad networks use technology to send, directly to your browser or mobile device, the ads and ad links that appear on the Service, and will automatically receive your IP address when they do so. They may also use other technologies (such as cookies, JavaScript, device identifiers, location data, and clear gifs, see above) to compile information about your browser’s or device’s visits and usage patterns on the Service and on other websites, and to measure the effectiveness of their ads and to personalize the advertising content delivered to you.</p>\r\n\r\n<p>For example, Google uses DART cookies in order to deliver ads to you through the Service. Google\'s use of the DART cookie enables it and its partners to serve ads to you based on your visit to the Service and previous websites that you may have visited. Other advertising networks also use similar cookies, clear gifs, or other mechanisms to deliver targeted advertising to you through the Service. You can delete these cookies by following the instructions of your browser.</p>\r\n\r\n<p>Please note that an advertiser may ask WebsiteName to show an ad to a certain audience of Users (e.g., based on demographics or other interests). In that situation, WebsiteName or our Partners determines the target audience and WebsiteName serves the advertising to that audience and only provides anonymous data to the advertiser. If you respond to such an ad, the advertiser or ad server may conclude that you fit the description of the audience they are trying to reach.</p>\r\n\r\n<p>To enhance your user experience or help us improve and measure our effectiveness, WebsiteName may embed code from third parties on the Service. Examples of such parties may include Facebook, Twitter, Pinterest, Google, YouTube, Howcast, VideoJug, AOL, and others. These third parties may collect information about you including IP address, cookies in ways WebsiteName does not control.</p>\r\n\r\n<p>The WebsiteName Privacy Policy does not apply to, and we cannot control the activities of third-parties. Please consult the respective privacy policies of such third parties or contact such third parties for more information.</p>\r\n\r\n<h2>Storage and Processing:</h2>\r\n\r\n<p>Your information collected through the Service may be stored and processed in the United States or any other country in which WebsiteName or its subsidiaries, affiliates, or service providers maintain facilities. WebsiteName may transfer information that we collect about you, including personal information, to affiliated entities, or to other third parties across borders and from your country or jurisdiction to other countries or jurisdictions around the world. If you are located in the European Union or other regions with laws governing data collection and use that may differ from U.S. law, please note that we may transfer information, including personal information, to a country and jurisdiction that does not have the same data protection laws as your jurisdiction, and you consent to the transfer of information to the U.S. or any other country in which WebsiteName or its parent, subsidiaries, affiliates, or service providers maintain facilities and the use and disclosure of information about you as described in this Privacy Policy.</p>\r\n\r\n<h2>Keeping your information safe:</h2>\r\n\r\n<p>WebsiteName cares about the security of your information, and uses commercially reasonable safeguards to preserve the integrity and security of all information collected through the Service. To protect your privacy and security, we take reasonable steps (such as requesting a unique password) to verify your identity before granting you access to your account. You are responsible for maintaining the secrecy of your unique password and account information, and for controlling access to your email communications from WebsiteName, at all times. However, WebsiteName cannot ensure or warrant the security of any information you transmit to WebsiteName or guarantee that information on the Service may not be accessed, disclosed, altered, or destroyed. Your privacy settings may also be affected by changes to the functionality of third party sites and services that you add to the WebsiteName Service, such as social networks. WebsiteName is not responsible for the functionality or security measures of any third party.</p>\r\n\r\n<h2>Compromise of information:</h2>\r\n\r\n<p>In the event that any information under our control is compromised as a result of a breach of security, WebsiteName will take reasonable steps to investigate the situation and where appropriate, notify those individuals whose information may have been compromised and take other steps, in accordance with any applicable laws and regulations.</p>\r\n\r\n<h2>Your Choices about Your Information</h2>\r\n\r\n<p>You control your account information and settings: You may update your account information and email-communication preferences at any time by logging in to your account and changing your profile settings. </p>\r\n\r\n<p>We make every effort to promptly process all unsubscribe requests. As noted above, you may not opt out of Service-related communications (e.g., account verification, purchase and billing confirmations and reminders, changes/updates to features of the Service, technical and security notices). If you have any questions about reviewing or modifying your account information, you can contact us directly at privacy@websitename.com.</p>\r\n\r\n<p>Opting out of collection of your information for Tracking / Advertising:</p>\r\n\r\n<p>Please refer to your mobile device or browser’s technical information for instructions on how to delete and disable cookies, and other tracking/recording tools. Depending on your type of device, it may not be possible to delete or disable tracking mechanisms on your mobile device. Note that disabling cookies and/or other tracking tools prevents WebsiteName or its business partners from tracking your browser’s activities in relation to the Service, and for use in targeted advertising activities by third parties. However, doing so may disable many of the features available through the Service. If you have any questions about opting out of the collection of cookies and other tracking/recording tools, you can contact us directly at privacy@websitename.com.</p>\r\n\r\n<h2>How long we keep your private profile information:</h2>\r\n\r\n<p>Following termination of your User account, WebsiteName may retain your private profile information for a commercially reasonable time for backup, archival, or audit purposes. For the avoidance of doubt, any information that you choose to make public on the service may not be removable.</p>\r\n\r\n<h2>Children’s Privacy</h2>\r\n\r\n<p>WebsiteName does not knowingly collect or solicit any information from anyone under the age of 13 or knowingly allow such persons to register as Users. The Service and its content are not directed at children under the age of 13. In the event that we learn that we have collected personal information from a child under age 13 without verification of parental consent, we will delete that information as quickly as possible. If you believe that we might have any information from or about a child under 13, please contact us at privacy@websitename.com.</p>\r\n\r\n<h2>Links to Other Websites and Services</h2>\r\n\r\n<p>We are not responsible for the practices employed by websites or services linked to or from the Service, including the information or content contained therein. Please remember that when you use a link to go from the Service to another website, our Privacy Policy does not apply to third-party websites or services. Your browsing and interaction on any third-party website or service, including those that have a link or advertisement on our website, are subject to that third party’s own rules and policies. In addition, you agree that we are not responsible and we do not control over any third-parties that you authorize to access your User Content. If you are using a third-party website or service (like Facebook, Google groups, or an IRC chatroom) and you allow such a third-party access to you User Content you do so at your own risk. This Privacy Policy does not apply to information we collect by other means (including offline) or from other sources other than through the Service.</p>', '﻿<h2>Comment nous recueillons et utilisons l\'information </h2>\r\n\r\n<p>Nous vous demandons certaines informations telles que votre nom d\'utilisateur, votre vrai nom, votre date de naissance, votre adresse, votre numéro de téléphone et votre adresse e-mail lorsque vous vous inscrivez pour un compte WebsiteName, ou si vous nous contactez. Nous pouvons également conserver tous les messages que vous envoyez par l\'intermédiaire du Service, et nous pouvons recueillir des informations que vous fournissez dans le Contenu Utilisateur que vous publiez sur le Service. Nous utilisons ces informations pour exploiter, maintenir et vous fournir les caractéristiques et fonctionnalités du Service. Votre nom d\'utilisateur et, si vous choisissez de le divulguer, votre vrai nom sera publié publiquement. Une fois publié, votre nom d\'utilisateur et / ou votre vrai nom peuvent ne pas pouvoir être supprimés.</p>\r\n\r\n<h2>Informations que nous pouvons recevoir de tiers:</h2>Informations que nous pouvons recevoir de tiers.</h2>\r\n\r\n<p>Nous pouvons recevoir des informations vous concernant de tiers. Par exemple, si vous accédez à nos sites Web ou à nos services par l\'intermédiaire d\'une connexion ou d\'une ouverture de session d\'un tiers, par exemple par Facebook Connect, en \"suivant\", \"aimant\", en ajoutant l\'application WebsiteName, en reliant votre compte au service WebsiteName, etc. Ces informations peuvent inclure, sans s\'y limiter, le code d\'utilisateur associé à votre compte (par exemple, votre UID Facebook), un jeton d\'accès nécessaire pour accéder à ce service, toute information que vous avez autorisée le tiers à partager avec nous, et toute information que vous avez rendue publique en rapport avec ce service. Si vous nous autorisez à accéder à votre liste d\'amis, les identifiants de vos amis et votre connexion à ces amis peuvent être utilisés et stockés pour rendre votre expérience plus sociale et pour vous permettre d\'inviter vos amis à utiliser notre Service ainsi que de vous fournir des mises à jour si et quand vos amis rejoignent WebsiteName. Vous devriez toujours revoir et, si nécessaire, ajuster vos paramètres de confidentialité sur les sites Web et services tiers avant de les lier ou de les connecter au Service WebsiteName. Vous pouvez également dissocier votre compte tiers du Service en ajustant vos paramètres sur le service tiers. </p>\r\n\r\n<h2>Inviter un ami à utiliser WebsiteName:</h2>\r\n\r\n<p>WebsiteName peut, à sa seule discrétion, développer une fonctionnalité qui vous permet d\'inviter des tiers au Service. Si vous choisissez d\'utiliser notre service d\'invitation pour inviter un tiers au Service via notre fonction \"Inviter des amis\", vous pouvez directement choisir un ami à inviter via la liste de contacts native de votre appareil mobile - mais nous ne vous demandons pas d\'importer votre liste de contacts dans le Service, et nous ne conservons pas les informations contenues dans votre liste de contacts. Vous comprenez qu\'en invitant un ami à WebsiteName via la fonction \"Inviter des amis\", vous envoyez directement un texte ou un e-mail depuis vos comptes personnels et que nous ne stockons pas votre liste de contacts. De plus, vous comprenez et acceptez que les frais normaux du transporteur s\'appliquent aux communications envoyées à partir de votre téléphone. Puisque cette invitation provient directement de votre courriel ou de votre téléphone, nous n\'avons pas accès à cette communication et ne la contrôlons pas.</p>\r\n\r\n<h2>Rechercher vos amis sur le Service:</h2>\r\n\r\n<p>WebsiteName peut, à sa seule discrétion, développer une fonctionnalité qui vous permet de localiser vos amis avec des comptes WebsiteName grâce à une fonction \"Trouver des amis\". La fonction \"Trouver des amis\" vous permet de choisir de localiser des amis soit par (i) votre liste de contacts, (ii) des sites de médias sociaux (tels que Twitter ou Facebook) ou (iii) par une recherche de noms et de noms d\'utilisateurs sur WebsiteName. Si vous choisissez de trouver vos amis par l\'intermédiaire de votre liste de contacts, vous acceptez de donner accès à votre liste de contacts par WebsiteName afin que nous puissions effectuer la recherche nécessaire pour déterminer si quelqu\'un associé aux informations que vous fournissez utilise ou non WebsiteName. Si vous choisissez de trouver vos amis sur des sites de médias sociaux, vous comprenez que les informations que ces sites fournissent pour effectuer ce type de recherche sont régies par leurs politiques de confidentialité et les paramètres de votre compte sur ces sites. Si vous choisissez de trouver vos amis par une recherche de noms ou de noms d\'utilisateur, tapez simplement un nom à rechercher et voyez si ce nom ou ce nom d\'utilisateur apparaît sur notre Service. Notez que nous ne conservons aucune information contenue dans votre liste de contacts ou dans les sites de médias sociaux concernant vos contacts, et que nous n\'utilisons ces informations que pour vous aider à trouver vos amis sur WebsiteName.</p>\r\n\r\n<h2>Informations analytiques:</h2>\r\n\r\n<p>Nous pouvons recueillir directement des données d\'analyse ou utiliser des outils et services d\'analyse tiers pour nous aider à mesurer les tendances du trafic et de l\'utilisation du Service. Ces outils recueillent des informations envoyées par votre navigateur ou appareil mobile, y compris les pages que vous visitez et d\'autres informations qui nous aident à améliorer le Service. Nous recueillons et utilisons ces informations analytiques sous forme agrégée de telle sorte qu\'elles ne peuvent raisonnablement pas être manipulées pour identifier un utilisateur en particulier.</p>\r\n\r\n<h2>Informations sur les cookies:</h2>\r\n\r\n<p>Tous les détails peuvent être trouvés sur notre Politique sur les cookies. Lorsque vous visitez le Service, nous pouvons envoyer un ou plusieurs cookies - un petit fichier texte contenant une chaîne de caractères alphanumériques - à votre ordinateur qui identifie de façon unique votre navigateur et permet à WebsiteName de vous aider à vous connecter plus rapidement et à améliorer votre navigation sur le site. Un cookie peut également nous transmettre des informations sur la façon dont vous utilisez le Service (par exemple, les pages que vous consultez, les liens sur lesquels vous cliquez et d\'autres actions que vous effectuez sur le Service), et nous permettre ou permettre à nos partenaires commerciaux de suivre votre utilisation du Service dans le temps. Un témoin persistant demeure sur votre disque dur après la fermeture de votre navigateur. Des cookies persistants peuvent être utilisés par votre navigateur lors de vos visites ultérieures sur le site. Les cookies persistants peuvent être supprimés en suivant les instructions de votre navigateur Web. Un témoin volatil est temporaire et disparaît lorsque vous fermez votre navigateur. Vous pouvez réinitialiser votre navigateur Web pour qu\'il refuse tous les cookies ou qu\'il vous indique quand un cookie est envoyé. Toutefois, certaines fonctions du Service peuvent ne pas fonctionner correctement si la capacité d\'accepter les cookies est désactivée. Tous les détails peuvent être trouvés sur notre Politique sur les cookies.</p>\r\n\r\n<h2>Informations sur le fichier journal:</h2>\r\n\r\n<p>Les informations du fichier journal sont automatiquement rapportées par votre navigateur ou votre appareil mobile chaque fois que vous accédez au Service. Lorsque vous utilisez notre Service, nos serveurs enregistrent automatiquement certaines informations du fichier journal. Ces journaux de serveur peuvent inclure des informations anonymes telles que votre demande Web, votre adresse IP, le type de navigateur, les pages et URL de référence / sortie, le nombre de clics et la façon dont vous interagissez avec les liens sur le Service, les noms de domaine, les pages de destination, les pages vues et autres informations similaires. </p>\r\n\r\n<h2>Clear gifs/web beacons information:</h2>\r\n\r\n<p>Lorsque vous utilisez le Service, nous pouvons utiliser des gifs clairs (également connus sous le nom de pixels invisibles) qui sont utilisés pour suivre de manière anonyme les habitudes d\'utilisation en ligne de nos utilisateurs. De plus, nous pouvons également utiliser des gifs clairs dans les courriels HTML envoyés à nos utilisateurs pour suivre quels courriels sont ouverts et quels liens sont cliqués par les destinataires. L\'information permet d\'établir des rapports plus précis et d\'améliorer le Service. </p>\r\n\r\n<h2>Identificateurs d\'appareil:</h2>\r\n\r\n<p>Lorsque vous accédez au Service par ou via un appareil mobile (y compris, mais sans s\'y limiter, les téléphones intelligents ou les tablettes), nous pouvons accéder, collecter, surveiller et/ou stocker à distance un ou plusieurs \" identifiants d\'appareil \", comme un identifiant unique universel (\" UUID \"). Les identificateurs d\'appareil sont de petits fichiers de données ou des structures de données similaires stockées sur votre appareil mobile ou associées à celui-ci, qui identifient de façon unique votre appareil mobile. Un identificateur de périphérique peut être des données stockées en relation avec le matériel du périphérique, des données stockées en relation avec le système d\'exploitation du périphérique ou un autre logiciel, ou des données envoyées au périphérique par WebsiteName. Un identificateur d\'appareil peut nous transmettre des informations sur la façon dont vous naviguez et utilisez le Service. Un identificateur d\'appareil peut rester en permanence sur votre appareil pour vous aider à vous connecter plus rapidement et à améliorer votre navigation sur le Service. Certaines fonctions du Service peuvent ne pas fonctionner correctement si l\'utilisation ou la disponibilité des identificateurs d\'appareil est altérée ou désactivée. </p>\r\n\r\n<h2>Données de localisation:</h2>\r\n\r\n<p>Lorsque vous accédez au Service par ou via un appareil mobile, nous pouvons accéder, collecter, surveiller et/ou stocker à distance des \"données de localisation\", qui peuvent inclure des coordonnées GPS (par exemple, latitude et/ou longitude) ou des informations similaires concernant la localisation de votre appareil mobile. Les données de localisation peuvent nous fournir des informations sur la façon dont vous naviguez et utilisez le Service. Certaines fonctions du Service, en particulier les services géodépendants, peuvent ne pas fonctionner correctement si l\'utilisation ou la disponibilité des données de localisation est altérée ou désactivée.</p>\r\n\r\n<h2>Communication commerciale et marketing:</h2>\r\n\r\n<p>Nous utilisons les informations que nous recueillons ou recevons, telles que votre adresse e-mail, pour communiquer directement avec vous. Nous pouvons vous envoyer des courriels contenant des bulletins d\'information, des promotions et des offres spéciales. Si vous ne souhaitez pas recevoir de tels messages électroniques, vous aurez la possibilité de vous désabonner ou de modifier vos préférences. Nous utilisons également vos informations pour vous envoyer des courriels liés au Service (par exemple, vérification de compte, confirmations et rappels d\'achat et de facturation, modifications/mises à jour des caractéristiques du Service, avis techniques et de sécurité). Vous ne pouvez pas vous désinscrire des courriels liés au service. Vous pouvez également être \"trouvé\" sur WebsiteName en fonction des informations que vous fournissez (voir \"Trouver des amis sur WebsiteName\") ci-dessus.</p>\r\n\r\n<h2>Utilisation de certaines informations que nous recueillons sur vous:</h2>\r\n\r\n<p>Nous utilisons ou pouvons utiliser des cookies, des fichiers journaux, des identificateurs d\'appareils, des données d\'emplacement et des informations gif claires : (a) mémoriser l\'information afin que vous n\'ayez pas à la saisir à nouveau pendant votre visite ou la prochaine fois que vous visitez le site ; (b) fournir un contenu et des renseignements personnalisés et personnalisés ; (c) fournir et surveiller l\'efficacité de notre Service ; (d) surveiller des mesures globales comme le nombre total de visiteurs, le trafic et les tendances démographiques ; (e) poser un diagnostic ou résoudre des problèmes technologiques ; (f) vous aider à accéder efficacement à vos renseignements après votre connexion ; (g) fournir de la publicité pour votre navigateur ou appareil et (h) mettre automatiquement à jour la fonction NomWeb sur vos dispositifs mobiles.</p>\r\n\r\n<h2>Partage de vos informations </h2>\r\n\r\n<p>Nous ne louerons ni ne vendrons vos informations à des tiers en dehors de WebsiteName et des sociétés de son groupe (y compris toute société mère, filiales et sociétés affiliées) sans votre consentement, sauf comme indiqué ci-dessous:</p>\r\n\r\n<p>À qui nous pouvons partager vos informations : Nous pouvons partager vos informations avec des partenaires commerciaux tiers et des Utilisateurs de confiance dans le but de vous fournir le Service. Les partenaires commerciaux tiers auront un accès limité à vos informations dans la mesure où cela est raisonnablement nécessaire pour fournir le Service, et nous exigerons que ces tiers se conforment à la présente Politique de confidentialité, ou opèrent selon une politique de confidentialité similaire.</p>\r\n\r\n<p>Qui peut voir le contenu utilisateur : Tout Contenu Utilisateur que vous divulguez volontairement pour publication sur le Service devient accessible au public et ne peut être supprimé, sauf par WebsiteName à sa seule discrétion. Une fois affiché sur WebsiteName, le contenu de l\'utilisateur peut ne pas pouvoir être retiré de la vue du public, car des copies peuvent rester visibles dans les pages mises en cache et archivées du Service, sur d\'autres sites qui nous ont republié, ou si d\'autres utilisateurs ont copié ou enregistré ces informations. Si vous ne souhaitez pas que votre contenu d\'utilisateur soit accessible au public, veuillez ne pas l\'afficher sur WebsiteName. Votre nom d\'utilisateur et, si vous choisissez de le divulguer, votre vrai nom sera publié publiquement. Une fois publié, votre nom d\'utilisateur et / ou votre vrai nom peuvent ne pas pouvoir être supprimés.</p>\r\n\r\n<p>Qui peut voir votre adresse IP : Si vous publiez du Contenu Utilisateur sur le Service alors que vous n\'êtes pas connecté, votre adresse IP sera publiée avec votre Contenu Utilisateur afin d\'attribuer votre contribution au Service. Une sélection d\'Utilisateurs de confiance ayant des pouvoirs administratifs sur WebsiteName ont la possibilité d\'examiner les adresses IP des utilisateurs pour réduire les comportements abusifs. Tout service tiers intégré sur WebsiteName tel qu\'un annonceur, un fournisseur de vidéo, un réseau social ou tout autre tiers aura également accès à votre adresse IP. </p>\r\n\r\n<p>Qui peut voir votre adresse email : Si vous entrez une adresse e-mail, vous activerez la communication à partir de WebsiteName et d\'autres utilisateurs. Si vous répondez à des utilisateurs ou participez à des activités du groupe WebsiteName telles que des réunions, votre adresse e-mail sera partagée avec ces utilisateurs. </p>\r\n\r\n<h2>Que se passe-t-il en cas de changement de contrôle:</h2>\r\n\r\n<p>Nous pouvons acheter ou vendre/céder/transférer la société (y compris toute action de la société), ou toute combinaison de ses produits, services, actifs et/ou activités. Vos informations telles que les noms et adresses e-mail des clients, le contenu de l\'utilisateur et d\'autres informations de l\'utilisateur liées au Service peuvent figurer parmi les articles vendus ou transférés dans ce type de transactions. Nous pouvons également vendre, céder ou transférer autrement ces renseignements dans le cadre de dessaisissements, de fusions, d\'acquisitions, de faillites, de dissolutions, de réorganisations, de liquidations, d\'opérations ou de procédures similaires impliquant la totalité ou une partie de la société. </p>\r\n\r\n<h2>Cas où nous sommes tenus de partager vos informations:</h2>\r\n\r\n<p>WebsiteName divulguera vos informations lorsque la loi ou une citation à comparaître l\'exige ou si nous croyons raisonnablement qu\'une telle action est nécessaire pour (a) se conformer à la loi et aux demandes raisonnables des forces de l\'ordre ; (b) pour appliquer nos Conditions d\'utilisation ou pour protéger la sécurité, la qualité ou l\'intégrité de notre Service ; et/ou (c) pour exercer ou protéger les droits, la propriété ou la sécurité personnelle du NomWeb, nos utilisateurs ou autres. </p>\r\n\r\n<h2>Partager certains types d\'informations que nous collectons sur vous:</h2>\r\n\r\n<p>Nous pouvons partager certaines informations sur le type de service, y compris les informations obtenues à l\'aide d\'outils tels que les cookies, les fichiers journaux, les identificateurs d\'appareils, les données de localisation et les gifs clairs (tels que les données d\'utilisation anonymes, les pages et URL de renvoi/sortie, les types de plate-forme, le nombre de clics, etc :) (i) avec nos partenaires commerciaux tiers aux fins décrites dans la section \"Comment nous recueillons et utilisons les renseignements\" ci-dessus. Nous pouvons également agréger ou retirer de toute autre manière les données de toutes les caractéristiques d\'identification personnelle et nous pouvons partager ces données agrégées et rendues anonymes avec des tiers. </p>\r\n\r\n<h2>Annonces sur le site WebsiteName:</h2>\r\n\r\n<p>Nous pouvons également partager certaines informations telles que votre emplacement, votre navigateur et les données des cookies et d\'autres données relatives à votre utilisation de notre Service avec nos partenaires commerciaux pour diffuser des publicités (\" annonces \") qui peuvent vous intéresser. WebsiteName peut permettre à des serveurs ou réseaux publicitaires tiers de diffuser des publicités sur le Service. Ces serveurs ou réseaux publicitaires tiers utilisent la technologie pour envoyer, directement à votre navigateur ou appareil mobile, les publicités et les liens publicitaires qui apparaissent sur le Service, et recevront automatiquement votre adresse IP lorsqu\'ils le feront. Ils peuvent également utiliser d\'autres technologies (telles que les cookies, JavaScript, les identificateurs d\'appareils, les données de localisation et les gifs clairs, voir ci-dessus) pour compiler des informations sur les visites et les habitudes d\'utilisation de votre navigateur ou appareil sur le Service et sur d\'autres sites Web, et pour mesurer l\'efficacité de leurs annonces et pour personnaliser le contenu publicitaire qui vous est livré. </p>\r\n\r\n<p>Par exemple, Google utilise des cookies DART afin de vous envoyer des annonces par le biais du Service. L\'utilisation par Google du cookie DART lui permet, ainsi qu\'à ses partenaires, de vous diffuser des annonces en fonction de votre visite sur le Service et les sites Web que vous avez visités précédemment. D\'autres réseaux publicitaires utilisent également des cookies similaires, des gifs clairs ou d\'autres mécanismes pour vous fournir de la publicité ciblée via le Service. Vous pouvez supprimer ces cookies en suivant les instructions de votre navigateur.</p>\r\n\r\n<p>Veuillez noter qu\'un annonceur peut demander à WebsiteName de montrer une annonce à un certain public d\'utilisateurs (par exemple, sur la base de données démographiques ou autres intérêts). Dans ce cas, WebsiteName ou nos Partenaires déterminent le public cible et WebsiteName sert la publicité à ce public et fournit uniquement des données anonymes à l\'annonceur. Si vous répondez à une telle annonce, l\'annonceur ou le serveur publicitaire peut conclure que vous correspondez à la description de l\'audience qu\'il tente d\'atteindre.</p>\r\n\r\n<p>Pour améliorer votre expérience utilisateur ou pour nous aider à améliorer et à mesurer notre efficacité, WebsiteName peut intégrer du code provenant de tiers sur le Service. Des exemples de telles parties peuvent inclure Facebook, Twitter, Pinterest, Google, YouTube, Howcast, VideoJug, AOL, et autres. Ces tiers peuvent recueillir des informations vous concernant, y compris votre adresse IP et les cookies, d\'une manière que WebsiteName ne contrôle pas. </p>\r\n\r\n<p>La politique de confidentialité de WebsiteName ne s\'applique pas à, et nous ne pouvons pas contrôler les activités des tiers. Veuillez consulter les politiques de confidentialité respectives de ces tierces parties ou contacter ces tierces parties pour plus d\'informations. </p>\r\n\r\n<h2>Stockage et traitement:</h2>\r\n\r\n<p>Vos informations collectées par le biais du Service peuvent être stockées et traitées aux États-Unis ou dans tout autre pays dans lequel WebsiteName ou ses filiales, sociétés affiliées ou fournisseurs de services ont des installations. WebsiteName peut transférer des informations que nous recueillons à votre sujet, y compris des informations personnelles, à des entités affiliées ou à d\'autres tiers à travers les frontières et de votre pays ou juridiction vers d\'autres pays ou juridictions dans le monde. Si vous êtes situé dans l\'Union européenne ou dans d\'autres régions dont les lois régissant la collecte et l\'utilisation des données peuvent différer des lois américaines, veuillez noter que nous pouvons transférer des informations, y compris des informations personnelles, vers un pays et une juridiction qui n\'ont pas les mêmes lois de protection des données que votre juridiction, et vous acceptez le transfert des informations aux États-Unis ou dans tout autre pays où WebsiteName ou sa société mère, filiales, affiliés ou fournisseurs de services entretiennent les installations et l\'utilisation et la divulgation des informations vous concernant comme décrit dans cette politique de confidentialité.</p>\r\n\r\n<h2>Préserver la sécurité de vos informations:</h2>\r\n\r\n<p>WebsiteName se soucie de la sécurité de vos informations, et utilise des sauvegardes commercialement raisonnables pour préserver l\'intégrité et la sécurité de toutes les informations collectées par le biais du Service. Pour protéger votre vie privée et votre sécurité, nous prenons des mesures raisonnables (comme demander un mot de passe unique) pour vérifier votre identité avant de vous donner accès à votre compte. Vous êtes responsable du maintien du secret de votre mot de passe unique et des informations de votre compte, et du contrôle de l\'accès à vos communications électroniques à partir de WebsiteName, à tout moment. Cependant, WebsiteName ne peut pas assurer ou garantir la sécurité de toute information que vous transmettez à WebsiteName ou garantir que l\'information sur le Service ne peut pas être consulté, divulgué, modifié ou détruit. Vos paramètres de confidentialité peuvent également être affectés par des modifications apportées à la fonctionnalité des sites et services tiers que vous ajoutez au Service NomWeb, tels que les réseaux sociaux. WebsiteName n\'est pas responsable de la fonctionnalité ou des mesures de sécurité d\'une tierce partie.</p>\r\n\r\n<h2>Compromis d\'informations:</h2>\r\n\r\n<Dans le cas où des informations sous notre contrôle seraient compromises à la suite d\'une violation de la sécurité, WebsiteName prendra des mesures raisonnables pour enquêter sur la situation et, le cas échéant, informer les personnes dont les informations peuvent avoir été compromises et prendre d\'autres mesures, conformément aux lois et règlements applicables. </p>\r\n\r\n<h2>Vos choix concernant vos informations </h2>\r\n\r\n<p>Vous contrôlez les informations et paramètres de votre compte : Vous pouvez mettre à jour les informations de votre compte et vos préférences de communication par e-mail à tout moment en vous connectant à votre compte et en modifiant vos paramètres de profil. </p>\r\n\r\n<p>Nous faisons tout notre possible pour traiter rapidement toutes les demandes de désabonnement. Comme indiqué ci-dessus, vous ne pouvez pas vous désinscrire des communications liées au Service (par exemple, vérification de compte, confirmations et rappels d\'achat et de facturation, modifications/mises à jour des caractéristiques du Service, avis techniques et de sécurité). Si vous avez des questions concernant l\'examen ou la modification des informations de votre compte, vous pouvez nous contacter directement à privacy@websitename.com.</p>\r\n\r\n<p>Se retirer de la collecte de vos informations pour le Suivi / Publicité:</p>\r\n\r\n<p>Veuillez consulter les informations techniques de votre appareil mobile ou de votre navigateur pour savoir comment supprimer et désactiver les cookies et autres outils de suivi/enregistrement. Selon le type de votre appareil, il se peut qu\'il ne soit pas possible de supprimer ou de désactiver les mécanismes de suivi sur votre appareil mobile. Notez que la désactivation des cookies et/ou d\'autres outils de suivi empêche WebsiteName ou ses partenaires commerciaux de suivre les activités de votre navigateur en relation avec le Service, et pour une utilisation dans des activités publicitaires ciblées par des tiers. Toutefois, cela peut désactiver un grand nombre de fonctions disponibles par l\'intermédiaire du Service. Si vous avez des questions au sujet de l\'exclusion de la collecte de cookies et d\'autres outils de suivi/enregistrement, vous pouvez nous contacter directement à privacy@websitename.com.</p>\r\n\r\n<h2>Compter combien de temps nous conservons les informations de votre profil privé:</h2>\r\n\r\n<p>Après la résiliation de votre compte d\'utilisateur, WebsiteName peut conserver les informations de votre profil privé pendant une période commercialement raisonnable à des fins de sauvegarde, d\'archivage ou d\'audit. Pour éviter tout doute, toute information que vous choisissez de rendre publique sur le service peut ne pas être amovible. </p>\r\n\r\n<h2>Intimité des enfants </h2>\r\n\r\n<p>WebsiteName ne recueille ni ne sollicite sciemment aucune information d\'une personne âgée de moins de 13 ans ou ne permet sciemment à ces personnes de s\'inscrire comme Utilisateurs. Le Service et son contenu ne s\'adressent pas aux enfants de moins de 13 ans ; si nous apprenons que nous avons recueilli des renseignements personnels d\'un enfant de moins de 13 ans sans vérification du consentement parental, nous supprimerons ces renseignements le plus rapidement possible. Si vous pensez que nous pourrions avoir des informations provenant d\'un enfant de moins de 13 ans ou le concernant, veuillez nous contacter à privacy@websitename.com.</p>\r\n\r\n<h2>Liens vers d\'autres sites Web et services </h2>\r\n\r\n<p>Nous ne sommes pas responsables des pratiques employées par les sites Web ou les services liés au Service, y compris les informations ou le contenu qu\'ils contiennent. N\'oubliez pas que lorsque vous utilisez un lien pour passer du Service à un autre site Web, notre Politique de confidentialité ne s\'applique pas aux sites Web ou services de tiers. Votre navigation et votre interaction sur tout site Web ou service de tiers, y compris ceux qui ont un lien ou une publicité sur notre site Web, sont assujettis aux règles et politiques de ce tiers. De plus, vous reconnaissez que nous ne sommes pas responsables et que nous ne contrôlons pas les tiers que vous autorisez à accéder à votre Contenu utilisateur. Si vous utilisez un site Web ou un service tiers (comme Facebook, des groupes Google ou un salon de discussion IRC) et que vous autorisez l\'accès de ce tiers à votre contenu utilisateur, vous le faites à vos propres risques. Cette politique de confidentialité ne s\'applique pas aux informations que nous recueillons par d\'autres moyens (y compris hors ligne) ou à partir d\'autres sources que le Service.</p>', '﻿<h2>Cómo recopilamos y utilizamos la información </h2>\r\n\r\n<p>Le pedimos cierta información como su nombre de usuario, nombre real, fecha de nacimiento, dirección, número de teléfono y dirección de correo electrónico cuando se registra para una cuenta de WebsiteName, o si se comunica con nosotros. También podemos retener cualquier mensaje que usted envíe a través del Servicio, y podemos recopilar información que usted proporcione en el Contenido de Usuario que usted publique en el Servicio. Utilizamos esta información para operar, mantener y proporcionarle las características y funcionalidad del Servicio. Su nombre de usuario y, si decide divulgarlo, su nombre real, se publicará públicamente. Una vez publicado su nombre de usuario y / o nombre real puede que no pueda ser eliminado.</p>\r\n\r\n<h2>Información que podemos recibir de terceros:</h2>\r\n\r\n<p>Es posible que recibamos información sobre usted de terceros. Por ejemplo, si accede a nuestros sitios web o Servicio a través de una conexión o inicio de sesión de terceros, por ejemplo, a través de Facebook Connect, mediante \"following\", \"liking\", añadiendo la aplicación WebsiteName, vinculando su cuenta al Servicio WebsiteName, etc., dicho tercero puede transmitir cierta información sobre el uso de su servicio a WebsiteName. Esta información podría incluir, entre otros, la identificación de usuario asociada a tu cuenta (por ejemplo, tu ID de usuario de Facebook), un código de acceso necesario para acceder a ese servicio, cualquier información que hayas permitido que el tercero comparta con nosotros y cualquier información que hayas hecho pública en relación con ese servicio. Si nos permite acceder a su lista de amigos, los ID de usuario de sus amigos y su conexión con ellos, podrá utilizarlos y almacenarlos para que su experiencia sea más social, y para permitirle invitar a sus amigos a utilizar nuestro Servicio, así como para proporcionarle actualizaciones cuando sus amigos se unan a WebsiteName. Siempre debe revisar y, si es necesario, ajustar su configuración de privacidad en los sitios web y servicios de terceros antes de vincularlos o conectarlos al Servicio WebsiteName. También puede desvincular su cuenta de terceros del Servicio ajustando su configuración en el servicio de terceros.</p>\r\n\r\n<h2>Invitar a un amigo a usar WebsiteName:</h2>\r\n\r\n<p>El Nombre del Sitio Web puede, a su sola discreción, desarrollar una característica que le permita invitar a terceros al Servicio. Si decide utilizar nuestro servicio de invitación para invitar a un tercero al Servicio a través de nuestra función \"Invitar a amigos\", puede elegir directamente a un amigo para invitarlo a través de la lista de contactos nativa de su dispositivo móvil, pero no es necesario que importe su lista de contactos al Servicio, y no conservamos la información contenida en su lista de contactos. Usted entiende que al invitar a un amigo a WebsiteName a través de la función \"Invitar a amigos\", está enviando directamente un texto o correo electrónico desde sus cuentas personales y que no estamos almacenando su lista de contactos. Además, usted entiende y acepta que los cargos normales del proveedor se aplican a las comunicaciones enviadas desde su teléfono. Dado que esta invitación viene directamente de su correo electrónico o teléfono, no tenemos acceso a esta comunicación ni la controlamos.</p>\r\n\r\n<h2>Buscar amigos en el Servicio:</h2>\r\n\r\n<p>El Nombre del Sitio Web puede, a su sola discreción, desarrollar una función que le permita localizar a sus amigos con cuentas de Nombre del Sitio Web a través de una función de \"Buscar amigos\". La función \"Buscar amigos\" le permite elegir entre (i) su lista de contactos, (ii) sitios de medios sociales (como Twitter o Facebook) o (iii) a través de una búsqueda de nombres y nombres de usuario en WebsiteName. Si usted elige encontrar a sus amigos a través de su lista de contactos, entonces usted está de acuerdo en proporcionar acceso de WebsiteName a su lista de contactos para que podamos realizar la búsqueda necesaria para determinar si alguien asociado con la información que usted proporciona está usando WebsiteName o no. Si eliges encontrar a tus amigos a través de sitios de medios sociales, entonces entiendes que la información que estos sitios proporcionan para llevar a cabo este tipo de búsqueda se rige por sus políticas de privacidad y la configuración de tu cuenta en esos sitios. Si decide buscar a sus amigos a través de una búsqueda de nombres o nombres de usuario, simplemente escriba un nombre para buscar y ver si ese nombre o nombre de usuario aparece en nuestro Servicio. Tenga en cuenta que no retenemos ninguna información contenida en su lista de contactos, o información de sitios de medios sociales acerca de sus contactos, y no utilizamos dicha información para ningún otro propósito que no sea para ayudarle a encontrar a sus amigos en WebsiteName.</p>\r\n\r\n<h2>Información analítica:</h2>\r\n\r\n<p>Podemos recopilar directamente datos analíticos o utilizar herramientas y servicios analíticos de terceros para ayudarnos a medir el tráfico y las tendencias de uso del Servicio. Estas herramientas recopilan información enviada por su navegador o dispositivo móvil, incluyendo las páginas que visita y otra información que nos ayuda a mejorar el Servicio. Recopilamos y utilizamos esta información analítica en forma agregada de manera que no pueda ser razonablemente manipulada para identificar a ningún usuario individual en particular.</p>\r\n\r\n<h2>Información sobre las cookies:</h2>\r\n\r\n<p>Los detalles completos se pueden encontrar en nuestra Política de Cookies. Cuando usted visita el Servicio, podemos enviar una o más cookies - un pequeño archivo de texto que contiene una cadena de caracteres alfanuméricos - a su computadora que identifica de manera única su navegador y permite que WebsiteName le ayude a iniciar sesión más rápidamente y mejorar su navegación a través del sitio. Una cookie también puede transmitirnos información sobre cómo utiliza el Servicio (por ejemplo, las páginas que visita, los enlaces en los que hace clic y otras acciones que realiza en el Servicio), y nos permite a nosotros o a nuestros socios comerciales realizar un seguimiento de su uso del Servicio a lo largo del tiempo. Una cookie persistente permanece en su disco duro después de cerrar su navegador. Las cookies persistentes pueden ser utilizadas por su navegador en visitas posteriores al sitio. Las cookies persistentes se pueden eliminar siguiendo las instrucciones de su navegador. Una cookie de sesión es temporal y desaparece después de cerrar el navegador. Usted puede configurar su navegador para que rechace todas las cookies o para que le indique cuándo se está enviando una cookie. Sin embargo, es posible que algunas funciones del Servicio no funcionen correctamente si la capacidad de aceptar cookies está desactivada. Todos los detalles se pueden encontrar en nuestra Política de Cookies.</p>\r\n\r\n<h2>Información de archivo de registro:</h2>\r\n\r\n<p>La información de los archivos de registro es automáticamente reportada por su navegador o dispositivo móvil cada vez que usted accede al Servicio. Cuando usted utiliza nuestro Servicio, nuestros servidores registran automáticamente cierta información de archivos de registro. Estos registros del servidor pueden incluir información anónima como su solicitud web, dirección de Protocolo de Internet (\"IP\"), tipo de navegador, páginas de referencia / salida y URLs, número de clics y cómo interactúa con los enlaces en el Servicio, nombres de dominio, páginas de destino, páginas vistas, y otra información similar.</p>\r\n\r\n<h2>Borrar gifs/balizas web información:</h2>\r\n\r\n<p>Cuando usted utiliza el Servicio, podemos emplear gifs transparentes (también conocidos como web beacons) que se utilizan para realizar un seguimiento anónimo de los patrones de uso en línea de nuestros Usuarios. Además, también podemos usar gifs claros en correos electrónicos basados en HTML enviados a nuestros usuarios para hacer un seguimiento de los correos electrónicos que se abren y de los enlaces en los que los destinatarios hacen clic. La información permite un reporte más preciso y una mejora del Servicio.</p>\r\n\r\n<h2>Identificadores de dispositivo:</h2>\r\n\r\n<p>Cuando usted accede al Servicio a través de un dispositivo móvil (incluidos, entre otros, teléfonos o tabletas inteligentes), podemos acceder, recopilar, supervisar y/o almacenar de forma remota uno o más \"identificadores de dispositivo\", como un identificador único universal (\"UUID\"). Los identificadores de dispositivos son pequeños archivos de datos o estructuras de datos similares almacenados en o asociados con su dispositivo móvil, que identifican de manera única a su dispositivo móvil. Un identificador de dispositivo puede ser datos almacenados en conexión con el hardware del dispositivo, datos almacenados en conexión con el sistema operativo del dispositivo u otro software, o datos enviados al dispositivo por WebsiteName. Un identificador de dispositivo puede transmitirnos información sobre cómo navega y utiliza el Servicio. Un identificador de dispositivo puede permanecer de forma persistente en su dispositivo, para ayudarle a iniciar sesión más rápidamente y mejorar su navegación a través del Servicio. Es posible que algunas funciones del Servicio no funcionen correctamente si el uso o la disponibilidad de los identificadores de dispositivos se ve afectada o desactivada.</p>\r\n\r\n<h2>Datos de localización:</h2>\r\n\r\n<p>Cuando usted accede al Servicio a través de un dispositivo móvil, nosotros podemos acceder, recopilar, monitorizar y/o almacenar de forma remota \"datos de localización\", que pueden incluir coordenadas GPS (por ejemplo, latitud y/o longitud) o información similar relativa a la localización de su dispositivo móvil. Los datos de ubicación pueden transmitirnos información sobre la forma en que usted navega y utiliza el Servicio. Es posible que algunas funciones del Servicio, en particular los servicios basados en la localización, no funcionen correctamente si el uso o la disponibilidad de los datos de localización se ve afectada o desactivada.</p>\r\n\r\n<h2>Comunicaciones comerciales y de marketing:</h2>\r\n\r\n<p>Utilizamos la información que recopilamos o recibimos, como su dirección de correo electrónico, para comunicarnos directamente con usted. Podemos enviarle correos electrónicos con boletines de noticias, promociones y ofertas especiales. Si usted no desea recibir tales mensajes de correo electrónico, se le dará la opción de optar por no recibirlos o cambiar sus preferencias. También utilizamos su información para enviarle correos electrónicos relacionados con el Servicio (por ejemplo, verificación de cuenta, confirmaciones y recordatorios de compra y facturación, cambios/actualizaciones de las características del Servicio, avisos técnicos y de seguridad). Usted no puede optar por no recibir correos electrónicos relacionados con el Servicio. Usted también puede ser \"encontrado\" en el Nombre del Sitio Web basado en la información que usted proporciona (ver \"Encontrar amigos en el Nombre del Sitio Web\") arriba.</p>\r\n\r\n<h2>Uso de cierta información de tipo de servicio que recopilamos sobre usted:</h2>\r\n\r\n<p>Usamos o podemos usar cookies, archivos de registro, identificadores de dispositivos, datos de ubicación e información de gifs claros para: (a) recordar la información para que no tenga que volver a introducirla durante su visita o la próxima vez que visite el sitio; (b) proporcionar contenido personalizado e información; (c) proporcionar y supervisar la eficacia de nuestro Servicio; (d) supervisar métricas agregadas como el número total de visitantes, el tráfico y los patrones demográficos; (e) diagnosticar o solucionar problemas de tecnología; (f) ayudarlo a acceder eficientemente a su información después de iniciar sesión; (g) proporcionar publicidad a su navegador o dispositivo, y (h) actualizar automáticamente la aplicación Nombre de sitio web en sus dispositivos móviles.</p>\r\n\r\n<h2>Compartir su información </h2>\r\n\r\n<p>No alquilaremos ni venderemos su información a terceros ajenos a WebsiteName y a las empresas de su grupo (incluidas las empresas matrices, subsidiarias y afiliadas) sin su consentimiento, excepto como se indica a continuación</p>\r\n\r\n<p>Con quién podemos compartir su información: Podemos compartir su información con terceros socios comerciales y usuarios de confianza con el fin de proporcionarle el Servicio. A los terceros socios comerciales se les dará acceso limitado a su información en la medida en que sea razonablemente necesario para entregar el Servicio, y requeriremos que dichos terceros cumplan con esta Política de Privacidad, u operen bajo una política de privacidad similar.</p>\r\n\r\n<p>Quién puede ver el contenido del usuario: Cualquier Contenido de Usuario que usted revele voluntariamente para su publicación en el Servicio estará disponible al público y no podrá ser eliminado, excepto por WebsiteName a su entera discreción. Una vez publicado en WebsiteName, el Contenido del Usuario no puede ser removido de la vista pública, ya que las copias pueden permanecer visibles en las páginas almacenadas y archivadas del Servicio, en otros sitios que nos han vuelto a publicar, o si otros Usuarios han copiado o guardado esa información. Si no desea que su Contenido de Usuario esté disponible para el público, por favor no lo publique en WebsiteName. Su nombre de usuario y, si decide divulgarlo, su nombre real, se publicará públicamente. Una vez publicado su nombre de usuario y / o nombre real puede que no pueda ser eliminado.</p>\r\n\r\n<p>Quién puede ver su dirección IP: Si publica Contenido de Usuario en el Servicio mientras no esté conectado, su dirección IP se publicará con su Contenido de Usuario para atribuir su contribución al Servicio. Una selección de usuarios de confianza con poderes administrativos en el Nombre del sitio web tienen la capacidad de revisar las direcciones IP de los usuarios para reducir el comportamiento abusivo. Cualquier servicio de terceros incrustado en el nombre del sitio web, como un anunciante, proveedor de vídeo, red social u otro tercero, también tendrá acceso a su dirección IP.</p>\r\n\r\n<p>Quién puede ver su dirección de correo electrónico: Si introduce una dirección de correo electrónico, habilitará la comunicación entre WebsiteName y otros usuarios. Si responde a los usuarios o participa en actividades del grupo WebsiteName como reuniones, su dirección de correo electrónico será compartida con estos usuarios.</p>\r\n\r\n<h2>¿Qué ocurre en caso de cambio de control:</h2>?\r\n\r\n<p>Podemos comprar o vender/desinvertir/transferir la compañía (incluyendo cualquier acción de la compañía), o cualquier combinación de sus productos, servicios, activos y/o negocios. Su información, como los nombres y direcciones de correo electrónico de los clientes, el Contenido de Usuario y otra información de usuario relacionada con el Servicio puede estar entre los artículos vendidos o transferidos de otro modo en este tipo de transacciones. También podemos vender, ceder o transferir de otro modo dicha información en el curso de desinversiones corporativas, fusiones, adquisiciones, quiebras, disoluciones, reorganizaciones, liquidaciones, transacciones o procedimientos similares que involucren a toda o parte de la compañía.</p>\r\n\r\n<h2>Instancias en las que se requiere que compartamos su información:</h2>\r\n\r\n<p>El Nombre del Sitio Web revelará su información cuando sea requerido por ley o citación o si creemos razonablemente que tal acción es necesaria para (a) cumplir con la ley y las solicitudes razonables de las fuerzas de seguridad; (b) para hacer cumplir nuestros Términos de Uso o para proteger la seguridad, calidad o integridad de nuestro Servicio; y/o (c) para ejercer o proteger los derechos, propiedad o seguridad personal del Nombre del Sitio Web, de nuestros Usuarios, o de otros.</p>\r\n\r\n<h2>Compartir cierta información de tipo de servicio que recopilamos sobre usted:</h2>\r\n\r\n<p>Podemos compartir cierta información de tipo de servicio, incluyendo información obtenida a través de herramientas tales como cookies, archivos de registro, identificadores de dispositivos, datos de ubicación y gifs de compensación (tales como datos de uso anónimo, páginas de referencia/salida y URLs, tipos de plataforma, número de clics, etc.): (i) con nuestros socios comerciales terceros para los fines descritos en la sección anterior sobre \"Cómo recopilamos y utilizamos la información\". También podemos agregar o de otro modo eliminar datos de todas las características de identificación personal y podemos compartir esos datos agregados y anónimos con terceros.</p>\r\n\r\n<h2>Anuncios en WebsiteName:</h2>\r\n\r\n<p>También podemos compartir cierta información como su ubicación, navegador, datos de cookies y otros datos relacionados con su uso de nuestro Servicio con nuestros socios comerciales para entregar anuncios (\"anuncios\") que puedan ser de su interés. WebsiteName puede permitir que servidores de anuncios o redes publicitarias de terceros publiquen anuncios en el Servicio. Estos servidores o redes publicitarias de terceros utilizan tecnología para enviar, directamente a su navegador o dispositivo móvil, los anuncios y enlaces de anuncios que aparecen en el Servicio, y recibirán automáticamente su dirección IP cuando lo hagan. También pueden utilizar otras tecnologías (como cookies, JavaScript, identificadores de dispositivos, datos de ubicación y clear gifs, ver arriba) para recopilar información sobre las visitas de su navegador o dispositivo y los patrones de uso en el Servicio y en otros sitios web, y para medir la efectividad de sus anuncios y personalizar el contenido publicitario que se le entrega.</p>\r\n\r\n<p>Por ejemplo, Google utiliza cookies de DART para enviarle anuncios a través del Servicio. El uso de la cookie de DART por parte de Google le permite a éste y a sus socios publicar anuncios para usted en función de su visita al Servicio y de los sitios web anteriores que haya visitado. Otras redes de publicidad también utilizan cookies similares, clear gifs u otros mecanismos para entregarle publicidad dirigida a usted a través del Servicio. Puede eliminar estas cookies siguiendo las instrucciones de su navegador.</p>\r\n\r\n<p>Tenga en cuenta que un anunciante puede pedir a WebsiteName que muestre un anuncio a una determinada audiencia de usuarios (por ejemplo, en función de la demografía u otros intereses). En ese caso, WebsiteName o nuestros socios determinan la audiencia objetivo y WebsiteName sirve la publicidad a esa audiencia y sólo proporciona datos anónimos al anunciante. Si usted responde a tal anuncio, el anunciante o servidor de anuncios puede concluir que usted encaja en la descripción de la audiencia a la que están tratando de llegar.</p>\r\n\r\n<p>Para mejorar su experiencia de usuario o ayudarnos a mejorar y medir nuestra efectividad, WebsiteName puede incrustar código de terceros en el Servicio. Ejemplos de tales fiestas pueden incluir Facebook, Twitter, Pinterest, Google, YouTube, Howcast, VideoJug, AOL, y otros. Estos terceros pueden recopilar información sobre usted, incluyendo la dirección IP, las cookies de manera que WebsiteName no lo controle.</p>\r\n\r\n<p>La Política de Privacidad del Nombre del Sitio Web no se aplica a, y no podemos controlar las actividades de terceros. Por favor, consulte las respectivas políticas de privacidad de dichos terceros o póngase en contacto con ellos para obtener más información.</p>\r\n\r\n<h2>Almacenamiento y Procesamiento:</h2>\r\n\r\n<p>Su información recopilada a través del Servicio puede ser almacenada y procesada en los Estados Unidos o en cualquier otro país en el que WebsiteName o sus subsidiarias, afiliados o proveedores de servicios mantengan instalaciones. WebsiteName puede transferir información que recopilamos sobre usted, incluyendo información personal, a entidades afiliadas o a terceros a través de las fronteras y desde su país o jurisdicción a otros países o jurisdicciones de todo el mundo. Si usted se encuentra en la Unión Europea o en otras regiones con leyes que rigen la recopilación y el uso de datos que pueden diferir de las leyes de EE.UU., tenga en cuenta que podemos transferir información, incluida la información personal, a un país y jurisdicción que no tenga las mismas leyes de protección de datos que su jurisdicción, y usted consiente la transferencia de información a EE.UU. o a cualquier otro país en el que WebsiteName o su empresa matriz, subsidiarias, filiales o proveedores de servicios mantengan instalaciones, así como el uso y la revelación de información acerca de usted, tal y como se describe en esta Política de Privacidad.</p>\r\n\r\n<h2>Mantener su información a salvo:</h2>\r\n\r\n<p>El Nombre del Sitio Web se preocupa por la seguridad de su información y utiliza medidas de seguridad comercialmente razonables para preservar la integridad y seguridad de toda la información recopilada a través del Servicio. Para proteger su privacidad y seguridad, tomamos medidas razonables (como solicitar una contraseña única) para verificar su identidad antes de concederle acceso a su cuenta. Usted es responsable de mantener el secreto de su contraseña única y la información de su cuenta, y de controlar el acceso a sus comunicaciones por correo electrónico desde WebsiteName, en todo momento. Sin embargo, WebsiteName no puede asegurar o garantizar la seguridad de cualquier información que usted transmita a WebsiteName o garantizar que la información en el Servicio no puede ser accedida, revelada, alterada o destruida. Su configuración de privacidad también puede verse afectada por los cambios en la funcionalidad de los sitios y servicios de terceros que usted agregue al Servicio WebsiteName, como las redes sociales. WebsiteName no es responsable de la funcionalidad o medidas de seguridad de cualquier tercero.</p>\r\n\r\n<h2>Compromiso de información:</h2>\r\n\r\n<p>En el caso de que cualquier información bajo nuestro control se vea comprometida como resultado de una violación de la seguridad, WebsiteName tomará las medidas razonables para investigar la situación y, en su caso, notificará a las personas cuya información pueda haber sido comprometida y tomará otras medidas, de conformidad con las leyes y reglamentos aplicables.</p>\r\n\r\n<h2>Sus opciones sobre su información </h2>\r\n\r\n<p>Usted controla la información y la configuración de su cuenta: Puede actualizar la información de su cuenta y las preferencias de comunicación por correo electrónico en cualquier momento iniciando sesión en su cuenta y cambiando la configuración de su perfil. </p>\r\n\r\n<p>Hacemos todo lo posible para procesar rápidamente todas las solicitudes de cancelación de suscripción. Como se mencionó anteriormente, usted no puede optar por no recibir comunicaciones relacionadas con el Servicio (por ejemplo, verificación de cuenta, confirmaciones y recordatorios de compra y facturación, cambios/actualizaciones de las características del Servicio, avisos técnicos y de seguridad). Si tiene alguna pregunta sobre la revisión o modificación de la información de su cuenta, puede ponerse en contacto con nosotros directamente en privacy@websitename.com.</p>\r\n\r\n<p>Optar por no recoger su información para Tracking / Publicidad:</p>\r\n\r\n<p>Por favor, consulte la información técnica de su dispositivo móvil o navegador para obtener instrucciones sobre cómo eliminar y desactivar las cookies y otras herramientas de seguimiento/registro. Dependiendo del tipo de dispositivo, es posible que no sea posible eliminar o desactivar los mecanismos de seguimiento de su dispositivo móvil. Tenga en cuenta que la desactivación de cookies y/u otras herramientas de seguimiento impide que WebsiteName o sus socios comerciales rastreen las actividades de su navegador en relación con el Servicio, y para su uso en actividades publicitarias específicas por parte de terceros. Sin embargo, al hacerlo, es posible que se deshabiliten muchas de las funciones disponibles a través del Servicio. Si tiene alguna pregunta sobre la exclusión voluntaria de la recopilación de cookies y otras herramientas de seguimiento/registro, puede ponerse en contacto con nosotros directamente en privacy@websitename.com.</p>\r\n\r\n<p>¿Cuánto tiempo mantenemos su información privada de perfil:</h2>?\r\n\r\n<p>Después de la terminación de su cuenta de usuario, WebsiteName puede retener la información de su perfil privado por un tiempo comercialmente razonable para propósitos de respaldo, archivo o auditoría. Para evitar dudas, cualquier información que usted elija hacer pública en el servicio puede no ser removible.</p>\r\n\r\n<h2>Privacidad de los niños </h2>\r\n\r\n<p>El Nombre del sitio web no recopila ni solicita deliberadamente información de ninguna persona menor de 13 años de edad ni permite que dichas personas se registren como usuarios. El Servicio y su contenido no están dirigidos a niños menores de 13. En el caso de que nos enteremos de que hemos recopilado información personal de un niño menor de 13 años sin la verificación del consentimiento de los padres, borraremos esa información tan pronto como sea posible. Si usted cree que podríamos tener alguna información de o sobre un niño menor de 13 años, por favor contáctenos en privacy@websitename.com.</p>.\r\n\r\n<h2>Enlaces a otros sitios web y servicios </h2>\r\n\r\n<p>No nos hacemos responsables de las prácticas empleadas por los sitios web o servicios enlazados desde o hacia el Servicio, incluyendo la información o el contenido de los mismos. Por favor, recuerde que cuando utiliza un enlace para pasar del Servicio a otro sitio web, nuestra Política de Privacidad no se aplica a los sitios web o servicios de terceros. Su navegación e interacción en cualquier sitio web o servicio de terceros, incluyendo aquellos que tienen un enlace o anuncio en nuestro sitio web, están sujetos a las propias reglas y políticas de ese tercero. Además, usted acepta que no somos responsables y que no controlamos a ningún tercero que usted autorice a acceder a su Contenido de Usuario. Si está utilizando un sitio web o servicio de un tercero (como Facebook, grupos de Google o una sala de chat de IRC) y permite que un tercero acceda a su Contenido de usuario, lo hace bajo su propio riesgo. Esta Política de Privacidad no se aplica a la información que recopilamos por otros medios (incluyendo fuera de línea) o de otras fuentes que no sean a través del Servicio.</p>');
INSERT INTO `pr__translation` (`id`, `length`, `page`, `name`, `en`, `fr`, `es`) VALUES
(197, 'small', 'Helpdesk', 'The ticket you are trying to open does not match your acc...', 'The ticket you are trying to open does not match your account.', 'Le ticket que vous essayez d\'ouvrir ne correspond pas à votre compte.', 'El ticket que está intentando abrir no coincide con su cuenta.'),
(198, 'small', 'Admin', 'No registered address', 'No registered address', 'Pas d’adresse enregistrée', 'No hay dirección registrada'),
(199, 'small', 'Admin', 'Addresses', 'Addresses', 'Adresses', 'Direcciones'),
(200, 'small', 'Helpdesk', 'Created on', 'Created on', 'Créé le', 'Creada el'),
(201, 'medium', 'Admin', 'Your ticket has been updated. To check the ticket status and add a new comment, foll...', 'Your ticket has been updated. To check the ticket status and add a new comment, follow the following link:', '﻿Votre ticket a été mis à jour. Pour vérifier l\'état du ticket et ajouter un commentaire suivez le lien suivant:', 'Su ticket ha sido actualizado. Para comprobar el estado de la solicitud y añadir un nuevo comentario, siga el siguiente enlace:'),
(202, 'small', 'Helpdesk', 'Reply', 'Reply', 'Répondre', 'Responde'),
(203, 'small', 'Helpdesk', 'Awaiting your reply', 'Awaiting your reply', 'En attente de votre réponse', 'A la espera de su respuesta'),
(204, 'small', 'Helpdesk', 'You can have only one opened ticket at once', 'You can have only one opened ticket at once', 'Vous ne pouvez avoir qu\'un seul ticket ouvert à la fois', 'Sólo puede tener un ticket abierto a la vez'),
(205, 'small', 'Helpdesk', 'Yes, ticket resolved', 'Yes, ticket resolved', 'Oui, ticket résolu', 'Sí, ticket resuelto'),
(206, 'small', 'Helpdesk', 'Subjet', 'Subjet', 'Objet', 'Asunto'),
(207, 'small', 'Helpdesk', 'Has the ticket been resolved?', 'Has the ticket been resolved?', 'Le ticket a été résolu ?', '¿Se ha resuelto el ticket?'),
(208, 'small', 'Admin', 'Helpdesk', 'Helpdesk', 'Helpdesk', 'Helpdesk'),
(209, 'small', 'Helpdesk', 'Close ticket', 'Close ticket', 'Fermer le ticket', 'Cerrar ticket'),
(210, 'small', 'Helpdesk', 'Closing ticket', 'Closing ticket', 'Fermeture du ticket', 'Cierre del ticket'),
(211, 'small', 'Helpdesk', 'Ticket', 'Ticket', 'Ticket', 'Ticket'),
(212, 'small', 'Helpdesk', 'Closed on', 'Closed on', 'Fermé le', 'Cerrado el'),
(213, 'small', 'Helpdesk', 'Ticket is closed', 'Ticket is closed', 'Le ticket est fermé', 'El ticket está cerrado'),
(214, 'small', 'Helpdesk', 'Waiting a reply from the user', 'Waiting a reply from the user', 'En attente d\'une réponse de l\'utilisateur', 'Esperando una respuesta del usuario'),
(215, 'small', 'Helpdesk', 'Waiting a reply from the user support', 'Waiting a reply from the user support', 'En attente d\'une réponse du support utilisateur', 'Esperando una respuesta del servicio de atención al usuario'),
(216, 'small', 'Helpdesk', 'Preview', 'Preview', 'Aperçu', 'Vista previa'),
(217, 'small', 'Helpdesk', 'Opened', 'Opened', 'Ouvert', 'Abierto'),
(218, 'small', 'Helpdesk', 'Read', 'Read', 'Lu', 'Leído'),
(219, 'small', 'Helpdesk', 'Closed', 'Closed', 'Fermé', 'Cerrado'),
(220, 'small', 'Helpdesk', 'No ticket open to user support', 'No ticket open to user support', 'Pas de ticket ouvert au support utilisateur', 'No hay tickets abiertos para soporte al usuario'),
(221, 'small', 'Helpdesk', 'Open a ticket', 'Open a ticket', 'Ouvrir un ticket', 'Abrir un ticket'),
(222, 'small', 'Helpdesk', 'Open a ticket to user support', 'Open a ticket to user support', 'Ouvrir un ticket au support utilisateur', 'Abrir un ticket para soporte al usuario'),
(223, 'small', 'Helpdesk', 'You already have an open ticket', 'You already have an open ticket', 'Vous avez déjà un ticket ouvert', 'Ya tiene un billete abierto'),
(224, 'small', 'Home', 'We are sorry to see you go, are you sure you want to delete your account?', 'We are sorry to see you go, are you sure you want to delete your account?', 'Nous sommes désolés de vous voir partir, êtes-vous sûr de vouloir supprimer votre compte ?', 'Lamentamos que se vaya, ¿está seguro de que desea eliminar su cuenta?'),
(225, 'small', 'Home', 'The deletion will be final', 'The deletion will be final', 'La suppression sera définitive', 'La eliminación será definitiva'),
(226, 'small', 'Home', 'Please, enter your password to confirm:', 'Please, enter your password to confirm:', 'Veuillez entrer votre mot de passe pour confirmer :', 'Por favor, introduzca su contraseña para confirmar:'),
(227, 'small', 'Home', 'This link to delete your WebsiteName account is no longer valid or is incorrect.', 'This link to delete your phpRegister account is no longer valid or is incorrect.', 'Ce lien pour supprimer votre compte phpRegister n\'est plus valide ou est incorrect.', 'Este enlace para borrar su cuenta phpRegister ya no es válido o es incorrecto.'),
(228, 'small', 'Home', 'You can create another one in your account profile.', 'You can create another one in your account profile.', 'Vous pouvez en créer un autre dans le profil de votre compte.', 'Puede crear otro en su perfil de cuenta.'),
(229, 'small', 'Home', 'Yes, delete my account now', 'Yes, delete my account now', 'Oui, supprimer mon compte maintenant', 'Sí, eliminar mi cuenta ahora'),
(230, 'small', 'Helpdesk', 'Open', 'Open', 'Ouvrir', 'Abrir'),
(231, 'small', 'Admin', 'Administration Home', 'Administration Home', 'Administration Accueil', 'Inicio de Administración'),
(232, 'small', 'Admin', 'Database', 'Database', 'Base de données', 'Base de datos'),
(233, 'small', 'Admin', 'By email', 'By email', 'Par email', 'Por email'),
(234, 'small', 'Admin', 'Total of registrations', 'Total of registrations', '﻿Total des créations', 'Total de inscripciones'),
(235, 'small', 'Admin', 'Charts Period', 'Charts Period', '﻿Période des graphiques', '﻿Período del gráfico'),
(236, 'small', 'Admin', '15 last days', '15 last days', '15 derniers jours', '15 días postreros'),
(237, 'small', 'Admin', 'Current month', 'Current month', 'Mois courant', 'Mes en curso'),
(238, 'small', 'Admin', 'Type of registrations', 'Type of registrations', 'Type des comptes créés', 'Tipo de registros'),
(239, 'small', 'Admin', 'Please, specify start date and end date', 'Please, specify start date and end date', '﻿Veuillez préciser la date de début et la date de fin', 'Por favor, especifique la fecha de inicio y la fecha de finalización'),
(240, 'small', 'Admin', 'Start date must be earlier than end date', 'Start date must be earlier than end date', '﻿La date de début doit être antérieure à la date de fin', 'La fecha de inicio debe ser anterior a la fecha de finalización'),
(241, 'small', 'Admin', 'Year', 'Year', 'Année', 'Año'),
(242, 'small', 'Helpdesk', 'From', 'From', 'De', 'De'),
(243, 'small', 'Admin', 'to', 'to', 'au', 'al'),
(244, 'small', 'Admin', 'Time range for charts on page opening:', 'Time range for charts on page opening:', 'Période des graphiques à l\'ouverture de la page :', 'Período gráfico en la apertura de la página:'),
(245, 'small', 'Admin', 'Last period filled', 'Last period filled', '﻿Dernière période entrée', '﻿Último período introducido'),
(246, 'small', 'Admin', 'Preferences', 'Preferences', 'Préférences', 'Preferencias'),
(247, 'small', 'Admin', 'Home', 'Home', 'Accueil', 'Inicio'),
(248, 'small', 'Admin', 'User Accounts', 'User Accounts', 'Comptes utilisateurs', 'Cuentas de usuario'),
(249, 'small', 'Admin', 'External Tools', 'External Tools', 'Outils externes', 'Herramientas externas'),
(250, 'small', 'Admin', 'Search account', 'Search account', 'Rechercher compte', 'Buscar cuenta'),
(251, 'small', 'Admin', 'Back to Website', 'Back to Website', 'Retour au site', 'Volver a la Website'),
(252, 'small', 'Admin', 'You don\'t have the required rights to access to the Administration section.', 'You don\'t have the required rights to access to the Administration section.', 'Vous n\'avez pas les droits requis pour accéder à l\'Administration du site.', 'No tiene los derechos necesarios para acceder a la sección Administración.'),
(253, 'small', 'Admin', 'To access to it, please contact the administrator of the site.', 'To access to it, please contact the administrator of the site.', 'Pour y accéder veuillez contacter un administrateur du site.', 'Para acceder a él, póngase en contacto con el administrador del sitio.'),
(254, 'small', 'Admin', 'Administration', 'Administration', 'Administration', 'Administración'),
(255, 'small', 'Admin', 'Language', 'Language', 'Langue', 'Idioma'),
(256, 'small', 'Admin', 'Registration Type', 'Registration Type', 'Type Inscription', 'Registro Tipo'),
(257, 'small', 'Admin', 'There is already an adminright with the name', 'There is already an adminright with the name', 'Il y a déjà un adminright avec le nom', 'Ya hay un adminright con el nombre'),
(258, 'small', 'Admin', 'No rights', 'No rights', 'Aucun droit', 'No derechos'),
(259, 'small', 'Admin', 'Total number of accounts:', 'Total number of accounts:', 'Nombre total de comptes :', 'Número total de cuentas:'),
(260, 'small', 'Admin', 'Search...by lastname, firstname, email, User Id', 'Search...by lastname, firstname, email, User Id', 'Recherche...par nom, prénom, email, User id', 'Buscar...por apellido, nombre, email, User id'),
(261, 'small', 'Admin', 'Creation date', 'Creation date', 'Date de création', 'Fecha de creación'),
(262, 'small', 'Admin', 'Send email', 'Send email', 'Envoyer un email', 'Enviar email'),
(263, 'small', 'Admin', 'Detailed information', 'Detailed information', 'Information détaillée', 'Información detallada'),
(264, 'small', 'Admin', 'Delete account', 'Delete account', 'Supprimer compte', 'Eliminar cuenta'),
(265, 'small', 'Admin', 'Send email to', 'Send email to', 'Envoyer un email à', 'Enviar un email a'),
(266, 'small', 'Admin', 'Email not specified', 'Email not specified', 'Email non précisé', 'Email no especificado'),
(267, 'small', 'Admin', 'Media social account with no email specified', 'Media social account with no email specified', 'Compte d\'un réseau social sans email précisé', 'Cuenta de red social sin email especificado'),
(268, 'small', 'Admin', 'Reply to', 'Reply to', 'Répondre à', 'Responder a'),
(269, 'small', 'Admin', 'Blind copy to', 'Blind copy to', 'Copie cachée à', 'Copia a ciegas a'),
(270, 'small', 'Admin', 'Subject', 'Subject', 'Sujet', 'Asunto'),
(271, 'small', 'Admin', 'Preview', 'Preview', 'Prévisualiser', 'Previsualizar'),
(272, 'small', 'Admin', 'Detailed account information', 'Detailed account information', '﻿Informations détaillées d\'un compte', 'Información detallada de la cuenta'),
(273, 'small', 'Admin', 'Not activated', 'Not activated', 'Non activé', 'No activado'),
(274, 'small', 'Admin', 'Edit Admin Rights', 'Edit Admin Rights', 'Editer les droits Admin', 'Editar derechos de Administrador'),
(275, 'small', 'Admin', 'Email sent!', 'Email sent!', 'Email envoyé', 'Email enviado!'),
(276, 'small', 'Admin', 'Admin rights description', 'Admin rights description', 'Description des droits Admin', 'Descripción de los derechos Admin'),
(277, 'small', 'Admin', 'Accounts with Admin rights', 'Accounts with Admin rights', 'Comptes avec droits Admin', 'Cuentas con derechos de administrador'),
(278, 'small', 'Admin', 'Rights', 'Rights', 'Droits', 'Derechos'),
(279, 'small', 'Admin', 'Select at least one specific right.', 'Select at least one specific right.', '﻿Sélectionnez au moins un droit spécifique.', 'Seleccione al menos un derecho específico.'),
(280, 'small', 'Admin', 'New Admin rights:', 'New Admin rights:', 'Nouveaux droits Admin :', 'Nuevos derechos de administración:'),
(281, 'small', 'Admin', 'General Information', 'General Information', '﻿Information Général', 'Información General'),
(282, 'small', 'Admin', 'Creation', 'Creation', 'Création', 'Creación'),
(283, 'small', 'Admin', 'Last session', 'Last session', 'Dernière session', 'Última sesión'),
(284, 'small', 'Admin', 'Admin Rights', 'Admin Rights', 'Droits Admin', 'Derechos de Admin'),
(285, 'small', 'Admin', 'Google Account', 'Google Account', 'Compte Google', 'Cuenta Google'),
(286, 'small', 'Admin', 'Link Google', 'Link Google', 'Lien Google', 'Enlace Google'),
(287, 'small', 'Admin', 'Account Verified', 'Account Verified', 'Compte Vérifié', 'Cuenta Verificada'),
(288, 'small', 'Admin', 'Facebook Account', 'Facebook Account', 'Compte Facebook', 'Cuenta Facebook'),
(289, 'small', 'Admin', 'Link Facebook', 'Link Facebook', 'Lien Facebook', 'Enlace Facebook'),
(290, 'small', 'Admin', 'Browser and Operating system', 'Browser and Operating system', 'Navigateur et système d\'exploitation', 'Navegador y sistema operativo'),
(291, 'small', 'Admin', 'Browser', 'Browser', 'Navigateur', 'Navegador'),
(292, 'small', 'Admin', 'Keys', 'Keys', 'Clefs', 'Claves'),
(293, 'small', 'Admin', 'Expiry in', 'Expiry in', 'Expire dans', 'Expiración en'),
(294, 'small', 'Admin', 'Link expired', 'Link expired', 'Lien expiré', 'Enlace caducado'),
(295, 'small', 'Admin', 'Account Activation Key', 'Account Activation Key', 'Lien Activation Compte', 'Clave de Activación de Cuenta'),
(296, 'small', 'Admin', 'New Email Key', 'New Email Key', 'Clef Nouvel Email', 'Nueva Clave de Email'),
(297, 'small', 'Admin', 'Creation key date', 'Creation key date', 'Date création clef', 'Fecha clave creación'),
(298, 'small', 'Admin', 'New password key', 'New password key', 'Clef nouveau mot de passe', 'Nueva clave de contraseña'),
(299, 'small', 'Admin', 'Location / Account creation', 'Location / Account creation', 'Localisation / Création du compte', 'Ubicación / Creación de la cuenta'),
(300, 'small', 'Admin', 'Country', 'Country', 'Pays', 'País'),
(301, 'small', 'Admin', 'Country code', 'Country code', 'Code du pays', 'Código de país'),
(302, 'small', 'Admin', 'City', 'City', 'Ville', 'Ciudad'),
(303, 'small', 'Admin', 'Region name', 'Region name', 'Nom de la région', 'Nombre de la región'),
(304, 'small', 'Admin', 'Location / Last session', 'Location / Last session', 'Localisation / Dernière session', 'Localización / Última sesión'),
(305, 'small', 'Admin', 'Please, confirm the account deletion', 'Please, confirm the account deletion', 'Veuillez confirmer la suppression du compte', 'Por favor, confirme la eliminación de la cuenta'),
(306, 'small', 'Admin', 'You can not undo this deletion', 'You can not undo this deletion', 'Vous ne pourrez pas annuler cette suppression', 'No se puede deshacer este borrado'),
(307, 'small', 'Admin', 'Yes, delete this account now', 'Yes, delete this account now', 'Oui, supprimer ce compte maintenant', 'Sí, eliminar esta cuenta ahora'),
(308, 'small', 'Admin', 'Delete this account', 'Delete this account', 'Supprimer ce compte', 'Eliminar esta cuenta'),
(309, 'small', 'Admin', 'Delete in progress', 'Delete in progress', 'Suppression en cours', 'Borrar en curso'),
(310, 'small', 'Admin', 'You can not delete your own account.', 'You can not delete your own account.', 'Vous ne pouvez pas supprimer votre propre compte.', 'No puedes borrar tu propia cuenta.'),
(311, 'small', 'Admin', 'You can not edit your own rights.', 'You can not edit your own rights.', 'Vous ne pouvez pas modifier vos propres droits.', 'No puede editar sus propios derechos.'),
(312, 'small', 'Admin', 'Actual Admin rights:', 'Actual Admin rights:', 'Droits Admin actuels:', 'Derechos de Admin:'),
(313, 'small', 'Admin', 'Specific rights', 'Specific rights', 'Drois spécifiques', 'Derechos específicos'),
(314, 'small', 'Admin', 'Update Admin rights', 'Update Admin rights', 'Mettre à jour les droits Admin', 'Actualizar los derechos Admin'),
(315, 'small', 'Admin', 'Search result', 'Search result', 'Résultat recherche', 'Resultado búsqueda'),
(316, 'small', 'Admin', 'Number of 404 redirections', 'Number of redirections', 'Nombre de redirections 404', 'Número de redirecciones 404'),
(317, 'small', 'Admin', 'Redirections 404 to 301', 'Redirections 404 to 301', 'Redirections 404 vers 301', 'Redirecciones 404 a 301'),
(318, 'small', 'Admin', 'New redirection', 'New redirection', 'Nouvelle redirection', 'Nueva redirección'),
(319, 'small', 'Admin', 'New redirection 404 to 301 (Moved Permanently)', 'New redirection 404 to 301 (Moved Permanently)', 'Nouvelle redirection 404 vers 301 (Moved Permanently)', 'Nueva redirección 404 a 301 (Moved Permanently)'),
(320, 'medium', 'Admin', 'You must specify the protocol <strong>http://</strong> or <strong>https://</strong>...', '﻿You must specify the protocol <strong>http://</strong> or <strong>https://</strong> in the source and destination.', '﻿Vous devez préciser le protocole <strong>http://</strong> ou <strong>https://</strong> dans la source et la destination.', '﻿Debe especificar el protocolo <strong>http://</strong> o <strong>https://</strong> en el origen y destino.'),
(321, 'small', 'Admin', 'Source', 'Source', 'Source', 'Fuente'),
(322, 'small', 'Admin', 'Destination', 'Destination', 'Destination', 'Destino'),
(323, 'small', 'Admin', 'Add redirection', 'Add redirection', 'Ajouter redirection', 'Añadir redirección'),
(324, 'small', 'Admin', 'There is already a 404 redirection for the source:', 'There is already a 404 redirection for the source:', 'Il y a déjà un redirection 404 pour la source :', 'Ya existe una redirección 404 para la fuente:'),
(325, 'small', 'Admin', 'Configuration', 'Configuration', 'Configuration', 'Configuración'),
(326, 'small', 'Admin', 'Please confirm the deletion of this redirection', 'Please confirm the deletion of this redirection', 'Veuillez confirmer la suppression de cette redirection', 'Por favor, confirme la eliminación de esta redirección'),
(327, 'small', 'Admin', 'Number of redirections', 'Number of redirections', 'Nombre de redirections', 'Número de redirecciones'),
(328, 'small', 'Admin', 'Last click date', 'Last click date', 'Date du dernier click', 'Fecha del último clic'),
(329, 'small', 'Admin', 'Confirm deletion', 'Confirm deletion', 'Confirmer supression', 'Confirmar el borrado'),
(330, 'small', 'Admin', 'Delete Redirection', 'Delete Redirection', 'Supprimer Redirection', 'Eliminar Redirección'),
(331, 'small', 'Admin', 'Count', 'Count', ' Count', 'Count'),
(332, 'small', 'Admin', 'Last click', 'Last click', 'Dernier click', 'Último clic'),
(333, 'small', 'Admin', 'Translations', 'Translations', 'Traductions', 'Traducciones'),
(334, 'small', 'Admin', '404 Redirections', '404 Redirections', '404 Redirections', '404 Redirecciones'),
(335, 'small', 'Admin', 'There is already a variable with this name', 'There is already a variable with this name', 'Il existe déjà une variable avec ce nom', 'Ya existe una variable con este nombre'),
(336, 'small', 'Admin', 'Add variable', 'Add variable', 'Ajouter variable', 'Añadir variable'),
(337, 'small', 'Admin', 'Default language when a variable is not translated', 'Default language when a variable is not translated', 'Langue par défaut quand une variable n\'est pas traduite', 'Idioma por defecto cuando una variable no está traducida'),
(338, 'large', 'Admin', 'Environment variables contained in the MySQL table <span class=\"border px-2 py-1\">...', 'Environment variables contained in the MySQL table <span class=\"border px-2 py-1\">pr__website_option</span> which will be inserted in the global PHP variable </strong><span class=\"border px-2 py-1\">$config</span>', 'Variables d\'environnement contenues dans la table MySQL <span class=\"border px-2 py-1\">pr__website_option</span> qui seront insérées dans la variable global PHP </strong><span class=\"border px-2 py-1\">$config</span>', 'Variables de entorno contenidas en la tabla MySQL <span class=\"border px-2 py-1\">pr__website_option</span> que se insertarán en la variable global PHP </strong><span class=\"border px-2 py-1\">$config</span>.'),
(339, 'small', 'Admin', 'New variable', 'New variable', 'Nouvelle variable', 'Nueva variable'),
(340, 'small', 'Admin', 'Add a variable:', 'Add a variable:', 'Ajouter une variable:', 'Añadir una variable:'),
(341, 'small', 'Admin', 'Description', 'Description', 'Description', 'Descripción'),
(342, 'small', 'Admin', 'Name', 'Name', 'Nom', 'Apellido'),
(343, 'small', 'Admin', 'Value', 'Value', 'Valeur', 'Valor'),
(344, 'small', 'Admin', 'Delete this variable', 'Delete this variable', 'Supprimer cette variable', 'Borrar esta variable'),
(345, 'small', 'Admin', 'Edit this variable', 'Edit this variable', 'Editer cette variable', 'Editar esta variable'),
(346, 'small', 'Admin', 'Modifying a variable', 'Modifying a variable', 'Modifier une variable', 'Modificar una variable'),
(347, 'medium', 'Admin', 'Changing a variable. Changing its <strong>Name</strong> can cause malfunctio...', 'Changing a variable. Changing its <strong>Name</strong> can cause malfunctions.', 'Modification d\'une variable. La modification de son <strong>Nom</strong> peut entrainer des disfonctionnements.', 'Modificación de una variable. Cambiar su <strong>Nombre</strong> puede causar fallos de funcionamiento.'),
(348, 'small', 'Admin', 'Confirm modification', 'Confirm modification', 'Confirmer modification', 'Confirmar la modificación'),
(349, 'small', 'Admin', 'Unix command to search in the code for the variable', 'Unix command to search in the code for the variable', 'Commande Unix pour rechercher dans le code la variable', 'Comando Unix para buscar en el código la variable'),
(350, 'small', 'Admin', '(in single quotation marks)', '(in single quotation marks)', '(entre guillements droits)', '(entre comillas simples)'),
(351, 'small', 'Admin', 'Copy this Unix command to clipboard', 'Copy this Unix command to clipboard', 'Copiez cette commande Unix dans le presse-papiers', 'Copie este comando Unix al portapapeles'),
(352, 'medium', 'Admin', 'Please confirm that you want to delete this variable. Any deletion is final and may...', 'Please confirm that you want to delete this variable. Any deletion is final and may cause malfunctions, you do so at your own risk.', 'Veuillez confirmer la suppression de cette variable. Toute suppression est définitive et peut entrainer des disfonctionnements, vous le faites à vos propres risques.', 'Confirme que desea eliminar esta variable. Cualquier borrado es definitivo y puede causar fallos de funcionamiento, usted lo hace bajo su propio riesgo.'),
(353, 'small', 'Admin', 'Check to confirm', 'Check to confirm', 'Cocher pour confirmer', 'Verifique para confirmar'),
(354, 'small', 'Admin', 'Please tick the box to confirm the deletion of this variable', 'Please tick the box to confirm the deletion of this variable', 'Veuillez cochez la case pour confirmer la suppression de cette variable', 'Por favor, marque la casilla para confirmar la eliminación de esta variable'),
(355, 'small', 'Admin', 'Variables', 'Variables', 'Variables', 'Variables'),
(356, 'small', 'Admin', 'Administration rights', 'Administration rights', 'Droits administration', 'Derechos administración'),
(357, 'small', 'Admin', 'From', 'From', 'De', 'De'),
(358, 'small', 'Helpdesk', 'Message', 'Message', 'Message', 'Mensaje'),
(359, 'small', 'Helpdesk', 'Date', 'Date', 'Date', 'Fecha'),
(360, 'small', 'Admin', 'You do not have the required rights to edit the translation variables', '﻿You do not have the required rights to edit the translation variables', '﻿Vous n\'avez pas les droits requis pour éditer les variables de traductions', '﻿No tiene los derechos necesarios para editar las variables de traducción'),
(361, 'small', 'Admin', 'Add admin right', 'Add admin right', 'Ajouter droit Admin', 'Añadir derecho de Admin'),
(362, 'small', 'Admin', 'Modifying a right', 'Modifying a right', 'Modification d\'un droit', 'Modificar un derecho'),
(363, 'small', 'Admin', 'Add an Admin right', 'Add an Admin right', 'Ajouter un droit Admin', 'Añadir un derecho de Admin'),
(364, 'small', 'Admin', 'New Admin right', 'New Admin right', 'Nouveau droit Admin', 'Nuevo derecho de Admin'),
(365, 'small', 'Admin', 'Edit this Admin right', 'Edit this Admin right', 'Modifier ce droit Admin', 'Modificar este derecho de Admin'),
(366, 'medium', 'Admin', 'Modifying the name or description of an Admin right. Modifying its name may cause...', 'Modifying the name or description of an Admin right. Modifying its name may cause malfunctions. You do it at your own risks.', 'Modifier le nom ou la description d\'un droit Admin. La modification de son nom peut entraîner des dysfonctionnements. Vous le faites à vos propres risques.', 'Modificar el nombre o la descripción de un derecho de administrador. La modificación de su nombre puede provocar fallos de funcionamiento. Lo haces a tu propio riesgo.'),
(367, 'small', 'Admin', 'The name of the right \"admin\" cannot be changed', 'The name of the right \"admin\" cannot be changed', 'Le nom du droit \"admin\" ne peut pas être changé', 'El nombre de la derecha \"admin\" no se puede cambiar'),
(368, 'small', 'Admin', 'Unix command to search where this Admin right is checked in the code', 'Unix command to search where this Admin right is checked in the code', 'Commande Unix pour rechercher où ce droit Admin est vérifié dans le code', 'Comando Unix para buscar donde este derecho de Admin está marcado en el código'),
(369, 'small', 'Admin', 'Delete this Admin right', 'Delete this Admin right', 'Supprimer ce droit Admin', 'Borrar este derecho de Admin'),
(370, 'medium', 'Admin', 'Please confirm that you want to delete this Admin right. Any deletion is final and...', 'Please confirm that you want to delete this Admin right. Any deletion is final and may cause malfunctions, you do so at your own risk.', 'Veuillez confirmer la suppression de ce droit Admin. Toute suppression est définitive et peut entrainer des disfonctionnements, vous le faites à vos propres risques.', 'Por favor, confirme que desea eliminar este derecho de Admin. Cualquier borrado es definitivo y puede causar fallos de funcionamiento, usted lo hace bajo su propio riesgo.'),
(371, 'small', 'Admin', 'Please tick the box to confirm the deletion of this Admin right', 'Please tick the box to confirm the deletion of this Admin right', 'Veuillez cocher la case pour confirmer la suppression de droit Admin', 'Por favor, marque la casilla para confirmar la eliminación de este derecho de Admin'),
(372, 'small', 'Admin', 'An Admin right', 'An Admin right', 'Un droit Admin', 'Un derecho de Admin'),
(373, 'small', 'Admin', 'An environment variable', 'An environment variable', 'Une variable d\'environnement', 'Una variable de entorno'),
(374, 'small', 'Helpdesk', 'New ticket', 'New ticket', 'Nouveau ticket', 'Nuevo ticket'),
(375, 'small', 'Admin', 'Change page', 'Change page', 'Modifier la page', 'Modificar la página'),
(376, 'small', 'Admin', 'Page', 'Page', 'Page', 'Página'),
(377, 'small', 'Admin', 'Variable', 'Variable', 'Variable', 'Variable'),
(378, 'small', 'Admin', 'Copy', 'Copy', 'Copier', 'Copiar'),
(379, 'small', 'Admin', 'Copy to clipboard the PHP code of the lg function used in another page', 'Copy to clipboard the PHP code of the lg function from another page', 'Copier dans le presse-papiers le code PHP de la fonction lg utilisée dans une autre page', 'Copiar al portapapeles el código PHP de la función lg utilizada en otra página'),
(380, 'small', 'Admin', 'Change variable name', 'Change variable name', 'Changer le nom de la variable', 'Cambiar el nombre de la variable'),
(381, 'small', 'Admin', 'Copy to clipboard the PHP code of the lg function used in the page', 'Copy to clipboard the PHP code of the lg function used in the page', 'Copier dans le presse-papiers le code PHP de la fonction lg utilisée dans la page', 'Copiar al portapapeles el código PHP de la función lg utilizada en la página'),
(382, 'small', 'Admin', 'Copy to clipboard the PHP code of the lg function of this Global variable', 'Copy to clipboard the PHP code of the lg function of this Global variable', 'Copier dans le presse-papiers le code PHP de la fonction lg de cette variable globale', 'Copiar al portapapeles el código PHP de la función lg de esta variable Global'),
(383, 'small', 'Admin', 'Copy to clipboard the Unix command to search this variable in the code', 'Copy to clipboard the Unix command to search this variable in the code', 'Copier dans le presse-papiers la commande Unix pour rechercher cette variable dans le code', 'Copiar al portapapeles el comando Unix para buscar esta variable en el código'),
(384, 'small', 'Admin', 'Translate', 'Translate', 'Traduire', 'Traducir'),
(385, 'small', 'Admin', 'PHP code of the lg function of this Global variable', 'PHP code of the lg function of this Global variable', 'Code PHP de la fonction lg de cette variable Globale', 'Código PHP de la función lg de esta variable Global'),
(386, 'small', 'Admin', 'PHP code of the lg function used in page', 'PHP code of the lg function used in page', 'Code PHP de la fonction lg utilisée dans la page', 'Código PHP de la función lg utilizada en la página'),
(387, 'small', 'Admin', 'Unix command to search this variable in the code', 'Unix command to search this variable in the code', 'Commande Unix pour rechercher cette variable dans le code', 'Comando Unix para buscar esta variable en el código'),
(388, 'small', 'Admin', 'PHP code of the lg function used in another page', 'PHP code of the lg function used in another page', 'Code PHP de la fonction lg utilisée dans une autre page', 'Código PHP de la función lg utilizada en otra página'),
(389, 'small', 'Admin', '\"Login as\" key', '\"Login as\" key', 'Clef \"Login as\"', 'Clave \"Login as\"'),
(390, 'small', 'Admin', 'Creation of a key to login as', 'Creation of a key to login as', 'Création d\'une clef pour se connecter en tant que', 'Creación de una llave para conectar como'),
(391, 'small', 'Admin', 'The key will be usable via a link.', 'The key will be usable via a link.', 'La clef sera utilisable via un lien.', 'La clave se podrá utilizar a través de un enlace.'),
(392, 'small', 'Admin', '﻿Generate a key', '﻿Generate a key', 'Générer une clef', '﻿Generar una clave'),
(393, 'small', 'Admin', 'Link with the key to login as', 'Link with the key to login as', 'Lien avec la clef pour se connecter en tant que', 'Enlace con la clave para conectar como'),
(394, 'small', 'Admin', 'Password \"Login as\"', 'Password \"Login as\"', 'Mot de passe \"Login as\"', 'Contraseña \"Login as\"'),
(395, 'small', 'Admin', 'This link can only be used once and the \"Login as\" password must be used.', 'This link can only be used once and the \"Login as\" password must be used.', 'Ce lien n\'est utilisable qu\'une seule fois et le mot de passe \"Login as\" devra être utilisé.', 'Este enlace sólo puede utilizarse una vez y debe utilizarse la contraseña \"Login as\".'),
(396, 'small', 'Admin', 'Delete the key', 'Delete the key', 'Supprimer la clef', 'Borrar la clave'),
(397, 'small', 'Log in', 'Log in with', 'Log in with', 'Se connecter avec', 'Iniciar sesión con'),
(398, 'small', 'Global', 'Main pages', 'Main pages', 'Pages principales', 'Páginas principales'),
(399, 'small', 'Home', 'Header Title', 'WebsiteName', 'WebsiteName', 'WebsiteName'),
(400, 'medium', 'Home', 'Header Desc', 'Description of your Website...', 'Description de votre site Web.....', 'Descripción de su sitio web....'),
(401, 'medium', 'Global', 'Header Desc', 'Some general information about WebsiteName...', 'Quelques informations générales sur WebsiteName.....', 'Alguna información general sobre WebsiteName....'),
(404, 'small', 'Terms', 'Header Title', 'Terms and Conditions & Privacy Policy', 'Conditions d\'utilisation et politique de confidentialité', 'Términos y condiciones y política de privacidad'),
(405, 'small', 'Terms', 'Privacy Policy', 'Privacy Policy', 'Politique de confidentialité', 'Política de privacidad'),
(406, 'small', 'Admin', 'Search...by Ticket ID, User ID, Subject or Message', 'Search...by Ticket ID, User ID, Subject or Message', 'Recherche...par Ticket ID, User ID, Sujet ou Message', 'Buscar...por Ticket ID, ID de usuario, Asunto o Mensaje');

CREATE TABLE `pr__url_redirection` (
  `id` smallint(8) UNSIGNED NOT NULL,
  `src` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dest` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count_redirect` int(11) DEFAULT '0',
  `date_lastclick` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__user` (
  `id` int(8) UNSIGNED NOT NULL,
  `activation_key` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `newsletter` tinyint(4) NOT NULL DEFAULT '1',
  `picture` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password_changekey` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password_changedate` datetime DEFAULT NULL,
  `firstname` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_deletekey` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_deletedate` datetime DEFAULT NULL,
  `lang` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `newemail` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `newemail_changekey` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `newemail_changedate` datetime DEFAULT NULL,
  `ip_accountcreated` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_accountcreated` datetime DEFAULT NULL,
  `lastsession_ip` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastsession_date` datetime DEFAULT NULL,
  `agent` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loginas_key` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DELIMITER $$
CREATE TRIGGER `pr__user_delete` BEFORE DELETE ON `pr__user` FOR EACH ROW BEGIN
DELETE FROM pr__ticket
    WHERE pr__ticket.user_id = OLD.id;
DELETE FROM pr__user_oauth
    WHERE pr__user_oauth.user_id = OLD.id;
DELETE FROM pr__address
    WHERE pr__address.user_id = OLD.id;
DELETE FROM pr__user_adminright
	WHERE pr__user_adminright.user_id = OLD.id;
DELETE FROM pr__user_adminprefs
	WHERE pr__user_adminprefs.user_id = OLD.id;
END
$$
DELIMITER ;

CREATE TABLE `pr__user_adminprefs` (
  `id` int(8) UNSIGNED NOT NULL,
  `user_id` int(8) UNSIGNED NOT NULL,
  `adminhome_period` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `adminhome_periodfilled` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accounts_searchorder` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `helpdesk_replyas` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `helpdesk_signaturetext` text COLLATE utf8_unicode_ci
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__user_adminright` (
  `id` int(8) UNSIGNED NOT NULL,
  `user_id` int(8) UNSIGNED NOT NULL,
  `adminright_id` tinyint(3) UNSIGNED NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__user_facebook` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstname` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastname` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `link` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `locale` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `picture` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `verified` tinyint(1) UNSIGNED NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__user_google` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `firstname` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastname` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `link` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `locale` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `picture` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `verified` tinyint(1) UNSIGNED DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `pr__user_oauth` (
  `id` int(8) UNSIGNED NOT NULL,
  `user_id` int(8) UNSIGNED NOT NULL,
  `google_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `facebook_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DELIMITER $$
CREATE TRIGGER `pr__user_oauth_delete` BEFORE DELETE ON `pr__user_oauth` FOR EACH ROW BEGIN
DELETE FROM pr__user_facebook
    WHERE pr__user_facebook.id = OLD.facebook_id;
DELETE FROM pr__user_google
    WHERE pr__user_google.id = OLD.google_id;
END
$$
DELIMITER ;

CREATE TABLE `pr__website_option` (
  `id` int(8) UNSIGNED NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `pr__website_option` (`id`, `name`, `value`, `description`) VALUES
(3, 'misstranslation_defaultlang', 'en', NULL),
(4, 'logas_password', '86fffe52dbc02d13bf24f66134e9e439b128d41b', NULL),
(21, 'WebsiteName', 'WebsiteName', 'Name of your website.\r\nUsed on some pages and emails.'),
(6, 'AdminAccountsPerPage', '20', 'Admin / Accounts: Max accounts displayed per page.'),
(10, 'ExpiryKeyNewEmail', '120', 'Minutes before expiration of the key sent by email to activate new email / password account.'),
(11, 'ExpiryKeyNewPassword', '120', 'Minutes before expiration of the key sent by email to create new account password.'),
(12, 'ExpiryKeyDelAccount', '120', 'Minutes before expiration of the key sent by email to delete an account.'),
(22, 'ImagesMaxSize', '1200', 'Uploaded Images Max Size in pixels.\r\nIf one side is bigger, image will be resized in function img_copyResized.'),
(23, 'GeoIPDatabaseFile', 'GeoLite2-City.mmdb', 'Name of file of MaxMind GeoIP2 database which must be in directory _libraries/geoip/database/'),
(18, 'SessionLifetime', '30', 'Number of days of the Session duration, server side. The configuration  of the your server must accept this duration: If the user session is lost too quickly, check also session.gc_maxlifetime from your php.ini file.'),
(24, 'GeoIPLibraryVersion', '2.9.0', 'Version of MaxMind GeoIP2 library, version is in folder _libraries/geoip/x.x.x'),
(26, 'HelpdeskEmail', 'TRUE', 'Send an notice by email to the admin contact of new ticket or of a new reply from a user on the Helpdesk.'),
(27, 'HelpdeskEmailContact', 'contact@phpregister.org', 'Email contact to prevent of new tickets and new replies from users on Helpdesk.'),
(28, 'HelpdeskEmailContactName', 'Helpdesk', 'Name associated to the email of the variable <b>HelpdeskEmailContact</b>.'),
(30, 'AdminTicketsPerPage', '30', 'Admin / Helpdesk: Max tickets displayed per page. '),
(29, 'CookieLifetime', '365', 'Lifetime in days for \"Datas\" cookie stocked by users browsers. \"Datas\" contains user preferences like language or redirection after login. Used in file /include/php/global_cookies.inc.php');


ALTER TABLE `pr__address`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`) USING BTREE,
  ADD KEY `country_code` (`country_code`);

ALTER TABLE `pr__adminright`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `adminright` (`name`);

ALTER TABLE `pr__country`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `country_code` (`code`) USING BTREE;

ALTER TABLE `pr__ticket`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`) USING BTREE;
ALTER TABLE `pr__ticket` ADD FULLTEXT KEY `fulltext_adminsearch` (`subject`,`message`);

ALTER TABLE `pr__ticket_reply`
  ADD PRIMARY KEY (`id`),
  ADD KEY `helpesk_id` (`ticket_id`) USING BTREE;

ALTER TABLE `pr__translation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `page` (`page`),
  ADD KEY `name` (`name`);

ALTER TABLE `pr__url_redirection`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `src` (`src`),
  ADD KEY `date_lastclick` (`date_lastclick`);

ALTER TABLE `pr__user`
  ADD PRIMARY KEY (`id`),
  ADD KEY `password_changekey` (`password_changekey`) USING BTREE,
  ADD KEY `email` (`email`) USING BTREE,
  ADD KEY `logas_key` (`loginas_key`),
  ADD KEY `date_accountcreated` (`date_accountcreated`),
  ADD KEY `lastsession_date` (`lastsession_date`);
ALTER TABLE `pr__user` ADD FULLTEXT KEY `fulltext_adminsearch` (`email`,`firstname`,`lastname`);

ALTER TABLE `pr__user_adminprefs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `prefs_user_id` (`user_id`) USING BTREE;

ALTER TABLE `pr__user_adminright`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`) USING BTREE;

ALTER TABLE `pr__user_facebook`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `facebook_email` (`email`);

ALTER TABLE `pr__user_google`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `google_email` (`email`);

ALTER TABLE `pr__user_oauth`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `google_id` (`google_id`),
  ADD UNIQUE KEY `facebook_id` (`facebook_id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `pr__website_option`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`id`),
  ADD KEY `value` (`value`);


ALTER TABLE `pr__address`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__adminright`
  MODIFY `id` tinyint(3) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__country`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__ticket`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__ticket_reply`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__translation`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__url_redirection`
  MODIFY `id` smallint(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__user`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__user_adminprefs`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__user_adminright`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__user_oauth`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `pr__website_option`
  MODIFY `id` int(8) UNSIGNED NOT NULL AUTO_INCREMENT;
COMMIT;
