/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

// +k8s:openapi-gen=true
// +k8s:deepcopy-gen=package
// +groupName=ext.cattle.io
package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// GroupMembershipRefreshRequestList is a list of GroupMembershipRefreshRequest resources
type GroupMembershipRefreshRequestList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []GroupMembershipRefreshRequest `json:"items"`
}

func NewGroupMembershipRefreshRequest(namespace, name string, obj GroupMembershipRefreshRequest) *GroupMembershipRefreshRequest {
	obj.APIVersion, obj.Kind = SchemeGroupVersion.WithKind("GroupMembershipRefreshRequest").ToAPIVersionAndKind()
	obj.Name = name
	obj.Namespace = namespace
	return &obj
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// KubeconfigList is a list of Kubeconfig resources
type KubeconfigList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []Kubeconfig `json:"items"`
}

func NewKubeconfig(namespace, name string, obj Kubeconfig) *Kubeconfig {
	obj.APIVersion, obj.Kind = SchemeGroupVersion.WithKind("Kubeconfig").ToAPIVersionAndKind()
	obj.Name = name
	obj.Namespace = namespace
	return &obj
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// PasswordChangeRequestList is a list of PasswordChangeRequest resources
type PasswordChangeRequestList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []PasswordChangeRequest `json:"items"`
}

func NewPasswordChangeRequest(namespace, name string, obj PasswordChangeRequest) *PasswordChangeRequest {
	obj.APIVersion, obj.Kind = SchemeGroupVersion.WithKind("PasswordChangeRequest").ToAPIVersionAndKind()
	obj.Name = name
	obj.Namespace = namespace
	return &obj
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// SelfUserList is a list of SelfUser resources
type SelfUserList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []SelfUser `json:"items"`
}

func NewSelfUser(namespace, name string, obj SelfUser) *SelfUser {
	obj.APIVersion, obj.Kind = SchemeGroupVersion.WithKind("SelfUser").ToAPIVersionAndKind()
	obj.Name = name
	obj.Namespace = namespace
	return &obj
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// TokenList is a list of Token resources
type TokenList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []Token `json:"items"`
}

func NewToken(namespace, name string, obj Token) *Token {
	obj.APIVersion, obj.Kind = SchemeGroupVersion.WithKind("Token").ToAPIVersionAndKind()
	obj.Name = name
	obj.Namespace = namespace
	return &obj
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// UserActivityList is a list of UserActivity resources
type UserActivityList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []UserActivity `json:"items"`
}

func NewUserActivity(namespace, name string, obj UserActivity) *UserActivity {
	obj.APIVersion, obj.Kind = SchemeGroupVersion.WithKind("UserActivity").ToAPIVersionAndKind()
	obj.Name = name
	obj.Namespace = namespace
	return &obj
}
