// This program generates a Go file containing a set of exported constants that represent
// configuration variables of Rancher at build-time.
package main

import (
	"fmt"
	"os"
	"text/template"
)

func main() {
	if err := generateGoConstantsFile(); err != nil {
		fmt.Fprintln(os.Stderr, err)
		os.Exit(1)
	}
}

func generateGoConstantsFile() error {
	in, err := os.OpenFile("build.yaml", os.O_RDONLY, 0644)
	if err != nil {
		return err
	}
	out, err := os.OpenFile("pkg/buildconfig/constants.go", os.O_TRUNC|os.O_WRONLY, 0644)
	if err != nil {
		return err
	}
	const raw = `// Code generated by pkg/codegen/config/main.go. DO NOT EDIT.
// Package buildconfig contains a set of exported constants that represent configuration variables of Rancher at build-time.
package buildconfig
	
const (
{{ . }})
`
	tmpl, err := template.New("").Parse(raw)
	if err != nil {
		return err
	}
	writer := GoConstantsWriter{
		Tmpl:   tmpl,
		Input:  in,
		Output: out,
	}
	return writer.Run()
}
