package management

import (
	"context"

	"github.com/rancher/rancher/pkg/auth/data"
	"github.com/rancher/rancher/pkg/types/config"
	"github.com/rancher/rancher/pkg/wrangler"
)

func Add(ctx context.Context, wrangler *wrangler.Context, management *config.ManagementContext) error {
	_, err := addRoles(wrangler, management)

	if err != nil {
		return err
	}

	if err := syncKEv2Operators(management); err != nil {
		return err
	}

	if err := data.AuthConfigs(management); err != nil {
		return err
	}

	if err := addKev2OperatorCredsSchemas(management); err != nil {
		return err
	}

	if err = addDefaultPodSecurityAdmissionConfigurationTemplates(management); err != nil {
		return err
	}

	if err := addKontainerDrivers(management); err != nil {
		return err
	}

	if err := addCattleGlobalNamespaces(management); err != nil {
		return err
	}

	return addMachineDrivers(management)
}
