/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	v1 "github.com/rancher/rancher/pkg/apis/catalog.cattle.io/v1"
	catalogcattleiov1 "github.com/rancher/rancher/pkg/generated/clientset/versioned/typed/catalog.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeOperations implements OperationInterface
type fakeOperations struct {
	*gentype.FakeClientWithList[*v1.Operation, *v1.OperationList]
	Fake *FakeCatalogV1
}

func newFakeOperations(fake *FakeCatalogV1, namespace string) catalogcattleiov1.OperationInterface {
	return &fakeOperations{
		gentype.NewFakeClientWithList[*v1.Operation, *v1.OperationList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("operations"),
			v1.SchemeGroupVersion.WithKind("Operation"),
			func() *v1.Operation { return &v1.Operation{} },
			func() *v1.OperationList { return &v1.OperationList{} },
			func(dst, src *v1.OperationList) { dst.ListMeta = src.ListMeta },
			func(list *v1.OperationList) []*v1.Operation { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.OperationList, items []*v1.Operation) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
