/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	v1 "github.com/rancher/rancher/pkg/apis/provisioning.cattle.io/v1"
	provisioningcattleiov1 "github.com/rancher/rancher/pkg/generated/clientset/versioned/typed/provisioning.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeClusters implements ClusterInterface
type fakeClusters struct {
	*gentype.FakeClientWithList[*v1.Cluster, *v1.ClusterList]
	Fake *FakeProvisioningV1
}

func newFakeClusters(fake *FakeProvisioningV1, namespace string) provisioningcattleiov1.ClusterInterface {
	return &fakeClusters{
		gentype.NewFakeClientWithList[*v1.Cluster, *v1.ClusterList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("clusters"),
			v1.SchemeGroupVersion.WithKind("Cluster"),
			func() *v1.Cluster { return &v1.Cluster{} },
			func() *v1.ClusterList { return &v1.ClusterList{} },
			func(dst, src *v1.ClusterList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ClusterList) []*v1.Cluster { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ClusterList, items []*v1.Cluster) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
