/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	context "context"

	rkecattleiov1 "github.com/rancher/rancher/pkg/apis/rke.cattle.io/v1"
	scheme "github.com/rancher/rancher/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CustomMachinesGetter has a method to return a CustomMachineInterface.
// A group's client should implement this interface.
type CustomMachinesGetter interface {
	CustomMachines(namespace string) CustomMachineInterface
}

// CustomMachineInterface has methods to work with CustomMachine resources.
type CustomMachineInterface interface {
	Create(ctx context.Context, customMachine *rkecattleiov1.CustomMachine, opts metav1.CreateOptions) (*rkecattleiov1.CustomMachine, error)
	Update(ctx context.Context, customMachine *rkecattleiov1.CustomMachine, opts metav1.UpdateOptions) (*rkecattleiov1.CustomMachine, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, customMachine *rkecattleiov1.CustomMachine, opts metav1.UpdateOptions) (*rkecattleiov1.CustomMachine, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*rkecattleiov1.CustomMachine, error)
	List(ctx context.Context, opts metav1.ListOptions) (*rkecattleiov1.CustomMachineList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *rkecattleiov1.CustomMachine, err error)
	CustomMachineExpansion
}

// customMachines implements CustomMachineInterface
type customMachines struct {
	*gentype.ClientWithList[*rkecattleiov1.CustomMachine, *rkecattleiov1.CustomMachineList]
}

// newCustomMachines returns a CustomMachines
func newCustomMachines(c *RkeV1Client, namespace string) *customMachines {
	return &customMachines{
		gentype.NewClientWithList[*rkecattleiov1.CustomMachine, *rkecattleiov1.CustomMachineList](
			"custommachines",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *rkecattleiov1.CustomMachine { return &rkecattleiov1.CustomMachine{} },
			func() *rkecattleiov1.CustomMachineList { return &rkecattleiov1.CustomMachineList{} },
		),
	}
}
