/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	v1 "github.com/rancher/rancher/pkg/apis/rke.cattle.io/v1"
	rkecattleiov1 "github.com/rancher/rancher/pkg/generated/clientset/versioned/typed/rke.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeRKEBootstraps implements RKEBootstrapInterface
type fakeRKEBootstraps struct {
	*gentype.FakeClientWithList[*v1.RKEBootstrap, *v1.RKEBootstrapList]
	Fake *FakeRkeV1
}

func newFakeRKEBootstraps(fake *FakeRkeV1, namespace string) rkecattleiov1.RKEBootstrapInterface {
	return &fakeRKEBootstraps{
		gentype.NewFakeClientWithList[*v1.RKEBootstrap, *v1.RKEBootstrapList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("rkebootstraps"),
			v1.SchemeGroupVersion.WithKind("RKEBootstrap"),
			func() *v1.RKEBootstrap { return &v1.RKEBootstrap{} },
			func() *v1.RKEBootstrapList { return &v1.RKEBootstrapList{} },
			func(dst, src *v1.RKEBootstrapList) { dst.ListMeta = src.ListMeta },
			func(list *v1.RKEBootstrapList) []*v1.RKEBootstrap { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.RKEBootstrapList, items []*v1.RKEBootstrap) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
