/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	v1 "github.com/rancher/rancher/pkg/apis/rke.cattle.io/v1"
	rkecattleiov1 "github.com/rancher/rancher/pkg/generated/clientset/versioned/typed/rke.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeRKEClusters implements RKEClusterInterface
type fakeRKEClusters struct {
	*gentype.FakeClientWithList[*v1.RKECluster, *v1.RKEClusterList]
	Fake *FakeRkeV1
}

func newFakeRKEClusters(fake *FakeRkeV1, namespace string) rkecattleiov1.RKEClusterInterface {
	return &fakeRKEClusters{
		gentype.NewFakeClientWithList[*v1.RKECluster, *v1.RKEClusterList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("rkeclusters"),
			v1.SchemeGroupVersion.WithKind("RKECluster"),
			func() *v1.RKECluster { return &v1.RKECluster{} },
			func() *v1.RKEClusterList { return &v1.RKEClusterList{} },
			func(dst, src *v1.RKEClusterList) { dst.ListMeta = src.ListMeta },
			func(list *v1.RKEClusterList) []*v1.RKECluster { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.RKEClusterList, items []*v1.RKECluster) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
