/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	v1 "github.com/rancher/rancher/pkg/apis/rke.cattle.io/v1"
	rkecattleiov1 "github.com/rancher/rancher/pkg/generated/clientset/versioned/typed/rke.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeRKEControlPlanes implements RKEControlPlaneInterface
type fakeRKEControlPlanes struct {
	*gentype.FakeClientWithList[*v1.RKEControlPlane, *v1.RKEControlPlaneList]
	Fake *FakeRkeV1
}

func newFakeRKEControlPlanes(fake *FakeRkeV1, namespace string) rkecattleiov1.RKEControlPlaneInterface {
	return &fakeRKEControlPlanes{
		gentype.NewFakeClientWithList[*v1.RKEControlPlane, *v1.RKEControlPlaneList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("rkecontrolplanes"),
			v1.SchemeGroupVersion.WithKind("RKEControlPlane"),
			func() *v1.RKEControlPlane { return &v1.RKEControlPlane{} },
			func() *v1.RKEControlPlaneList { return &v1.RKEControlPlaneList{} },
			func(dst, src *v1.RKEControlPlaneList) { dst.ListMeta = src.ListMeta },
			func(list *v1.RKEControlPlaneList) []*v1.RKEControlPlane { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.RKEControlPlaneList, items []*v1.RKEControlPlane) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
