/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	http "net/http"

	rkecattleiov1 "github.com/rancher/rancher/pkg/apis/rke.cattle.io/v1"
	scheme "github.com/rancher/rancher/pkg/generated/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type RkeV1Interface interface {
	RESTClient() rest.Interface
	CustomMachinesGetter
	ETCDSnapshotsGetter
	RKEBootstrapsGetter
	RKEBootstrapTemplatesGetter
	RKEClustersGetter
	RKEControlPlanesGetter
}

// RkeV1Client is used to interact with features provided by the rke.cattle.io group.
type RkeV1Client struct {
	restClient rest.Interface
}

func (c *RkeV1Client) CustomMachines(namespace string) CustomMachineInterface {
	return newCustomMachines(c, namespace)
}

func (c *RkeV1Client) ETCDSnapshots(namespace string) ETCDSnapshotInterface {
	return newETCDSnapshots(c, namespace)
}

func (c *RkeV1Client) RKEBootstraps(namespace string) RKEBootstrapInterface {
	return newRKEBootstraps(c, namespace)
}

func (c *RkeV1Client) RKEBootstrapTemplates(namespace string) RKEBootstrapTemplateInterface {
	return newRKEBootstrapTemplates(c, namespace)
}

func (c *RkeV1Client) RKEClusters(namespace string) RKEClusterInterface {
	return newRKEClusters(c, namespace)
}

func (c *RkeV1Client) RKEControlPlanes(namespace string) RKEControlPlaneInterface {
	return newRKEControlPlanes(c, namespace)
}

// NewForConfig creates a new RkeV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*RkeV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new RkeV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*RkeV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &RkeV1Client{client}, nil
}

// NewForConfigOrDie creates a new RkeV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *RkeV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new RkeV1Client for the given RESTClient.
func New(c rest.Interface) *RkeV1Client {
	return &RkeV1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := rkecattleiov1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *RkeV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
