/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	context "context"

	rkecattleiov1 "github.com/rancher/rancher/pkg/apis/rke.cattle.io/v1"
	scheme "github.com/rancher/rancher/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// RKEClustersGetter has a method to return a RKEClusterInterface.
// A group's client should implement this interface.
type RKEClustersGetter interface {
	RKEClusters(namespace string) RKEClusterInterface
}

// RKEClusterInterface has methods to work with RKECluster resources.
type RKEClusterInterface interface {
	Create(ctx context.Context, rKECluster *rkecattleiov1.RKECluster, opts metav1.CreateOptions) (*rkecattleiov1.RKECluster, error)
	Update(ctx context.Context, rKECluster *rkecattleiov1.RKECluster, opts metav1.UpdateOptions) (*rkecattleiov1.RKECluster, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, rKECluster *rkecattleiov1.RKECluster, opts metav1.UpdateOptions) (*rkecattleiov1.RKECluster, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*rkecattleiov1.RKECluster, error)
	List(ctx context.Context, opts metav1.ListOptions) (*rkecattleiov1.RKEClusterList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *rkecattleiov1.RKECluster, err error)
	RKEClusterExpansion
}

// rKEClusters implements RKEClusterInterface
type rKEClusters struct {
	*gentype.ClientWithList[*rkecattleiov1.RKECluster, *rkecattleiov1.RKEClusterList]
}

// newRKEClusters returns a RKEClusters
func newRKEClusters(c *RkeV1Client, namespace string) *rKEClusters {
	return &rKEClusters{
		gentype.NewClientWithList[*rkecattleiov1.RKECluster, *rkecattleiov1.RKEClusterList](
			"rkeclusters",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *rkecattleiov1.RKECluster { return &rkecattleiov1.RKECluster{} },
			func() *rkecattleiov1.RKEClusterList { return &rkecattleiov1.RKEClusterList{} },
		),
	}
}
