/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	context "context"

	telemetrycattleiov1 "github.com/rancher/rancher/pkg/apis/telemetry.cattle.io/v1"
	scheme "github.com/rancher/rancher/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// SecretRequestsGetter has a method to return a SecretRequestInterface.
// A group's client should implement this interface.
type SecretRequestsGetter interface {
	SecretRequests() SecretRequestInterface
}

// SecretRequestInterface has methods to work with SecretRequest resources.
type SecretRequestInterface interface {
	Create(ctx context.Context, secretRequest *telemetrycattleiov1.SecretRequest, opts metav1.CreateOptions) (*telemetrycattleiov1.SecretRequest, error)
	Update(ctx context.Context, secretRequest *telemetrycattleiov1.SecretRequest, opts metav1.UpdateOptions) (*telemetrycattleiov1.SecretRequest, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, secretRequest *telemetrycattleiov1.SecretRequest, opts metav1.UpdateOptions) (*telemetrycattleiov1.SecretRequest, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*telemetrycattleiov1.SecretRequest, error)
	List(ctx context.Context, opts metav1.ListOptions) (*telemetrycattleiov1.SecretRequestList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *telemetrycattleiov1.SecretRequest, err error)
	SecretRequestExpansion
}

// secretRequests implements SecretRequestInterface
type secretRequests struct {
	*gentype.ClientWithList[*telemetrycattleiov1.SecretRequest, *telemetrycattleiov1.SecretRequestList]
}

// newSecretRequests returns a SecretRequests
func newSecretRequests(c *TelemetryV1Client) *secretRequests {
	return &secretRequests{
		gentype.NewClientWithList[*telemetrycattleiov1.SecretRequest, *telemetrycattleiov1.SecretRequestList](
			"secretrequests",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *telemetrycattleiov1.SecretRequest { return &telemetrycattleiov1.SecretRequest{} },
			func() *telemetrycattleiov1.SecretRequestList { return &telemetrycattleiov1.SecretRequestList{} },
		),
	}
}
