/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package fake

import (
	upgradecattleiov1 "github.com/rancher/rancher/pkg/generated/clientset/versioned/typed/upgrade.cattle.io/v1"
	v1 "github.com/rancher/system-upgrade-controller/pkg/apis/upgrade.cattle.io/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakePlans implements PlanInterface
type fakePlans struct {
	*gentype.FakeClientWithList[*v1.Plan, *v1.PlanList]
	Fake *FakeUpgradeV1
}

func newFakePlans(fake *FakeUpgradeV1, namespace string) upgradecattleiov1.PlanInterface {
	return &fakePlans{
		gentype.NewFakeClientWithList[*v1.Plan, *v1.PlanList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("plans"),
			v1.SchemeGroupVersion.WithKind("Plan"),
			func() *v1.Plan { return &v1.Plan{} },
			func() *v1.PlanList { return &v1.PlanList{} },
			func(dst, src *v1.PlanList) { dst.ListMeta = src.ListMeta },
			func(list *v1.PlanList) []*v1.Plan { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.PlanList, items []*v1.Plan) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
