/*
Copyright 2025 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1beta1

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/wrangler/v3/pkg/apply"
	"github.com/rancher/wrangler/v3/pkg/condition"
	"github.com/rancher/wrangler/v3/pkg/generic"
	"github.com/rancher/wrangler/v3/pkg/kv"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	v1beta1 "sigs.k8s.io/cluster-api/api/v1beta1"
)

// MachineController interface for managing Machine resources.
type MachineController interface {
	generic.ControllerInterface[*v1beta1.Machine, *v1beta1.MachineList]
}

// MachineClient interface for managing Machine resources in Kubernetes.
type MachineClient interface {
	generic.ClientInterface[*v1beta1.Machine, *v1beta1.MachineList]
}

// MachineCache interface for retrieving Machine resources in memory.
type MachineCache interface {
	generic.CacheInterface[*v1beta1.Machine]
}

// MachineStatusHandler is executed for every added or modified Machine. Should return the new status to be updated
type MachineStatusHandler func(obj *v1beta1.Machine, status v1beta1.MachineStatus) (v1beta1.MachineStatus, error)

// MachineGeneratingHandler is the top-level handler that is executed for every Machine event. It extends MachineStatusHandler by a returning a slice of child objects to be passed to apply.Apply
type MachineGeneratingHandler func(obj *v1beta1.Machine, status v1beta1.MachineStatus) ([]runtime.Object, v1beta1.MachineStatus, error)

// RegisterMachineStatusHandler configures a MachineController to execute a MachineStatusHandler for every events observed.
// If a non-empty condition is provided, it will be updated in the status conditions for every handler execution
func RegisterMachineStatusHandler(ctx context.Context, controller MachineController, condition condition.Cond, name string, handler MachineStatusHandler) {
	statusHandler := &machineStatusHandler{
		client:    controller,
		condition: condition,
		handler:   handler,
	}
	controller.AddGenericHandler(ctx, name, generic.FromObjectHandlerToHandler(statusHandler.sync))
}

// RegisterMachineGeneratingHandler configures a MachineController to execute a MachineGeneratingHandler for every events observed, passing the returned objects to the provided apply.Apply.
// If a non-empty condition is provided, it will be updated in the status conditions for every handler execution
func RegisterMachineGeneratingHandler(ctx context.Context, controller MachineController, apply apply.Apply,
	condition condition.Cond, name string, handler MachineGeneratingHandler, opts *generic.GeneratingHandlerOptions) {
	statusHandler := &machineGeneratingHandler{
		MachineGeneratingHandler: handler,
		apply:                    apply,
		name:                     name,
		gvk:                      controller.GroupVersionKind(),
	}
	if opts != nil {
		statusHandler.opts = *opts
	}
	controller.OnChange(ctx, name, statusHandler.Remove)
	RegisterMachineStatusHandler(ctx, controller, condition, name, statusHandler.Handle)
}

type machineStatusHandler struct {
	client    MachineClient
	condition condition.Cond
	handler   MachineStatusHandler
}

// sync is executed on every resource addition or modification. Executes the configured handlers and sends the updated status to the Kubernetes API
func (a *machineStatusHandler) sync(key string, obj *v1beta1.Machine) (*v1beta1.Machine, error) {
	if obj == nil {
		return obj, nil
	}

	origStatus := obj.Status.DeepCopy()
	obj = obj.DeepCopy()
	newStatus, err := a.handler(obj, obj.Status)
	if err != nil {
		// Revert to old status on error
		newStatus = *origStatus.DeepCopy()
	}

	if a.condition != "" {
		if errors.IsConflict(err) {
			a.condition.SetError(&newStatus, "", nil)
		} else {
			a.condition.SetError(&newStatus, "", err)
		}
	}
	if !equality.Semantic.DeepEqual(origStatus, &newStatus) {
		if a.condition != "" {
			// Since status has changed, update the lastUpdatedTime
			a.condition.LastUpdated(&newStatus, time.Now().UTC().Format(time.RFC3339))
		}

		var newErr error
		obj.Status = newStatus
		newObj, newErr := a.client.UpdateStatus(obj)
		if err == nil {
			err = newErr
		}
		if newErr == nil {
			obj = newObj
		}
	}
	return obj, err
}

type machineGeneratingHandler struct {
	MachineGeneratingHandler
	apply apply.Apply
	opts  generic.GeneratingHandlerOptions
	gvk   schema.GroupVersionKind
	name  string
	seen  sync.Map
}

// Remove handles the observed deletion of a resource, cascade deleting every associated resource previously applied
func (a *machineGeneratingHandler) Remove(key string, obj *v1beta1.Machine) (*v1beta1.Machine, error) {
	if obj != nil {
		return obj, nil
	}

	obj = &v1beta1.Machine{}
	obj.Namespace, obj.Name = kv.RSplit(key, "/")
	obj.SetGroupVersionKind(a.gvk)

	if a.opts.UniqueApplyForResourceVersion {
		a.seen.Delete(key)
	}

	return nil, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects()
}

// Handle executes the configured MachineGeneratingHandler and pass the resulting objects to apply.Apply, finally returning the new status of the resource
func (a *machineGeneratingHandler) Handle(obj *v1beta1.Machine, status v1beta1.MachineStatus) (v1beta1.MachineStatus, error) {
	if !obj.DeletionTimestamp.IsZero() {
		return status, nil
	}

	objs, newStatus, err := a.MachineGeneratingHandler(obj, status)
	if err != nil {
		return newStatus, err
	}
	if !a.isNewResourceVersion(obj) {
		return newStatus, nil
	}

	err = generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects(objs...)
	if err != nil {
		return newStatus, err
	}
	a.storeResourceVersion(obj)
	return newStatus, nil
}

// isNewResourceVersion detects if a specific resource version was already successfully processed.
// Only used if UniqueApplyForResourceVersion is set in generic.GeneratingHandlerOptions
func (a *machineGeneratingHandler) isNewResourceVersion(obj *v1beta1.Machine) bool {
	if !a.opts.UniqueApplyForResourceVersion {
		return true
	}

	// Apply once per resource version
	key := obj.Namespace + "/" + obj.Name
	previous, ok := a.seen.Load(key)
	return !ok || previous != obj.ResourceVersion
}

// storeResourceVersion keeps track of the latest resource version of an object for which Apply was executed
// Only used if UniqueApplyForResourceVersion is set in generic.GeneratingHandlerOptions
func (a *machineGeneratingHandler) storeResourceVersion(obj *v1beta1.Machine) {
	if !a.opts.UniqueApplyForResourceVersion {
		return
	}

	key := obj.Namespace + "/" + obj.Name
	a.seen.Store(key, obj.ResourceVersion)
}
