// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/apiregistration.k8s.io/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
	v1 "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1"
)

var (
	lockAPIServiceListerMockGet  sync.RWMutex
	lockAPIServiceListerMockList sync.RWMutex
)

// Ensure, that APIServiceListerMock does implement v11.APIServiceLister.
// If this is not the case, regenerate this file with moq.
var _ v11.APIServiceLister = &APIServiceListerMock{}

// APIServiceListerMock is a mock implementation of v11.APIServiceLister.
//
//	    func TestSomethingThatUsesAPIServiceLister(t *testing.T) {
//
//	        // make and configure a mocked v11.APIServiceLister
//	        mockedAPIServiceLister := &APIServiceListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.APIService, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.APIService, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedAPIServiceLister in code that requires v11.APIServiceLister
//	        // and then make assertions.
//
//	    }
type APIServiceListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.APIService, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.APIService, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *APIServiceListerMock) Get(namespace string, name string) (*v1.APIService, error) {
	if mock.GetFunc == nil {
		panic("APIServiceListerMock.GetFunc: method is nil but APIServiceLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAPIServiceListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAPIServiceListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedAPIServiceLister.GetCalls())
func (mock *APIServiceListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAPIServiceListerMockGet.RLock()
	calls = mock.calls.Get
	lockAPIServiceListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *APIServiceListerMock) List(namespace string, selector labels.Selector) ([]*v1.APIService, error) {
	if mock.ListFunc == nil {
		panic("APIServiceListerMock.ListFunc: method is nil but APIServiceLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockAPIServiceListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAPIServiceListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedAPIServiceLister.ListCalls())
func (mock *APIServiceListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockAPIServiceListerMockList.RLock()
	calls = mock.calls.List
	lockAPIServiceListerMockList.RUnlock()
	return calls
}

var (
	lockAPIServiceControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockAPIServiceControllerMockAddClusterScopedHandler        sync.RWMutex
	lockAPIServiceControllerMockAddFeatureHandler              sync.RWMutex
	lockAPIServiceControllerMockAddHandler                     sync.RWMutex
	lockAPIServiceControllerMockEnqueue                        sync.RWMutex
	lockAPIServiceControllerMockEnqueueAfter                   sync.RWMutex
	lockAPIServiceControllerMockGeneric                        sync.RWMutex
	lockAPIServiceControllerMockInformer                       sync.RWMutex
	lockAPIServiceControllerMockLister                         sync.RWMutex
)

// Ensure, that APIServiceControllerMock does implement v11.APIServiceController.
// If this is not the case, regenerate this file with moq.
var _ v11.APIServiceController = &APIServiceControllerMock{}

// APIServiceControllerMock is a mock implementation of v11.APIServiceController.
//
//	    func TestSomethingThatUsesAPIServiceController(t *testing.T) {
//
//	        // make and configure a mocked v11.APIServiceController
//	        mockedAPIServiceController := &APIServiceControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.APIServiceLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedAPIServiceController in code that requires v11.APIServiceController
//	        // and then make assertions.
//
//	    }
type APIServiceControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.APIServiceHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.APIServiceHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.APIServiceHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.APIServiceHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.APIServiceLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.APIServiceHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.APIServiceHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.APIServiceHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.APIServiceHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *APIServiceControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.APIServiceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("APIServiceControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but APIServiceController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.APIServiceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAPIServiceControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAPIServiceControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedAPIServiceController.AddClusterScopedFeatureHandlerCalls())
func (mock *APIServiceControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.APIServiceHandlerFunc
	}
	lockAPIServiceControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAPIServiceControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *APIServiceControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.APIServiceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("APIServiceControllerMock.AddClusterScopedHandlerFunc: method is nil but APIServiceController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.APIServiceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAPIServiceControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAPIServiceControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedAPIServiceController.AddClusterScopedHandlerCalls())
func (mock *APIServiceControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.APIServiceHandlerFunc
	}
	lockAPIServiceControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAPIServiceControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *APIServiceControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.APIServiceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("APIServiceControllerMock.AddFeatureHandlerFunc: method is nil but APIServiceController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.APIServiceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAPIServiceControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAPIServiceControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedAPIServiceController.AddFeatureHandlerCalls())
func (mock *APIServiceControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.APIServiceHandlerFunc
	}
	lockAPIServiceControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAPIServiceControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *APIServiceControllerMock) AddHandler(ctx context.Context, name string, handler v11.APIServiceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("APIServiceControllerMock.AddHandlerFunc: method is nil but APIServiceController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.APIServiceHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockAPIServiceControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAPIServiceControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedAPIServiceController.AddHandlerCalls())
func (mock *APIServiceControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.APIServiceHandlerFunc
	}
	lockAPIServiceControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAPIServiceControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *APIServiceControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("APIServiceControllerMock.EnqueueFunc: method is nil but APIServiceController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAPIServiceControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockAPIServiceControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedAPIServiceController.EnqueueCalls())
func (mock *APIServiceControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAPIServiceControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockAPIServiceControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *APIServiceControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("APIServiceControllerMock.EnqueueAfterFunc: method is nil but APIServiceController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockAPIServiceControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockAPIServiceControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedAPIServiceController.EnqueueAfterCalls())
func (mock *APIServiceControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockAPIServiceControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockAPIServiceControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *APIServiceControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("APIServiceControllerMock.GenericFunc: method is nil but APIServiceController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockAPIServiceControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockAPIServiceControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedAPIServiceController.GenericCalls())
func (mock *APIServiceControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockAPIServiceControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockAPIServiceControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *APIServiceControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("APIServiceControllerMock.InformerFunc: method is nil but APIServiceController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockAPIServiceControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockAPIServiceControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedAPIServiceController.InformerCalls())
func (mock *APIServiceControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockAPIServiceControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockAPIServiceControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *APIServiceControllerMock) Lister() v11.APIServiceLister {
	if mock.ListerFunc == nil {
		panic("APIServiceControllerMock.ListerFunc: method is nil but APIServiceController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockAPIServiceControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockAPIServiceControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedAPIServiceController.ListerCalls())
func (mock *APIServiceControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockAPIServiceControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockAPIServiceControllerMockLister.RUnlock()
	return calls
}

var (
	lockAPIServiceInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockAPIServiceInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockAPIServiceInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockAPIServiceInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockAPIServiceInterfaceMockAddFeatureHandler                sync.RWMutex
	lockAPIServiceInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockAPIServiceInterfaceMockAddHandler                       sync.RWMutex
	lockAPIServiceInterfaceMockAddLifecycle                     sync.RWMutex
	lockAPIServiceInterfaceMockController                       sync.RWMutex
	lockAPIServiceInterfaceMockCreate                           sync.RWMutex
	lockAPIServiceInterfaceMockDelete                           sync.RWMutex
	lockAPIServiceInterfaceMockDeleteCollection                 sync.RWMutex
	lockAPIServiceInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockAPIServiceInterfaceMockGet                              sync.RWMutex
	lockAPIServiceInterfaceMockGetNamespaced                    sync.RWMutex
	lockAPIServiceInterfaceMockList                             sync.RWMutex
	lockAPIServiceInterfaceMockListNamespaced                   sync.RWMutex
	lockAPIServiceInterfaceMockObjectClient                     sync.RWMutex
	lockAPIServiceInterfaceMockUpdate                           sync.RWMutex
	lockAPIServiceInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that APIServiceInterfaceMock does implement v11.APIServiceInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.APIServiceInterface = &APIServiceInterfaceMock{}

// APIServiceInterfaceMock is a mock implementation of v11.APIServiceInterface.
//
//	    func TestSomethingThatUsesAPIServiceInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.APIServiceInterface
//	        mockedAPIServiceInterface := &APIServiceInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.APIServiceLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.APIServiceLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.APIServiceLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.APIServiceHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.APIServiceLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.APIServiceController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.APIService) (*v1.APIService, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.APIService, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.APIService, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.APIServiceList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.APIServiceList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.APIService) (*v1.APIService, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedAPIServiceInterface in code that requires v11.APIServiceInterface
//	        // and then make assertions.
//
//	    }
type APIServiceInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.APIServiceHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.APIServiceLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.APIServiceHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.APIServiceLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.APIServiceHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.APIServiceLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.APIServiceHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.APIServiceLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.APIServiceController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.APIService) (*v1.APIService, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.APIService, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.APIService, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.APIServiceList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.APIServiceList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.APIService) (*v1.APIService, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.APIServiceHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.APIServiceLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.APIServiceHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.APIServiceLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.APIServiceHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.APIServiceLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.APIServiceHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.APIServiceLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.APIService
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.APIService
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *APIServiceInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.APIServiceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("APIServiceInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but APIServiceInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.APIServiceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAPIServiceInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAPIServiceInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *APIServiceInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.APIServiceHandlerFunc
	}
	lockAPIServiceInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAPIServiceInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *APIServiceInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.APIServiceLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("APIServiceInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but APIServiceInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.APIServiceLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAPIServiceInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockAPIServiceInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *APIServiceInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.APIServiceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.APIServiceLifecycle
	}
	lockAPIServiceInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockAPIServiceInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *APIServiceInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.APIServiceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("APIServiceInterfaceMock.AddClusterScopedHandlerFunc: method is nil but APIServiceInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.APIServiceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAPIServiceInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAPIServiceInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddClusterScopedHandlerCalls())
func (mock *APIServiceInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.APIServiceHandlerFunc
	}
	lockAPIServiceInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAPIServiceInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *APIServiceInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.APIServiceLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("APIServiceInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but APIServiceInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.APIServiceLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAPIServiceInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockAPIServiceInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddClusterScopedLifecycleCalls())
func (mock *APIServiceInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.APIServiceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.APIServiceLifecycle
	}
	lockAPIServiceInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockAPIServiceInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *APIServiceInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.APIServiceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("APIServiceInterfaceMock.AddFeatureHandlerFunc: method is nil but APIServiceInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.APIServiceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAPIServiceInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAPIServiceInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddFeatureHandlerCalls())
func (mock *APIServiceInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.APIServiceHandlerFunc
	}
	lockAPIServiceInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAPIServiceInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *APIServiceInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.APIServiceLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("APIServiceInterfaceMock.AddFeatureLifecycleFunc: method is nil but APIServiceInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.APIServiceLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAPIServiceInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockAPIServiceInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddFeatureLifecycleCalls())
func (mock *APIServiceInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.APIServiceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.APIServiceLifecycle
	}
	lockAPIServiceInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockAPIServiceInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *APIServiceInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.APIServiceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("APIServiceInterfaceMock.AddHandlerFunc: method is nil but APIServiceInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.APIServiceHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockAPIServiceInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAPIServiceInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddHandlerCalls())
func (mock *APIServiceInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.APIServiceHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.APIServiceHandlerFunc
	}
	lockAPIServiceInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAPIServiceInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *APIServiceInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.APIServiceLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("APIServiceInterfaceMock.AddLifecycleFunc: method is nil but APIServiceInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.APIServiceLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAPIServiceInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockAPIServiceInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedAPIServiceInterface.AddLifecycleCalls())
func (mock *APIServiceInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.APIServiceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.APIServiceLifecycle
	}
	lockAPIServiceInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockAPIServiceInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *APIServiceInterfaceMock) Controller() v11.APIServiceController {
	if mock.ControllerFunc == nil {
		panic("APIServiceInterfaceMock.ControllerFunc: method is nil but APIServiceInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockAPIServiceInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockAPIServiceInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedAPIServiceInterface.ControllerCalls())
func (mock *APIServiceInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockAPIServiceInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockAPIServiceInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *APIServiceInterfaceMock) Create(in1 *v1.APIService) (*v1.APIService, error) {
	if mock.CreateFunc == nil {
		panic("APIServiceInterfaceMock.CreateFunc: method is nil but APIServiceInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.APIService
	}{
		In1: in1,
	}
	lockAPIServiceInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockAPIServiceInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedAPIServiceInterface.CreateCalls())
func (mock *APIServiceInterfaceMock) CreateCalls() []struct {
	In1 *v1.APIService
} {
	var calls []struct {
		In1 *v1.APIService
	}
	lockAPIServiceInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockAPIServiceInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *APIServiceInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("APIServiceInterfaceMock.DeleteFunc: method is nil but APIServiceInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockAPIServiceInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockAPIServiceInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedAPIServiceInterface.DeleteCalls())
func (mock *APIServiceInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockAPIServiceInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockAPIServiceInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *APIServiceInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("APIServiceInterfaceMock.DeleteCollectionFunc: method is nil but APIServiceInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockAPIServiceInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockAPIServiceInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedAPIServiceInterface.DeleteCollectionCalls())
func (mock *APIServiceInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockAPIServiceInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockAPIServiceInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *APIServiceInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("APIServiceInterfaceMock.DeleteNamespacedFunc: method is nil but APIServiceInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockAPIServiceInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockAPIServiceInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedAPIServiceInterface.DeleteNamespacedCalls())
func (mock *APIServiceInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockAPIServiceInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockAPIServiceInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *APIServiceInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.APIService, error) {
	if mock.GetFunc == nil {
		panic("APIServiceInterfaceMock.GetFunc: method is nil but APIServiceInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockAPIServiceInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAPIServiceInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedAPIServiceInterface.GetCalls())
func (mock *APIServiceInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockAPIServiceInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockAPIServiceInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *APIServiceInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.APIService, error) {
	if mock.GetNamespacedFunc == nil {
		panic("APIServiceInterfaceMock.GetNamespacedFunc: method is nil but APIServiceInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockAPIServiceInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockAPIServiceInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedAPIServiceInterface.GetNamespacedCalls())
func (mock *APIServiceInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockAPIServiceInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockAPIServiceInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *APIServiceInterfaceMock) List(opts metav1.ListOptions) (*v1.APIServiceList, error) {
	if mock.ListFunc == nil {
		panic("APIServiceInterfaceMock.ListFunc: method is nil but APIServiceInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAPIServiceInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAPIServiceInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedAPIServiceInterface.ListCalls())
func (mock *APIServiceInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAPIServiceInterfaceMockList.RLock()
	calls = mock.calls.List
	lockAPIServiceInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *APIServiceInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.APIServiceList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("APIServiceInterfaceMock.ListNamespacedFunc: method is nil but APIServiceInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockAPIServiceInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockAPIServiceInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedAPIServiceInterface.ListNamespacedCalls())
func (mock *APIServiceInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockAPIServiceInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockAPIServiceInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *APIServiceInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("APIServiceInterfaceMock.ObjectClientFunc: method is nil but APIServiceInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockAPIServiceInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockAPIServiceInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedAPIServiceInterface.ObjectClientCalls())
func (mock *APIServiceInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockAPIServiceInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockAPIServiceInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *APIServiceInterfaceMock) Update(in1 *v1.APIService) (*v1.APIService, error) {
	if mock.UpdateFunc == nil {
		panic("APIServiceInterfaceMock.UpdateFunc: method is nil but APIServiceInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.APIService
	}{
		In1: in1,
	}
	lockAPIServiceInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockAPIServiceInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedAPIServiceInterface.UpdateCalls())
func (mock *APIServiceInterfaceMock) UpdateCalls() []struct {
	In1 *v1.APIService
} {
	var calls []struct {
		In1 *v1.APIService
	}
	lockAPIServiceInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockAPIServiceInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *APIServiceInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("APIServiceInterfaceMock.WatchFunc: method is nil but APIServiceInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAPIServiceInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockAPIServiceInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedAPIServiceInterface.WatchCalls())
func (mock *APIServiceInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAPIServiceInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockAPIServiceInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockAPIServicesGetterMockAPIServices sync.RWMutex
)

// Ensure, that APIServicesGetterMock does implement v11.APIServicesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.APIServicesGetter = &APIServicesGetterMock{}

// APIServicesGetterMock is a mock implementation of v11.APIServicesGetter.
//
//	    func TestSomethingThatUsesAPIServicesGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.APIServicesGetter
//	        mockedAPIServicesGetter := &APIServicesGetterMock{
//	            APIServicesFunc: func(namespace string) v11.APIServiceInterface {
//		               panic("mock out the APIServices method")
//	            },
//	        }
//
//	        // use mockedAPIServicesGetter in code that requires v11.APIServicesGetter
//	        // and then make assertions.
//
//	    }
type APIServicesGetterMock struct {
	// APIServicesFunc mocks the APIServices method.
	APIServicesFunc func(namespace string) v11.APIServiceInterface

	// calls tracks calls to the methods.
	calls struct {
		// APIServices holds details about calls to the APIServices method.
		APIServices []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// APIServices calls APIServicesFunc.
func (mock *APIServicesGetterMock) APIServices(namespace string) v11.APIServiceInterface {
	if mock.APIServicesFunc == nil {
		panic("APIServicesGetterMock.APIServicesFunc: method is nil but APIServicesGetter.APIServices was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockAPIServicesGetterMockAPIServices.Lock()
	mock.calls.APIServices = append(mock.calls.APIServices, callInfo)
	lockAPIServicesGetterMockAPIServices.Unlock()
	return mock.APIServicesFunc(namespace)
}

// APIServicesCalls gets all the calls that were made to APIServices.
// Check the length with:
//
//	len(mockedAPIServicesGetter.APIServicesCalls())
func (mock *APIServicesGetterMock) APIServicesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockAPIServicesGetterMockAPIServices.RLock()
	calls = mock.calls.APIServices
	lockAPIServicesGetterMockAPIServices.RUnlock()
	return calls
}
