// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/apps/v1"
	v1 "k8s.io/api/apps/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockDeploymentListerMockGet  sync.RWMutex
	lockDeploymentListerMockList sync.RWMutex
)

// Ensure, that DeploymentListerMock does implement v11.DeploymentLister.
// If this is not the case, regenerate this file with moq.
var _ v11.DeploymentLister = &DeploymentListerMock{}

// DeploymentListerMock is a mock implementation of v11.DeploymentLister.
//
//	    func TestSomethingThatUsesDeploymentLister(t *testing.T) {
//
//	        // make and configure a mocked v11.DeploymentLister
//	        mockedDeploymentLister := &DeploymentListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.Deployment, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Deployment, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedDeploymentLister in code that requires v11.DeploymentLister
//	        // and then make assertions.
//
//	    }
type DeploymentListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Deployment, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Deployment, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *DeploymentListerMock) Get(namespace string, name string) (*v1.Deployment, error) {
	if mock.GetFunc == nil {
		panic("DeploymentListerMock.GetFunc: method is nil but DeploymentLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDeploymentListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDeploymentListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedDeploymentLister.GetCalls())
func (mock *DeploymentListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDeploymentListerMockGet.RLock()
	calls = mock.calls.Get
	lockDeploymentListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DeploymentListerMock) List(namespace string, selector labels.Selector) ([]*v1.Deployment, error) {
	if mock.ListFunc == nil {
		panic("DeploymentListerMock.ListFunc: method is nil but DeploymentLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockDeploymentListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDeploymentListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedDeploymentLister.ListCalls())
func (mock *DeploymentListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockDeploymentListerMockList.RLock()
	calls = mock.calls.List
	lockDeploymentListerMockList.RUnlock()
	return calls
}

var (
	lockDeploymentControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockDeploymentControllerMockAddClusterScopedHandler        sync.RWMutex
	lockDeploymentControllerMockAddFeatureHandler              sync.RWMutex
	lockDeploymentControllerMockAddHandler                     sync.RWMutex
	lockDeploymentControllerMockEnqueue                        sync.RWMutex
	lockDeploymentControllerMockEnqueueAfter                   sync.RWMutex
	lockDeploymentControllerMockGeneric                        sync.RWMutex
	lockDeploymentControllerMockInformer                       sync.RWMutex
	lockDeploymentControllerMockLister                         sync.RWMutex
)

// Ensure, that DeploymentControllerMock does implement v11.DeploymentController.
// If this is not the case, regenerate this file with moq.
var _ v11.DeploymentController = &DeploymentControllerMock{}

// DeploymentControllerMock is a mock implementation of v11.DeploymentController.
//
//	    func TestSomethingThatUsesDeploymentController(t *testing.T) {
//
//	        // make and configure a mocked v11.DeploymentController
//	        mockedDeploymentController := &DeploymentControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.DeploymentLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedDeploymentController in code that requires v11.DeploymentController
//	        // and then make assertions.
//
//	    }
type DeploymentControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.DeploymentHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.DeploymentHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DeploymentHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.DeploymentHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.DeploymentLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.DeploymentHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.DeploymentHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.DeploymentHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.DeploymentHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DeploymentControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.DeploymentHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DeploymentControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but DeploymentController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.DeploymentHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDeploymentControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDeploymentControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedDeploymentController.AddClusterScopedFeatureHandlerCalls())
func (mock *DeploymentControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.DeploymentHandlerFunc
	}
	lockDeploymentControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDeploymentControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DeploymentControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.DeploymentHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DeploymentControllerMock.AddClusterScopedHandlerFunc: method is nil but DeploymentController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.DeploymentHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDeploymentControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDeploymentControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedDeploymentController.AddClusterScopedHandlerCalls())
func (mock *DeploymentControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.DeploymentHandlerFunc
	}
	lockDeploymentControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDeploymentControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DeploymentControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DeploymentHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DeploymentControllerMock.AddFeatureHandlerFunc: method is nil but DeploymentController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DeploymentHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDeploymentControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDeploymentControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedDeploymentController.AddFeatureHandlerCalls())
func (mock *DeploymentControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DeploymentHandlerFunc
	}
	lockDeploymentControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDeploymentControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DeploymentControllerMock) AddHandler(ctx context.Context, name string, handler v11.DeploymentHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DeploymentControllerMock.AddHandlerFunc: method is nil but DeploymentController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.DeploymentHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockDeploymentControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDeploymentControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedDeploymentController.AddHandlerCalls())
func (mock *DeploymentControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.DeploymentHandlerFunc
	}
	lockDeploymentControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDeploymentControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *DeploymentControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("DeploymentControllerMock.EnqueueFunc: method is nil but DeploymentController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDeploymentControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockDeploymentControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedDeploymentController.EnqueueCalls())
func (mock *DeploymentControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDeploymentControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockDeploymentControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *DeploymentControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("DeploymentControllerMock.EnqueueAfterFunc: method is nil but DeploymentController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockDeploymentControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockDeploymentControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedDeploymentController.EnqueueAfterCalls())
func (mock *DeploymentControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockDeploymentControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockDeploymentControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *DeploymentControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("DeploymentControllerMock.GenericFunc: method is nil but DeploymentController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockDeploymentControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockDeploymentControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedDeploymentController.GenericCalls())
func (mock *DeploymentControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockDeploymentControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockDeploymentControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *DeploymentControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("DeploymentControllerMock.InformerFunc: method is nil but DeploymentController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockDeploymentControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockDeploymentControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedDeploymentController.InformerCalls())
func (mock *DeploymentControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockDeploymentControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockDeploymentControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *DeploymentControllerMock) Lister() v11.DeploymentLister {
	if mock.ListerFunc == nil {
		panic("DeploymentControllerMock.ListerFunc: method is nil but DeploymentController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockDeploymentControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockDeploymentControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedDeploymentController.ListerCalls())
func (mock *DeploymentControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockDeploymentControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockDeploymentControllerMockLister.RUnlock()
	return calls
}

var (
	lockDeploymentInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockDeploymentInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockDeploymentInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockDeploymentInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockDeploymentInterfaceMockAddFeatureHandler                sync.RWMutex
	lockDeploymentInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockDeploymentInterfaceMockAddHandler                       sync.RWMutex
	lockDeploymentInterfaceMockAddLifecycle                     sync.RWMutex
	lockDeploymentInterfaceMockController                       sync.RWMutex
	lockDeploymentInterfaceMockCreate                           sync.RWMutex
	lockDeploymentInterfaceMockDelete                           sync.RWMutex
	lockDeploymentInterfaceMockDeleteCollection                 sync.RWMutex
	lockDeploymentInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockDeploymentInterfaceMockGet                              sync.RWMutex
	lockDeploymentInterfaceMockGetNamespaced                    sync.RWMutex
	lockDeploymentInterfaceMockList                             sync.RWMutex
	lockDeploymentInterfaceMockListNamespaced                   sync.RWMutex
	lockDeploymentInterfaceMockObjectClient                     sync.RWMutex
	lockDeploymentInterfaceMockUpdate                           sync.RWMutex
	lockDeploymentInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that DeploymentInterfaceMock does implement v11.DeploymentInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.DeploymentInterface = &DeploymentInterfaceMock{}

// DeploymentInterfaceMock is a mock implementation of v11.DeploymentInterface.
//
//	    func TestSomethingThatUsesDeploymentInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.DeploymentInterface
//	        mockedDeploymentInterface := &DeploymentInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.DeploymentLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.DeploymentLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.DeploymentLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.DeploymentHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.DeploymentLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.DeploymentController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.Deployment) (*v1.Deployment, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.Deployment, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Deployment, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.DeploymentList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.DeploymentList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.Deployment) (*v1.Deployment, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedDeploymentInterface in code that requires v11.DeploymentInterface
//	        // and then make assertions.
//
//	    }
type DeploymentInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.DeploymentHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.DeploymentLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.DeploymentHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.DeploymentLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DeploymentHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.DeploymentLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.DeploymentHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.DeploymentLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.DeploymentController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Deployment) (*v1.Deployment, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Deployment, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Deployment, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.DeploymentList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.DeploymentList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Deployment) (*v1.Deployment, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.DeploymentHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DeploymentLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.DeploymentHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DeploymentLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.DeploymentHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DeploymentLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.DeploymentHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DeploymentLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Deployment
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Deployment
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DeploymentInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.DeploymentHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DeploymentInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but DeploymentInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.DeploymentHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDeploymentInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDeploymentInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *DeploymentInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.DeploymentHandlerFunc
	}
	lockDeploymentInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDeploymentInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *DeploymentInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.DeploymentLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("DeploymentInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but DeploymentInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.DeploymentLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDeploymentInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockDeploymentInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *DeploymentInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.DeploymentLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.DeploymentLifecycle
	}
	lockDeploymentInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockDeploymentInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DeploymentInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.DeploymentHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DeploymentInterfaceMock.AddClusterScopedHandlerFunc: method is nil but DeploymentInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.DeploymentHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDeploymentInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDeploymentInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddClusterScopedHandlerCalls())
func (mock *DeploymentInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.DeploymentHandlerFunc
	}
	lockDeploymentInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDeploymentInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *DeploymentInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.DeploymentLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("DeploymentInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but DeploymentInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.DeploymentLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDeploymentInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockDeploymentInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddClusterScopedLifecycleCalls())
func (mock *DeploymentInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.DeploymentLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.DeploymentLifecycle
	}
	lockDeploymentInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockDeploymentInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DeploymentInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DeploymentHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DeploymentInterfaceMock.AddFeatureHandlerFunc: method is nil but DeploymentInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DeploymentHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDeploymentInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDeploymentInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddFeatureHandlerCalls())
func (mock *DeploymentInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DeploymentHandlerFunc
	}
	lockDeploymentInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDeploymentInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *DeploymentInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.DeploymentLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("DeploymentInterfaceMock.AddFeatureLifecycleFunc: method is nil but DeploymentInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.DeploymentLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDeploymentInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockDeploymentInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddFeatureLifecycleCalls())
func (mock *DeploymentInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.DeploymentLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.DeploymentLifecycle
	}
	lockDeploymentInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockDeploymentInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DeploymentInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.DeploymentHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DeploymentInterfaceMock.AddHandlerFunc: method is nil but DeploymentInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.DeploymentHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockDeploymentInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDeploymentInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddHandlerCalls())
func (mock *DeploymentInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.DeploymentHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.DeploymentHandlerFunc
	}
	lockDeploymentInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDeploymentInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *DeploymentInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.DeploymentLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("DeploymentInterfaceMock.AddLifecycleFunc: method is nil but DeploymentInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.DeploymentLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDeploymentInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockDeploymentInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedDeploymentInterface.AddLifecycleCalls())
func (mock *DeploymentInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.DeploymentLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.DeploymentLifecycle
	}
	lockDeploymentInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockDeploymentInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *DeploymentInterfaceMock) Controller() v11.DeploymentController {
	if mock.ControllerFunc == nil {
		panic("DeploymentInterfaceMock.ControllerFunc: method is nil but DeploymentInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockDeploymentInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockDeploymentInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedDeploymentInterface.ControllerCalls())
func (mock *DeploymentInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockDeploymentInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockDeploymentInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *DeploymentInterfaceMock) Create(in1 *v1.Deployment) (*v1.Deployment, error) {
	if mock.CreateFunc == nil {
		panic("DeploymentInterfaceMock.CreateFunc: method is nil but DeploymentInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Deployment
	}{
		In1: in1,
	}
	lockDeploymentInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockDeploymentInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedDeploymentInterface.CreateCalls())
func (mock *DeploymentInterfaceMock) CreateCalls() []struct {
	In1 *v1.Deployment
} {
	var calls []struct {
		In1 *v1.Deployment
	}
	lockDeploymentInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockDeploymentInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *DeploymentInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("DeploymentInterfaceMock.DeleteFunc: method is nil but DeploymentInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockDeploymentInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockDeploymentInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedDeploymentInterface.DeleteCalls())
func (mock *DeploymentInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockDeploymentInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockDeploymentInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *DeploymentInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("DeploymentInterfaceMock.DeleteCollectionFunc: method is nil but DeploymentInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockDeploymentInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockDeploymentInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedDeploymentInterface.DeleteCollectionCalls())
func (mock *DeploymentInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockDeploymentInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockDeploymentInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *DeploymentInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("DeploymentInterfaceMock.DeleteNamespacedFunc: method is nil but DeploymentInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockDeploymentInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockDeploymentInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedDeploymentInterface.DeleteNamespacedCalls())
func (mock *DeploymentInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockDeploymentInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockDeploymentInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *DeploymentInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Deployment, error) {
	if mock.GetFunc == nil {
		panic("DeploymentInterfaceMock.GetFunc: method is nil but DeploymentInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockDeploymentInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDeploymentInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedDeploymentInterface.GetCalls())
func (mock *DeploymentInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockDeploymentInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockDeploymentInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *DeploymentInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Deployment, error) {
	if mock.GetNamespacedFunc == nil {
		panic("DeploymentInterfaceMock.GetNamespacedFunc: method is nil but DeploymentInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockDeploymentInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockDeploymentInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedDeploymentInterface.GetNamespacedCalls())
func (mock *DeploymentInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockDeploymentInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockDeploymentInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DeploymentInterfaceMock) List(opts metav1.ListOptions) (*v1.DeploymentList, error) {
	if mock.ListFunc == nil {
		panic("DeploymentInterfaceMock.ListFunc: method is nil but DeploymentInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDeploymentInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDeploymentInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedDeploymentInterface.ListCalls())
func (mock *DeploymentInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDeploymentInterfaceMockList.RLock()
	calls = mock.calls.List
	lockDeploymentInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *DeploymentInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.DeploymentList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("DeploymentInterfaceMock.ListNamespacedFunc: method is nil but DeploymentInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockDeploymentInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockDeploymentInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedDeploymentInterface.ListNamespacedCalls())
func (mock *DeploymentInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockDeploymentInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockDeploymentInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *DeploymentInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("DeploymentInterfaceMock.ObjectClientFunc: method is nil but DeploymentInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockDeploymentInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockDeploymentInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedDeploymentInterface.ObjectClientCalls())
func (mock *DeploymentInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockDeploymentInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockDeploymentInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *DeploymentInterfaceMock) Update(in1 *v1.Deployment) (*v1.Deployment, error) {
	if mock.UpdateFunc == nil {
		panic("DeploymentInterfaceMock.UpdateFunc: method is nil but DeploymentInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Deployment
	}{
		In1: in1,
	}
	lockDeploymentInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockDeploymentInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedDeploymentInterface.UpdateCalls())
func (mock *DeploymentInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Deployment
} {
	var calls []struct {
		In1 *v1.Deployment
	}
	lockDeploymentInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockDeploymentInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *DeploymentInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("DeploymentInterfaceMock.WatchFunc: method is nil but DeploymentInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDeploymentInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockDeploymentInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedDeploymentInterface.WatchCalls())
func (mock *DeploymentInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDeploymentInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockDeploymentInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockDeploymentsGetterMockDeployments sync.RWMutex
)

// Ensure, that DeploymentsGetterMock does implement v11.DeploymentsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.DeploymentsGetter = &DeploymentsGetterMock{}

// DeploymentsGetterMock is a mock implementation of v11.DeploymentsGetter.
//
//	    func TestSomethingThatUsesDeploymentsGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.DeploymentsGetter
//	        mockedDeploymentsGetter := &DeploymentsGetterMock{
//	            DeploymentsFunc: func(namespace string) v11.DeploymentInterface {
//		               panic("mock out the Deployments method")
//	            },
//	        }
//
//	        // use mockedDeploymentsGetter in code that requires v11.DeploymentsGetter
//	        // and then make assertions.
//
//	    }
type DeploymentsGetterMock struct {
	// DeploymentsFunc mocks the Deployments method.
	DeploymentsFunc func(namespace string) v11.DeploymentInterface

	// calls tracks calls to the methods.
	calls struct {
		// Deployments holds details about calls to the Deployments method.
		Deployments []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Deployments calls DeploymentsFunc.
func (mock *DeploymentsGetterMock) Deployments(namespace string) v11.DeploymentInterface {
	if mock.DeploymentsFunc == nil {
		panic("DeploymentsGetterMock.DeploymentsFunc: method is nil but DeploymentsGetter.Deployments was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockDeploymentsGetterMockDeployments.Lock()
	mock.calls.Deployments = append(mock.calls.Deployments, callInfo)
	lockDeploymentsGetterMockDeployments.Unlock()
	return mock.DeploymentsFunc(namespace)
}

// DeploymentsCalls gets all the calls that were made to Deployments.
// Check the length with:
//
//	len(mockedDeploymentsGetter.DeploymentsCalls())
func (mock *DeploymentsGetterMock) DeploymentsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockDeploymentsGetterMockDeployments.RLock()
	calls = mock.calls.Deployments
	lockDeploymentsGetterMockDeployments.RUnlock()
	return calls
}
