// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/apps/v1"
	v1 "k8s.io/api/apps/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockReplicaSetListerMockGet  sync.RWMutex
	lockReplicaSetListerMockList sync.RWMutex
)

// Ensure, that ReplicaSetListerMock does implement v11.ReplicaSetLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicaSetLister = &ReplicaSetListerMock{}

// ReplicaSetListerMock is a mock implementation of v11.ReplicaSetLister.
//
//	    func TestSomethingThatUsesReplicaSetLister(t *testing.T) {
//
//	        // make and configure a mocked v11.ReplicaSetLister
//	        mockedReplicaSetLister := &ReplicaSetListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.ReplicaSet, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ReplicaSet, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedReplicaSetLister in code that requires v11.ReplicaSetLister
//	        // and then make assertions.
//
//	    }
type ReplicaSetListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ReplicaSet, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ReplicaSet, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ReplicaSetListerMock) Get(namespace string, name string) (*v1.ReplicaSet, error) {
	if mock.GetFunc == nil {
		panic("ReplicaSetListerMock.GetFunc: method is nil but ReplicaSetLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockReplicaSetListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockReplicaSetListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedReplicaSetLister.GetCalls())
func (mock *ReplicaSetListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockReplicaSetListerMockGet.RLock()
	calls = mock.calls.Get
	lockReplicaSetListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ReplicaSetListerMock) List(namespace string, selector labels.Selector) ([]*v1.ReplicaSet, error) {
	if mock.ListFunc == nil {
		panic("ReplicaSetListerMock.ListFunc: method is nil but ReplicaSetLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockReplicaSetListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockReplicaSetListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedReplicaSetLister.ListCalls())
func (mock *ReplicaSetListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockReplicaSetListerMockList.RLock()
	calls = mock.calls.List
	lockReplicaSetListerMockList.RUnlock()
	return calls
}

var (
	lockReplicaSetControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockReplicaSetControllerMockAddClusterScopedHandler        sync.RWMutex
	lockReplicaSetControllerMockAddFeatureHandler              sync.RWMutex
	lockReplicaSetControllerMockAddHandler                     sync.RWMutex
	lockReplicaSetControllerMockEnqueue                        sync.RWMutex
	lockReplicaSetControllerMockEnqueueAfter                   sync.RWMutex
	lockReplicaSetControllerMockGeneric                        sync.RWMutex
	lockReplicaSetControllerMockInformer                       sync.RWMutex
	lockReplicaSetControllerMockLister                         sync.RWMutex
)

// Ensure, that ReplicaSetControllerMock does implement v11.ReplicaSetController.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicaSetController = &ReplicaSetControllerMock{}

// ReplicaSetControllerMock is a mock implementation of v11.ReplicaSetController.
//
//	    func TestSomethingThatUsesReplicaSetController(t *testing.T) {
//
//	        // make and configure a mocked v11.ReplicaSetController
//	        mockedReplicaSetController := &ReplicaSetControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.ReplicaSetLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedReplicaSetController in code that requires v11.ReplicaSetController
//	        // and then make assertions.
//
//	    }
type ReplicaSetControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ReplicaSetHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ReplicaSetHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicaSetHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ReplicaSetHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ReplicaSetLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ReplicaSetHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ReplicaSetHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ReplicaSetHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ReplicaSetHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ReplicaSetControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ReplicaSetHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ReplicaSetControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ReplicaSetController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ReplicaSetHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockReplicaSetControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockReplicaSetControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedReplicaSetController.AddClusterScopedFeatureHandlerCalls())
func (mock *ReplicaSetControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockReplicaSetControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ReplicaSetControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ReplicaSetHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ReplicaSetControllerMock.AddClusterScopedHandlerFunc: method is nil but ReplicaSetController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ReplicaSetHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockReplicaSetControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockReplicaSetControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedReplicaSetController.AddClusterScopedHandlerCalls())
func (mock *ReplicaSetControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockReplicaSetControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ReplicaSetControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicaSetHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ReplicaSetControllerMock.AddFeatureHandlerFunc: method is nil but ReplicaSetController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicaSetHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockReplicaSetControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockReplicaSetControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedReplicaSetController.AddFeatureHandlerCalls())
func (mock *ReplicaSetControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockReplicaSetControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ReplicaSetControllerMock) AddHandler(ctx context.Context, name string, handler v11.ReplicaSetHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ReplicaSetControllerMock.AddHandlerFunc: method is nil but ReplicaSetController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ReplicaSetHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockReplicaSetControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockReplicaSetControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedReplicaSetController.AddHandlerCalls())
func (mock *ReplicaSetControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockReplicaSetControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ReplicaSetControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ReplicaSetControllerMock.EnqueueFunc: method is nil but ReplicaSetController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockReplicaSetControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockReplicaSetControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedReplicaSetController.EnqueueCalls())
func (mock *ReplicaSetControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockReplicaSetControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockReplicaSetControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ReplicaSetControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ReplicaSetControllerMock.EnqueueAfterFunc: method is nil but ReplicaSetController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockReplicaSetControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockReplicaSetControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedReplicaSetController.EnqueueAfterCalls())
func (mock *ReplicaSetControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockReplicaSetControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockReplicaSetControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ReplicaSetControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ReplicaSetControllerMock.GenericFunc: method is nil but ReplicaSetController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockReplicaSetControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockReplicaSetControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedReplicaSetController.GenericCalls())
func (mock *ReplicaSetControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicaSetControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockReplicaSetControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ReplicaSetControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ReplicaSetControllerMock.InformerFunc: method is nil but ReplicaSetController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockReplicaSetControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockReplicaSetControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedReplicaSetController.InformerCalls())
func (mock *ReplicaSetControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicaSetControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockReplicaSetControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ReplicaSetControllerMock) Lister() v11.ReplicaSetLister {
	if mock.ListerFunc == nil {
		panic("ReplicaSetControllerMock.ListerFunc: method is nil but ReplicaSetController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockReplicaSetControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockReplicaSetControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedReplicaSetController.ListerCalls())
func (mock *ReplicaSetControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicaSetControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockReplicaSetControllerMockLister.RUnlock()
	return calls
}

var (
	lockReplicaSetInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockReplicaSetInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockReplicaSetInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockReplicaSetInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockReplicaSetInterfaceMockAddFeatureHandler                sync.RWMutex
	lockReplicaSetInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockReplicaSetInterfaceMockAddHandler                       sync.RWMutex
	lockReplicaSetInterfaceMockAddLifecycle                     sync.RWMutex
	lockReplicaSetInterfaceMockController                       sync.RWMutex
	lockReplicaSetInterfaceMockCreate                           sync.RWMutex
	lockReplicaSetInterfaceMockDelete                           sync.RWMutex
	lockReplicaSetInterfaceMockDeleteCollection                 sync.RWMutex
	lockReplicaSetInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockReplicaSetInterfaceMockGet                              sync.RWMutex
	lockReplicaSetInterfaceMockGetNamespaced                    sync.RWMutex
	lockReplicaSetInterfaceMockList                             sync.RWMutex
	lockReplicaSetInterfaceMockListNamespaced                   sync.RWMutex
	lockReplicaSetInterfaceMockObjectClient                     sync.RWMutex
	lockReplicaSetInterfaceMockUpdate                           sync.RWMutex
	lockReplicaSetInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ReplicaSetInterfaceMock does implement v11.ReplicaSetInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicaSetInterface = &ReplicaSetInterfaceMock{}

// ReplicaSetInterfaceMock is a mock implementation of v11.ReplicaSetInterface.
//
//	    func TestSomethingThatUsesReplicaSetInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.ReplicaSetInterface
//	        mockedReplicaSetInterface := &ReplicaSetInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ReplicaSetLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ReplicaSetLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ReplicaSetLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ReplicaSetHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ReplicaSetLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.ReplicaSetController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.ReplicaSet) (*v1.ReplicaSet, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.ReplicaSet, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ReplicaSet, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.ReplicaSetList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ReplicaSetList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.ReplicaSet) (*v1.ReplicaSet, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedReplicaSetInterface in code that requires v11.ReplicaSetInterface
//	        // and then make assertions.
//
//	    }
type ReplicaSetInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ReplicaSetHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ReplicaSetLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ReplicaSetHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ReplicaSetLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicaSetHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ReplicaSetLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ReplicaSetHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ReplicaSetLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ReplicaSetController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ReplicaSet) (*v1.ReplicaSet, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ReplicaSet, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ReplicaSet, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ReplicaSetList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ReplicaSetList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ReplicaSet) (*v1.ReplicaSet, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ReplicaSetHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicaSetLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ReplicaSetHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicaSetLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ReplicaSetHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicaSetLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ReplicaSetHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicaSetLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ReplicaSet
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ReplicaSet
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ReplicaSetInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ReplicaSetHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ReplicaSetInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ReplicaSetInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ReplicaSetHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockReplicaSetInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockReplicaSetInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ReplicaSetInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockReplicaSetInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ReplicaSetInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ReplicaSetLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ReplicaSetInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ReplicaSetInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicaSetLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockReplicaSetInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockReplicaSetInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ReplicaSetInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ReplicaSetLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicaSetLifecycle
	}
	lockReplicaSetInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockReplicaSetInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ReplicaSetInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ReplicaSetHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ReplicaSetInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ReplicaSetInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ReplicaSetHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockReplicaSetInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockReplicaSetInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddClusterScopedHandlerCalls())
func (mock *ReplicaSetInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockReplicaSetInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ReplicaSetInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ReplicaSetLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ReplicaSetInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ReplicaSetInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicaSetLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockReplicaSetInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockReplicaSetInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddClusterScopedLifecycleCalls())
func (mock *ReplicaSetInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ReplicaSetLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicaSetLifecycle
	}
	lockReplicaSetInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockReplicaSetInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ReplicaSetInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicaSetHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ReplicaSetInterfaceMock.AddFeatureHandlerFunc: method is nil but ReplicaSetInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicaSetHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockReplicaSetInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockReplicaSetInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddFeatureHandlerCalls())
func (mock *ReplicaSetInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockReplicaSetInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ReplicaSetInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ReplicaSetLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ReplicaSetInterfaceMock.AddFeatureLifecycleFunc: method is nil but ReplicaSetInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ReplicaSetLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockReplicaSetInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockReplicaSetInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddFeatureLifecycleCalls())
func (mock *ReplicaSetInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ReplicaSetLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ReplicaSetLifecycle
	}
	lockReplicaSetInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockReplicaSetInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ReplicaSetInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ReplicaSetHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ReplicaSetInterfaceMock.AddHandlerFunc: method is nil but ReplicaSetInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ReplicaSetHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockReplicaSetInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockReplicaSetInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddHandlerCalls())
func (mock *ReplicaSetInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ReplicaSetHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ReplicaSetHandlerFunc
	}
	lockReplicaSetInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockReplicaSetInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ReplicaSetInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ReplicaSetLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ReplicaSetInterfaceMock.AddLifecycleFunc: method is nil but ReplicaSetInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ReplicaSetLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockReplicaSetInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockReplicaSetInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedReplicaSetInterface.AddLifecycleCalls())
func (mock *ReplicaSetInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ReplicaSetLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ReplicaSetLifecycle
	}
	lockReplicaSetInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockReplicaSetInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ReplicaSetInterfaceMock) Controller() v11.ReplicaSetController {
	if mock.ControllerFunc == nil {
		panic("ReplicaSetInterfaceMock.ControllerFunc: method is nil but ReplicaSetInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockReplicaSetInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockReplicaSetInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedReplicaSetInterface.ControllerCalls())
func (mock *ReplicaSetInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicaSetInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockReplicaSetInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ReplicaSetInterfaceMock) Create(in1 *v1.ReplicaSet) (*v1.ReplicaSet, error) {
	if mock.CreateFunc == nil {
		panic("ReplicaSetInterfaceMock.CreateFunc: method is nil but ReplicaSetInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ReplicaSet
	}{
		In1: in1,
	}
	lockReplicaSetInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockReplicaSetInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedReplicaSetInterface.CreateCalls())
func (mock *ReplicaSetInterfaceMock) CreateCalls() []struct {
	In1 *v1.ReplicaSet
} {
	var calls []struct {
		In1 *v1.ReplicaSet
	}
	lockReplicaSetInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockReplicaSetInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ReplicaSetInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ReplicaSetInterfaceMock.DeleteFunc: method is nil but ReplicaSetInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockReplicaSetInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockReplicaSetInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedReplicaSetInterface.DeleteCalls())
func (mock *ReplicaSetInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockReplicaSetInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockReplicaSetInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ReplicaSetInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ReplicaSetInterfaceMock.DeleteCollectionFunc: method is nil but ReplicaSetInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockReplicaSetInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockReplicaSetInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedReplicaSetInterface.DeleteCollectionCalls())
func (mock *ReplicaSetInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockReplicaSetInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockReplicaSetInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ReplicaSetInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ReplicaSetInterfaceMock.DeleteNamespacedFunc: method is nil but ReplicaSetInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockReplicaSetInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockReplicaSetInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedReplicaSetInterface.DeleteNamespacedCalls())
func (mock *ReplicaSetInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockReplicaSetInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockReplicaSetInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ReplicaSetInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ReplicaSet, error) {
	if mock.GetFunc == nil {
		panic("ReplicaSetInterfaceMock.GetFunc: method is nil but ReplicaSetInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockReplicaSetInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockReplicaSetInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedReplicaSetInterface.GetCalls())
func (mock *ReplicaSetInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockReplicaSetInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockReplicaSetInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ReplicaSetInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ReplicaSet, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ReplicaSetInterfaceMock.GetNamespacedFunc: method is nil but ReplicaSetInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockReplicaSetInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockReplicaSetInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedReplicaSetInterface.GetNamespacedCalls())
func (mock *ReplicaSetInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockReplicaSetInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockReplicaSetInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ReplicaSetInterfaceMock) List(opts metav1.ListOptions) (*v1.ReplicaSetList, error) {
	if mock.ListFunc == nil {
		panic("ReplicaSetInterfaceMock.ListFunc: method is nil but ReplicaSetInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockReplicaSetInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockReplicaSetInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedReplicaSetInterface.ListCalls())
func (mock *ReplicaSetInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockReplicaSetInterfaceMockList.RLock()
	calls = mock.calls.List
	lockReplicaSetInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ReplicaSetInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ReplicaSetList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ReplicaSetInterfaceMock.ListNamespacedFunc: method is nil but ReplicaSetInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockReplicaSetInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockReplicaSetInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedReplicaSetInterface.ListNamespacedCalls())
func (mock *ReplicaSetInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockReplicaSetInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockReplicaSetInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ReplicaSetInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ReplicaSetInterfaceMock.ObjectClientFunc: method is nil but ReplicaSetInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockReplicaSetInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockReplicaSetInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedReplicaSetInterface.ObjectClientCalls())
func (mock *ReplicaSetInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicaSetInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockReplicaSetInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ReplicaSetInterfaceMock) Update(in1 *v1.ReplicaSet) (*v1.ReplicaSet, error) {
	if mock.UpdateFunc == nil {
		panic("ReplicaSetInterfaceMock.UpdateFunc: method is nil but ReplicaSetInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ReplicaSet
	}{
		In1: in1,
	}
	lockReplicaSetInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockReplicaSetInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedReplicaSetInterface.UpdateCalls())
func (mock *ReplicaSetInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ReplicaSet
} {
	var calls []struct {
		In1 *v1.ReplicaSet
	}
	lockReplicaSetInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockReplicaSetInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ReplicaSetInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ReplicaSetInterfaceMock.WatchFunc: method is nil but ReplicaSetInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockReplicaSetInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockReplicaSetInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedReplicaSetInterface.WatchCalls())
func (mock *ReplicaSetInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockReplicaSetInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockReplicaSetInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockReplicaSetsGetterMockReplicaSets sync.RWMutex
)

// Ensure, that ReplicaSetsGetterMock does implement v11.ReplicaSetsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicaSetsGetter = &ReplicaSetsGetterMock{}

// ReplicaSetsGetterMock is a mock implementation of v11.ReplicaSetsGetter.
//
//	    func TestSomethingThatUsesReplicaSetsGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.ReplicaSetsGetter
//	        mockedReplicaSetsGetter := &ReplicaSetsGetterMock{
//	            ReplicaSetsFunc: func(namespace string) v11.ReplicaSetInterface {
//		               panic("mock out the ReplicaSets method")
//	            },
//	        }
//
//	        // use mockedReplicaSetsGetter in code that requires v11.ReplicaSetsGetter
//	        // and then make assertions.
//
//	    }
type ReplicaSetsGetterMock struct {
	// ReplicaSetsFunc mocks the ReplicaSets method.
	ReplicaSetsFunc func(namespace string) v11.ReplicaSetInterface

	// calls tracks calls to the methods.
	calls struct {
		// ReplicaSets holds details about calls to the ReplicaSets method.
		ReplicaSets []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ReplicaSets calls ReplicaSetsFunc.
func (mock *ReplicaSetsGetterMock) ReplicaSets(namespace string) v11.ReplicaSetInterface {
	if mock.ReplicaSetsFunc == nil {
		panic("ReplicaSetsGetterMock.ReplicaSetsFunc: method is nil but ReplicaSetsGetter.ReplicaSets was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockReplicaSetsGetterMockReplicaSets.Lock()
	mock.calls.ReplicaSets = append(mock.calls.ReplicaSets, callInfo)
	lockReplicaSetsGetterMockReplicaSets.Unlock()
	return mock.ReplicaSetsFunc(namespace)
}

// ReplicaSetsCalls gets all the calls that were made to ReplicaSets.
// Check the length with:
//
//	len(mockedReplicaSetsGetter.ReplicaSetsCalls())
func (mock *ReplicaSetsGetterMock) ReplicaSetsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockReplicaSetsGetterMockReplicaSets.RLock()
	calls = mock.calls.ReplicaSets
	lockReplicaSetsGetterMockReplicaSets.RUnlock()
	return calls
}
