// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v21 "github.com/rancher/rancher/pkg/generated/norman/autoscaling/v2"
	v2 "k8s.io/api/autoscaling/v2"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockHorizontalPodAutoscalerListerMockGet  sync.RWMutex
	lockHorizontalPodAutoscalerListerMockList sync.RWMutex
)

// Ensure, that HorizontalPodAutoscalerListerMock does implement v21.HorizontalPodAutoscalerLister.
// If this is not the case, regenerate this file with moq.
var _ v21.HorizontalPodAutoscalerLister = &HorizontalPodAutoscalerListerMock{}

// HorizontalPodAutoscalerListerMock is a mock implementation of v21.HorizontalPodAutoscalerLister.
//
//	    func TestSomethingThatUsesHorizontalPodAutoscalerLister(t *testing.T) {
//
//	        // make and configure a mocked v21.HorizontalPodAutoscalerLister
//	        mockedHorizontalPodAutoscalerLister := &HorizontalPodAutoscalerListerMock{
//	            GetFunc: func(namespace string, name string) (*v2.HorizontalPodAutoscaler, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v2.HorizontalPodAutoscaler, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedHorizontalPodAutoscalerLister in code that requires v21.HorizontalPodAutoscalerLister
//	        // and then make assertions.
//
//	    }
type HorizontalPodAutoscalerListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v2.HorizontalPodAutoscaler, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v2.HorizontalPodAutoscaler, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *HorizontalPodAutoscalerListerMock) Get(namespace string, name string) (*v2.HorizontalPodAutoscaler, error) {
	if mock.GetFunc == nil {
		panic("HorizontalPodAutoscalerListerMock.GetFunc: method is nil but HorizontalPodAutoscalerLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockHorizontalPodAutoscalerListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockHorizontalPodAutoscalerListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerLister.GetCalls())
func (mock *HorizontalPodAutoscalerListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockHorizontalPodAutoscalerListerMockGet.RLock()
	calls = mock.calls.Get
	lockHorizontalPodAutoscalerListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *HorizontalPodAutoscalerListerMock) List(namespace string, selector labels.Selector) ([]*v2.HorizontalPodAutoscaler, error) {
	if mock.ListFunc == nil {
		panic("HorizontalPodAutoscalerListerMock.ListFunc: method is nil but HorizontalPodAutoscalerLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockHorizontalPodAutoscalerListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockHorizontalPodAutoscalerListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerLister.ListCalls())
func (mock *HorizontalPodAutoscalerListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockHorizontalPodAutoscalerListerMockList.RLock()
	calls = mock.calls.List
	lockHorizontalPodAutoscalerListerMockList.RUnlock()
	return calls
}

var (
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedHandler        sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockAddFeatureHandler              sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockAddHandler                     sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockEnqueue                        sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockEnqueueAfter                   sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockGeneric                        sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockInformer                       sync.RWMutex
	lockHorizontalPodAutoscalerControllerMockLister                         sync.RWMutex
)

// Ensure, that HorizontalPodAutoscalerControllerMock does implement v21.HorizontalPodAutoscalerController.
// If this is not the case, regenerate this file with moq.
var _ v21.HorizontalPodAutoscalerController = &HorizontalPodAutoscalerControllerMock{}

// HorizontalPodAutoscalerControllerMock is a mock implementation of v21.HorizontalPodAutoscalerController.
//
//	    func TestSomethingThatUsesHorizontalPodAutoscalerController(t *testing.T) {
//
//	        // make and configure a mocked v21.HorizontalPodAutoscalerController
//	        mockedHorizontalPodAutoscalerController := &HorizontalPodAutoscalerControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v21.HorizontalPodAutoscalerLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedHorizontalPodAutoscalerController in code that requires v21.HorizontalPodAutoscalerController
//	        // and then make assertions.
//
//	    }
type HorizontalPodAutoscalerControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v21.HorizontalPodAutoscalerHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v21.HorizontalPodAutoscalerHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v21.HorizontalPodAutoscalerHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v21.HorizontalPodAutoscalerLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v21.HorizontalPodAutoscalerHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *HorizontalPodAutoscalerControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but HorizontalPodAutoscalerController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.AddClusterScopedFeatureHandlerCalls())
func (mock *HorizontalPodAutoscalerControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *HorizontalPodAutoscalerControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.AddClusterScopedHandlerFunc: method is nil but HorizontalPodAutoscalerController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.AddClusterScopedHandlerCalls())
func (mock *HorizontalPodAutoscalerControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockHorizontalPodAutoscalerControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *HorizontalPodAutoscalerControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.AddFeatureHandlerFunc: method is nil but HorizontalPodAutoscalerController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockHorizontalPodAutoscalerControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockHorizontalPodAutoscalerControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.AddFeatureHandlerCalls())
func (mock *HorizontalPodAutoscalerControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockHorizontalPodAutoscalerControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *HorizontalPodAutoscalerControllerMock) AddHandler(ctx context.Context, name string, handler v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.AddHandlerFunc: method is nil but HorizontalPodAutoscalerController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockHorizontalPodAutoscalerControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockHorizontalPodAutoscalerControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.AddHandlerCalls())
func (mock *HorizontalPodAutoscalerControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockHorizontalPodAutoscalerControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *HorizontalPodAutoscalerControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.EnqueueFunc: method is nil but HorizontalPodAutoscalerController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockHorizontalPodAutoscalerControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockHorizontalPodAutoscalerControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.EnqueueCalls())
func (mock *HorizontalPodAutoscalerControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockHorizontalPodAutoscalerControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockHorizontalPodAutoscalerControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *HorizontalPodAutoscalerControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.EnqueueAfterFunc: method is nil but HorizontalPodAutoscalerController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockHorizontalPodAutoscalerControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockHorizontalPodAutoscalerControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.EnqueueAfterCalls())
func (mock *HorizontalPodAutoscalerControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockHorizontalPodAutoscalerControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockHorizontalPodAutoscalerControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *HorizontalPodAutoscalerControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.GenericFunc: method is nil but HorizontalPodAutoscalerController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockHorizontalPodAutoscalerControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockHorizontalPodAutoscalerControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.GenericCalls())
func (mock *HorizontalPodAutoscalerControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockHorizontalPodAutoscalerControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockHorizontalPodAutoscalerControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *HorizontalPodAutoscalerControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.InformerFunc: method is nil but HorizontalPodAutoscalerController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockHorizontalPodAutoscalerControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockHorizontalPodAutoscalerControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.InformerCalls())
func (mock *HorizontalPodAutoscalerControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockHorizontalPodAutoscalerControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockHorizontalPodAutoscalerControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *HorizontalPodAutoscalerControllerMock) Lister() v21.HorizontalPodAutoscalerLister {
	if mock.ListerFunc == nil {
		panic("HorizontalPodAutoscalerControllerMock.ListerFunc: method is nil but HorizontalPodAutoscalerController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockHorizontalPodAutoscalerControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockHorizontalPodAutoscalerControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerController.ListerCalls())
func (mock *HorizontalPodAutoscalerControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockHorizontalPodAutoscalerControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockHorizontalPodAutoscalerControllerMockLister.RUnlock()
	return calls
}

var (
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureHandler                sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddHandler                       sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockAddLifecycle                     sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockController                       sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockCreate                           sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockDelete                           sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockDeleteCollection                 sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockGet                              sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockGetNamespaced                    sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockList                             sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockListNamespaced                   sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockObjectClient                     sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockUpdate                           sync.RWMutex
	lockHorizontalPodAutoscalerInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that HorizontalPodAutoscalerInterfaceMock does implement v21.HorizontalPodAutoscalerInterface.
// If this is not the case, regenerate this file with moq.
var _ v21.HorizontalPodAutoscalerInterface = &HorizontalPodAutoscalerInterfaceMock{}

// HorizontalPodAutoscalerInterfaceMock is a mock implementation of v21.HorizontalPodAutoscalerInterface.
//
//	    func TestSomethingThatUsesHorizontalPodAutoscalerInterface(t *testing.T) {
//
//	        // make and configure a mocked v21.HorizontalPodAutoscalerInterface
//	        mockedHorizontalPodAutoscalerInterface := &HorizontalPodAutoscalerInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v21.HorizontalPodAutoscalerLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v21.HorizontalPodAutoscalerLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v21.HorizontalPodAutoscalerLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v21.HorizontalPodAutoscalerLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v21.HorizontalPodAutoscalerController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v2.HorizontalPodAutoscaler) (*v2.HorizontalPodAutoscaler, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v2.HorizontalPodAutoscaler, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v2.HorizontalPodAutoscaler, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v2.HorizontalPodAutoscalerList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v2.HorizontalPodAutoscalerList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v2.HorizontalPodAutoscaler) (*v2.HorizontalPodAutoscaler, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedHorizontalPodAutoscalerInterface in code that requires v21.HorizontalPodAutoscalerInterface
//	        // and then make assertions.
//
//	    }
type HorizontalPodAutoscalerInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v21.HorizontalPodAutoscalerLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v21.HorizontalPodAutoscalerLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v21.HorizontalPodAutoscalerLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v21.HorizontalPodAutoscalerLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v21.HorizontalPodAutoscalerController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v2.HorizontalPodAutoscaler) (*v2.HorizontalPodAutoscaler, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v2.HorizontalPodAutoscaler, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v2.HorizontalPodAutoscaler, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v2.HorizontalPodAutoscalerList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v2.HorizontalPodAutoscalerList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v2.HorizontalPodAutoscaler) (*v2.HorizontalPodAutoscaler, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v21.HorizontalPodAutoscalerLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v21.HorizontalPodAutoscalerLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v21.HorizontalPodAutoscalerLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v21.HorizontalPodAutoscalerHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v21.HorizontalPodAutoscalerLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v2.HorizontalPodAutoscaler
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v2.HorizontalPodAutoscaler
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but HorizontalPodAutoscalerInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v21.HorizontalPodAutoscalerLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but HorizontalPodAutoscalerInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v21.HorizontalPodAutoscalerLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v21.HorizontalPodAutoscalerLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v21.HorizontalPodAutoscalerLifecycle
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddClusterScopedHandlerFunc: method is nil but HorizontalPodAutoscalerInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddClusterScopedHandlerCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v21.HorizontalPodAutoscalerLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but HorizontalPodAutoscalerInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v21.HorizontalPodAutoscalerLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddClusterScopedLifecycleCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v21.HorizontalPodAutoscalerLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v21.HorizontalPodAutoscalerLifecycle
	}
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockHorizontalPodAutoscalerInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddFeatureHandlerFunc: method is nil but HorizontalPodAutoscalerInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddFeatureHandlerCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v21.HorizontalPodAutoscalerLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddFeatureLifecycleFunc: method is nil but HorizontalPodAutoscalerInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v21.HorizontalPodAutoscalerLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddFeatureLifecycleCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v21.HorizontalPodAutoscalerLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v21.HorizontalPodAutoscalerLifecycle
	}
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockHorizontalPodAutoscalerInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v21.HorizontalPodAutoscalerHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddHandlerFunc: method is nil but HorizontalPodAutoscalerInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v21.HorizontalPodAutoscalerHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddHandlerCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v21.HorizontalPodAutoscalerHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v21.HorizontalPodAutoscalerHandlerFunc
	}
	lockHorizontalPodAutoscalerInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockHorizontalPodAutoscalerInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v21.HorizontalPodAutoscalerLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.AddLifecycleFunc: method is nil but HorizontalPodAutoscalerInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v21.HorizontalPodAutoscalerLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockHorizontalPodAutoscalerInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.AddLifecycleCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v21.HorizontalPodAutoscalerLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v21.HorizontalPodAutoscalerLifecycle
	}
	lockHorizontalPodAutoscalerInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockHorizontalPodAutoscalerInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) Controller() v21.HorizontalPodAutoscalerController {
	if mock.ControllerFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.ControllerFunc: method is nil but HorizontalPodAutoscalerInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockHorizontalPodAutoscalerInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.ControllerCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockHorizontalPodAutoscalerInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockHorizontalPodAutoscalerInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) Create(in1 *v2.HorizontalPodAutoscaler) (*v2.HorizontalPodAutoscaler, error) {
	if mock.CreateFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.CreateFunc: method is nil but HorizontalPodAutoscalerInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v2.HorizontalPodAutoscaler
	}{
		In1: in1,
	}
	lockHorizontalPodAutoscalerInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.CreateCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) CreateCalls() []struct {
	In1 *v2.HorizontalPodAutoscaler
} {
	var calls []struct {
		In1 *v2.HorizontalPodAutoscaler
	}
	lockHorizontalPodAutoscalerInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockHorizontalPodAutoscalerInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.DeleteFunc: method is nil but HorizontalPodAutoscalerInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockHorizontalPodAutoscalerInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.DeleteCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockHorizontalPodAutoscalerInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.DeleteCollectionFunc: method is nil but HorizontalPodAutoscalerInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockHorizontalPodAutoscalerInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.DeleteCollectionCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockHorizontalPodAutoscalerInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.DeleteNamespacedFunc: method is nil but HorizontalPodAutoscalerInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockHorizontalPodAutoscalerInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.DeleteNamespacedCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockHorizontalPodAutoscalerInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) Get(name string, opts metav1.GetOptions) (*v2.HorizontalPodAutoscaler, error) {
	if mock.GetFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.GetFunc: method is nil but HorizontalPodAutoscalerInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockHorizontalPodAutoscalerInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.GetCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockHorizontalPodAutoscalerInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v2.HorizontalPodAutoscaler, error) {
	if mock.GetNamespacedFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.GetNamespacedFunc: method is nil but HorizontalPodAutoscalerInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockHorizontalPodAutoscalerInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.GetNamespacedCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockHorizontalPodAutoscalerInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) List(opts metav1.ListOptions) (*v2.HorizontalPodAutoscalerList, error) {
	if mock.ListFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.ListFunc: method is nil but HorizontalPodAutoscalerInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockHorizontalPodAutoscalerInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.ListCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockList.RLock()
	calls = mock.calls.List
	lockHorizontalPodAutoscalerInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v2.HorizontalPodAutoscalerList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.ListNamespacedFunc: method is nil but HorizontalPodAutoscalerInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockHorizontalPodAutoscalerInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.ListNamespacedCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockHorizontalPodAutoscalerInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.ObjectClientFunc: method is nil but HorizontalPodAutoscalerInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockHorizontalPodAutoscalerInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.ObjectClientCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockHorizontalPodAutoscalerInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockHorizontalPodAutoscalerInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) Update(in1 *v2.HorizontalPodAutoscaler) (*v2.HorizontalPodAutoscaler, error) {
	if mock.UpdateFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.UpdateFunc: method is nil but HorizontalPodAutoscalerInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v2.HorizontalPodAutoscaler
	}{
		In1: in1,
	}
	lockHorizontalPodAutoscalerInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.UpdateCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) UpdateCalls() []struct {
	In1 *v2.HorizontalPodAutoscaler
} {
	var calls []struct {
		In1 *v2.HorizontalPodAutoscaler
	}
	lockHorizontalPodAutoscalerInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockHorizontalPodAutoscalerInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *HorizontalPodAutoscalerInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("HorizontalPodAutoscalerInterfaceMock.WatchFunc: method is nil but HorizontalPodAutoscalerInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockHorizontalPodAutoscalerInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockHorizontalPodAutoscalerInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalerInterface.WatchCalls())
func (mock *HorizontalPodAutoscalerInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockHorizontalPodAutoscalerInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockHorizontalPodAutoscalerInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockHorizontalPodAutoscalersGetterMockHorizontalPodAutoscalers sync.RWMutex
)

// Ensure, that HorizontalPodAutoscalersGetterMock does implement v21.HorizontalPodAutoscalersGetter.
// If this is not the case, regenerate this file with moq.
var _ v21.HorizontalPodAutoscalersGetter = &HorizontalPodAutoscalersGetterMock{}

// HorizontalPodAutoscalersGetterMock is a mock implementation of v21.HorizontalPodAutoscalersGetter.
//
//	    func TestSomethingThatUsesHorizontalPodAutoscalersGetter(t *testing.T) {
//
//	        // make and configure a mocked v21.HorizontalPodAutoscalersGetter
//	        mockedHorizontalPodAutoscalersGetter := &HorizontalPodAutoscalersGetterMock{
//	            HorizontalPodAutoscalersFunc: func(namespace string) v21.HorizontalPodAutoscalerInterface {
//		               panic("mock out the HorizontalPodAutoscalers method")
//	            },
//	        }
//
//	        // use mockedHorizontalPodAutoscalersGetter in code that requires v21.HorizontalPodAutoscalersGetter
//	        // and then make assertions.
//
//	    }
type HorizontalPodAutoscalersGetterMock struct {
	// HorizontalPodAutoscalersFunc mocks the HorizontalPodAutoscalers method.
	HorizontalPodAutoscalersFunc func(namespace string) v21.HorizontalPodAutoscalerInterface

	// calls tracks calls to the methods.
	calls struct {
		// HorizontalPodAutoscalers holds details about calls to the HorizontalPodAutoscalers method.
		HorizontalPodAutoscalers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// HorizontalPodAutoscalers calls HorizontalPodAutoscalersFunc.
func (mock *HorizontalPodAutoscalersGetterMock) HorizontalPodAutoscalers(namespace string) v21.HorizontalPodAutoscalerInterface {
	if mock.HorizontalPodAutoscalersFunc == nil {
		panic("HorizontalPodAutoscalersGetterMock.HorizontalPodAutoscalersFunc: method is nil but HorizontalPodAutoscalersGetter.HorizontalPodAutoscalers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockHorizontalPodAutoscalersGetterMockHorizontalPodAutoscalers.Lock()
	mock.calls.HorizontalPodAutoscalers = append(mock.calls.HorizontalPodAutoscalers, callInfo)
	lockHorizontalPodAutoscalersGetterMockHorizontalPodAutoscalers.Unlock()
	return mock.HorizontalPodAutoscalersFunc(namespace)
}

// HorizontalPodAutoscalersCalls gets all the calls that were made to HorizontalPodAutoscalers.
// Check the length with:
//
//	len(mockedHorizontalPodAutoscalersGetter.HorizontalPodAutoscalersCalls())
func (mock *HorizontalPodAutoscalersGetterMock) HorizontalPodAutoscalersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockHorizontalPodAutoscalersGetterMockHorizontalPodAutoscalers.RLock()
	calls = mock.calls.HorizontalPodAutoscalers
	lockHorizontalPodAutoscalersGetterMockHorizontalPodAutoscalers.RUnlock()
	return calls
}
