// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/cluster.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/cluster.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterAuthTokenListerMockGet  sync.RWMutex
	lockClusterAuthTokenListerMockList sync.RWMutex
)

// Ensure, that ClusterAuthTokenListerMock does implement v31.ClusterAuthTokenLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAuthTokenLister = &ClusterAuthTokenListerMock{}

// ClusterAuthTokenListerMock is a mock implementation of v31.ClusterAuthTokenLister.
//
//	    func TestSomethingThatUsesClusterAuthTokenLister(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterAuthTokenLister
//	        mockedClusterAuthTokenLister := &ClusterAuthTokenListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.ClusterAuthToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterAuthToken, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedClusterAuthTokenLister in code that requires v31.ClusterAuthTokenLister
//	        // and then make assertions.
//
//	    }
type ClusterAuthTokenListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterAuthToken, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterAuthToken, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterAuthTokenListerMock) Get(namespace string, name string) (*v3.ClusterAuthToken, error) {
	if mock.GetFunc == nil {
		panic("ClusterAuthTokenListerMock.GetFunc: method is nil but ClusterAuthTokenLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterAuthTokenListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterAuthTokenListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterAuthTokenLister.GetCalls())
func (mock *ClusterAuthTokenListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterAuthTokenListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterAuthTokenListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterAuthTokenListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterAuthToken, error) {
	if mock.ListFunc == nil {
		panic("ClusterAuthTokenListerMock.ListFunc: method is nil but ClusterAuthTokenLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterAuthTokenListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterAuthTokenListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterAuthTokenLister.ListCalls())
func (mock *ClusterAuthTokenListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterAuthTokenListerMockList.RLock()
	calls = mock.calls.List
	lockClusterAuthTokenListerMockList.RUnlock()
	return calls
}

var (
	lockClusterAuthTokenControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterAuthTokenControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterAuthTokenControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterAuthTokenControllerMockAddHandler                     sync.RWMutex
	lockClusterAuthTokenControllerMockEnqueue                        sync.RWMutex
	lockClusterAuthTokenControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterAuthTokenControllerMockGeneric                        sync.RWMutex
	lockClusterAuthTokenControllerMockInformer                       sync.RWMutex
	lockClusterAuthTokenControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterAuthTokenControllerMock does implement v31.ClusterAuthTokenController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAuthTokenController = &ClusterAuthTokenControllerMock{}

// ClusterAuthTokenControllerMock is a mock implementation of v31.ClusterAuthTokenController.
//
//	    func TestSomethingThatUsesClusterAuthTokenController(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterAuthTokenController
//	        mockedClusterAuthTokenController := &ClusterAuthTokenControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.ClusterAuthTokenLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedClusterAuthTokenController in code that requires v31.ClusterAuthTokenController
//	        // and then make assertions.
//
//	    }
type ClusterAuthTokenControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAuthTokenHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterAuthTokenHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterAuthTokenHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterAuthTokenLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterAuthTokenHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterAuthTokenHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAuthTokenHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterAuthTokenHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterAuthTokenControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterAuthTokenControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterAuthTokenController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterAuthTokenControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterAuthTokenControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterAuthTokenControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterAuthTokenControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterAuthTokenControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterAuthTokenControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterAuthTokenController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterAuthTokenControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterAuthTokenControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.AddClusterScopedHandlerCalls())
func (mock *ClusterAuthTokenControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterAuthTokenControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterAuthTokenControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterAuthTokenControllerMock.AddFeatureHandlerFunc: method is nil but ClusterAuthTokenController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterAuthTokenControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterAuthTokenControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.AddFeatureHandlerCalls())
func (mock *ClusterAuthTokenControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterAuthTokenControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterAuthTokenControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterAuthTokenControllerMock.AddHandlerFunc: method is nil but ClusterAuthTokenController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterAuthTokenControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterAuthTokenControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.AddHandlerCalls())
func (mock *ClusterAuthTokenControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterAuthTokenControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterAuthTokenControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterAuthTokenControllerMock.EnqueueFunc: method is nil but ClusterAuthTokenController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterAuthTokenControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterAuthTokenControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.EnqueueCalls())
func (mock *ClusterAuthTokenControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterAuthTokenControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterAuthTokenControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterAuthTokenControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterAuthTokenControllerMock.EnqueueAfterFunc: method is nil but ClusterAuthTokenController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterAuthTokenControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterAuthTokenControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.EnqueueAfterCalls())
func (mock *ClusterAuthTokenControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterAuthTokenControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterAuthTokenControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterAuthTokenControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterAuthTokenControllerMock.GenericFunc: method is nil but ClusterAuthTokenController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAuthTokenControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterAuthTokenControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.GenericCalls())
func (mock *ClusterAuthTokenControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAuthTokenControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterAuthTokenControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterAuthTokenControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterAuthTokenControllerMock.InformerFunc: method is nil but ClusterAuthTokenController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAuthTokenControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterAuthTokenControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.InformerCalls())
func (mock *ClusterAuthTokenControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAuthTokenControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterAuthTokenControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterAuthTokenControllerMock) Lister() v31.ClusterAuthTokenLister {
	if mock.ListerFunc == nil {
		panic("ClusterAuthTokenControllerMock.ListerFunc: method is nil but ClusterAuthTokenController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAuthTokenControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterAuthTokenControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedClusterAuthTokenController.ListerCalls())
func (mock *ClusterAuthTokenControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAuthTokenControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterAuthTokenControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddHandler                       sync.RWMutex
	lockClusterAuthTokenInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterAuthTokenInterfaceMockController                       sync.RWMutex
	lockClusterAuthTokenInterfaceMockCreate                           sync.RWMutex
	lockClusterAuthTokenInterfaceMockDelete                           sync.RWMutex
	lockClusterAuthTokenInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterAuthTokenInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterAuthTokenInterfaceMockGet                              sync.RWMutex
	lockClusterAuthTokenInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterAuthTokenInterfaceMockList                             sync.RWMutex
	lockClusterAuthTokenInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterAuthTokenInterfaceMockObjectClient                     sync.RWMutex
	lockClusterAuthTokenInterfaceMockUpdate                           sync.RWMutex
	lockClusterAuthTokenInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterAuthTokenInterfaceMock does implement v31.ClusterAuthTokenInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAuthTokenInterface = &ClusterAuthTokenInterfaceMock{}

// ClusterAuthTokenInterfaceMock is a mock implementation of v31.ClusterAuthTokenInterface.
//
//	    func TestSomethingThatUsesClusterAuthTokenInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterAuthTokenInterface
//	        mockedClusterAuthTokenInterface := &ClusterAuthTokenInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAuthTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAuthTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAuthTokenLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterAuthTokenLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.ClusterAuthTokenController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.ClusterAuthToken) (*v3.ClusterAuthToken, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterAuthToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAuthToken, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.ClusterAuthTokenList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterAuthTokenList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.ClusterAuthToken) (*v3.ClusterAuthToken, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedClusterAuthTokenInterface in code that requires v31.ClusterAuthTokenInterface
//	        // and then make assertions.
//
//	    }
type ClusterAuthTokenInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAuthTokenLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAuthTokenLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAuthTokenLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterAuthTokenLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterAuthTokenController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterAuthToken) (*v3.ClusterAuthToken, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterAuthToken, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAuthToken, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterAuthTokenList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterAuthTokenList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterAuthToken) (*v3.ClusterAuthToken, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterAuthTokenHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAuthTokenLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterAuthTokenHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAuthTokenLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAuthTokenHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAuthTokenLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAuthTokenHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAuthTokenLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterAuthToken
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterAuthToken
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterAuthTokenInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAuthTokenLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterAuthTokenInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAuthTokenLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterAuthTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAuthTokenLifecycle
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterAuthTokenInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterAuthTokenInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterAuthTokenInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterAuthTokenInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAuthTokenLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterAuthTokenInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAuthTokenLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterAuthTokenInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterAuthTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAuthTokenLifecycle
	}
	lockClusterAuthTokenInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterAuthTokenInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterAuthTokenInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterAuthTokenInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterAuthTokenInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddFeatureHandlerCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterAuthTokenInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAuthTokenLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterAuthTokenInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterAuthTokenLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterAuthTokenInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterAuthTokenInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddFeatureLifecycleCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterAuthTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterAuthTokenLifecycle
	}
	lockClusterAuthTokenInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterAuthTokenInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterAuthTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddHandlerFunc: method is nil but ClusterAuthTokenInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterAuthTokenHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterAuthTokenInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterAuthTokenInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddHandlerCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterAuthTokenHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterAuthTokenHandlerFunc
	}
	lockClusterAuthTokenInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterAuthTokenInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterAuthTokenInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterAuthTokenLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.AddLifecycleFunc: method is nil but ClusterAuthTokenInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterAuthTokenLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterAuthTokenInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterAuthTokenInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.AddLifecycleCalls())
func (mock *ClusterAuthTokenInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterAuthTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterAuthTokenLifecycle
	}
	lockClusterAuthTokenInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterAuthTokenInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterAuthTokenInterfaceMock) Controller() v31.ClusterAuthTokenController {
	if mock.ControllerFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.ControllerFunc: method is nil but ClusterAuthTokenInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAuthTokenInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterAuthTokenInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.ControllerCalls())
func (mock *ClusterAuthTokenInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAuthTokenInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterAuthTokenInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterAuthTokenInterfaceMock) Create(in1 *v3.ClusterAuthToken) (*v3.ClusterAuthToken, error) {
	if mock.CreateFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.CreateFunc: method is nil but ClusterAuthTokenInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterAuthToken
	}{
		In1: in1,
	}
	lockClusterAuthTokenInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterAuthTokenInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.CreateCalls())
func (mock *ClusterAuthTokenInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterAuthToken
} {
	var calls []struct {
		In1 *v3.ClusterAuthToken
	}
	lockClusterAuthTokenInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterAuthTokenInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterAuthTokenInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.DeleteFunc: method is nil but ClusterAuthTokenInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterAuthTokenInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterAuthTokenInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.DeleteCalls())
func (mock *ClusterAuthTokenInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterAuthTokenInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterAuthTokenInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterAuthTokenInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.DeleteCollectionFunc: method is nil but ClusterAuthTokenInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterAuthTokenInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterAuthTokenInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.DeleteCollectionCalls())
func (mock *ClusterAuthTokenInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterAuthTokenInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterAuthTokenInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterAuthTokenInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterAuthTokenInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterAuthTokenInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterAuthTokenInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.DeleteNamespacedCalls())
func (mock *ClusterAuthTokenInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterAuthTokenInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterAuthTokenInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterAuthTokenInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterAuthToken, error) {
	if mock.GetFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.GetFunc: method is nil but ClusterAuthTokenInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterAuthTokenInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterAuthTokenInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.GetCalls())
func (mock *ClusterAuthTokenInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterAuthTokenInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterAuthTokenInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterAuthTokenInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAuthToken, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.GetNamespacedFunc: method is nil but ClusterAuthTokenInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterAuthTokenInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterAuthTokenInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.GetNamespacedCalls())
func (mock *ClusterAuthTokenInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterAuthTokenInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterAuthTokenInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterAuthTokenInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterAuthTokenList, error) {
	if mock.ListFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.ListFunc: method is nil but ClusterAuthTokenInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterAuthTokenInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterAuthTokenInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.ListCalls())
func (mock *ClusterAuthTokenInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterAuthTokenInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterAuthTokenInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterAuthTokenInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterAuthTokenList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.ListNamespacedFunc: method is nil but ClusterAuthTokenInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterAuthTokenInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterAuthTokenInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.ListNamespacedCalls())
func (mock *ClusterAuthTokenInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterAuthTokenInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterAuthTokenInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterAuthTokenInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.ObjectClientFunc: method is nil but ClusterAuthTokenInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAuthTokenInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterAuthTokenInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.ObjectClientCalls())
func (mock *ClusterAuthTokenInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAuthTokenInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterAuthTokenInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterAuthTokenInterfaceMock) Update(in1 *v3.ClusterAuthToken) (*v3.ClusterAuthToken, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.UpdateFunc: method is nil but ClusterAuthTokenInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterAuthToken
	}{
		In1: in1,
	}
	lockClusterAuthTokenInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterAuthTokenInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.UpdateCalls())
func (mock *ClusterAuthTokenInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterAuthToken
} {
	var calls []struct {
		In1 *v3.ClusterAuthToken
	}
	lockClusterAuthTokenInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterAuthTokenInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterAuthTokenInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterAuthTokenInterfaceMock.WatchFunc: method is nil but ClusterAuthTokenInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterAuthTokenInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterAuthTokenInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedClusterAuthTokenInterface.WatchCalls())
func (mock *ClusterAuthTokenInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterAuthTokenInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterAuthTokenInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterAuthTokensGetterMockClusterAuthTokens sync.RWMutex
)

// Ensure, that ClusterAuthTokensGetterMock does implement v31.ClusterAuthTokensGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAuthTokensGetter = &ClusterAuthTokensGetterMock{}

// ClusterAuthTokensGetterMock is a mock implementation of v31.ClusterAuthTokensGetter.
//
//	    func TestSomethingThatUsesClusterAuthTokensGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterAuthTokensGetter
//	        mockedClusterAuthTokensGetter := &ClusterAuthTokensGetterMock{
//	            ClusterAuthTokensFunc: func(namespace string) v31.ClusterAuthTokenInterface {
//		               panic("mock out the ClusterAuthTokens method")
//	            },
//	        }
//
//	        // use mockedClusterAuthTokensGetter in code that requires v31.ClusterAuthTokensGetter
//	        // and then make assertions.
//
//	    }
type ClusterAuthTokensGetterMock struct {
	// ClusterAuthTokensFunc mocks the ClusterAuthTokens method.
	ClusterAuthTokensFunc func(namespace string) v31.ClusterAuthTokenInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterAuthTokens holds details about calls to the ClusterAuthTokens method.
		ClusterAuthTokens []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterAuthTokens calls ClusterAuthTokensFunc.
func (mock *ClusterAuthTokensGetterMock) ClusterAuthTokens(namespace string) v31.ClusterAuthTokenInterface {
	if mock.ClusterAuthTokensFunc == nil {
		panic("ClusterAuthTokensGetterMock.ClusterAuthTokensFunc: method is nil but ClusterAuthTokensGetter.ClusterAuthTokens was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterAuthTokensGetterMockClusterAuthTokens.Lock()
	mock.calls.ClusterAuthTokens = append(mock.calls.ClusterAuthTokens, callInfo)
	lockClusterAuthTokensGetterMockClusterAuthTokens.Unlock()
	return mock.ClusterAuthTokensFunc(namespace)
}

// ClusterAuthTokensCalls gets all the calls that were made to ClusterAuthTokens.
// Check the length with:
//
//	len(mockedClusterAuthTokensGetter.ClusterAuthTokensCalls())
func (mock *ClusterAuthTokensGetterMock) ClusterAuthTokensCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterAuthTokensGetterMockClusterAuthTokens.RLock()
	calls = mock.calls.ClusterAuthTokens
	lockClusterAuthTokensGetterMockClusterAuthTokens.RUnlock()
	return calls
}
