// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/cluster.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/cluster.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterUserAttributeListerMockGet  sync.RWMutex
	lockClusterUserAttributeListerMockList sync.RWMutex
)

// Ensure, that ClusterUserAttributeListerMock does implement v31.ClusterUserAttributeLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterUserAttributeLister = &ClusterUserAttributeListerMock{}

// ClusterUserAttributeListerMock is a mock implementation of v31.ClusterUserAttributeLister.
//
//	    func TestSomethingThatUsesClusterUserAttributeLister(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterUserAttributeLister
//	        mockedClusterUserAttributeLister := &ClusterUserAttributeListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.ClusterUserAttribute, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterUserAttribute, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedClusterUserAttributeLister in code that requires v31.ClusterUserAttributeLister
//	        // and then make assertions.
//
//	    }
type ClusterUserAttributeListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterUserAttribute, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterUserAttribute, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterUserAttributeListerMock) Get(namespace string, name string) (*v3.ClusterUserAttribute, error) {
	if mock.GetFunc == nil {
		panic("ClusterUserAttributeListerMock.GetFunc: method is nil but ClusterUserAttributeLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterUserAttributeListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterUserAttributeListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterUserAttributeLister.GetCalls())
func (mock *ClusterUserAttributeListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterUserAttributeListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterUserAttributeListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterUserAttributeListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterUserAttribute, error) {
	if mock.ListFunc == nil {
		panic("ClusterUserAttributeListerMock.ListFunc: method is nil but ClusterUserAttributeLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterUserAttributeListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterUserAttributeListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterUserAttributeLister.ListCalls())
func (mock *ClusterUserAttributeListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterUserAttributeListerMockList.RLock()
	calls = mock.calls.List
	lockClusterUserAttributeListerMockList.RUnlock()
	return calls
}

var (
	lockClusterUserAttributeControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterUserAttributeControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterUserAttributeControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterUserAttributeControllerMockAddHandler                     sync.RWMutex
	lockClusterUserAttributeControllerMockEnqueue                        sync.RWMutex
	lockClusterUserAttributeControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterUserAttributeControllerMockGeneric                        sync.RWMutex
	lockClusterUserAttributeControllerMockInformer                       sync.RWMutex
	lockClusterUserAttributeControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterUserAttributeControllerMock does implement v31.ClusterUserAttributeController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterUserAttributeController = &ClusterUserAttributeControllerMock{}

// ClusterUserAttributeControllerMock is a mock implementation of v31.ClusterUserAttributeController.
//
//	    func TestSomethingThatUsesClusterUserAttributeController(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterUserAttributeController
//	        mockedClusterUserAttributeController := &ClusterUserAttributeControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.ClusterUserAttributeLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedClusterUserAttributeController in code that requires v31.ClusterUserAttributeController
//	        // and then make assertions.
//
//	    }
type ClusterUserAttributeControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterUserAttributeHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterUserAttributeHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterUserAttributeHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterUserAttributeLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterUserAttributeHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterUserAttributeHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterUserAttributeHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterUserAttributeHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterUserAttributeControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterUserAttributeControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterUserAttributeController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterUserAttributeControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterUserAttributeControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterUserAttributeControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterUserAttributeControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterUserAttributeControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterUserAttributeControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterUserAttributeController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterUserAttributeControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterUserAttributeControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.AddClusterScopedHandlerCalls())
func (mock *ClusterUserAttributeControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterUserAttributeControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterUserAttributeControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterUserAttributeControllerMock.AddFeatureHandlerFunc: method is nil but ClusterUserAttributeController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterUserAttributeControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterUserAttributeControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.AddFeatureHandlerCalls())
func (mock *ClusterUserAttributeControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterUserAttributeControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterUserAttributeControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterUserAttributeControllerMock.AddHandlerFunc: method is nil but ClusterUserAttributeController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterUserAttributeControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterUserAttributeControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.AddHandlerCalls())
func (mock *ClusterUserAttributeControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterUserAttributeControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterUserAttributeControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterUserAttributeControllerMock.EnqueueFunc: method is nil but ClusterUserAttributeController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterUserAttributeControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterUserAttributeControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.EnqueueCalls())
func (mock *ClusterUserAttributeControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterUserAttributeControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterUserAttributeControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterUserAttributeControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterUserAttributeControllerMock.EnqueueAfterFunc: method is nil but ClusterUserAttributeController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterUserAttributeControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterUserAttributeControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.EnqueueAfterCalls())
func (mock *ClusterUserAttributeControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterUserAttributeControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterUserAttributeControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterUserAttributeControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterUserAttributeControllerMock.GenericFunc: method is nil but ClusterUserAttributeController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterUserAttributeControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterUserAttributeControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.GenericCalls())
func (mock *ClusterUserAttributeControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterUserAttributeControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterUserAttributeControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterUserAttributeControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterUserAttributeControllerMock.InformerFunc: method is nil but ClusterUserAttributeController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterUserAttributeControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterUserAttributeControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.InformerCalls())
func (mock *ClusterUserAttributeControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterUserAttributeControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterUserAttributeControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterUserAttributeControllerMock) Lister() v31.ClusterUserAttributeLister {
	if mock.ListerFunc == nil {
		panic("ClusterUserAttributeControllerMock.ListerFunc: method is nil but ClusterUserAttributeController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterUserAttributeControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterUserAttributeControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedClusterUserAttributeController.ListerCalls())
func (mock *ClusterUserAttributeControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterUserAttributeControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterUserAttributeControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddHandler                       sync.RWMutex
	lockClusterUserAttributeInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterUserAttributeInterfaceMockController                       sync.RWMutex
	lockClusterUserAttributeInterfaceMockCreate                           sync.RWMutex
	lockClusterUserAttributeInterfaceMockDelete                           sync.RWMutex
	lockClusterUserAttributeInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterUserAttributeInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterUserAttributeInterfaceMockGet                              sync.RWMutex
	lockClusterUserAttributeInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterUserAttributeInterfaceMockList                             sync.RWMutex
	lockClusterUserAttributeInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterUserAttributeInterfaceMockObjectClient                     sync.RWMutex
	lockClusterUserAttributeInterfaceMockUpdate                           sync.RWMutex
	lockClusterUserAttributeInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterUserAttributeInterfaceMock does implement v31.ClusterUserAttributeInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterUserAttributeInterface = &ClusterUserAttributeInterfaceMock{}

// ClusterUserAttributeInterfaceMock is a mock implementation of v31.ClusterUserAttributeInterface.
//
//	    func TestSomethingThatUsesClusterUserAttributeInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterUserAttributeInterface
//	        mockedClusterUserAttributeInterface := &ClusterUserAttributeInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterUserAttributeLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterUserAttributeLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterUserAttributeLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterUserAttributeLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.ClusterUserAttributeController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.ClusterUserAttribute) (*v3.ClusterUserAttribute, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterUserAttribute, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterUserAttribute, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.ClusterUserAttributeList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterUserAttributeList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.ClusterUserAttribute) (*v3.ClusterUserAttribute, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedClusterUserAttributeInterface in code that requires v31.ClusterUserAttributeInterface
//	        // and then make assertions.
//
//	    }
type ClusterUserAttributeInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterUserAttributeLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterUserAttributeLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterUserAttributeLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterUserAttributeLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterUserAttributeController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterUserAttribute) (*v3.ClusterUserAttribute, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterUserAttribute, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterUserAttribute, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterUserAttributeList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterUserAttributeList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterUserAttribute) (*v3.ClusterUserAttribute, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterUserAttributeHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterUserAttributeLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterUserAttributeHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterUserAttributeLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterUserAttributeHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterUserAttributeLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterUserAttributeHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterUserAttributeLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterUserAttribute
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterUserAttribute
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterUserAttributeInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterUserAttributeLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterUserAttributeInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterUserAttributeLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterUserAttributeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterUserAttributeLifecycle
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterUserAttributeInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterUserAttributeInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterUserAttributeInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterUserAttributeInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterUserAttributeLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterUserAttributeInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterUserAttributeLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterUserAttributeInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterUserAttributeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterUserAttributeLifecycle
	}
	lockClusterUserAttributeInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterUserAttributeInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterUserAttributeInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterUserAttributeInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterUserAttributeInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddFeatureHandlerCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterUserAttributeInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterUserAttributeLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterUserAttributeInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterUserAttributeLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterUserAttributeInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterUserAttributeInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddFeatureLifecycleCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterUserAttributeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterUserAttributeLifecycle
	}
	lockClusterUserAttributeInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterUserAttributeInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterUserAttributeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddHandlerFunc: method is nil but ClusterUserAttributeInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterUserAttributeHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterUserAttributeInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterUserAttributeInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddHandlerCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterUserAttributeHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterUserAttributeHandlerFunc
	}
	lockClusterUserAttributeInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterUserAttributeInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterUserAttributeInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterUserAttributeLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.AddLifecycleFunc: method is nil but ClusterUserAttributeInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterUserAttributeLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterUserAttributeInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterUserAttributeInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.AddLifecycleCalls())
func (mock *ClusterUserAttributeInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterUserAttributeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterUserAttributeLifecycle
	}
	lockClusterUserAttributeInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterUserAttributeInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterUserAttributeInterfaceMock) Controller() v31.ClusterUserAttributeController {
	if mock.ControllerFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.ControllerFunc: method is nil but ClusterUserAttributeInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterUserAttributeInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterUserAttributeInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.ControllerCalls())
func (mock *ClusterUserAttributeInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterUserAttributeInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterUserAttributeInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterUserAttributeInterfaceMock) Create(in1 *v3.ClusterUserAttribute) (*v3.ClusterUserAttribute, error) {
	if mock.CreateFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.CreateFunc: method is nil but ClusterUserAttributeInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterUserAttribute
	}{
		In1: in1,
	}
	lockClusterUserAttributeInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterUserAttributeInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.CreateCalls())
func (mock *ClusterUserAttributeInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterUserAttribute
} {
	var calls []struct {
		In1 *v3.ClusterUserAttribute
	}
	lockClusterUserAttributeInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterUserAttributeInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterUserAttributeInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.DeleteFunc: method is nil but ClusterUserAttributeInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterUserAttributeInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterUserAttributeInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.DeleteCalls())
func (mock *ClusterUserAttributeInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterUserAttributeInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterUserAttributeInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterUserAttributeInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.DeleteCollectionFunc: method is nil but ClusterUserAttributeInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterUserAttributeInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterUserAttributeInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.DeleteCollectionCalls())
func (mock *ClusterUserAttributeInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterUserAttributeInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterUserAttributeInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterUserAttributeInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterUserAttributeInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterUserAttributeInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterUserAttributeInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.DeleteNamespacedCalls())
func (mock *ClusterUserAttributeInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterUserAttributeInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterUserAttributeInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterUserAttributeInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterUserAttribute, error) {
	if mock.GetFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.GetFunc: method is nil but ClusterUserAttributeInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterUserAttributeInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterUserAttributeInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.GetCalls())
func (mock *ClusterUserAttributeInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterUserAttributeInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterUserAttributeInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterUserAttributeInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterUserAttribute, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.GetNamespacedFunc: method is nil but ClusterUserAttributeInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterUserAttributeInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterUserAttributeInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.GetNamespacedCalls())
func (mock *ClusterUserAttributeInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterUserAttributeInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterUserAttributeInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterUserAttributeInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterUserAttributeList, error) {
	if mock.ListFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.ListFunc: method is nil but ClusterUserAttributeInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterUserAttributeInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterUserAttributeInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.ListCalls())
func (mock *ClusterUserAttributeInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterUserAttributeInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterUserAttributeInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterUserAttributeInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterUserAttributeList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.ListNamespacedFunc: method is nil but ClusterUserAttributeInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterUserAttributeInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterUserAttributeInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.ListNamespacedCalls())
func (mock *ClusterUserAttributeInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterUserAttributeInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterUserAttributeInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterUserAttributeInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.ObjectClientFunc: method is nil but ClusterUserAttributeInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterUserAttributeInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterUserAttributeInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.ObjectClientCalls())
func (mock *ClusterUserAttributeInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterUserAttributeInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterUserAttributeInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterUserAttributeInterfaceMock) Update(in1 *v3.ClusterUserAttribute) (*v3.ClusterUserAttribute, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.UpdateFunc: method is nil but ClusterUserAttributeInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterUserAttribute
	}{
		In1: in1,
	}
	lockClusterUserAttributeInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterUserAttributeInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.UpdateCalls())
func (mock *ClusterUserAttributeInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterUserAttribute
} {
	var calls []struct {
		In1 *v3.ClusterUserAttribute
	}
	lockClusterUserAttributeInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterUserAttributeInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterUserAttributeInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterUserAttributeInterfaceMock.WatchFunc: method is nil but ClusterUserAttributeInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterUserAttributeInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterUserAttributeInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedClusterUserAttributeInterface.WatchCalls())
func (mock *ClusterUserAttributeInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterUserAttributeInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterUserAttributeInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterUserAttributesGetterMockClusterUserAttributes sync.RWMutex
)

// Ensure, that ClusterUserAttributesGetterMock does implement v31.ClusterUserAttributesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterUserAttributesGetter = &ClusterUserAttributesGetterMock{}

// ClusterUserAttributesGetterMock is a mock implementation of v31.ClusterUserAttributesGetter.
//
//	    func TestSomethingThatUsesClusterUserAttributesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterUserAttributesGetter
//	        mockedClusterUserAttributesGetter := &ClusterUserAttributesGetterMock{
//	            ClusterUserAttributesFunc: func(namespace string) v31.ClusterUserAttributeInterface {
//		               panic("mock out the ClusterUserAttributes method")
//	            },
//	        }
//
//	        // use mockedClusterUserAttributesGetter in code that requires v31.ClusterUserAttributesGetter
//	        // and then make assertions.
//
//	    }
type ClusterUserAttributesGetterMock struct {
	// ClusterUserAttributesFunc mocks the ClusterUserAttributes method.
	ClusterUserAttributesFunc func(namespace string) v31.ClusterUserAttributeInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterUserAttributes holds details about calls to the ClusterUserAttributes method.
		ClusterUserAttributes []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterUserAttributes calls ClusterUserAttributesFunc.
func (mock *ClusterUserAttributesGetterMock) ClusterUserAttributes(namespace string) v31.ClusterUserAttributeInterface {
	if mock.ClusterUserAttributesFunc == nil {
		panic("ClusterUserAttributesGetterMock.ClusterUserAttributesFunc: method is nil but ClusterUserAttributesGetter.ClusterUserAttributes was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterUserAttributesGetterMockClusterUserAttributes.Lock()
	mock.calls.ClusterUserAttributes = append(mock.calls.ClusterUserAttributes, callInfo)
	lockClusterUserAttributesGetterMockClusterUserAttributes.Unlock()
	return mock.ClusterUserAttributesFunc(namespace)
}

// ClusterUserAttributesCalls gets all the calls that were made to ClusterUserAttributes.
// Check the length with:
//
//	len(mockedClusterUserAttributesGetter.ClusterUserAttributesCalls())
func (mock *ClusterUserAttributesGetterMock) ClusterUserAttributesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterUserAttributesGetterMockClusterUserAttributes.RLock()
	calls = mock.calls.ClusterUserAttributes
	lockClusterUserAttributesGetterMockClusterUserAttributes.RUnlock()
	return calls
}
