// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockComponentStatusListerMockGet  sync.RWMutex
	lockComponentStatusListerMockList sync.RWMutex
)

// Ensure, that ComponentStatusListerMock does implement v11.ComponentStatusLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ComponentStatusLister = &ComponentStatusListerMock{}

// ComponentStatusListerMock is a mock implementation of v11.ComponentStatusLister.
//
//	    func TestSomethingThatUsesComponentStatusLister(t *testing.T) {
//
//	        // make and configure a mocked v11.ComponentStatusLister
//	        mockedComponentStatusLister := &ComponentStatusListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.ComponentStatus, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ComponentStatus, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedComponentStatusLister in code that requires v11.ComponentStatusLister
//	        // and then make assertions.
//
//	    }
type ComponentStatusListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ComponentStatus, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ComponentStatus, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ComponentStatusListerMock) Get(namespace string, name string) (*v1.ComponentStatus, error) {
	if mock.GetFunc == nil {
		panic("ComponentStatusListerMock.GetFunc: method is nil but ComponentStatusLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockComponentStatusListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockComponentStatusListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedComponentStatusLister.GetCalls())
func (mock *ComponentStatusListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockComponentStatusListerMockGet.RLock()
	calls = mock.calls.Get
	lockComponentStatusListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ComponentStatusListerMock) List(namespace string, selector labels.Selector) ([]*v1.ComponentStatus, error) {
	if mock.ListFunc == nil {
		panic("ComponentStatusListerMock.ListFunc: method is nil but ComponentStatusLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockComponentStatusListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockComponentStatusListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedComponentStatusLister.ListCalls())
func (mock *ComponentStatusListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockComponentStatusListerMockList.RLock()
	calls = mock.calls.List
	lockComponentStatusListerMockList.RUnlock()
	return calls
}

var (
	lockComponentStatusControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockComponentStatusControllerMockAddClusterScopedHandler        sync.RWMutex
	lockComponentStatusControllerMockAddFeatureHandler              sync.RWMutex
	lockComponentStatusControllerMockAddHandler                     sync.RWMutex
	lockComponentStatusControllerMockEnqueue                        sync.RWMutex
	lockComponentStatusControllerMockEnqueueAfter                   sync.RWMutex
	lockComponentStatusControllerMockGeneric                        sync.RWMutex
	lockComponentStatusControllerMockInformer                       sync.RWMutex
	lockComponentStatusControllerMockLister                         sync.RWMutex
)

// Ensure, that ComponentStatusControllerMock does implement v11.ComponentStatusController.
// If this is not the case, regenerate this file with moq.
var _ v11.ComponentStatusController = &ComponentStatusControllerMock{}

// ComponentStatusControllerMock is a mock implementation of v11.ComponentStatusController.
//
//	    func TestSomethingThatUsesComponentStatusController(t *testing.T) {
//
//	        // make and configure a mocked v11.ComponentStatusController
//	        mockedComponentStatusController := &ComponentStatusControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.ComponentStatusLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedComponentStatusController in code that requires v11.ComponentStatusController
//	        // and then make assertions.
//
//	    }
type ComponentStatusControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ComponentStatusHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ComponentStatusHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ComponentStatusHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ComponentStatusHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ComponentStatusLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ComponentStatusHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ComponentStatusHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ComponentStatusHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ComponentStatusHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ComponentStatusControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ComponentStatusHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ComponentStatusControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ComponentStatusController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ComponentStatusHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockComponentStatusControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockComponentStatusControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedComponentStatusController.AddClusterScopedFeatureHandlerCalls())
func (mock *ComponentStatusControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockComponentStatusControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ComponentStatusControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ComponentStatusHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ComponentStatusControllerMock.AddClusterScopedHandlerFunc: method is nil but ComponentStatusController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ComponentStatusHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockComponentStatusControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockComponentStatusControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedComponentStatusController.AddClusterScopedHandlerCalls())
func (mock *ComponentStatusControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockComponentStatusControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ComponentStatusControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ComponentStatusHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ComponentStatusControllerMock.AddFeatureHandlerFunc: method is nil but ComponentStatusController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ComponentStatusHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockComponentStatusControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockComponentStatusControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedComponentStatusController.AddFeatureHandlerCalls())
func (mock *ComponentStatusControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockComponentStatusControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ComponentStatusControllerMock) AddHandler(ctx context.Context, name string, handler v11.ComponentStatusHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ComponentStatusControllerMock.AddHandlerFunc: method is nil but ComponentStatusController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ComponentStatusHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockComponentStatusControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockComponentStatusControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedComponentStatusController.AddHandlerCalls())
func (mock *ComponentStatusControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockComponentStatusControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ComponentStatusControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ComponentStatusControllerMock.EnqueueFunc: method is nil but ComponentStatusController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockComponentStatusControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockComponentStatusControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedComponentStatusController.EnqueueCalls())
func (mock *ComponentStatusControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockComponentStatusControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockComponentStatusControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ComponentStatusControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ComponentStatusControllerMock.EnqueueAfterFunc: method is nil but ComponentStatusController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockComponentStatusControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockComponentStatusControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedComponentStatusController.EnqueueAfterCalls())
func (mock *ComponentStatusControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockComponentStatusControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockComponentStatusControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ComponentStatusControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ComponentStatusControllerMock.GenericFunc: method is nil but ComponentStatusController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockComponentStatusControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockComponentStatusControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedComponentStatusController.GenericCalls())
func (mock *ComponentStatusControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockComponentStatusControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockComponentStatusControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ComponentStatusControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ComponentStatusControllerMock.InformerFunc: method is nil but ComponentStatusController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockComponentStatusControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockComponentStatusControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedComponentStatusController.InformerCalls())
func (mock *ComponentStatusControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockComponentStatusControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockComponentStatusControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ComponentStatusControllerMock) Lister() v11.ComponentStatusLister {
	if mock.ListerFunc == nil {
		panic("ComponentStatusControllerMock.ListerFunc: method is nil but ComponentStatusController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockComponentStatusControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockComponentStatusControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedComponentStatusController.ListerCalls())
func (mock *ComponentStatusControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockComponentStatusControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockComponentStatusControllerMockLister.RUnlock()
	return calls
}

var (
	lockComponentStatusInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockComponentStatusInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockComponentStatusInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockComponentStatusInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockComponentStatusInterfaceMockAddFeatureHandler                sync.RWMutex
	lockComponentStatusInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockComponentStatusInterfaceMockAddHandler                       sync.RWMutex
	lockComponentStatusInterfaceMockAddLifecycle                     sync.RWMutex
	lockComponentStatusInterfaceMockController                       sync.RWMutex
	lockComponentStatusInterfaceMockCreate                           sync.RWMutex
	lockComponentStatusInterfaceMockDelete                           sync.RWMutex
	lockComponentStatusInterfaceMockDeleteCollection                 sync.RWMutex
	lockComponentStatusInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockComponentStatusInterfaceMockGet                              sync.RWMutex
	lockComponentStatusInterfaceMockGetNamespaced                    sync.RWMutex
	lockComponentStatusInterfaceMockList                             sync.RWMutex
	lockComponentStatusInterfaceMockListNamespaced                   sync.RWMutex
	lockComponentStatusInterfaceMockObjectClient                     sync.RWMutex
	lockComponentStatusInterfaceMockUpdate                           sync.RWMutex
	lockComponentStatusInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ComponentStatusInterfaceMock does implement v11.ComponentStatusInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ComponentStatusInterface = &ComponentStatusInterfaceMock{}

// ComponentStatusInterfaceMock is a mock implementation of v11.ComponentStatusInterface.
//
//	    func TestSomethingThatUsesComponentStatusInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.ComponentStatusInterface
//	        mockedComponentStatusInterface := &ComponentStatusInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ComponentStatusLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ComponentStatusLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ComponentStatusLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ComponentStatusHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ComponentStatusLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.ComponentStatusController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.ComponentStatus) (*v1.ComponentStatus, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.ComponentStatus, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ComponentStatus, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.ComponentStatusList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ComponentStatusList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.ComponentStatus) (*v1.ComponentStatus, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedComponentStatusInterface in code that requires v11.ComponentStatusInterface
//	        // and then make assertions.
//
//	    }
type ComponentStatusInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ComponentStatusHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ComponentStatusLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ComponentStatusHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ComponentStatusLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ComponentStatusHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ComponentStatusLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ComponentStatusHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ComponentStatusLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ComponentStatusController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ComponentStatus) (*v1.ComponentStatus, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ComponentStatus, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ComponentStatus, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ComponentStatusList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ComponentStatusList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ComponentStatus) (*v1.ComponentStatus, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ComponentStatusHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ComponentStatusLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ComponentStatusHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ComponentStatusLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ComponentStatusHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ComponentStatusLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ComponentStatusHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ComponentStatusLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ComponentStatus
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ComponentStatus
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ComponentStatusInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ComponentStatusHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ComponentStatusInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ComponentStatusInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ComponentStatusHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockComponentStatusInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockComponentStatusInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ComponentStatusInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockComponentStatusInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ComponentStatusInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ComponentStatusLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ComponentStatusInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ComponentStatusInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ComponentStatusLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockComponentStatusInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockComponentStatusInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ComponentStatusInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ComponentStatusLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ComponentStatusLifecycle
	}
	lockComponentStatusInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockComponentStatusInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ComponentStatusInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ComponentStatusHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ComponentStatusInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ComponentStatusInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ComponentStatusHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockComponentStatusInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockComponentStatusInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddClusterScopedHandlerCalls())
func (mock *ComponentStatusInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockComponentStatusInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ComponentStatusInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ComponentStatusLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ComponentStatusInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ComponentStatusInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ComponentStatusLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockComponentStatusInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockComponentStatusInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddClusterScopedLifecycleCalls())
func (mock *ComponentStatusInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ComponentStatusLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ComponentStatusLifecycle
	}
	lockComponentStatusInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockComponentStatusInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ComponentStatusInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ComponentStatusHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ComponentStatusInterfaceMock.AddFeatureHandlerFunc: method is nil but ComponentStatusInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ComponentStatusHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockComponentStatusInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockComponentStatusInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddFeatureHandlerCalls())
func (mock *ComponentStatusInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockComponentStatusInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ComponentStatusInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ComponentStatusLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ComponentStatusInterfaceMock.AddFeatureLifecycleFunc: method is nil but ComponentStatusInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ComponentStatusLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockComponentStatusInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockComponentStatusInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddFeatureLifecycleCalls())
func (mock *ComponentStatusInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ComponentStatusLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ComponentStatusLifecycle
	}
	lockComponentStatusInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockComponentStatusInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ComponentStatusInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ComponentStatusHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ComponentStatusInterfaceMock.AddHandlerFunc: method is nil but ComponentStatusInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ComponentStatusHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockComponentStatusInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockComponentStatusInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddHandlerCalls())
func (mock *ComponentStatusInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ComponentStatusHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ComponentStatusHandlerFunc
	}
	lockComponentStatusInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockComponentStatusInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ComponentStatusInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ComponentStatusLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ComponentStatusInterfaceMock.AddLifecycleFunc: method is nil but ComponentStatusInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ComponentStatusLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockComponentStatusInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockComponentStatusInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedComponentStatusInterface.AddLifecycleCalls())
func (mock *ComponentStatusInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ComponentStatusLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ComponentStatusLifecycle
	}
	lockComponentStatusInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockComponentStatusInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ComponentStatusInterfaceMock) Controller() v11.ComponentStatusController {
	if mock.ControllerFunc == nil {
		panic("ComponentStatusInterfaceMock.ControllerFunc: method is nil but ComponentStatusInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockComponentStatusInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockComponentStatusInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedComponentStatusInterface.ControllerCalls())
func (mock *ComponentStatusInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockComponentStatusInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockComponentStatusInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ComponentStatusInterfaceMock) Create(in1 *v1.ComponentStatus) (*v1.ComponentStatus, error) {
	if mock.CreateFunc == nil {
		panic("ComponentStatusInterfaceMock.CreateFunc: method is nil but ComponentStatusInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ComponentStatus
	}{
		In1: in1,
	}
	lockComponentStatusInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockComponentStatusInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedComponentStatusInterface.CreateCalls())
func (mock *ComponentStatusInterfaceMock) CreateCalls() []struct {
	In1 *v1.ComponentStatus
} {
	var calls []struct {
		In1 *v1.ComponentStatus
	}
	lockComponentStatusInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockComponentStatusInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ComponentStatusInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ComponentStatusInterfaceMock.DeleteFunc: method is nil but ComponentStatusInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockComponentStatusInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockComponentStatusInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedComponentStatusInterface.DeleteCalls())
func (mock *ComponentStatusInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockComponentStatusInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockComponentStatusInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ComponentStatusInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ComponentStatusInterfaceMock.DeleteCollectionFunc: method is nil but ComponentStatusInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockComponentStatusInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockComponentStatusInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedComponentStatusInterface.DeleteCollectionCalls())
func (mock *ComponentStatusInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockComponentStatusInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockComponentStatusInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ComponentStatusInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ComponentStatusInterfaceMock.DeleteNamespacedFunc: method is nil but ComponentStatusInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockComponentStatusInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockComponentStatusInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedComponentStatusInterface.DeleteNamespacedCalls())
func (mock *ComponentStatusInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockComponentStatusInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockComponentStatusInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ComponentStatusInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ComponentStatus, error) {
	if mock.GetFunc == nil {
		panic("ComponentStatusInterfaceMock.GetFunc: method is nil but ComponentStatusInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockComponentStatusInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockComponentStatusInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedComponentStatusInterface.GetCalls())
func (mock *ComponentStatusInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockComponentStatusInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockComponentStatusInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ComponentStatusInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ComponentStatus, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ComponentStatusInterfaceMock.GetNamespacedFunc: method is nil but ComponentStatusInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockComponentStatusInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockComponentStatusInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedComponentStatusInterface.GetNamespacedCalls())
func (mock *ComponentStatusInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockComponentStatusInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockComponentStatusInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ComponentStatusInterfaceMock) List(opts metav1.ListOptions) (*v1.ComponentStatusList, error) {
	if mock.ListFunc == nil {
		panic("ComponentStatusInterfaceMock.ListFunc: method is nil but ComponentStatusInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockComponentStatusInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockComponentStatusInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedComponentStatusInterface.ListCalls())
func (mock *ComponentStatusInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockComponentStatusInterfaceMockList.RLock()
	calls = mock.calls.List
	lockComponentStatusInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ComponentStatusInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ComponentStatusList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ComponentStatusInterfaceMock.ListNamespacedFunc: method is nil but ComponentStatusInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockComponentStatusInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockComponentStatusInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedComponentStatusInterface.ListNamespacedCalls())
func (mock *ComponentStatusInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockComponentStatusInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockComponentStatusInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ComponentStatusInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ComponentStatusInterfaceMock.ObjectClientFunc: method is nil but ComponentStatusInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockComponentStatusInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockComponentStatusInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedComponentStatusInterface.ObjectClientCalls())
func (mock *ComponentStatusInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockComponentStatusInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockComponentStatusInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ComponentStatusInterfaceMock) Update(in1 *v1.ComponentStatus) (*v1.ComponentStatus, error) {
	if mock.UpdateFunc == nil {
		panic("ComponentStatusInterfaceMock.UpdateFunc: method is nil but ComponentStatusInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ComponentStatus
	}{
		In1: in1,
	}
	lockComponentStatusInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockComponentStatusInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedComponentStatusInterface.UpdateCalls())
func (mock *ComponentStatusInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ComponentStatus
} {
	var calls []struct {
		In1 *v1.ComponentStatus
	}
	lockComponentStatusInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockComponentStatusInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ComponentStatusInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ComponentStatusInterfaceMock.WatchFunc: method is nil but ComponentStatusInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockComponentStatusInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockComponentStatusInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedComponentStatusInterface.WatchCalls())
func (mock *ComponentStatusInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockComponentStatusInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockComponentStatusInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockComponentStatusesGetterMockComponentStatuses sync.RWMutex
)

// Ensure, that ComponentStatusesGetterMock does implement v11.ComponentStatusesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ComponentStatusesGetter = &ComponentStatusesGetterMock{}

// ComponentStatusesGetterMock is a mock implementation of v11.ComponentStatusesGetter.
//
//	    func TestSomethingThatUsesComponentStatusesGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.ComponentStatusesGetter
//	        mockedComponentStatusesGetter := &ComponentStatusesGetterMock{
//	            ComponentStatusesFunc: func(namespace string) v11.ComponentStatusInterface {
//		               panic("mock out the ComponentStatuses method")
//	            },
//	        }
//
//	        // use mockedComponentStatusesGetter in code that requires v11.ComponentStatusesGetter
//	        // and then make assertions.
//
//	    }
type ComponentStatusesGetterMock struct {
	// ComponentStatusesFunc mocks the ComponentStatuses method.
	ComponentStatusesFunc func(namespace string) v11.ComponentStatusInterface

	// calls tracks calls to the methods.
	calls struct {
		// ComponentStatuses holds details about calls to the ComponentStatuses method.
		ComponentStatuses []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ComponentStatuses calls ComponentStatusesFunc.
func (mock *ComponentStatusesGetterMock) ComponentStatuses(namespace string) v11.ComponentStatusInterface {
	if mock.ComponentStatusesFunc == nil {
		panic("ComponentStatusesGetterMock.ComponentStatusesFunc: method is nil but ComponentStatusesGetter.ComponentStatuses was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockComponentStatusesGetterMockComponentStatuses.Lock()
	mock.calls.ComponentStatuses = append(mock.calls.ComponentStatuses, callInfo)
	lockComponentStatusesGetterMockComponentStatuses.Unlock()
	return mock.ComponentStatusesFunc(namespace)
}

// ComponentStatusesCalls gets all the calls that were made to ComponentStatuses.
// Check the length with:
//
//	len(mockedComponentStatusesGetter.ComponentStatusesCalls())
func (mock *ComponentStatusesGetterMock) ComponentStatusesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockComponentStatusesGetterMockComponentStatuses.RLock()
	calls = mock.calls.ComponentStatuses
	lockComponentStatusesGetterMockComponentStatuses.RUnlock()
	return calls
}
