// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockEndpointsListerMockGet  sync.RWMutex
	lockEndpointsListerMockList sync.RWMutex
)

// Ensure, that EndpointsListerMock does implement v11.EndpointsLister.
// If this is not the case, regenerate this file with moq.
var _ v11.EndpointsLister = &EndpointsListerMock{}

// EndpointsListerMock is a mock implementation of v11.EndpointsLister.
//
//	    func TestSomethingThatUsesEndpointsLister(t *testing.T) {
//
//	        // make and configure a mocked v11.EndpointsLister
//	        mockedEndpointsLister := &EndpointsListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.Endpoints, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Endpoints, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedEndpointsLister in code that requires v11.EndpointsLister
//	        // and then make assertions.
//
//	    }
type EndpointsListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Endpoints, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Endpoints, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *EndpointsListerMock) Get(namespace string, name string) (*v1.Endpoints, error) {
	if mock.GetFunc == nil {
		panic("EndpointsListerMock.GetFunc: method is nil but EndpointsLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockEndpointsListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockEndpointsListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedEndpointsLister.GetCalls())
func (mock *EndpointsListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockEndpointsListerMockGet.RLock()
	calls = mock.calls.Get
	lockEndpointsListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *EndpointsListerMock) List(namespace string, selector labels.Selector) ([]*v1.Endpoints, error) {
	if mock.ListFunc == nil {
		panic("EndpointsListerMock.ListFunc: method is nil but EndpointsLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockEndpointsListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockEndpointsListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedEndpointsLister.ListCalls())
func (mock *EndpointsListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockEndpointsListerMockList.RLock()
	calls = mock.calls.List
	lockEndpointsListerMockList.RUnlock()
	return calls
}

var (
	lockEndpointsControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockEndpointsControllerMockAddClusterScopedHandler        sync.RWMutex
	lockEndpointsControllerMockAddFeatureHandler              sync.RWMutex
	lockEndpointsControllerMockAddHandler                     sync.RWMutex
	lockEndpointsControllerMockEnqueue                        sync.RWMutex
	lockEndpointsControllerMockEnqueueAfter                   sync.RWMutex
	lockEndpointsControllerMockGeneric                        sync.RWMutex
	lockEndpointsControllerMockInformer                       sync.RWMutex
	lockEndpointsControllerMockLister                         sync.RWMutex
)

// Ensure, that EndpointsControllerMock does implement v11.EndpointsController.
// If this is not the case, regenerate this file with moq.
var _ v11.EndpointsController = &EndpointsControllerMock{}

// EndpointsControllerMock is a mock implementation of v11.EndpointsController.
//
//	    func TestSomethingThatUsesEndpointsController(t *testing.T) {
//
//	        // make and configure a mocked v11.EndpointsController
//	        mockedEndpointsController := &EndpointsControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.EndpointsLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedEndpointsController in code that requires v11.EndpointsController
//	        // and then make assertions.
//
//	    }
type EndpointsControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.EndpointsHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.EndpointsHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.EndpointsHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.EndpointsHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.EndpointsLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.EndpointsHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.EndpointsHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.EndpointsHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.EndpointsHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *EndpointsControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.EndpointsHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("EndpointsControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but EndpointsController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.EndpointsHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockEndpointsControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockEndpointsControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedEndpointsController.AddClusterScopedFeatureHandlerCalls())
func (mock *EndpointsControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.EndpointsHandlerFunc
	}
	lockEndpointsControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockEndpointsControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *EndpointsControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.EndpointsHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("EndpointsControllerMock.AddClusterScopedHandlerFunc: method is nil but EndpointsController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.EndpointsHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockEndpointsControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockEndpointsControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedEndpointsController.AddClusterScopedHandlerCalls())
func (mock *EndpointsControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.EndpointsHandlerFunc
	}
	lockEndpointsControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockEndpointsControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *EndpointsControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.EndpointsHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("EndpointsControllerMock.AddFeatureHandlerFunc: method is nil but EndpointsController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.EndpointsHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockEndpointsControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockEndpointsControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedEndpointsController.AddFeatureHandlerCalls())
func (mock *EndpointsControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.EndpointsHandlerFunc
	}
	lockEndpointsControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockEndpointsControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *EndpointsControllerMock) AddHandler(ctx context.Context, name string, handler v11.EndpointsHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("EndpointsControllerMock.AddHandlerFunc: method is nil but EndpointsController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.EndpointsHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockEndpointsControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockEndpointsControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedEndpointsController.AddHandlerCalls())
func (mock *EndpointsControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.EndpointsHandlerFunc
	}
	lockEndpointsControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockEndpointsControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *EndpointsControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("EndpointsControllerMock.EnqueueFunc: method is nil but EndpointsController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockEndpointsControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockEndpointsControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedEndpointsController.EnqueueCalls())
func (mock *EndpointsControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockEndpointsControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockEndpointsControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *EndpointsControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("EndpointsControllerMock.EnqueueAfterFunc: method is nil but EndpointsController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockEndpointsControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockEndpointsControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedEndpointsController.EnqueueAfterCalls())
func (mock *EndpointsControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockEndpointsControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockEndpointsControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *EndpointsControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("EndpointsControllerMock.GenericFunc: method is nil but EndpointsController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockEndpointsControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockEndpointsControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedEndpointsController.GenericCalls())
func (mock *EndpointsControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockEndpointsControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockEndpointsControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *EndpointsControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("EndpointsControllerMock.InformerFunc: method is nil but EndpointsController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockEndpointsControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockEndpointsControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedEndpointsController.InformerCalls())
func (mock *EndpointsControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockEndpointsControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockEndpointsControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *EndpointsControllerMock) Lister() v11.EndpointsLister {
	if mock.ListerFunc == nil {
		panic("EndpointsControllerMock.ListerFunc: method is nil but EndpointsController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockEndpointsControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockEndpointsControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedEndpointsController.ListerCalls())
func (mock *EndpointsControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockEndpointsControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockEndpointsControllerMockLister.RUnlock()
	return calls
}

var (
	lockEndpointsInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockEndpointsInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockEndpointsInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockEndpointsInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockEndpointsInterfaceMockAddFeatureHandler                sync.RWMutex
	lockEndpointsInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockEndpointsInterfaceMockAddHandler                       sync.RWMutex
	lockEndpointsInterfaceMockAddLifecycle                     sync.RWMutex
	lockEndpointsInterfaceMockController                       sync.RWMutex
	lockEndpointsInterfaceMockCreate                           sync.RWMutex
	lockEndpointsInterfaceMockDelete                           sync.RWMutex
	lockEndpointsInterfaceMockDeleteCollection                 sync.RWMutex
	lockEndpointsInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockEndpointsInterfaceMockGet                              sync.RWMutex
	lockEndpointsInterfaceMockGetNamespaced                    sync.RWMutex
	lockEndpointsInterfaceMockList                             sync.RWMutex
	lockEndpointsInterfaceMockListNamespaced                   sync.RWMutex
	lockEndpointsInterfaceMockObjectClient                     sync.RWMutex
	lockEndpointsInterfaceMockUpdate                           sync.RWMutex
	lockEndpointsInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that EndpointsInterfaceMock does implement v11.EndpointsInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.EndpointsInterface = &EndpointsInterfaceMock{}

// EndpointsInterfaceMock is a mock implementation of v11.EndpointsInterface.
//
//	    func TestSomethingThatUsesEndpointsInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.EndpointsInterface
//	        mockedEndpointsInterface := &EndpointsInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.EndpointsLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.EndpointsLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.EndpointsLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.EndpointsHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.EndpointsLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.EndpointsController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.Endpoints) (*v1.Endpoints, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.Endpoints, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Endpoints, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.EndpointsList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.EndpointsList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.Endpoints) (*v1.Endpoints, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedEndpointsInterface in code that requires v11.EndpointsInterface
//	        // and then make assertions.
//
//	    }
type EndpointsInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.EndpointsHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.EndpointsLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.EndpointsHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.EndpointsLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.EndpointsHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.EndpointsLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.EndpointsHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.EndpointsLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.EndpointsController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Endpoints) (*v1.Endpoints, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Endpoints, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Endpoints, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.EndpointsList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.EndpointsList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Endpoints) (*v1.Endpoints, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.EndpointsHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.EndpointsLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.EndpointsHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.EndpointsLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.EndpointsHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.EndpointsLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.EndpointsHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.EndpointsLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Endpoints
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Endpoints
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *EndpointsInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.EndpointsHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("EndpointsInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but EndpointsInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.EndpointsHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockEndpointsInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockEndpointsInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *EndpointsInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.EndpointsHandlerFunc
	}
	lockEndpointsInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockEndpointsInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *EndpointsInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.EndpointsLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("EndpointsInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but EndpointsInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.EndpointsLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockEndpointsInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockEndpointsInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *EndpointsInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.EndpointsLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.EndpointsLifecycle
	}
	lockEndpointsInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockEndpointsInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *EndpointsInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.EndpointsHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("EndpointsInterfaceMock.AddClusterScopedHandlerFunc: method is nil but EndpointsInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.EndpointsHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockEndpointsInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockEndpointsInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddClusterScopedHandlerCalls())
func (mock *EndpointsInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.EndpointsHandlerFunc
	}
	lockEndpointsInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockEndpointsInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *EndpointsInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.EndpointsLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("EndpointsInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but EndpointsInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.EndpointsLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockEndpointsInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockEndpointsInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddClusterScopedLifecycleCalls())
func (mock *EndpointsInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.EndpointsLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.EndpointsLifecycle
	}
	lockEndpointsInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockEndpointsInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *EndpointsInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.EndpointsHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("EndpointsInterfaceMock.AddFeatureHandlerFunc: method is nil but EndpointsInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.EndpointsHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockEndpointsInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockEndpointsInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddFeatureHandlerCalls())
func (mock *EndpointsInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.EndpointsHandlerFunc
	}
	lockEndpointsInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockEndpointsInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *EndpointsInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.EndpointsLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("EndpointsInterfaceMock.AddFeatureLifecycleFunc: method is nil but EndpointsInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.EndpointsLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockEndpointsInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockEndpointsInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddFeatureLifecycleCalls())
func (mock *EndpointsInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.EndpointsLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.EndpointsLifecycle
	}
	lockEndpointsInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockEndpointsInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *EndpointsInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.EndpointsHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("EndpointsInterfaceMock.AddHandlerFunc: method is nil but EndpointsInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.EndpointsHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockEndpointsInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockEndpointsInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddHandlerCalls())
func (mock *EndpointsInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.EndpointsHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.EndpointsHandlerFunc
	}
	lockEndpointsInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockEndpointsInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *EndpointsInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.EndpointsLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("EndpointsInterfaceMock.AddLifecycleFunc: method is nil but EndpointsInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.EndpointsLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockEndpointsInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockEndpointsInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedEndpointsInterface.AddLifecycleCalls())
func (mock *EndpointsInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.EndpointsLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.EndpointsLifecycle
	}
	lockEndpointsInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockEndpointsInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *EndpointsInterfaceMock) Controller() v11.EndpointsController {
	if mock.ControllerFunc == nil {
		panic("EndpointsInterfaceMock.ControllerFunc: method is nil but EndpointsInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockEndpointsInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockEndpointsInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedEndpointsInterface.ControllerCalls())
func (mock *EndpointsInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockEndpointsInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockEndpointsInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *EndpointsInterfaceMock) Create(in1 *v1.Endpoints) (*v1.Endpoints, error) {
	if mock.CreateFunc == nil {
		panic("EndpointsInterfaceMock.CreateFunc: method is nil but EndpointsInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Endpoints
	}{
		In1: in1,
	}
	lockEndpointsInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockEndpointsInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedEndpointsInterface.CreateCalls())
func (mock *EndpointsInterfaceMock) CreateCalls() []struct {
	In1 *v1.Endpoints
} {
	var calls []struct {
		In1 *v1.Endpoints
	}
	lockEndpointsInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockEndpointsInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *EndpointsInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("EndpointsInterfaceMock.DeleteFunc: method is nil but EndpointsInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockEndpointsInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockEndpointsInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedEndpointsInterface.DeleteCalls())
func (mock *EndpointsInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockEndpointsInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockEndpointsInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *EndpointsInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("EndpointsInterfaceMock.DeleteCollectionFunc: method is nil but EndpointsInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockEndpointsInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockEndpointsInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedEndpointsInterface.DeleteCollectionCalls())
func (mock *EndpointsInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockEndpointsInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockEndpointsInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *EndpointsInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("EndpointsInterfaceMock.DeleteNamespacedFunc: method is nil but EndpointsInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockEndpointsInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockEndpointsInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedEndpointsInterface.DeleteNamespacedCalls())
func (mock *EndpointsInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockEndpointsInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockEndpointsInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *EndpointsInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Endpoints, error) {
	if mock.GetFunc == nil {
		panic("EndpointsInterfaceMock.GetFunc: method is nil but EndpointsInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockEndpointsInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockEndpointsInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedEndpointsInterface.GetCalls())
func (mock *EndpointsInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockEndpointsInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockEndpointsInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *EndpointsInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Endpoints, error) {
	if mock.GetNamespacedFunc == nil {
		panic("EndpointsInterfaceMock.GetNamespacedFunc: method is nil but EndpointsInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockEndpointsInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockEndpointsInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedEndpointsInterface.GetNamespacedCalls())
func (mock *EndpointsInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockEndpointsInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockEndpointsInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *EndpointsInterfaceMock) List(opts metav1.ListOptions) (*v1.EndpointsList, error) {
	if mock.ListFunc == nil {
		panic("EndpointsInterfaceMock.ListFunc: method is nil but EndpointsInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockEndpointsInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockEndpointsInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedEndpointsInterface.ListCalls())
func (mock *EndpointsInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockEndpointsInterfaceMockList.RLock()
	calls = mock.calls.List
	lockEndpointsInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *EndpointsInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.EndpointsList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("EndpointsInterfaceMock.ListNamespacedFunc: method is nil but EndpointsInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockEndpointsInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockEndpointsInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedEndpointsInterface.ListNamespacedCalls())
func (mock *EndpointsInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockEndpointsInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockEndpointsInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *EndpointsInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("EndpointsInterfaceMock.ObjectClientFunc: method is nil but EndpointsInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockEndpointsInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockEndpointsInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedEndpointsInterface.ObjectClientCalls())
func (mock *EndpointsInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockEndpointsInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockEndpointsInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *EndpointsInterfaceMock) Update(in1 *v1.Endpoints) (*v1.Endpoints, error) {
	if mock.UpdateFunc == nil {
		panic("EndpointsInterfaceMock.UpdateFunc: method is nil but EndpointsInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Endpoints
	}{
		In1: in1,
	}
	lockEndpointsInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockEndpointsInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedEndpointsInterface.UpdateCalls())
func (mock *EndpointsInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Endpoints
} {
	var calls []struct {
		In1 *v1.Endpoints
	}
	lockEndpointsInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockEndpointsInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *EndpointsInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("EndpointsInterfaceMock.WatchFunc: method is nil but EndpointsInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockEndpointsInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockEndpointsInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedEndpointsInterface.WatchCalls())
func (mock *EndpointsInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockEndpointsInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockEndpointsInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockEndpointsGetterMockEndpoints sync.RWMutex
)

// Ensure, that EndpointsGetterMock does implement v11.EndpointsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.EndpointsGetter = &EndpointsGetterMock{}

// EndpointsGetterMock is a mock implementation of v11.EndpointsGetter.
//
//	    func TestSomethingThatUsesEndpointsGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.EndpointsGetter
//	        mockedEndpointsGetter := &EndpointsGetterMock{
//	            EndpointsFunc: func(namespace string) v11.EndpointsInterface {
//		               panic("mock out the Endpoints method")
//	            },
//	        }
//
//	        // use mockedEndpointsGetter in code that requires v11.EndpointsGetter
//	        // and then make assertions.
//
//	    }
type EndpointsGetterMock struct {
	// EndpointsFunc mocks the Endpoints method.
	EndpointsFunc func(namespace string) v11.EndpointsInterface

	// calls tracks calls to the methods.
	calls struct {
		// Endpoints holds details about calls to the Endpoints method.
		Endpoints []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Endpoints calls EndpointsFunc.
func (mock *EndpointsGetterMock) Endpoints(namespace string) v11.EndpointsInterface {
	if mock.EndpointsFunc == nil {
		panic("EndpointsGetterMock.EndpointsFunc: method is nil but EndpointsGetter.Endpoints was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockEndpointsGetterMockEndpoints.Lock()
	mock.calls.Endpoints = append(mock.calls.Endpoints, callInfo)
	lockEndpointsGetterMockEndpoints.Unlock()
	return mock.EndpointsFunc(namespace)
}

// EndpointsCalls gets all the calls that were made to Endpoints.
// Check the length with:
//
//	len(mockedEndpointsGetter.EndpointsCalls())
func (mock *EndpointsGetterMock) EndpointsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockEndpointsGetterMockEndpoints.RLock()
	calls = mock.calls.Endpoints
	lockEndpointsGetterMockEndpoints.RUnlock()
	return calls
}
