// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockResourceQuotaListerMockGet  sync.RWMutex
	lockResourceQuotaListerMockList sync.RWMutex
)

// Ensure, that ResourceQuotaListerMock does implement v11.ResourceQuotaLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ResourceQuotaLister = &ResourceQuotaListerMock{}

// ResourceQuotaListerMock is a mock implementation of v11.ResourceQuotaLister.
//
//	    func TestSomethingThatUsesResourceQuotaLister(t *testing.T) {
//
//	        // make and configure a mocked v11.ResourceQuotaLister
//	        mockedResourceQuotaLister := &ResourceQuotaListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.ResourceQuota, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ResourceQuota, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedResourceQuotaLister in code that requires v11.ResourceQuotaLister
//	        // and then make assertions.
//
//	    }
type ResourceQuotaListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ResourceQuota, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ResourceQuota, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ResourceQuotaListerMock) Get(namespace string, name string) (*v1.ResourceQuota, error) {
	if mock.GetFunc == nil {
		panic("ResourceQuotaListerMock.GetFunc: method is nil but ResourceQuotaLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockResourceQuotaListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockResourceQuotaListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedResourceQuotaLister.GetCalls())
func (mock *ResourceQuotaListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockResourceQuotaListerMockGet.RLock()
	calls = mock.calls.Get
	lockResourceQuotaListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ResourceQuotaListerMock) List(namespace string, selector labels.Selector) ([]*v1.ResourceQuota, error) {
	if mock.ListFunc == nil {
		panic("ResourceQuotaListerMock.ListFunc: method is nil but ResourceQuotaLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockResourceQuotaListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockResourceQuotaListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedResourceQuotaLister.ListCalls())
func (mock *ResourceQuotaListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockResourceQuotaListerMockList.RLock()
	calls = mock.calls.List
	lockResourceQuotaListerMockList.RUnlock()
	return calls
}

var (
	lockResourceQuotaControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockResourceQuotaControllerMockAddClusterScopedHandler        sync.RWMutex
	lockResourceQuotaControllerMockAddFeatureHandler              sync.RWMutex
	lockResourceQuotaControllerMockAddHandler                     sync.RWMutex
	lockResourceQuotaControllerMockEnqueue                        sync.RWMutex
	lockResourceQuotaControllerMockEnqueueAfter                   sync.RWMutex
	lockResourceQuotaControllerMockGeneric                        sync.RWMutex
	lockResourceQuotaControllerMockInformer                       sync.RWMutex
	lockResourceQuotaControllerMockLister                         sync.RWMutex
)

// Ensure, that ResourceQuotaControllerMock does implement v11.ResourceQuotaController.
// If this is not the case, regenerate this file with moq.
var _ v11.ResourceQuotaController = &ResourceQuotaControllerMock{}

// ResourceQuotaControllerMock is a mock implementation of v11.ResourceQuotaController.
//
//	    func TestSomethingThatUsesResourceQuotaController(t *testing.T) {
//
//	        // make and configure a mocked v11.ResourceQuotaController
//	        mockedResourceQuotaController := &ResourceQuotaControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.ResourceQuotaLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedResourceQuotaController in code that requires v11.ResourceQuotaController
//	        // and then make assertions.
//
//	    }
type ResourceQuotaControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ResourceQuotaHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ResourceQuotaHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ResourceQuotaHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ResourceQuotaHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ResourceQuotaLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ResourceQuotaHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ResourceQuotaHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ResourceQuotaHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ResourceQuotaHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ResourceQuotaControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ResourceQuotaHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ResourceQuotaControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ResourceQuotaController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ResourceQuotaHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockResourceQuotaControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockResourceQuotaControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedResourceQuotaController.AddClusterScopedFeatureHandlerCalls())
func (mock *ResourceQuotaControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockResourceQuotaControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ResourceQuotaControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ResourceQuotaHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ResourceQuotaControllerMock.AddClusterScopedHandlerFunc: method is nil but ResourceQuotaController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ResourceQuotaHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockResourceQuotaControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockResourceQuotaControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedResourceQuotaController.AddClusterScopedHandlerCalls())
func (mock *ResourceQuotaControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockResourceQuotaControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ResourceQuotaControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ResourceQuotaHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ResourceQuotaControllerMock.AddFeatureHandlerFunc: method is nil but ResourceQuotaController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ResourceQuotaHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockResourceQuotaControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockResourceQuotaControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedResourceQuotaController.AddFeatureHandlerCalls())
func (mock *ResourceQuotaControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockResourceQuotaControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ResourceQuotaControllerMock) AddHandler(ctx context.Context, name string, handler v11.ResourceQuotaHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ResourceQuotaControllerMock.AddHandlerFunc: method is nil but ResourceQuotaController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ResourceQuotaHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockResourceQuotaControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockResourceQuotaControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedResourceQuotaController.AddHandlerCalls())
func (mock *ResourceQuotaControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockResourceQuotaControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ResourceQuotaControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ResourceQuotaControllerMock.EnqueueFunc: method is nil but ResourceQuotaController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockResourceQuotaControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockResourceQuotaControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedResourceQuotaController.EnqueueCalls())
func (mock *ResourceQuotaControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockResourceQuotaControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockResourceQuotaControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ResourceQuotaControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ResourceQuotaControllerMock.EnqueueAfterFunc: method is nil but ResourceQuotaController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockResourceQuotaControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockResourceQuotaControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedResourceQuotaController.EnqueueAfterCalls())
func (mock *ResourceQuotaControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockResourceQuotaControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockResourceQuotaControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ResourceQuotaControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ResourceQuotaControllerMock.GenericFunc: method is nil but ResourceQuotaController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockResourceQuotaControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockResourceQuotaControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedResourceQuotaController.GenericCalls())
func (mock *ResourceQuotaControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockResourceQuotaControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockResourceQuotaControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ResourceQuotaControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ResourceQuotaControllerMock.InformerFunc: method is nil but ResourceQuotaController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockResourceQuotaControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockResourceQuotaControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedResourceQuotaController.InformerCalls())
func (mock *ResourceQuotaControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockResourceQuotaControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockResourceQuotaControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ResourceQuotaControllerMock) Lister() v11.ResourceQuotaLister {
	if mock.ListerFunc == nil {
		panic("ResourceQuotaControllerMock.ListerFunc: method is nil but ResourceQuotaController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockResourceQuotaControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockResourceQuotaControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedResourceQuotaController.ListerCalls())
func (mock *ResourceQuotaControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockResourceQuotaControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockResourceQuotaControllerMockLister.RUnlock()
	return calls
}

var (
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockResourceQuotaInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockResourceQuotaInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockResourceQuotaInterfaceMockAddFeatureHandler                sync.RWMutex
	lockResourceQuotaInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockResourceQuotaInterfaceMockAddHandler                       sync.RWMutex
	lockResourceQuotaInterfaceMockAddLifecycle                     sync.RWMutex
	lockResourceQuotaInterfaceMockController                       sync.RWMutex
	lockResourceQuotaInterfaceMockCreate                           sync.RWMutex
	lockResourceQuotaInterfaceMockDelete                           sync.RWMutex
	lockResourceQuotaInterfaceMockDeleteCollection                 sync.RWMutex
	lockResourceQuotaInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockResourceQuotaInterfaceMockGet                              sync.RWMutex
	lockResourceQuotaInterfaceMockGetNamespaced                    sync.RWMutex
	lockResourceQuotaInterfaceMockList                             sync.RWMutex
	lockResourceQuotaInterfaceMockListNamespaced                   sync.RWMutex
	lockResourceQuotaInterfaceMockObjectClient                     sync.RWMutex
	lockResourceQuotaInterfaceMockUpdate                           sync.RWMutex
	lockResourceQuotaInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ResourceQuotaInterfaceMock does implement v11.ResourceQuotaInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ResourceQuotaInterface = &ResourceQuotaInterfaceMock{}

// ResourceQuotaInterfaceMock is a mock implementation of v11.ResourceQuotaInterface.
//
//	    func TestSomethingThatUsesResourceQuotaInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.ResourceQuotaInterface
//	        mockedResourceQuotaInterface := &ResourceQuotaInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ResourceQuotaLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ResourceQuotaLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ResourceQuotaLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ResourceQuotaHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ResourceQuotaLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.ResourceQuotaController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.ResourceQuota) (*v1.ResourceQuota, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.ResourceQuota, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ResourceQuota, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.ResourceQuotaList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ResourceQuotaList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.ResourceQuota) (*v1.ResourceQuota, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedResourceQuotaInterface in code that requires v11.ResourceQuotaInterface
//	        // and then make assertions.
//
//	    }
type ResourceQuotaInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ResourceQuotaHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ResourceQuotaLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ResourceQuotaHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ResourceQuotaLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ResourceQuotaHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ResourceQuotaLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ResourceQuotaHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ResourceQuotaLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ResourceQuotaController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ResourceQuota) (*v1.ResourceQuota, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ResourceQuota, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ResourceQuota, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ResourceQuotaList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ResourceQuotaList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ResourceQuota) (*v1.ResourceQuota, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ResourceQuotaHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ResourceQuotaLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ResourceQuotaHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ResourceQuotaLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ResourceQuotaHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ResourceQuotaLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ResourceQuotaHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ResourceQuotaLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ResourceQuota
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ResourceQuota
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ResourceQuotaHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ResourceQuotaInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ResourceQuotaHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ResourceQuotaLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ResourceQuotaInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ResourceQuotaLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ResourceQuotaLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ResourceQuotaLifecycle
	}
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockResourceQuotaInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ResourceQuotaHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ResourceQuotaInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ResourceQuotaHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockResourceQuotaInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockResourceQuotaInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddClusterScopedHandlerCalls())
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockResourceQuotaInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ResourceQuotaLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ResourceQuotaInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ResourceQuotaLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockResourceQuotaInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockResourceQuotaInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddClusterScopedLifecycleCalls())
func (mock *ResourceQuotaInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ResourceQuotaLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ResourceQuotaLifecycle
	}
	lockResourceQuotaInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockResourceQuotaInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ResourceQuotaInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ResourceQuotaHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddFeatureHandlerFunc: method is nil but ResourceQuotaInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ResourceQuotaHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockResourceQuotaInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockResourceQuotaInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddFeatureHandlerCalls())
func (mock *ResourceQuotaInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockResourceQuotaInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ResourceQuotaInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ResourceQuotaLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddFeatureLifecycleFunc: method is nil but ResourceQuotaInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ResourceQuotaLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockResourceQuotaInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockResourceQuotaInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddFeatureLifecycleCalls())
func (mock *ResourceQuotaInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ResourceQuotaLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ResourceQuotaLifecycle
	}
	lockResourceQuotaInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockResourceQuotaInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ResourceQuotaInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ResourceQuotaHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddHandlerFunc: method is nil but ResourceQuotaInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ResourceQuotaHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockResourceQuotaInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockResourceQuotaInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddHandlerCalls())
func (mock *ResourceQuotaInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ResourceQuotaHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ResourceQuotaHandlerFunc
	}
	lockResourceQuotaInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockResourceQuotaInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ResourceQuotaInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ResourceQuotaLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ResourceQuotaInterfaceMock.AddLifecycleFunc: method is nil but ResourceQuotaInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ResourceQuotaLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockResourceQuotaInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockResourceQuotaInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.AddLifecycleCalls())
func (mock *ResourceQuotaInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ResourceQuotaLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ResourceQuotaLifecycle
	}
	lockResourceQuotaInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockResourceQuotaInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ResourceQuotaInterfaceMock) Controller() v11.ResourceQuotaController {
	if mock.ControllerFunc == nil {
		panic("ResourceQuotaInterfaceMock.ControllerFunc: method is nil but ResourceQuotaInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockResourceQuotaInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockResourceQuotaInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.ControllerCalls())
func (mock *ResourceQuotaInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockResourceQuotaInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockResourceQuotaInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ResourceQuotaInterfaceMock) Create(in1 *v1.ResourceQuota) (*v1.ResourceQuota, error) {
	if mock.CreateFunc == nil {
		panic("ResourceQuotaInterfaceMock.CreateFunc: method is nil but ResourceQuotaInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ResourceQuota
	}{
		In1: in1,
	}
	lockResourceQuotaInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockResourceQuotaInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.CreateCalls())
func (mock *ResourceQuotaInterfaceMock) CreateCalls() []struct {
	In1 *v1.ResourceQuota
} {
	var calls []struct {
		In1 *v1.ResourceQuota
	}
	lockResourceQuotaInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockResourceQuotaInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ResourceQuotaInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ResourceQuotaInterfaceMock.DeleteFunc: method is nil but ResourceQuotaInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockResourceQuotaInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockResourceQuotaInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.DeleteCalls())
func (mock *ResourceQuotaInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockResourceQuotaInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockResourceQuotaInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ResourceQuotaInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ResourceQuotaInterfaceMock.DeleteCollectionFunc: method is nil but ResourceQuotaInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockResourceQuotaInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockResourceQuotaInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.DeleteCollectionCalls())
func (mock *ResourceQuotaInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockResourceQuotaInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockResourceQuotaInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ResourceQuotaInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ResourceQuotaInterfaceMock.DeleteNamespacedFunc: method is nil but ResourceQuotaInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockResourceQuotaInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockResourceQuotaInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.DeleteNamespacedCalls())
func (mock *ResourceQuotaInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockResourceQuotaInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockResourceQuotaInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ResourceQuotaInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ResourceQuota, error) {
	if mock.GetFunc == nil {
		panic("ResourceQuotaInterfaceMock.GetFunc: method is nil but ResourceQuotaInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockResourceQuotaInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockResourceQuotaInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.GetCalls())
func (mock *ResourceQuotaInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockResourceQuotaInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockResourceQuotaInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ResourceQuotaInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ResourceQuota, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ResourceQuotaInterfaceMock.GetNamespacedFunc: method is nil but ResourceQuotaInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockResourceQuotaInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockResourceQuotaInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.GetNamespacedCalls())
func (mock *ResourceQuotaInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockResourceQuotaInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockResourceQuotaInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ResourceQuotaInterfaceMock) List(opts metav1.ListOptions) (*v1.ResourceQuotaList, error) {
	if mock.ListFunc == nil {
		panic("ResourceQuotaInterfaceMock.ListFunc: method is nil but ResourceQuotaInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockResourceQuotaInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockResourceQuotaInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.ListCalls())
func (mock *ResourceQuotaInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockResourceQuotaInterfaceMockList.RLock()
	calls = mock.calls.List
	lockResourceQuotaInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ResourceQuotaInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ResourceQuotaList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ResourceQuotaInterfaceMock.ListNamespacedFunc: method is nil but ResourceQuotaInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockResourceQuotaInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockResourceQuotaInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.ListNamespacedCalls())
func (mock *ResourceQuotaInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockResourceQuotaInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockResourceQuotaInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ResourceQuotaInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ResourceQuotaInterfaceMock.ObjectClientFunc: method is nil but ResourceQuotaInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockResourceQuotaInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockResourceQuotaInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.ObjectClientCalls())
func (mock *ResourceQuotaInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockResourceQuotaInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockResourceQuotaInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ResourceQuotaInterfaceMock) Update(in1 *v1.ResourceQuota) (*v1.ResourceQuota, error) {
	if mock.UpdateFunc == nil {
		panic("ResourceQuotaInterfaceMock.UpdateFunc: method is nil but ResourceQuotaInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ResourceQuota
	}{
		In1: in1,
	}
	lockResourceQuotaInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockResourceQuotaInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.UpdateCalls())
func (mock *ResourceQuotaInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ResourceQuota
} {
	var calls []struct {
		In1 *v1.ResourceQuota
	}
	lockResourceQuotaInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockResourceQuotaInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ResourceQuotaInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ResourceQuotaInterfaceMock.WatchFunc: method is nil but ResourceQuotaInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockResourceQuotaInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockResourceQuotaInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedResourceQuotaInterface.WatchCalls())
func (mock *ResourceQuotaInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockResourceQuotaInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockResourceQuotaInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockResourceQuotasGetterMockResourceQuotas sync.RWMutex
)

// Ensure, that ResourceQuotasGetterMock does implement v11.ResourceQuotasGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ResourceQuotasGetter = &ResourceQuotasGetterMock{}

// ResourceQuotasGetterMock is a mock implementation of v11.ResourceQuotasGetter.
//
//	    func TestSomethingThatUsesResourceQuotasGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.ResourceQuotasGetter
//	        mockedResourceQuotasGetter := &ResourceQuotasGetterMock{
//	            ResourceQuotasFunc: func(namespace string) v11.ResourceQuotaInterface {
//		               panic("mock out the ResourceQuotas method")
//	            },
//	        }
//
//	        // use mockedResourceQuotasGetter in code that requires v11.ResourceQuotasGetter
//	        // and then make assertions.
//
//	    }
type ResourceQuotasGetterMock struct {
	// ResourceQuotasFunc mocks the ResourceQuotas method.
	ResourceQuotasFunc func(namespace string) v11.ResourceQuotaInterface

	// calls tracks calls to the methods.
	calls struct {
		// ResourceQuotas holds details about calls to the ResourceQuotas method.
		ResourceQuotas []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ResourceQuotas calls ResourceQuotasFunc.
func (mock *ResourceQuotasGetterMock) ResourceQuotas(namespace string) v11.ResourceQuotaInterface {
	if mock.ResourceQuotasFunc == nil {
		panic("ResourceQuotasGetterMock.ResourceQuotasFunc: method is nil but ResourceQuotasGetter.ResourceQuotas was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockResourceQuotasGetterMockResourceQuotas.Lock()
	mock.calls.ResourceQuotas = append(mock.calls.ResourceQuotas, callInfo)
	lockResourceQuotasGetterMockResourceQuotas.Unlock()
	return mock.ResourceQuotasFunc(namespace)
}

// ResourceQuotasCalls gets all the calls that were made to ResourceQuotas.
// Check the length with:
//
//	len(mockedResourceQuotasGetter.ResourceQuotasCalls())
func (mock *ResourceQuotasGetterMock) ResourceQuotasCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockResourceQuotasGetterMockResourceQuotas.RLock()
	calls = mock.calls.ResourceQuotas
	lockResourceQuotasGetterMockResourceQuotas.RUnlock()
	return calls
}
