// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockSecretListerMockGet  sync.RWMutex
	lockSecretListerMockList sync.RWMutex
)

// Ensure, that SecretListerMock does implement v11.SecretLister.
// If this is not the case, regenerate this file with moq.
var _ v11.SecretLister = &SecretListerMock{}

// SecretListerMock is a mock implementation of v11.SecretLister.
//
//	    func TestSomethingThatUsesSecretLister(t *testing.T) {
//
//	        // make and configure a mocked v11.SecretLister
//	        mockedSecretLister := &SecretListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.Secret, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Secret, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedSecretLister in code that requires v11.SecretLister
//	        // and then make assertions.
//
//	    }
type SecretListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Secret, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Secret, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *SecretListerMock) Get(namespace string, name string) (*v1.Secret, error) {
	if mock.GetFunc == nil {
		panic("SecretListerMock.GetFunc: method is nil but SecretLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSecretListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSecretListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSecretLister.GetCalls())
func (mock *SecretListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSecretListerMockGet.RLock()
	calls = mock.calls.Get
	lockSecretListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SecretListerMock) List(namespace string, selector labels.Selector) ([]*v1.Secret, error) {
	if mock.ListFunc == nil {
		panic("SecretListerMock.ListFunc: method is nil but SecretLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockSecretListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSecretListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSecretLister.ListCalls())
func (mock *SecretListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockSecretListerMockList.RLock()
	calls = mock.calls.List
	lockSecretListerMockList.RUnlock()
	return calls
}

var (
	lockSecretControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockSecretControllerMockAddClusterScopedHandler        sync.RWMutex
	lockSecretControllerMockAddFeatureHandler              sync.RWMutex
	lockSecretControllerMockAddHandler                     sync.RWMutex
	lockSecretControllerMockEnqueue                        sync.RWMutex
	lockSecretControllerMockEnqueueAfter                   sync.RWMutex
	lockSecretControllerMockGeneric                        sync.RWMutex
	lockSecretControllerMockInformer                       sync.RWMutex
	lockSecretControllerMockLister                         sync.RWMutex
)

// Ensure, that SecretControllerMock does implement v11.SecretController.
// If this is not the case, regenerate this file with moq.
var _ v11.SecretController = &SecretControllerMock{}

// SecretControllerMock is a mock implementation of v11.SecretController.
//
//	    func TestSomethingThatUsesSecretController(t *testing.T) {
//
//	        // make and configure a mocked v11.SecretController
//	        mockedSecretController := &SecretControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.SecretHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.SecretHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.SecretHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.SecretHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.SecretLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedSecretController in code that requires v11.SecretController
//	        // and then make assertions.
//
//	    }
type SecretControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.SecretHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.SecretHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.SecretHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.SecretHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.SecretLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.SecretHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.SecretHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.SecretHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.SecretHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SecretControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.SecretHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SecretControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but SecretController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.SecretHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSecretControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSecretControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSecretController.AddClusterScopedFeatureHandlerCalls())
func (mock *SecretControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.SecretHandlerFunc
	}
	lockSecretControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSecretControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SecretControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.SecretHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SecretControllerMock.AddClusterScopedHandlerFunc: method is nil but SecretController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.SecretHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockSecretControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSecretControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSecretController.AddClusterScopedHandlerCalls())
func (mock *SecretControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.SecretHandlerFunc
	}
	lockSecretControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSecretControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SecretControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.SecretHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SecretControllerMock.AddFeatureHandlerFunc: method is nil but SecretController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.SecretHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSecretControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSecretControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSecretController.AddFeatureHandlerCalls())
func (mock *SecretControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.SecretHandlerFunc
	}
	lockSecretControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSecretControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SecretControllerMock) AddHandler(ctx context.Context, name string, handler v11.SecretHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SecretControllerMock.AddHandlerFunc: method is nil but SecretController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.SecretHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockSecretControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSecretControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSecretController.AddHandlerCalls())
func (mock *SecretControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.SecretHandlerFunc
	}
	lockSecretControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSecretControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *SecretControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("SecretControllerMock.EnqueueFunc: method is nil but SecretController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockSecretControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockSecretControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedSecretController.EnqueueCalls())
func (mock *SecretControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockSecretControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockSecretControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *SecretControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("SecretControllerMock.EnqueueAfterFunc: method is nil but SecretController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockSecretControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockSecretControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedSecretController.EnqueueAfterCalls())
func (mock *SecretControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockSecretControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockSecretControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *SecretControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("SecretControllerMock.GenericFunc: method is nil but SecretController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockSecretControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockSecretControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedSecretController.GenericCalls())
func (mock *SecretControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockSecretControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockSecretControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *SecretControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("SecretControllerMock.InformerFunc: method is nil but SecretController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockSecretControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockSecretControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedSecretController.InformerCalls())
func (mock *SecretControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockSecretControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockSecretControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *SecretControllerMock) Lister() v11.SecretLister {
	if mock.ListerFunc == nil {
		panic("SecretControllerMock.ListerFunc: method is nil but SecretController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockSecretControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockSecretControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedSecretController.ListerCalls())
func (mock *SecretControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockSecretControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockSecretControllerMockLister.RUnlock()
	return calls
}

var (
	lockSecretInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockSecretInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockSecretInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockSecretInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockSecretInterfaceMockAddFeatureHandler                sync.RWMutex
	lockSecretInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockSecretInterfaceMockAddHandler                       sync.RWMutex
	lockSecretInterfaceMockAddLifecycle                     sync.RWMutex
	lockSecretInterfaceMockController                       sync.RWMutex
	lockSecretInterfaceMockCreate                           sync.RWMutex
	lockSecretInterfaceMockDelete                           sync.RWMutex
	lockSecretInterfaceMockDeleteCollection                 sync.RWMutex
	lockSecretInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockSecretInterfaceMockGet                              sync.RWMutex
	lockSecretInterfaceMockGetNamespaced                    sync.RWMutex
	lockSecretInterfaceMockList                             sync.RWMutex
	lockSecretInterfaceMockListNamespaced                   sync.RWMutex
	lockSecretInterfaceMockObjectClient                     sync.RWMutex
	lockSecretInterfaceMockUpdate                           sync.RWMutex
	lockSecretInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that SecretInterfaceMock does implement v11.SecretInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.SecretInterface = &SecretInterfaceMock{}

// SecretInterfaceMock is a mock implementation of v11.SecretInterface.
//
//	    func TestSomethingThatUsesSecretInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.SecretInterface
//	        mockedSecretInterface := &SecretInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.SecretHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.SecretLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.SecretHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.SecretLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.SecretHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.SecretLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.SecretHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.SecretLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.SecretController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.Secret) (*v1.Secret, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.Secret, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Secret, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.SecretList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.SecretList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.Secret) (*v1.Secret, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedSecretInterface in code that requires v11.SecretInterface
//	        // and then make assertions.
//
//	    }
type SecretInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.SecretHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.SecretLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.SecretHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.SecretLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.SecretHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.SecretLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.SecretHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.SecretLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.SecretController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Secret) (*v1.Secret, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Secret, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Secret, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.SecretList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.SecretList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Secret) (*v1.Secret, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.SecretHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.SecretLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.SecretHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.SecretLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.SecretHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.SecretLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.SecretHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.SecretLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Secret
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Secret
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *SecretInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.SecretHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("SecretInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but SecretInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.SecretHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSecretInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockSecretInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedSecretInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *SecretInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.SecretHandlerFunc
	}
	lockSecretInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockSecretInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *SecretInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.SecretLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("SecretInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but SecretInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.SecretLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSecretInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockSecretInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedSecretInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *SecretInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.SecretLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.SecretLifecycle
	}
	lockSecretInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockSecretInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *SecretInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.SecretHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("SecretInterfaceMock.AddClusterScopedHandlerFunc: method is nil but SecretInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.SecretHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockSecretInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockSecretInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedSecretInterface.AddClusterScopedHandlerCalls())
func (mock *SecretInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.SecretHandlerFunc
	}
	lockSecretInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockSecretInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *SecretInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.SecretLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("SecretInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but SecretInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.SecretLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockSecretInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockSecretInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedSecretInterface.AddClusterScopedLifecycleCalls())
func (mock *SecretInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.SecretLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.SecretLifecycle
	}
	lockSecretInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockSecretInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *SecretInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.SecretHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("SecretInterfaceMock.AddFeatureHandlerFunc: method is nil but SecretInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.SecretHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockSecretInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockSecretInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedSecretInterface.AddFeatureHandlerCalls())
func (mock *SecretInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.SecretHandlerFunc
	}
	lockSecretInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockSecretInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *SecretInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.SecretLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("SecretInterfaceMock.AddFeatureLifecycleFunc: method is nil but SecretInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.SecretLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSecretInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockSecretInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedSecretInterface.AddFeatureLifecycleCalls())
func (mock *SecretInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.SecretLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.SecretLifecycle
	}
	lockSecretInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockSecretInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *SecretInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.SecretHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("SecretInterfaceMock.AddHandlerFunc: method is nil but SecretInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.SecretHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockSecretInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockSecretInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedSecretInterface.AddHandlerCalls())
func (mock *SecretInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.SecretHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.SecretHandlerFunc
	}
	lockSecretInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockSecretInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *SecretInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.SecretLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("SecretInterfaceMock.AddLifecycleFunc: method is nil but SecretInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.SecretLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockSecretInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockSecretInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedSecretInterface.AddLifecycleCalls())
func (mock *SecretInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.SecretLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.SecretLifecycle
	}
	lockSecretInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockSecretInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *SecretInterfaceMock) Controller() v11.SecretController {
	if mock.ControllerFunc == nil {
		panic("SecretInterfaceMock.ControllerFunc: method is nil but SecretInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockSecretInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockSecretInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedSecretInterface.ControllerCalls())
func (mock *SecretInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockSecretInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockSecretInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *SecretInterfaceMock) Create(in1 *v1.Secret) (*v1.Secret, error) {
	if mock.CreateFunc == nil {
		panic("SecretInterfaceMock.CreateFunc: method is nil but SecretInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Secret
	}{
		In1: in1,
	}
	lockSecretInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockSecretInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedSecretInterface.CreateCalls())
func (mock *SecretInterfaceMock) CreateCalls() []struct {
	In1 *v1.Secret
} {
	var calls []struct {
		In1 *v1.Secret
	}
	lockSecretInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockSecretInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *SecretInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("SecretInterfaceMock.DeleteFunc: method is nil but SecretInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockSecretInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockSecretInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedSecretInterface.DeleteCalls())
func (mock *SecretInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockSecretInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockSecretInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *SecretInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("SecretInterfaceMock.DeleteCollectionFunc: method is nil but SecretInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockSecretInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockSecretInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedSecretInterface.DeleteCollectionCalls())
func (mock *SecretInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockSecretInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockSecretInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *SecretInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("SecretInterfaceMock.DeleteNamespacedFunc: method is nil but SecretInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockSecretInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockSecretInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedSecretInterface.DeleteNamespacedCalls())
func (mock *SecretInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockSecretInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockSecretInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *SecretInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Secret, error) {
	if mock.GetFunc == nil {
		panic("SecretInterfaceMock.GetFunc: method is nil but SecretInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockSecretInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockSecretInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedSecretInterface.GetCalls())
func (mock *SecretInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockSecretInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockSecretInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *SecretInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Secret, error) {
	if mock.GetNamespacedFunc == nil {
		panic("SecretInterfaceMock.GetNamespacedFunc: method is nil but SecretInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockSecretInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockSecretInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedSecretInterface.GetNamespacedCalls())
func (mock *SecretInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockSecretInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockSecretInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *SecretInterfaceMock) List(opts metav1.ListOptions) (*v1.SecretList, error) {
	if mock.ListFunc == nil {
		panic("SecretInterfaceMock.ListFunc: method is nil but SecretInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSecretInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockSecretInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedSecretInterface.ListCalls())
func (mock *SecretInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSecretInterfaceMockList.RLock()
	calls = mock.calls.List
	lockSecretInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *SecretInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.SecretList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("SecretInterfaceMock.ListNamespacedFunc: method is nil but SecretInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockSecretInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockSecretInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedSecretInterface.ListNamespacedCalls())
func (mock *SecretInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockSecretInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockSecretInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *SecretInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("SecretInterfaceMock.ObjectClientFunc: method is nil but SecretInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockSecretInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockSecretInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedSecretInterface.ObjectClientCalls())
func (mock *SecretInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockSecretInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockSecretInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *SecretInterfaceMock) Update(in1 *v1.Secret) (*v1.Secret, error) {
	if mock.UpdateFunc == nil {
		panic("SecretInterfaceMock.UpdateFunc: method is nil but SecretInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Secret
	}{
		In1: in1,
	}
	lockSecretInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockSecretInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedSecretInterface.UpdateCalls())
func (mock *SecretInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Secret
} {
	var calls []struct {
		In1 *v1.Secret
	}
	lockSecretInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockSecretInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *SecretInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("SecretInterfaceMock.WatchFunc: method is nil but SecretInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockSecretInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockSecretInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedSecretInterface.WatchCalls())
func (mock *SecretInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockSecretInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockSecretInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockSecretsGetterMockSecrets sync.RWMutex
)

// Ensure, that SecretsGetterMock does implement v11.SecretsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.SecretsGetter = &SecretsGetterMock{}

// SecretsGetterMock is a mock implementation of v11.SecretsGetter.
//
//	    func TestSomethingThatUsesSecretsGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.SecretsGetter
//	        mockedSecretsGetter := &SecretsGetterMock{
//	            SecretsFunc: func(namespace string) v11.SecretInterface {
//		               panic("mock out the Secrets method")
//	            },
//	        }
//
//	        // use mockedSecretsGetter in code that requires v11.SecretsGetter
//	        // and then make assertions.
//
//	    }
type SecretsGetterMock struct {
	// SecretsFunc mocks the Secrets method.
	SecretsFunc func(namespace string) v11.SecretInterface

	// calls tracks calls to the methods.
	calls struct {
		// Secrets holds details about calls to the Secrets method.
		Secrets []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Secrets calls SecretsFunc.
func (mock *SecretsGetterMock) Secrets(namespace string) v11.SecretInterface {
	if mock.SecretsFunc == nil {
		panic("SecretsGetterMock.SecretsFunc: method is nil but SecretsGetter.Secrets was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockSecretsGetterMockSecrets.Lock()
	mock.calls.Secrets = append(mock.calls.Secrets, callInfo)
	lockSecretsGetterMockSecrets.Unlock()
	return mock.SecretsFunc(namespace)
}

// SecretsCalls gets all the calls that were made to Secrets.
// Check the length with:
//
//	len(mockedSecretsGetter.SecretsCalls())
func (mock *SecretsGetterMock) SecretsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockSecretsGetterMockSecrets.RLock()
	calls = mock.calls.Secrets
	lockSecretsGetterMockSecrets.RUnlock()
	return calls
}
