// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockServiceAccountListerMockGet  sync.RWMutex
	lockServiceAccountListerMockList sync.RWMutex
)

// Ensure, that ServiceAccountListerMock does implement v11.ServiceAccountLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceAccountLister = &ServiceAccountListerMock{}

// ServiceAccountListerMock is a mock implementation of v11.ServiceAccountLister.
//
//	    func TestSomethingThatUsesServiceAccountLister(t *testing.T) {
//
//	        // make and configure a mocked v11.ServiceAccountLister
//	        mockedServiceAccountLister := &ServiceAccountListerMock{
//	            GetFunc: func(namespace string, name string) (*v1.ServiceAccount, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ServiceAccount, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedServiceAccountLister in code that requires v11.ServiceAccountLister
//	        // and then make assertions.
//
//	    }
type ServiceAccountListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ServiceAccount, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ServiceAccount, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ServiceAccountListerMock) Get(namespace string, name string) (*v1.ServiceAccount, error) {
	if mock.GetFunc == nil {
		panic("ServiceAccountListerMock.GetFunc: method is nil but ServiceAccountLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockServiceAccountListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockServiceAccountListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedServiceAccountLister.GetCalls())
func (mock *ServiceAccountListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockServiceAccountListerMockGet.RLock()
	calls = mock.calls.Get
	lockServiceAccountListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ServiceAccountListerMock) List(namespace string, selector labels.Selector) ([]*v1.ServiceAccount, error) {
	if mock.ListFunc == nil {
		panic("ServiceAccountListerMock.ListFunc: method is nil but ServiceAccountLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockServiceAccountListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockServiceAccountListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedServiceAccountLister.ListCalls())
func (mock *ServiceAccountListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockServiceAccountListerMockList.RLock()
	calls = mock.calls.List
	lockServiceAccountListerMockList.RUnlock()
	return calls
}

var (
	lockServiceAccountControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockServiceAccountControllerMockAddClusterScopedHandler        sync.RWMutex
	lockServiceAccountControllerMockAddFeatureHandler              sync.RWMutex
	lockServiceAccountControllerMockAddHandler                     sync.RWMutex
	lockServiceAccountControllerMockEnqueue                        sync.RWMutex
	lockServiceAccountControllerMockEnqueueAfter                   sync.RWMutex
	lockServiceAccountControllerMockGeneric                        sync.RWMutex
	lockServiceAccountControllerMockInformer                       sync.RWMutex
	lockServiceAccountControllerMockLister                         sync.RWMutex
)

// Ensure, that ServiceAccountControllerMock does implement v11.ServiceAccountController.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceAccountController = &ServiceAccountControllerMock{}

// ServiceAccountControllerMock is a mock implementation of v11.ServiceAccountController.
//
//	    func TestSomethingThatUsesServiceAccountController(t *testing.T) {
//
//	        // make and configure a mocked v11.ServiceAccountController
//	        mockedServiceAccountController := &ServiceAccountControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v11.ServiceAccountLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedServiceAccountController in code that requires v11.ServiceAccountController
//	        // and then make assertions.
//
//	    }
type ServiceAccountControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ServiceAccountHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ServiceAccountHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceAccountHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ServiceAccountHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ServiceAccountLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ServiceAccountHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ServiceAccountHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ServiceAccountHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ServiceAccountHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ServiceAccountControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ServiceAccountHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ServiceAccountControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ServiceAccountController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ServiceAccountHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockServiceAccountControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockServiceAccountControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountController.AddClusterScopedFeatureHandlerCalls())
func (mock *ServiceAccountControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockServiceAccountControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ServiceAccountControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ServiceAccountHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ServiceAccountControllerMock.AddClusterScopedHandlerFunc: method is nil but ServiceAccountController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ServiceAccountHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockServiceAccountControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockServiceAccountControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedServiceAccountController.AddClusterScopedHandlerCalls())
func (mock *ServiceAccountControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockServiceAccountControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ServiceAccountControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceAccountHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ServiceAccountControllerMock.AddFeatureHandlerFunc: method is nil but ServiceAccountController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceAccountHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockServiceAccountControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockServiceAccountControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountController.AddFeatureHandlerCalls())
func (mock *ServiceAccountControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockServiceAccountControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ServiceAccountControllerMock) AddHandler(ctx context.Context, name string, handler v11.ServiceAccountHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ServiceAccountControllerMock.AddHandlerFunc: method is nil but ServiceAccountController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ServiceAccountHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockServiceAccountControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockServiceAccountControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedServiceAccountController.AddHandlerCalls())
func (mock *ServiceAccountControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockServiceAccountControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ServiceAccountControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ServiceAccountControllerMock.EnqueueFunc: method is nil but ServiceAccountController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockServiceAccountControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockServiceAccountControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedServiceAccountController.EnqueueCalls())
func (mock *ServiceAccountControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockServiceAccountControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockServiceAccountControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ServiceAccountControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ServiceAccountControllerMock.EnqueueAfterFunc: method is nil but ServiceAccountController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockServiceAccountControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockServiceAccountControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedServiceAccountController.EnqueueAfterCalls())
func (mock *ServiceAccountControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockServiceAccountControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockServiceAccountControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ServiceAccountControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ServiceAccountControllerMock.GenericFunc: method is nil but ServiceAccountController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockServiceAccountControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedServiceAccountController.GenericCalls())
func (mock *ServiceAccountControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockServiceAccountControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ServiceAccountControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ServiceAccountControllerMock.InformerFunc: method is nil but ServiceAccountController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockServiceAccountControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedServiceAccountController.InformerCalls())
func (mock *ServiceAccountControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockServiceAccountControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ServiceAccountControllerMock) Lister() v11.ServiceAccountLister {
	if mock.ListerFunc == nil {
		panic("ServiceAccountControllerMock.ListerFunc: method is nil but ServiceAccountController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockServiceAccountControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedServiceAccountController.ListerCalls())
func (mock *ServiceAccountControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockServiceAccountControllerMockLister.RUnlock()
	return calls
}

var (
	lockServiceAccountInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockServiceAccountInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockServiceAccountInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockServiceAccountInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockServiceAccountInterfaceMockAddFeatureHandler                sync.RWMutex
	lockServiceAccountInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockServiceAccountInterfaceMockAddHandler                       sync.RWMutex
	lockServiceAccountInterfaceMockAddLifecycle                     sync.RWMutex
	lockServiceAccountInterfaceMockController                       sync.RWMutex
	lockServiceAccountInterfaceMockCreate                           sync.RWMutex
	lockServiceAccountInterfaceMockDelete                           sync.RWMutex
	lockServiceAccountInterfaceMockDeleteCollection                 sync.RWMutex
	lockServiceAccountInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockServiceAccountInterfaceMockGet                              sync.RWMutex
	lockServiceAccountInterfaceMockGetNamespaced                    sync.RWMutex
	lockServiceAccountInterfaceMockList                             sync.RWMutex
	lockServiceAccountInterfaceMockListNamespaced                   sync.RWMutex
	lockServiceAccountInterfaceMockObjectClient                     sync.RWMutex
	lockServiceAccountInterfaceMockUpdate                           sync.RWMutex
	lockServiceAccountInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ServiceAccountInterfaceMock does implement v11.ServiceAccountInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceAccountInterface = &ServiceAccountInterfaceMock{}

// ServiceAccountInterfaceMock is a mock implementation of v11.ServiceAccountInterface.
//
//	    func TestSomethingThatUsesServiceAccountInterface(t *testing.T) {
//
//	        // make and configure a mocked v11.ServiceAccountInterface
//	        mockedServiceAccountInterface := &ServiceAccountInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ServiceAccountLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ServiceAccountLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ServiceAccountLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ServiceAccountHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ServiceAccountLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v11.ServiceAccountController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v1.ServiceAccount) (*v1.ServiceAccount, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v1.ServiceAccount, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ServiceAccount, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v1.ServiceAccountList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ServiceAccountList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v1.ServiceAccount) (*v1.ServiceAccount, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedServiceAccountInterface in code that requires v11.ServiceAccountInterface
//	        // and then make assertions.
//
//	    }
type ServiceAccountInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ServiceAccountHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ServiceAccountLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ServiceAccountHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ServiceAccountLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceAccountHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ServiceAccountLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ServiceAccountHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ServiceAccountLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ServiceAccountController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ServiceAccount) (*v1.ServiceAccount, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ServiceAccount, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ServiceAccount, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ServiceAccountList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ServiceAccountList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ServiceAccount) (*v1.ServiceAccount, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ServiceAccountHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceAccountLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ServiceAccountHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceAccountLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ServiceAccountHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceAccountLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ServiceAccountHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ServiceAccountLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ServiceAccount
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ServiceAccount
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ServiceAccountInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ServiceAccountHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ServiceAccountInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ServiceAccountInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ServiceAccountHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockServiceAccountInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockServiceAccountInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ServiceAccountInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockServiceAccountInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ServiceAccountInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ServiceAccountLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ServiceAccountInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ServiceAccountInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceAccountLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockServiceAccountInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockServiceAccountInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ServiceAccountInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ServiceAccountLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceAccountLifecycle
	}
	lockServiceAccountInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockServiceAccountInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ServiceAccountInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ServiceAccountHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ServiceAccountInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ServiceAccountInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ServiceAccountHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockServiceAccountInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockServiceAccountInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddClusterScopedHandlerCalls())
func (mock *ServiceAccountInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockServiceAccountInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ServiceAccountInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ServiceAccountLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ServiceAccountInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ServiceAccountInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceAccountLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockServiceAccountInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockServiceAccountInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddClusterScopedLifecycleCalls())
func (mock *ServiceAccountInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ServiceAccountLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ServiceAccountLifecycle
	}
	lockServiceAccountInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockServiceAccountInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ServiceAccountInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ServiceAccountHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ServiceAccountInterfaceMock.AddFeatureHandlerFunc: method is nil but ServiceAccountInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceAccountHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockServiceAccountInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockServiceAccountInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddFeatureHandlerCalls())
func (mock *ServiceAccountInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockServiceAccountInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ServiceAccountInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ServiceAccountLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ServiceAccountInterfaceMock.AddFeatureLifecycleFunc: method is nil but ServiceAccountInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ServiceAccountLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockServiceAccountInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockServiceAccountInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddFeatureLifecycleCalls())
func (mock *ServiceAccountInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ServiceAccountLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ServiceAccountLifecycle
	}
	lockServiceAccountInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockServiceAccountInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ServiceAccountInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ServiceAccountHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ServiceAccountInterfaceMock.AddHandlerFunc: method is nil but ServiceAccountInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ServiceAccountHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockServiceAccountInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockServiceAccountInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddHandlerCalls())
func (mock *ServiceAccountInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ServiceAccountHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ServiceAccountHandlerFunc
	}
	lockServiceAccountInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockServiceAccountInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ServiceAccountInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ServiceAccountLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ServiceAccountInterfaceMock.AddLifecycleFunc: method is nil but ServiceAccountInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ServiceAccountLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockServiceAccountInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockServiceAccountInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedServiceAccountInterface.AddLifecycleCalls())
func (mock *ServiceAccountInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ServiceAccountLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ServiceAccountLifecycle
	}
	lockServiceAccountInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockServiceAccountInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ServiceAccountInterfaceMock) Controller() v11.ServiceAccountController {
	if mock.ControllerFunc == nil {
		panic("ServiceAccountInterfaceMock.ControllerFunc: method is nil but ServiceAccountInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockServiceAccountInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedServiceAccountInterface.ControllerCalls())
func (mock *ServiceAccountInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockServiceAccountInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ServiceAccountInterfaceMock) Create(in1 *v1.ServiceAccount) (*v1.ServiceAccount, error) {
	if mock.CreateFunc == nil {
		panic("ServiceAccountInterfaceMock.CreateFunc: method is nil but ServiceAccountInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ServiceAccount
	}{
		In1: in1,
	}
	lockServiceAccountInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockServiceAccountInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedServiceAccountInterface.CreateCalls())
func (mock *ServiceAccountInterfaceMock) CreateCalls() []struct {
	In1 *v1.ServiceAccount
} {
	var calls []struct {
		In1 *v1.ServiceAccount
	}
	lockServiceAccountInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockServiceAccountInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ServiceAccountInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ServiceAccountInterfaceMock.DeleteFunc: method is nil but ServiceAccountInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockServiceAccountInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockServiceAccountInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedServiceAccountInterface.DeleteCalls())
func (mock *ServiceAccountInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockServiceAccountInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockServiceAccountInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ServiceAccountInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ServiceAccountInterfaceMock.DeleteCollectionFunc: method is nil but ServiceAccountInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockServiceAccountInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockServiceAccountInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedServiceAccountInterface.DeleteCollectionCalls())
func (mock *ServiceAccountInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockServiceAccountInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockServiceAccountInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ServiceAccountInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ServiceAccountInterfaceMock.DeleteNamespacedFunc: method is nil but ServiceAccountInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockServiceAccountInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockServiceAccountInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedServiceAccountInterface.DeleteNamespacedCalls())
func (mock *ServiceAccountInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockServiceAccountInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockServiceAccountInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ServiceAccountInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ServiceAccount, error) {
	if mock.GetFunc == nil {
		panic("ServiceAccountInterfaceMock.GetFunc: method is nil but ServiceAccountInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockServiceAccountInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockServiceAccountInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedServiceAccountInterface.GetCalls())
func (mock *ServiceAccountInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockServiceAccountInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockServiceAccountInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ServiceAccountInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ServiceAccount, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ServiceAccountInterfaceMock.GetNamespacedFunc: method is nil but ServiceAccountInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockServiceAccountInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockServiceAccountInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedServiceAccountInterface.GetNamespacedCalls())
func (mock *ServiceAccountInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockServiceAccountInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockServiceAccountInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ServiceAccountInterfaceMock) List(opts metav1.ListOptions) (*v1.ServiceAccountList, error) {
	if mock.ListFunc == nil {
		panic("ServiceAccountInterfaceMock.ListFunc: method is nil but ServiceAccountInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockServiceAccountInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockServiceAccountInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedServiceAccountInterface.ListCalls())
func (mock *ServiceAccountInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockServiceAccountInterfaceMockList.RLock()
	calls = mock.calls.List
	lockServiceAccountInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ServiceAccountInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ServiceAccountList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ServiceAccountInterfaceMock.ListNamespacedFunc: method is nil but ServiceAccountInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockServiceAccountInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockServiceAccountInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedServiceAccountInterface.ListNamespacedCalls())
func (mock *ServiceAccountInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockServiceAccountInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockServiceAccountInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ServiceAccountInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ServiceAccountInterfaceMock.ObjectClientFunc: method is nil but ServiceAccountInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockServiceAccountInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockServiceAccountInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedServiceAccountInterface.ObjectClientCalls())
func (mock *ServiceAccountInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockServiceAccountInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockServiceAccountInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ServiceAccountInterfaceMock) Update(in1 *v1.ServiceAccount) (*v1.ServiceAccount, error) {
	if mock.UpdateFunc == nil {
		panic("ServiceAccountInterfaceMock.UpdateFunc: method is nil but ServiceAccountInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ServiceAccount
	}{
		In1: in1,
	}
	lockServiceAccountInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockServiceAccountInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedServiceAccountInterface.UpdateCalls())
func (mock *ServiceAccountInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ServiceAccount
} {
	var calls []struct {
		In1 *v1.ServiceAccount
	}
	lockServiceAccountInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockServiceAccountInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ServiceAccountInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ServiceAccountInterfaceMock.WatchFunc: method is nil but ServiceAccountInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockServiceAccountInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockServiceAccountInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedServiceAccountInterface.WatchCalls())
func (mock *ServiceAccountInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockServiceAccountInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockServiceAccountInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockServiceAccountsGetterMockServiceAccounts sync.RWMutex
)

// Ensure, that ServiceAccountsGetterMock does implement v11.ServiceAccountsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ServiceAccountsGetter = &ServiceAccountsGetterMock{}

// ServiceAccountsGetterMock is a mock implementation of v11.ServiceAccountsGetter.
//
//	    func TestSomethingThatUsesServiceAccountsGetter(t *testing.T) {
//
//	        // make and configure a mocked v11.ServiceAccountsGetter
//	        mockedServiceAccountsGetter := &ServiceAccountsGetterMock{
//	            ServiceAccountsFunc: func(namespace string) v11.ServiceAccountInterface {
//		               panic("mock out the ServiceAccounts method")
//	            },
//	        }
//
//	        // use mockedServiceAccountsGetter in code that requires v11.ServiceAccountsGetter
//	        // and then make assertions.
//
//	    }
type ServiceAccountsGetterMock struct {
	// ServiceAccountsFunc mocks the ServiceAccounts method.
	ServiceAccountsFunc func(namespace string) v11.ServiceAccountInterface

	// calls tracks calls to the methods.
	calls struct {
		// ServiceAccounts holds details about calls to the ServiceAccounts method.
		ServiceAccounts []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ServiceAccounts calls ServiceAccountsFunc.
func (mock *ServiceAccountsGetterMock) ServiceAccounts(namespace string) v11.ServiceAccountInterface {
	if mock.ServiceAccountsFunc == nil {
		panic("ServiceAccountsGetterMock.ServiceAccountsFunc: method is nil but ServiceAccountsGetter.ServiceAccounts was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockServiceAccountsGetterMockServiceAccounts.Lock()
	mock.calls.ServiceAccounts = append(mock.calls.ServiceAccounts, callInfo)
	lockServiceAccountsGetterMockServiceAccounts.Unlock()
	return mock.ServiceAccountsFunc(namespace)
}

// ServiceAccountsCalls gets all the calls that were made to ServiceAccounts.
// Check the length with:
//
//	len(mockedServiceAccountsGetter.ServiceAccountsCalls())
func (mock *ServiceAccountsGetterMock) ServiceAccountsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockServiceAccountsGetterMockServiceAccounts.RLock()
	calls = mock.calls.ServiceAccounts
	lockServiceAccountsGetterMockServiceAccounts.RUnlock()
	return calls
}
