// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterRegistrationTokenListerMockGet  sync.RWMutex
	lockClusterRegistrationTokenListerMockList sync.RWMutex
)

// Ensure, that ClusterRegistrationTokenListerMock does implement v31.ClusterRegistrationTokenLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterRegistrationTokenLister = &ClusterRegistrationTokenListerMock{}

// ClusterRegistrationTokenListerMock is a mock implementation of v31.ClusterRegistrationTokenLister.
//
//	    func TestSomethingThatUsesClusterRegistrationTokenLister(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterRegistrationTokenLister
//	        mockedClusterRegistrationTokenLister := &ClusterRegistrationTokenListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.ClusterRegistrationToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterRegistrationToken, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedClusterRegistrationTokenLister in code that requires v31.ClusterRegistrationTokenLister
//	        // and then make assertions.
//
//	    }
type ClusterRegistrationTokenListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterRegistrationToken, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterRegistrationToken, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterRegistrationTokenListerMock) Get(namespace string, name string) (*v3.ClusterRegistrationToken, error) {
	if mock.GetFunc == nil {
		panic("ClusterRegistrationTokenListerMock.GetFunc: method is nil but ClusterRegistrationTokenLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterRegistrationTokenListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterRegistrationTokenListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenLister.GetCalls())
func (mock *ClusterRegistrationTokenListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterRegistrationTokenListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterRegistrationTokenListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterRegistrationTokenListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterRegistrationToken, error) {
	if mock.ListFunc == nil {
		panic("ClusterRegistrationTokenListerMock.ListFunc: method is nil but ClusterRegistrationTokenLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterRegistrationTokenListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterRegistrationTokenListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenLister.ListCalls())
func (mock *ClusterRegistrationTokenListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterRegistrationTokenListerMockList.RLock()
	calls = mock.calls.List
	lockClusterRegistrationTokenListerMockList.RUnlock()
	return calls
}

var (
	lockClusterRegistrationTokenControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterRegistrationTokenControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterRegistrationTokenControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterRegistrationTokenControllerMockAddHandler                     sync.RWMutex
	lockClusterRegistrationTokenControllerMockEnqueue                        sync.RWMutex
	lockClusterRegistrationTokenControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterRegistrationTokenControllerMockGeneric                        sync.RWMutex
	lockClusterRegistrationTokenControllerMockInformer                       sync.RWMutex
	lockClusterRegistrationTokenControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterRegistrationTokenControllerMock does implement v31.ClusterRegistrationTokenController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterRegistrationTokenController = &ClusterRegistrationTokenControllerMock{}

// ClusterRegistrationTokenControllerMock is a mock implementation of v31.ClusterRegistrationTokenController.
//
//	    func TestSomethingThatUsesClusterRegistrationTokenController(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterRegistrationTokenController
//	        mockedClusterRegistrationTokenController := &ClusterRegistrationTokenControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.ClusterRegistrationTokenLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedClusterRegistrationTokenController in code that requires v31.ClusterRegistrationTokenController
//	        // and then make assertions.
//
//	    }
type ClusterRegistrationTokenControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterRegistrationTokenHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterRegistrationTokenHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterRegistrationTokenHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterRegistrationTokenLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterRegistrationTokenHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterRegistrationTokenControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterRegistrationTokenController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterRegistrationTokenControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterRegistrationTokenControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterRegistrationTokenControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterRegistrationTokenControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterRegistrationTokenControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterRegistrationTokenController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterRegistrationTokenControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterRegistrationTokenControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.AddClusterScopedHandlerCalls())
func (mock *ClusterRegistrationTokenControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterRegistrationTokenControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterRegistrationTokenControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.AddFeatureHandlerFunc: method is nil but ClusterRegistrationTokenController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterRegistrationTokenControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterRegistrationTokenControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.AddFeatureHandlerCalls())
func (mock *ClusterRegistrationTokenControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterRegistrationTokenControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterRegistrationTokenControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.AddHandlerFunc: method is nil but ClusterRegistrationTokenController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterRegistrationTokenControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterRegistrationTokenControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.AddHandlerCalls())
func (mock *ClusterRegistrationTokenControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterRegistrationTokenControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterRegistrationTokenControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.EnqueueFunc: method is nil but ClusterRegistrationTokenController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterRegistrationTokenControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterRegistrationTokenControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.EnqueueCalls())
func (mock *ClusterRegistrationTokenControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterRegistrationTokenControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterRegistrationTokenControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterRegistrationTokenControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.EnqueueAfterFunc: method is nil but ClusterRegistrationTokenController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterRegistrationTokenControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterRegistrationTokenControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.EnqueueAfterCalls())
func (mock *ClusterRegistrationTokenControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterRegistrationTokenControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterRegistrationTokenControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterRegistrationTokenControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.GenericFunc: method is nil but ClusterRegistrationTokenController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRegistrationTokenControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterRegistrationTokenControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.GenericCalls())
func (mock *ClusterRegistrationTokenControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRegistrationTokenControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterRegistrationTokenControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterRegistrationTokenControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.InformerFunc: method is nil but ClusterRegistrationTokenController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRegistrationTokenControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterRegistrationTokenControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.InformerCalls())
func (mock *ClusterRegistrationTokenControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRegistrationTokenControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterRegistrationTokenControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterRegistrationTokenControllerMock) Lister() v31.ClusterRegistrationTokenLister {
	if mock.ListerFunc == nil {
		panic("ClusterRegistrationTokenControllerMock.ListerFunc: method is nil but ClusterRegistrationTokenController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRegistrationTokenControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterRegistrationTokenControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenController.ListerCalls())
func (mock *ClusterRegistrationTokenControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRegistrationTokenControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterRegistrationTokenControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddHandler                       sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockController                       sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockCreate                           sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockDelete                           sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockGet                              sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockList                             sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockObjectClient                     sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockUpdate                           sync.RWMutex
	lockClusterRegistrationTokenInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterRegistrationTokenInterfaceMock does implement v31.ClusterRegistrationTokenInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterRegistrationTokenInterface = &ClusterRegistrationTokenInterfaceMock{}

// ClusterRegistrationTokenInterfaceMock is a mock implementation of v31.ClusterRegistrationTokenInterface.
//
//	    func TestSomethingThatUsesClusterRegistrationTokenInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterRegistrationTokenInterface
//	        mockedClusterRegistrationTokenInterface := &ClusterRegistrationTokenInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterRegistrationTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterRegistrationTokenLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterRegistrationTokenLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterRegistrationTokenLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.ClusterRegistrationTokenController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.ClusterRegistrationToken) (*v3.ClusterRegistrationToken, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterRegistrationToken, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterRegistrationToken, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.ClusterRegistrationTokenList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterRegistrationTokenList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.ClusterRegistrationToken) (*v3.ClusterRegistrationToken, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedClusterRegistrationTokenInterface in code that requires v31.ClusterRegistrationTokenInterface
//	        // and then make assertions.
//
//	    }
type ClusterRegistrationTokenInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterRegistrationTokenLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterRegistrationTokenLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterRegistrationTokenLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterRegistrationTokenLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterRegistrationTokenController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterRegistrationToken) (*v3.ClusterRegistrationToken, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterRegistrationToken, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterRegistrationToken, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterRegistrationTokenList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterRegistrationTokenList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterRegistrationToken) (*v3.ClusterRegistrationToken, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterRegistrationTokenLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterRegistrationTokenLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterRegistrationTokenLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterRegistrationTokenHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterRegistrationTokenLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterRegistrationToken
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterRegistrationToken
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterRegistrationTokenInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterRegistrationTokenLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterRegistrationTokenInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterRegistrationTokenLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterRegistrationTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterRegistrationTokenLifecycle
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterRegistrationTokenInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterRegistrationTokenLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterRegistrationTokenInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterRegistrationTokenLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterRegistrationTokenLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterRegistrationTokenLifecycle
	}
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterRegistrationTokenInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterRegistrationTokenInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterRegistrationTokenInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddFeatureHandlerCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterRegistrationTokenInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterRegistrationTokenLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterRegistrationTokenInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterRegistrationTokenLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterRegistrationTokenInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddFeatureLifecycleCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterRegistrationTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterRegistrationTokenLifecycle
	}
	lockClusterRegistrationTokenInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterRegistrationTokenInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterRegistrationTokenHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddHandlerFunc: method is nil but ClusterRegistrationTokenInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterRegistrationTokenHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterRegistrationTokenInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddHandlerCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterRegistrationTokenHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterRegistrationTokenHandlerFunc
	}
	lockClusterRegistrationTokenInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterRegistrationTokenInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterRegistrationTokenLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.AddLifecycleFunc: method is nil but ClusterRegistrationTokenInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterRegistrationTokenLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterRegistrationTokenInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterRegistrationTokenInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.AddLifecycleCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterRegistrationTokenLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterRegistrationTokenLifecycle
	}
	lockClusterRegistrationTokenInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterRegistrationTokenInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) Controller() v31.ClusterRegistrationTokenController {
	if mock.ControllerFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.ControllerFunc: method is nil but ClusterRegistrationTokenInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRegistrationTokenInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterRegistrationTokenInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.ControllerCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRegistrationTokenInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterRegistrationTokenInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) Create(in1 *v3.ClusterRegistrationToken) (*v3.ClusterRegistrationToken, error) {
	if mock.CreateFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.CreateFunc: method is nil but ClusterRegistrationTokenInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterRegistrationToken
	}{
		In1: in1,
	}
	lockClusterRegistrationTokenInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterRegistrationTokenInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.CreateCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterRegistrationToken
} {
	var calls []struct {
		In1 *v3.ClusterRegistrationToken
	}
	lockClusterRegistrationTokenInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterRegistrationTokenInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.DeleteFunc: method is nil but ClusterRegistrationTokenInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterRegistrationTokenInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterRegistrationTokenInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.DeleteCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterRegistrationTokenInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterRegistrationTokenInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.DeleteCollectionFunc: method is nil but ClusterRegistrationTokenInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterRegistrationTokenInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterRegistrationTokenInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.DeleteCollectionCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterRegistrationTokenInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterRegistrationTokenInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterRegistrationTokenInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterRegistrationTokenInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterRegistrationTokenInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.DeleteNamespacedCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterRegistrationTokenInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterRegistrationTokenInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterRegistrationToken, error) {
	if mock.GetFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.GetFunc: method is nil but ClusterRegistrationTokenInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterRegistrationTokenInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterRegistrationTokenInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.GetCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterRegistrationTokenInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterRegistrationTokenInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterRegistrationToken, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.GetNamespacedFunc: method is nil but ClusterRegistrationTokenInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterRegistrationTokenInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterRegistrationTokenInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.GetNamespacedCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterRegistrationTokenInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterRegistrationTokenInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterRegistrationTokenList, error) {
	if mock.ListFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.ListFunc: method is nil but ClusterRegistrationTokenInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterRegistrationTokenInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterRegistrationTokenInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.ListCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterRegistrationTokenInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterRegistrationTokenInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterRegistrationTokenList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.ListNamespacedFunc: method is nil but ClusterRegistrationTokenInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterRegistrationTokenInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterRegistrationTokenInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.ListNamespacedCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterRegistrationTokenInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterRegistrationTokenInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.ObjectClientFunc: method is nil but ClusterRegistrationTokenInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterRegistrationTokenInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterRegistrationTokenInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.ObjectClientCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterRegistrationTokenInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterRegistrationTokenInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) Update(in1 *v3.ClusterRegistrationToken) (*v3.ClusterRegistrationToken, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.UpdateFunc: method is nil but ClusterRegistrationTokenInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterRegistrationToken
	}{
		In1: in1,
	}
	lockClusterRegistrationTokenInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterRegistrationTokenInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.UpdateCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterRegistrationToken
} {
	var calls []struct {
		In1 *v3.ClusterRegistrationToken
	}
	lockClusterRegistrationTokenInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterRegistrationTokenInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterRegistrationTokenInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterRegistrationTokenInterfaceMock.WatchFunc: method is nil but ClusterRegistrationTokenInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterRegistrationTokenInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterRegistrationTokenInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedClusterRegistrationTokenInterface.WatchCalls())
func (mock *ClusterRegistrationTokenInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterRegistrationTokenInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterRegistrationTokenInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterRegistrationTokensGetterMockClusterRegistrationTokens sync.RWMutex
)

// Ensure, that ClusterRegistrationTokensGetterMock does implement v31.ClusterRegistrationTokensGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterRegistrationTokensGetter = &ClusterRegistrationTokensGetterMock{}

// ClusterRegistrationTokensGetterMock is a mock implementation of v31.ClusterRegistrationTokensGetter.
//
//	    func TestSomethingThatUsesClusterRegistrationTokensGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.ClusterRegistrationTokensGetter
//	        mockedClusterRegistrationTokensGetter := &ClusterRegistrationTokensGetterMock{
//	            ClusterRegistrationTokensFunc: func(namespace string) v31.ClusterRegistrationTokenInterface {
//		               panic("mock out the ClusterRegistrationTokens method")
//	            },
//	        }
//
//	        // use mockedClusterRegistrationTokensGetter in code that requires v31.ClusterRegistrationTokensGetter
//	        // and then make assertions.
//
//	    }
type ClusterRegistrationTokensGetterMock struct {
	// ClusterRegistrationTokensFunc mocks the ClusterRegistrationTokens method.
	ClusterRegistrationTokensFunc func(namespace string) v31.ClusterRegistrationTokenInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterRegistrationTokens holds details about calls to the ClusterRegistrationTokens method.
		ClusterRegistrationTokens []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterRegistrationTokens calls ClusterRegistrationTokensFunc.
func (mock *ClusterRegistrationTokensGetterMock) ClusterRegistrationTokens(namespace string) v31.ClusterRegistrationTokenInterface {
	if mock.ClusterRegistrationTokensFunc == nil {
		panic("ClusterRegistrationTokensGetterMock.ClusterRegistrationTokensFunc: method is nil but ClusterRegistrationTokensGetter.ClusterRegistrationTokens was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterRegistrationTokensGetterMockClusterRegistrationTokens.Lock()
	mock.calls.ClusterRegistrationTokens = append(mock.calls.ClusterRegistrationTokens, callInfo)
	lockClusterRegistrationTokensGetterMockClusterRegistrationTokens.Unlock()
	return mock.ClusterRegistrationTokensFunc(namespace)
}

// ClusterRegistrationTokensCalls gets all the calls that were made to ClusterRegistrationTokens.
// Check the length with:
//
//	len(mockedClusterRegistrationTokensGetter.ClusterRegistrationTokensCalls())
func (mock *ClusterRegistrationTokensGetterMock) ClusterRegistrationTokensCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterRegistrationTokensGetterMockClusterRegistrationTokens.RLock()
	calls = mock.calls.ClusterRegistrationTokens
	lockClusterRegistrationTokensGetterMockClusterRegistrationTokens.RUnlock()
	return calls
}
