// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockFeatureListerMockGet  sync.RWMutex
	lockFeatureListerMockList sync.RWMutex
)

// Ensure, that FeatureListerMock does implement v31.FeatureLister.
// If this is not the case, regenerate this file with moq.
var _ v31.FeatureLister = &FeatureListerMock{}

// FeatureListerMock is a mock implementation of v31.FeatureLister.
//
//	    func TestSomethingThatUsesFeatureLister(t *testing.T) {
//
//	        // make and configure a mocked v31.FeatureLister
//	        mockedFeatureLister := &FeatureListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.Feature, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Feature, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedFeatureLister in code that requires v31.FeatureLister
//	        // and then make assertions.
//
//	    }
type FeatureListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Feature, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Feature, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *FeatureListerMock) Get(namespace string, name string) (*v3.Feature, error) {
	if mock.GetFunc == nil {
		panic("FeatureListerMock.GetFunc: method is nil but FeatureLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockFeatureListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockFeatureListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedFeatureLister.GetCalls())
func (mock *FeatureListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockFeatureListerMockGet.RLock()
	calls = mock.calls.Get
	lockFeatureListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *FeatureListerMock) List(namespace string, selector labels.Selector) ([]*v3.Feature, error) {
	if mock.ListFunc == nil {
		panic("FeatureListerMock.ListFunc: method is nil but FeatureLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockFeatureListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockFeatureListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedFeatureLister.ListCalls())
func (mock *FeatureListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockFeatureListerMockList.RLock()
	calls = mock.calls.List
	lockFeatureListerMockList.RUnlock()
	return calls
}

var (
	lockFeatureControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockFeatureControllerMockAddClusterScopedHandler        sync.RWMutex
	lockFeatureControllerMockAddFeatureHandler              sync.RWMutex
	lockFeatureControllerMockAddHandler                     sync.RWMutex
	lockFeatureControllerMockEnqueue                        sync.RWMutex
	lockFeatureControllerMockEnqueueAfter                   sync.RWMutex
	lockFeatureControllerMockGeneric                        sync.RWMutex
	lockFeatureControllerMockInformer                       sync.RWMutex
	lockFeatureControllerMockLister                         sync.RWMutex
)

// Ensure, that FeatureControllerMock does implement v31.FeatureController.
// If this is not the case, regenerate this file with moq.
var _ v31.FeatureController = &FeatureControllerMock{}

// FeatureControllerMock is a mock implementation of v31.FeatureController.
//
//	    func TestSomethingThatUsesFeatureController(t *testing.T) {
//
//	        // make and configure a mocked v31.FeatureController
//	        mockedFeatureController := &FeatureControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.FeatureLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedFeatureController in code that requires v31.FeatureController
//	        // and then make assertions.
//
//	    }
type FeatureControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.FeatureHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.FeatureHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FeatureHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.FeatureHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.FeatureLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.FeatureHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.FeatureHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.FeatureHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.FeatureHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *FeatureControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.FeatureHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("FeatureControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but FeatureController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.FeatureHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockFeatureControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockFeatureControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedFeatureController.AddClusterScopedFeatureHandlerCalls())
func (mock *FeatureControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.FeatureHandlerFunc
	}
	lockFeatureControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockFeatureControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *FeatureControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.FeatureHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("FeatureControllerMock.AddClusterScopedHandlerFunc: method is nil but FeatureController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.FeatureHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockFeatureControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockFeatureControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedFeatureController.AddClusterScopedHandlerCalls())
func (mock *FeatureControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.FeatureHandlerFunc
	}
	lockFeatureControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockFeatureControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *FeatureControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FeatureHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("FeatureControllerMock.AddFeatureHandlerFunc: method is nil but FeatureController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FeatureHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockFeatureControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockFeatureControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedFeatureController.AddFeatureHandlerCalls())
func (mock *FeatureControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FeatureHandlerFunc
	}
	lockFeatureControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockFeatureControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *FeatureControllerMock) AddHandler(ctx context.Context, name string, handler v31.FeatureHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("FeatureControllerMock.AddHandlerFunc: method is nil but FeatureController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.FeatureHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockFeatureControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockFeatureControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedFeatureController.AddHandlerCalls())
func (mock *FeatureControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.FeatureHandlerFunc
	}
	lockFeatureControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockFeatureControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *FeatureControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("FeatureControllerMock.EnqueueFunc: method is nil but FeatureController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockFeatureControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockFeatureControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedFeatureController.EnqueueCalls())
func (mock *FeatureControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockFeatureControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockFeatureControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *FeatureControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("FeatureControllerMock.EnqueueAfterFunc: method is nil but FeatureController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockFeatureControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockFeatureControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedFeatureController.EnqueueAfterCalls())
func (mock *FeatureControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockFeatureControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockFeatureControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *FeatureControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("FeatureControllerMock.GenericFunc: method is nil but FeatureController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockFeatureControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockFeatureControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedFeatureController.GenericCalls())
func (mock *FeatureControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockFeatureControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockFeatureControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *FeatureControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("FeatureControllerMock.InformerFunc: method is nil but FeatureController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockFeatureControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockFeatureControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedFeatureController.InformerCalls())
func (mock *FeatureControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockFeatureControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockFeatureControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *FeatureControllerMock) Lister() v31.FeatureLister {
	if mock.ListerFunc == nil {
		panic("FeatureControllerMock.ListerFunc: method is nil but FeatureController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockFeatureControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockFeatureControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedFeatureController.ListerCalls())
func (mock *FeatureControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockFeatureControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockFeatureControllerMockLister.RUnlock()
	return calls
}

var (
	lockFeatureInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockFeatureInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockFeatureInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockFeatureInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockFeatureInterfaceMockAddFeatureHandler                sync.RWMutex
	lockFeatureInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockFeatureInterfaceMockAddHandler                       sync.RWMutex
	lockFeatureInterfaceMockAddLifecycle                     sync.RWMutex
	lockFeatureInterfaceMockController                       sync.RWMutex
	lockFeatureInterfaceMockCreate                           sync.RWMutex
	lockFeatureInterfaceMockDelete                           sync.RWMutex
	lockFeatureInterfaceMockDeleteCollection                 sync.RWMutex
	lockFeatureInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockFeatureInterfaceMockGet                              sync.RWMutex
	lockFeatureInterfaceMockGetNamespaced                    sync.RWMutex
	lockFeatureInterfaceMockList                             sync.RWMutex
	lockFeatureInterfaceMockListNamespaced                   sync.RWMutex
	lockFeatureInterfaceMockObjectClient                     sync.RWMutex
	lockFeatureInterfaceMockUpdate                           sync.RWMutex
	lockFeatureInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that FeatureInterfaceMock does implement v31.FeatureInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.FeatureInterface = &FeatureInterfaceMock{}

// FeatureInterfaceMock is a mock implementation of v31.FeatureInterface.
//
//	    func TestSomethingThatUsesFeatureInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.FeatureInterface
//	        mockedFeatureInterface := &FeatureInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.FeatureLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.FeatureLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.FeatureLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.FeatureHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.FeatureLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.FeatureController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.Feature) (*v3.Feature, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.Feature, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Feature, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.FeatureList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.FeatureList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.Feature) (*v3.Feature, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedFeatureInterface in code that requires v31.FeatureInterface
//	        // and then make assertions.
//
//	    }
type FeatureInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.FeatureHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.FeatureLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.FeatureHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.FeatureLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FeatureHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.FeatureLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.FeatureHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.FeatureLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.FeatureController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Feature) (*v3.Feature, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Feature, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Feature, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.FeatureList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.FeatureList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Feature) (*v3.Feature, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.FeatureHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FeatureLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.FeatureHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FeatureLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.FeatureHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FeatureLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.FeatureHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FeatureLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Feature
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Feature
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *FeatureInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.FeatureHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("FeatureInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but FeatureInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.FeatureHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockFeatureInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockFeatureInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedFeatureInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *FeatureInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.FeatureHandlerFunc
	}
	lockFeatureInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockFeatureInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *FeatureInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.FeatureLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("FeatureInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but FeatureInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.FeatureLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockFeatureInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockFeatureInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedFeatureInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *FeatureInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.FeatureLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.FeatureLifecycle
	}
	lockFeatureInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockFeatureInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *FeatureInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.FeatureHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("FeatureInterfaceMock.AddClusterScopedHandlerFunc: method is nil but FeatureInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.FeatureHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockFeatureInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockFeatureInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedFeatureInterface.AddClusterScopedHandlerCalls())
func (mock *FeatureInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.FeatureHandlerFunc
	}
	lockFeatureInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockFeatureInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *FeatureInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.FeatureLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("FeatureInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but FeatureInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.FeatureLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockFeatureInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockFeatureInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedFeatureInterface.AddClusterScopedLifecycleCalls())
func (mock *FeatureInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.FeatureLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.FeatureLifecycle
	}
	lockFeatureInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockFeatureInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *FeatureInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FeatureHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("FeatureInterfaceMock.AddFeatureHandlerFunc: method is nil but FeatureInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FeatureHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockFeatureInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockFeatureInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedFeatureInterface.AddFeatureHandlerCalls())
func (mock *FeatureInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FeatureHandlerFunc
	}
	lockFeatureInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockFeatureInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *FeatureInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.FeatureLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("FeatureInterfaceMock.AddFeatureLifecycleFunc: method is nil but FeatureInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.FeatureLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockFeatureInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockFeatureInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedFeatureInterface.AddFeatureLifecycleCalls())
func (mock *FeatureInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.FeatureLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.FeatureLifecycle
	}
	lockFeatureInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockFeatureInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *FeatureInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.FeatureHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("FeatureInterfaceMock.AddHandlerFunc: method is nil but FeatureInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.FeatureHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockFeatureInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockFeatureInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedFeatureInterface.AddHandlerCalls())
func (mock *FeatureInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.FeatureHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.FeatureHandlerFunc
	}
	lockFeatureInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockFeatureInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *FeatureInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.FeatureLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("FeatureInterfaceMock.AddLifecycleFunc: method is nil but FeatureInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.FeatureLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockFeatureInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockFeatureInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedFeatureInterface.AddLifecycleCalls())
func (mock *FeatureInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.FeatureLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.FeatureLifecycle
	}
	lockFeatureInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockFeatureInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *FeatureInterfaceMock) Controller() v31.FeatureController {
	if mock.ControllerFunc == nil {
		panic("FeatureInterfaceMock.ControllerFunc: method is nil but FeatureInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockFeatureInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockFeatureInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedFeatureInterface.ControllerCalls())
func (mock *FeatureInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockFeatureInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockFeatureInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *FeatureInterfaceMock) Create(in1 *v3.Feature) (*v3.Feature, error) {
	if mock.CreateFunc == nil {
		panic("FeatureInterfaceMock.CreateFunc: method is nil but FeatureInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Feature
	}{
		In1: in1,
	}
	lockFeatureInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockFeatureInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedFeatureInterface.CreateCalls())
func (mock *FeatureInterfaceMock) CreateCalls() []struct {
	In1 *v3.Feature
} {
	var calls []struct {
		In1 *v3.Feature
	}
	lockFeatureInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockFeatureInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *FeatureInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("FeatureInterfaceMock.DeleteFunc: method is nil but FeatureInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockFeatureInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockFeatureInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedFeatureInterface.DeleteCalls())
func (mock *FeatureInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockFeatureInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockFeatureInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *FeatureInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("FeatureInterfaceMock.DeleteCollectionFunc: method is nil but FeatureInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockFeatureInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockFeatureInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedFeatureInterface.DeleteCollectionCalls())
func (mock *FeatureInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockFeatureInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockFeatureInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *FeatureInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("FeatureInterfaceMock.DeleteNamespacedFunc: method is nil but FeatureInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockFeatureInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockFeatureInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedFeatureInterface.DeleteNamespacedCalls())
func (mock *FeatureInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockFeatureInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockFeatureInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *FeatureInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Feature, error) {
	if mock.GetFunc == nil {
		panic("FeatureInterfaceMock.GetFunc: method is nil but FeatureInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockFeatureInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockFeatureInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedFeatureInterface.GetCalls())
func (mock *FeatureInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockFeatureInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockFeatureInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *FeatureInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Feature, error) {
	if mock.GetNamespacedFunc == nil {
		panic("FeatureInterfaceMock.GetNamespacedFunc: method is nil but FeatureInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockFeatureInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockFeatureInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedFeatureInterface.GetNamespacedCalls())
func (mock *FeatureInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockFeatureInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockFeatureInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *FeatureInterfaceMock) List(opts metav1.ListOptions) (*v3.FeatureList, error) {
	if mock.ListFunc == nil {
		panic("FeatureInterfaceMock.ListFunc: method is nil but FeatureInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockFeatureInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockFeatureInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedFeatureInterface.ListCalls())
func (mock *FeatureInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockFeatureInterfaceMockList.RLock()
	calls = mock.calls.List
	lockFeatureInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *FeatureInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.FeatureList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("FeatureInterfaceMock.ListNamespacedFunc: method is nil but FeatureInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockFeatureInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockFeatureInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedFeatureInterface.ListNamespacedCalls())
func (mock *FeatureInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockFeatureInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockFeatureInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *FeatureInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("FeatureInterfaceMock.ObjectClientFunc: method is nil but FeatureInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockFeatureInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockFeatureInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedFeatureInterface.ObjectClientCalls())
func (mock *FeatureInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockFeatureInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockFeatureInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *FeatureInterfaceMock) Update(in1 *v3.Feature) (*v3.Feature, error) {
	if mock.UpdateFunc == nil {
		panic("FeatureInterfaceMock.UpdateFunc: method is nil but FeatureInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Feature
	}{
		In1: in1,
	}
	lockFeatureInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockFeatureInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedFeatureInterface.UpdateCalls())
func (mock *FeatureInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Feature
} {
	var calls []struct {
		In1 *v3.Feature
	}
	lockFeatureInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockFeatureInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *FeatureInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("FeatureInterfaceMock.WatchFunc: method is nil but FeatureInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockFeatureInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockFeatureInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedFeatureInterface.WatchCalls())
func (mock *FeatureInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockFeatureInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockFeatureInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockFeaturesGetterMockFeatures sync.RWMutex
)

// Ensure, that FeaturesGetterMock does implement v31.FeaturesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.FeaturesGetter = &FeaturesGetterMock{}

// FeaturesGetterMock is a mock implementation of v31.FeaturesGetter.
//
//	    func TestSomethingThatUsesFeaturesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.FeaturesGetter
//	        mockedFeaturesGetter := &FeaturesGetterMock{
//	            FeaturesFunc: func(namespace string) v31.FeatureInterface {
//		               panic("mock out the Features method")
//	            },
//	        }
//
//	        // use mockedFeaturesGetter in code that requires v31.FeaturesGetter
//	        // and then make assertions.
//
//	    }
type FeaturesGetterMock struct {
	// FeaturesFunc mocks the Features method.
	FeaturesFunc func(namespace string) v31.FeatureInterface

	// calls tracks calls to the methods.
	calls struct {
		// Features holds details about calls to the Features method.
		Features []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Features calls FeaturesFunc.
func (mock *FeaturesGetterMock) Features(namespace string) v31.FeatureInterface {
	if mock.FeaturesFunc == nil {
		panic("FeaturesGetterMock.FeaturesFunc: method is nil but FeaturesGetter.Features was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockFeaturesGetterMockFeatures.Lock()
	mock.calls.Features = append(mock.calls.Features, callInfo)
	lockFeaturesGetterMockFeatures.Unlock()
	return mock.FeaturesFunc(namespace)
}

// FeaturesCalls gets all the calls that were made to Features.
// Check the length with:
//
//	len(mockedFeaturesGetter.FeaturesCalls())
func (mock *FeaturesGetterMock) FeaturesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockFeaturesGetterMockFeatures.RLock()
	calls = mock.calls.Features
	lockFeaturesGetterMockFeatures.RUnlock()
	return calls
}
