// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockGlobalRoleListerMockGet  sync.RWMutex
	lockGlobalRoleListerMockList sync.RWMutex
)

// Ensure, that GlobalRoleListerMock does implement v31.GlobalRoleLister.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleLister = &GlobalRoleListerMock{}

// GlobalRoleListerMock is a mock implementation of v31.GlobalRoleLister.
//
//	    func TestSomethingThatUsesGlobalRoleLister(t *testing.T) {
//
//	        // make and configure a mocked v31.GlobalRoleLister
//	        mockedGlobalRoleLister := &GlobalRoleListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.GlobalRole, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.GlobalRole, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedGlobalRoleLister in code that requires v31.GlobalRoleLister
//	        // and then make assertions.
//
//	    }
type GlobalRoleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.GlobalRole, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.GlobalRole, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *GlobalRoleListerMock) Get(namespace string, name string) (*v3.GlobalRole, error) {
	if mock.GetFunc == nil {
		panic("GlobalRoleListerMock.GetFunc: method is nil but GlobalRoleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalRoleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalRoleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedGlobalRoleLister.GetCalls())
func (mock *GlobalRoleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalRoleListerMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalRoleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalRoleListerMock) List(namespace string, selector labels.Selector) ([]*v3.GlobalRole, error) {
	if mock.ListFunc == nil {
		panic("GlobalRoleListerMock.ListFunc: method is nil but GlobalRoleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockGlobalRoleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalRoleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedGlobalRoleLister.ListCalls())
func (mock *GlobalRoleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockGlobalRoleListerMockList.RLock()
	calls = mock.calls.List
	lockGlobalRoleListerMockList.RUnlock()
	return calls
}

var (
	lockGlobalRoleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockGlobalRoleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockGlobalRoleControllerMockAddFeatureHandler              sync.RWMutex
	lockGlobalRoleControllerMockAddHandler                     sync.RWMutex
	lockGlobalRoleControllerMockEnqueue                        sync.RWMutex
	lockGlobalRoleControllerMockEnqueueAfter                   sync.RWMutex
	lockGlobalRoleControllerMockGeneric                        sync.RWMutex
	lockGlobalRoleControllerMockInformer                       sync.RWMutex
	lockGlobalRoleControllerMockLister                         sync.RWMutex
)

// Ensure, that GlobalRoleControllerMock does implement v31.GlobalRoleController.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleController = &GlobalRoleControllerMock{}

// GlobalRoleControllerMock is a mock implementation of v31.GlobalRoleController.
//
//	    func TestSomethingThatUsesGlobalRoleController(t *testing.T) {
//
//	        // make and configure a mocked v31.GlobalRoleController
//	        mockedGlobalRoleController := &GlobalRoleControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.GlobalRoleLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedGlobalRoleController in code that requires v31.GlobalRoleController
//	        // and then make assertions.
//
//	    }
type GlobalRoleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalRoleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.GlobalRoleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.GlobalRoleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.GlobalRoleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalRoleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalRoleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.GlobalRoleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalRoleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalRoleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalRoleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalRoleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalRoleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalRoleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedGlobalRoleController.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalRoleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalRoleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalRoleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.GlobalRoleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalRoleControllerMock.AddClusterScopedHandlerFunc: method is nil but GlobalRoleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalRoleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalRoleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedGlobalRoleController.AddClusterScopedHandlerCalls())
func (mock *GlobalRoleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalRoleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalRoleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalRoleControllerMock.AddFeatureHandlerFunc: method is nil but GlobalRoleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalRoleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalRoleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedGlobalRoleController.AddFeatureHandlerCalls())
func (mock *GlobalRoleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalRoleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalRoleControllerMock) AddHandler(ctx context.Context, name string, handler v31.GlobalRoleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalRoleControllerMock.AddHandlerFunc: method is nil but GlobalRoleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalRoleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockGlobalRoleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalRoleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedGlobalRoleController.AddHandlerCalls())
func (mock *GlobalRoleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalRoleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *GlobalRoleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("GlobalRoleControllerMock.EnqueueFunc: method is nil but GlobalRoleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalRoleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockGlobalRoleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedGlobalRoleController.EnqueueCalls())
func (mock *GlobalRoleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalRoleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockGlobalRoleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *GlobalRoleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("GlobalRoleControllerMock.EnqueueAfterFunc: method is nil but GlobalRoleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockGlobalRoleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockGlobalRoleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedGlobalRoleController.EnqueueAfterCalls())
func (mock *GlobalRoleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockGlobalRoleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockGlobalRoleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *GlobalRoleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("GlobalRoleControllerMock.GenericFunc: method is nil but GlobalRoleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockGlobalRoleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedGlobalRoleController.GenericCalls())
func (mock *GlobalRoleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockGlobalRoleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *GlobalRoleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("GlobalRoleControllerMock.InformerFunc: method is nil but GlobalRoleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockGlobalRoleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedGlobalRoleController.InformerCalls())
func (mock *GlobalRoleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockGlobalRoleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *GlobalRoleControllerMock) Lister() v31.GlobalRoleLister {
	if mock.ListerFunc == nil {
		panic("GlobalRoleControllerMock.ListerFunc: method is nil but GlobalRoleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockGlobalRoleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedGlobalRoleController.ListerCalls())
func (mock *GlobalRoleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockGlobalRoleControllerMockLister.RUnlock()
	return calls
}

var (
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockGlobalRoleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockGlobalRoleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockGlobalRoleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockGlobalRoleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockGlobalRoleInterfaceMockAddHandler                       sync.RWMutex
	lockGlobalRoleInterfaceMockAddLifecycle                     sync.RWMutex
	lockGlobalRoleInterfaceMockController                       sync.RWMutex
	lockGlobalRoleInterfaceMockCreate                           sync.RWMutex
	lockGlobalRoleInterfaceMockDelete                           sync.RWMutex
	lockGlobalRoleInterfaceMockDeleteCollection                 sync.RWMutex
	lockGlobalRoleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockGlobalRoleInterfaceMockGet                              sync.RWMutex
	lockGlobalRoleInterfaceMockGetNamespaced                    sync.RWMutex
	lockGlobalRoleInterfaceMockList                             sync.RWMutex
	lockGlobalRoleInterfaceMockListNamespaced                   sync.RWMutex
	lockGlobalRoleInterfaceMockObjectClient                     sync.RWMutex
	lockGlobalRoleInterfaceMockUpdate                           sync.RWMutex
	lockGlobalRoleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that GlobalRoleInterfaceMock does implement v31.GlobalRoleInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleInterface = &GlobalRoleInterfaceMock{}

// GlobalRoleInterfaceMock is a mock implementation of v31.GlobalRoleInterface.
//
//	    func TestSomethingThatUsesGlobalRoleInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.GlobalRoleInterface
//	        mockedGlobalRoleInterface := &GlobalRoleInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalRoleLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalRoleLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalRoleLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.GlobalRoleHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.GlobalRoleLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.GlobalRoleController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.GlobalRole) (*v3.GlobalRole, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.GlobalRole, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalRole, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.GlobalRoleList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.GlobalRoleList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.GlobalRole) (*v3.GlobalRole, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedGlobalRoleInterface in code that requires v31.GlobalRoleInterface
//	        // and then make assertions.
//
//	    }
type GlobalRoleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalRoleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalRoleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalRoleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalRoleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalRoleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.GlobalRoleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.GlobalRoleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.GlobalRoleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.GlobalRole) (*v3.GlobalRole, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.GlobalRole, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalRole, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.GlobalRoleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.GlobalRoleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.GlobalRole) (*v3.GlobalRole, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalRole
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalRole
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalRoleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalRoleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalRoleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalRoleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalRoleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *GlobalRoleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalRoleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("GlobalRoleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but GlobalRoleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *GlobalRoleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalRoleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleLifecycle
	}
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockGlobalRoleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalRoleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalRoleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalRoleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but GlobalRoleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalRoleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalRoleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddClusterScopedHandlerCalls())
func (mock *GlobalRoleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalRoleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *GlobalRoleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalRoleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("GlobalRoleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but GlobalRoleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalRoleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockGlobalRoleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddClusterScopedLifecycleCalls())
func (mock *GlobalRoleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalRoleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleLifecycle
	}
	lockGlobalRoleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockGlobalRoleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalRoleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalRoleInterfaceMock.AddFeatureHandlerFunc: method is nil but GlobalRoleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalRoleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalRoleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddFeatureHandlerCalls())
func (mock *GlobalRoleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalRoleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *GlobalRoleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalRoleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("GlobalRoleInterfaceMock.AddFeatureLifecycleFunc: method is nil but GlobalRoleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalRoleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalRoleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockGlobalRoleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddFeatureLifecycleCalls())
func (mock *GlobalRoleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.GlobalRoleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalRoleLifecycle
	}
	lockGlobalRoleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockGlobalRoleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalRoleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.GlobalRoleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalRoleInterfaceMock.AddHandlerFunc: method is nil but GlobalRoleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalRoleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockGlobalRoleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalRoleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddHandlerCalls())
func (mock *GlobalRoleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.GlobalRoleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalRoleHandlerFunc
	}
	lockGlobalRoleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalRoleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *GlobalRoleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.GlobalRoleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("GlobalRoleInterfaceMock.AddLifecycleFunc: method is nil but GlobalRoleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalRoleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalRoleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockGlobalRoleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.AddLifecycleCalls())
func (mock *GlobalRoleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.GlobalRoleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalRoleLifecycle
	}
	lockGlobalRoleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockGlobalRoleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *GlobalRoleInterfaceMock) Controller() v31.GlobalRoleController {
	if mock.ControllerFunc == nil {
		panic("GlobalRoleInterfaceMock.ControllerFunc: method is nil but GlobalRoleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockGlobalRoleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.ControllerCalls())
func (mock *GlobalRoleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockGlobalRoleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *GlobalRoleInterfaceMock) Create(in1 *v3.GlobalRole) (*v3.GlobalRole, error) {
	if mock.CreateFunc == nil {
		panic("GlobalRoleInterfaceMock.CreateFunc: method is nil but GlobalRoleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalRole
	}{
		In1: in1,
	}
	lockGlobalRoleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockGlobalRoleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.CreateCalls())
func (mock *GlobalRoleInterfaceMock) CreateCalls() []struct {
	In1 *v3.GlobalRole
} {
	var calls []struct {
		In1 *v3.GlobalRole
	}
	lockGlobalRoleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockGlobalRoleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *GlobalRoleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("GlobalRoleInterfaceMock.DeleteFunc: method is nil but GlobalRoleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockGlobalRoleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockGlobalRoleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.DeleteCalls())
func (mock *GlobalRoleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockGlobalRoleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockGlobalRoleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *GlobalRoleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("GlobalRoleInterfaceMock.DeleteCollectionFunc: method is nil but GlobalRoleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockGlobalRoleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockGlobalRoleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.DeleteCollectionCalls())
func (mock *GlobalRoleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockGlobalRoleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockGlobalRoleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *GlobalRoleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("GlobalRoleInterfaceMock.DeleteNamespacedFunc: method is nil but GlobalRoleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockGlobalRoleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockGlobalRoleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.DeleteNamespacedCalls())
func (mock *GlobalRoleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockGlobalRoleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockGlobalRoleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *GlobalRoleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.GlobalRole, error) {
	if mock.GetFunc == nil {
		panic("GlobalRoleInterfaceMock.GetFunc: method is nil but GlobalRoleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockGlobalRoleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalRoleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.GetCalls())
func (mock *GlobalRoleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockGlobalRoleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalRoleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *GlobalRoleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalRole, error) {
	if mock.GetNamespacedFunc == nil {
		panic("GlobalRoleInterfaceMock.GetNamespacedFunc: method is nil but GlobalRoleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockGlobalRoleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockGlobalRoleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.GetNamespacedCalls())
func (mock *GlobalRoleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockGlobalRoleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockGlobalRoleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalRoleInterfaceMock) List(opts metav1.ListOptions) (*v3.GlobalRoleList, error) {
	if mock.ListFunc == nil {
		panic("GlobalRoleInterfaceMock.ListFunc: method is nil but GlobalRoleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalRoleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalRoleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.ListCalls())
func (mock *GlobalRoleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalRoleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockGlobalRoleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *GlobalRoleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.GlobalRoleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("GlobalRoleInterfaceMock.ListNamespacedFunc: method is nil but GlobalRoleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockGlobalRoleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockGlobalRoleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.ListNamespacedCalls())
func (mock *GlobalRoleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockGlobalRoleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockGlobalRoleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *GlobalRoleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("GlobalRoleInterfaceMock.ObjectClientFunc: method is nil but GlobalRoleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockGlobalRoleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.ObjectClientCalls())
func (mock *GlobalRoleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockGlobalRoleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *GlobalRoleInterfaceMock) Update(in1 *v3.GlobalRole) (*v3.GlobalRole, error) {
	if mock.UpdateFunc == nil {
		panic("GlobalRoleInterfaceMock.UpdateFunc: method is nil but GlobalRoleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalRole
	}{
		In1: in1,
	}
	lockGlobalRoleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockGlobalRoleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.UpdateCalls())
func (mock *GlobalRoleInterfaceMock) UpdateCalls() []struct {
	In1 *v3.GlobalRole
} {
	var calls []struct {
		In1 *v3.GlobalRole
	}
	lockGlobalRoleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockGlobalRoleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *GlobalRoleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("GlobalRoleInterfaceMock.WatchFunc: method is nil but GlobalRoleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalRoleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockGlobalRoleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedGlobalRoleInterface.WatchCalls())
func (mock *GlobalRoleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalRoleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockGlobalRoleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockGlobalRolesGetterMockGlobalRoles sync.RWMutex
)

// Ensure, that GlobalRolesGetterMock does implement v31.GlobalRolesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRolesGetter = &GlobalRolesGetterMock{}

// GlobalRolesGetterMock is a mock implementation of v31.GlobalRolesGetter.
//
//	    func TestSomethingThatUsesGlobalRolesGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.GlobalRolesGetter
//	        mockedGlobalRolesGetter := &GlobalRolesGetterMock{
//	            GlobalRolesFunc: func(namespace string) v31.GlobalRoleInterface {
//		               panic("mock out the GlobalRoles method")
//	            },
//	        }
//
//	        // use mockedGlobalRolesGetter in code that requires v31.GlobalRolesGetter
//	        // and then make assertions.
//
//	    }
type GlobalRolesGetterMock struct {
	// GlobalRolesFunc mocks the GlobalRoles method.
	GlobalRolesFunc func(namespace string) v31.GlobalRoleInterface

	// calls tracks calls to the methods.
	calls struct {
		// GlobalRoles holds details about calls to the GlobalRoles method.
		GlobalRoles []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// GlobalRoles calls GlobalRolesFunc.
func (mock *GlobalRolesGetterMock) GlobalRoles(namespace string) v31.GlobalRoleInterface {
	if mock.GlobalRolesFunc == nil {
		panic("GlobalRolesGetterMock.GlobalRolesFunc: method is nil but GlobalRolesGetter.GlobalRoles was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockGlobalRolesGetterMockGlobalRoles.Lock()
	mock.calls.GlobalRoles = append(mock.calls.GlobalRoles, callInfo)
	lockGlobalRolesGetterMockGlobalRoles.Unlock()
	return mock.GlobalRolesFunc(namespace)
}

// GlobalRolesCalls gets all the calls that were made to GlobalRoles.
// Check the length with:
//
//	len(mockedGlobalRolesGetter.GlobalRolesCalls())
func (mock *GlobalRolesGetterMock) GlobalRolesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockGlobalRolesGetterMockGlobalRoles.RLock()
	calls = mock.calls.GlobalRoles
	lockGlobalRolesGetterMockGlobalRoles.RUnlock()
	return calls
}
