// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockKontainerDriverListerMockGet  sync.RWMutex
	lockKontainerDriverListerMockList sync.RWMutex
)

// Ensure, that KontainerDriverListerMock does implement v31.KontainerDriverLister.
// If this is not the case, regenerate this file with moq.
var _ v31.KontainerDriverLister = &KontainerDriverListerMock{}

// KontainerDriverListerMock is a mock implementation of v31.KontainerDriverLister.
//
//	    func TestSomethingThatUsesKontainerDriverLister(t *testing.T) {
//
//	        // make and configure a mocked v31.KontainerDriverLister
//	        mockedKontainerDriverLister := &KontainerDriverListerMock{
//	            GetFunc: func(namespace string, name string) (*v3.KontainerDriver, error) {
//		               panic("mock out the Get method")
//	            },
//	            ListFunc: func(namespace string, selector labels.Selector) ([]*v3.KontainerDriver, error) {
//		               panic("mock out the List method")
//	            },
//	        }
//
//	        // use mockedKontainerDriverLister in code that requires v31.KontainerDriverLister
//	        // and then make assertions.
//
//	    }
type KontainerDriverListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.KontainerDriver, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.KontainerDriver, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *KontainerDriverListerMock) Get(namespace string, name string) (*v3.KontainerDriver, error) {
	if mock.GetFunc == nil {
		panic("KontainerDriverListerMock.GetFunc: method is nil but KontainerDriverLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockKontainerDriverListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockKontainerDriverListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedKontainerDriverLister.GetCalls())
func (mock *KontainerDriverListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockKontainerDriverListerMockGet.RLock()
	calls = mock.calls.Get
	lockKontainerDriverListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *KontainerDriverListerMock) List(namespace string, selector labels.Selector) ([]*v3.KontainerDriver, error) {
	if mock.ListFunc == nil {
		panic("KontainerDriverListerMock.ListFunc: method is nil but KontainerDriverLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockKontainerDriverListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockKontainerDriverListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedKontainerDriverLister.ListCalls())
func (mock *KontainerDriverListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockKontainerDriverListerMockList.RLock()
	calls = mock.calls.List
	lockKontainerDriverListerMockList.RUnlock()
	return calls
}

var (
	lockKontainerDriverControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockKontainerDriverControllerMockAddClusterScopedHandler        sync.RWMutex
	lockKontainerDriverControllerMockAddFeatureHandler              sync.RWMutex
	lockKontainerDriverControllerMockAddHandler                     sync.RWMutex
	lockKontainerDriverControllerMockEnqueue                        sync.RWMutex
	lockKontainerDriverControllerMockEnqueueAfter                   sync.RWMutex
	lockKontainerDriverControllerMockGeneric                        sync.RWMutex
	lockKontainerDriverControllerMockInformer                       sync.RWMutex
	lockKontainerDriverControllerMockLister                         sync.RWMutex
)

// Ensure, that KontainerDriverControllerMock does implement v31.KontainerDriverController.
// If this is not the case, regenerate this file with moq.
var _ v31.KontainerDriverController = &KontainerDriverControllerMock{}

// KontainerDriverControllerMock is a mock implementation of v31.KontainerDriverController.
//
//	    func TestSomethingThatUsesKontainerDriverController(t *testing.T) {
//
//	        // make and configure a mocked v31.KontainerDriverController
//	        mockedKontainerDriverController := &KontainerDriverControllerMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, handler v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            EnqueueFunc: func(namespace string, name string)  {
//		               panic("mock out the Enqueue method")
//	            },
//	            EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
//		               panic("mock out the EnqueueAfter method")
//	            },
//	            GenericFunc: func() controller.GenericController {
//		               panic("mock out the Generic method")
//	            },
//	            InformerFunc: func() cache.SharedIndexInformer {
//		               panic("mock out the Informer method")
//	            },
//	            ListerFunc: func() v31.KontainerDriverLister {
//		               panic("mock out the Lister method")
//	            },
//	        }
//
//	        // use mockedKontainerDriverController in code that requires v31.KontainerDriverController
//	        // and then make assertions.
//
//	    }
type KontainerDriverControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.KontainerDriverHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.KontainerDriverHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.KontainerDriverHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.KontainerDriverHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.KontainerDriverLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.KontainerDriverHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.KontainerDriverHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.KontainerDriverHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.KontainerDriverHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *KontainerDriverControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.KontainerDriverHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("KontainerDriverControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but KontainerDriverController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.KontainerDriverHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockKontainerDriverControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockKontainerDriverControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedKontainerDriverController.AddClusterScopedFeatureHandlerCalls())
func (mock *KontainerDriverControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockKontainerDriverControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *KontainerDriverControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.KontainerDriverHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("KontainerDriverControllerMock.AddClusterScopedHandlerFunc: method is nil but KontainerDriverController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.KontainerDriverHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockKontainerDriverControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockKontainerDriverControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedKontainerDriverController.AddClusterScopedHandlerCalls())
func (mock *KontainerDriverControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockKontainerDriverControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *KontainerDriverControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.KontainerDriverHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("KontainerDriverControllerMock.AddFeatureHandlerFunc: method is nil but KontainerDriverController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.KontainerDriverHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockKontainerDriverControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockKontainerDriverControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedKontainerDriverController.AddFeatureHandlerCalls())
func (mock *KontainerDriverControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockKontainerDriverControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *KontainerDriverControllerMock) AddHandler(ctx context.Context, name string, handler v31.KontainerDriverHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("KontainerDriverControllerMock.AddHandlerFunc: method is nil but KontainerDriverController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.KontainerDriverHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockKontainerDriverControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockKontainerDriverControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedKontainerDriverController.AddHandlerCalls())
func (mock *KontainerDriverControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockKontainerDriverControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *KontainerDriverControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("KontainerDriverControllerMock.EnqueueFunc: method is nil but KontainerDriverController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockKontainerDriverControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockKontainerDriverControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//
//	len(mockedKontainerDriverController.EnqueueCalls())
func (mock *KontainerDriverControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockKontainerDriverControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockKontainerDriverControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *KontainerDriverControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("KontainerDriverControllerMock.EnqueueAfterFunc: method is nil but KontainerDriverController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockKontainerDriverControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockKontainerDriverControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//
//	len(mockedKontainerDriverController.EnqueueAfterCalls())
func (mock *KontainerDriverControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockKontainerDriverControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockKontainerDriverControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *KontainerDriverControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("KontainerDriverControllerMock.GenericFunc: method is nil but KontainerDriverController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockKontainerDriverControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockKontainerDriverControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//
//	len(mockedKontainerDriverController.GenericCalls())
func (mock *KontainerDriverControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockKontainerDriverControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockKontainerDriverControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *KontainerDriverControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("KontainerDriverControllerMock.InformerFunc: method is nil but KontainerDriverController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockKontainerDriverControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockKontainerDriverControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//
//	len(mockedKontainerDriverController.InformerCalls())
func (mock *KontainerDriverControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockKontainerDriverControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockKontainerDriverControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *KontainerDriverControllerMock) Lister() v31.KontainerDriverLister {
	if mock.ListerFunc == nil {
		panic("KontainerDriverControllerMock.ListerFunc: method is nil but KontainerDriverController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockKontainerDriverControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockKontainerDriverControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//
//	len(mockedKontainerDriverController.ListerCalls())
func (mock *KontainerDriverControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockKontainerDriverControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockKontainerDriverControllerMockLister.RUnlock()
	return calls
}

var (
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockKontainerDriverInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockKontainerDriverInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockKontainerDriverInterfaceMockAddFeatureHandler                sync.RWMutex
	lockKontainerDriverInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockKontainerDriverInterfaceMockAddHandler                       sync.RWMutex
	lockKontainerDriverInterfaceMockAddLifecycle                     sync.RWMutex
	lockKontainerDriverInterfaceMockController                       sync.RWMutex
	lockKontainerDriverInterfaceMockCreate                           sync.RWMutex
	lockKontainerDriverInterfaceMockDelete                           sync.RWMutex
	lockKontainerDriverInterfaceMockDeleteCollection                 sync.RWMutex
	lockKontainerDriverInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockKontainerDriverInterfaceMockGet                              sync.RWMutex
	lockKontainerDriverInterfaceMockGetNamespaced                    sync.RWMutex
	lockKontainerDriverInterfaceMockList                             sync.RWMutex
	lockKontainerDriverInterfaceMockListNamespaced                   sync.RWMutex
	lockKontainerDriverInterfaceMockObjectClient                     sync.RWMutex
	lockKontainerDriverInterfaceMockUpdate                           sync.RWMutex
	lockKontainerDriverInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that KontainerDriverInterfaceMock does implement v31.KontainerDriverInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.KontainerDriverInterface = &KontainerDriverInterfaceMock{}

// KontainerDriverInterfaceMock is a mock implementation of v31.KontainerDriverInterface.
//
//	    func TestSomethingThatUsesKontainerDriverInterface(t *testing.T) {
//
//	        // make and configure a mocked v31.KontainerDriverInterface
//	        mockedKontainerDriverInterface := &KontainerDriverInterfaceMock{
//	            AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedFeatureHandler method")
//	            },
//	            AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.KontainerDriverLifecycle)  {
//		               panic("mock out the AddClusterScopedFeatureLifecycle method")
//	            },
//	            AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddClusterScopedHandler method")
//	            },
//	            AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.KontainerDriverLifecycle)  {
//		               panic("mock out the AddClusterScopedLifecycle method")
//	            },
//	            AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddFeatureHandler method")
//	            },
//	            AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.KontainerDriverLifecycle)  {
//		               panic("mock out the AddFeatureLifecycle method")
//	            },
//	            AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.KontainerDriverHandlerFunc)  {
//		               panic("mock out the AddHandler method")
//	            },
//	            AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.KontainerDriverLifecycle)  {
//		               panic("mock out the AddLifecycle method")
//	            },
//	            ControllerFunc: func() v31.KontainerDriverController {
//		               panic("mock out the Controller method")
//	            },
//	            CreateFunc: func(in1 *v3.KontainerDriver) (*v3.KontainerDriver, error) {
//		               panic("mock out the Create method")
//	            },
//	            DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the Delete method")
//	            },
//	            DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
//		               panic("mock out the DeleteCollection method")
//	            },
//	            DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
//		               panic("mock out the DeleteNamespaced method")
//	            },
//	            GetFunc: func(name string, opts metav1.GetOptions) (*v3.KontainerDriver, error) {
//		               panic("mock out the Get method")
//	            },
//	            GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.KontainerDriver, error) {
//		               panic("mock out the GetNamespaced method")
//	            },
//	            ListFunc: func(opts metav1.ListOptions) (*v3.KontainerDriverList, error) {
//		               panic("mock out the List method")
//	            },
//	            ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.KontainerDriverList, error) {
//		               panic("mock out the ListNamespaced method")
//	            },
//	            ObjectClientFunc: func() *objectclient.ObjectClient {
//		               panic("mock out the ObjectClient method")
//	            },
//	            UpdateFunc: func(in1 *v3.KontainerDriver) (*v3.KontainerDriver, error) {
//		               panic("mock out the Update method")
//	            },
//	            WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
//		               panic("mock out the Watch method")
//	            },
//	        }
//
//	        // use mockedKontainerDriverInterface in code that requires v31.KontainerDriverInterface
//	        // and then make assertions.
//
//	    }
type KontainerDriverInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.KontainerDriverHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.KontainerDriverLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.KontainerDriverHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.KontainerDriverLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.KontainerDriverHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.KontainerDriverLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.KontainerDriverHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.KontainerDriverLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.KontainerDriverController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.KontainerDriver) (*v3.KontainerDriver, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.KontainerDriver, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.KontainerDriver, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.KontainerDriverList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.KontainerDriverList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.KontainerDriver) (*v3.KontainerDriver, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.KontainerDriverHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.KontainerDriverLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.KontainerDriverHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.KontainerDriverLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.KontainerDriverHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.KontainerDriverLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.KontainerDriverHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.KontainerDriverLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.KontainerDriver
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.KontainerDriver
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *KontainerDriverInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.KontainerDriverHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("KontainerDriverInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but KontainerDriverInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.KontainerDriverHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *KontainerDriverInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *KontainerDriverInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.KontainerDriverLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("KontainerDriverInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but KontainerDriverInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.KontainerDriverLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *KontainerDriverInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.KontainerDriverLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.KontainerDriverLifecycle
	}
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockKontainerDriverInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *KontainerDriverInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.KontainerDriverHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("KontainerDriverInterfaceMock.AddClusterScopedHandlerFunc: method is nil but KontainerDriverInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.KontainerDriverHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockKontainerDriverInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockKontainerDriverInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddClusterScopedHandlerCalls())
func (mock *KontainerDriverInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockKontainerDriverInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *KontainerDriverInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.KontainerDriverLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("KontainerDriverInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but KontainerDriverInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.KontainerDriverLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockKontainerDriverInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockKontainerDriverInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddClusterScopedLifecycleCalls())
func (mock *KontainerDriverInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.KontainerDriverLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.KontainerDriverLifecycle
	}
	lockKontainerDriverInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockKontainerDriverInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *KontainerDriverInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.KontainerDriverHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("KontainerDriverInterfaceMock.AddFeatureHandlerFunc: method is nil but KontainerDriverInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.KontainerDriverHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockKontainerDriverInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockKontainerDriverInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddFeatureHandlerCalls())
func (mock *KontainerDriverInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockKontainerDriverInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *KontainerDriverInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.KontainerDriverLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("KontainerDriverInterfaceMock.AddFeatureLifecycleFunc: method is nil but KontainerDriverInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.KontainerDriverLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockKontainerDriverInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockKontainerDriverInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddFeatureLifecycleCalls())
func (mock *KontainerDriverInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.KontainerDriverLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.KontainerDriverLifecycle
	}
	lockKontainerDriverInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockKontainerDriverInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *KontainerDriverInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.KontainerDriverHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("KontainerDriverInterfaceMock.AddHandlerFunc: method is nil but KontainerDriverInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.KontainerDriverHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockKontainerDriverInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockKontainerDriverInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddHandlerCalls())
func (mock *KontainerDriverInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.KontainerDriverHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.KontainerDriverHandlerFunc
	}
	lockKontainerDriverInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockKontainerDriverInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *KontainerDriverInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.KontainerDriverLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("KontainerDriverInterfaceMock.AddLifecycleFunc: method is nil but KontainerDriverInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.KontainerDriverLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockKontainerDriverInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockKontainerDriverInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.AddLifecycleCalls())
func (mock *KontainerDriverInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.KontainerDriverLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.KontainerDriverLifecycle
	}
	lockKontainerDriverInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockKontainerDriverInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *KontainerDriverInterfaceMock) Controller() v31.KontainerDriverController {
	if mock.ControllerFunc == nil {
		panic("KontainerDriverInterfaceMock.ControllerFunc: method is nil but KontainerDriverInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockKontainerDriverInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockKontainerDriverInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.ControllerCalls())
func (mock *KontainerDriverInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockKontainerDriverInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockKontainerDriverInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *KontainerDriverInterfaceMock) Create(in1 *v3.KontainerDriver) (*v3.KontainerDriver, error) {
	if mock.CreateFunc == nil {
		panic("KontainerDriverInterfaceMock.CreateFunc: method is nil but KontainerDriverInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.KontainerDriver
	}{
		In1: in1,
	}
	lockKontainerDriverInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockKontainerDriverInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.CreateCalls())
func (mock *KontainerDriverInterfaceMock) CreateCalls() []struct {
	In1 *v3.KontainerDriver
} {
	var calls []struct {
		In1 *v3.KontainerDriver
	}
	lockKontainerDriverInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockKontainerDriverInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *KontainerDriverInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("KontainerDriverInterfaceMock.DeleteFunc: method is nil but KontainerDriverInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockKontainerDriverInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockKontainerDriverInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.DeleteCalls())
func (mock *KontainerDriverInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockKontainerDriverInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockKontainerDriverInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *KontainerDriverInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("KontainerDriverInterfaceMock.DeleteCollectionFunc: method is nil but KontainerDriverInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockKontainerDriverInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockKontainerDriverInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.DeleteCollectionCalls())
func (mock *KontainerDriverInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockKontainerDriverInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockKontainerDriverInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *KontainerDriverInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("KontainerDriverInterfaceMock.DeleteNamespacedFunc: method is nil but KontainerDriverInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockKontainerDriverInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockKontainerDriverInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.DeleteNamespacedCalls())
func (mock *KontainerDriverInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockKontainerDriverInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockKontainerDriverInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *KontainerDriverInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.KontainerDriver, error) {
	if mock.GetFunc == nil {
		panic("KontainerDriverInterfaceMock.GetFunc: method is nil but KontainerDriverInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockKontainerDriverInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockKontainerDriverInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.GetCalls())
func (mock *KontainerDriverInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockKontainerDriverInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockKontainerDriverInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *KontainerDriverInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.KontainerDriver, error) {
	if mock.GetNamespacedFunc == nil {
		panic("KontainerDriverInterfaceMock.GetNamespacedFunc: method is nil but KontainerDriverInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockKontainerDriverInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockKontainerDriverInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.GetNamespacedCalls())
func (mock *KontainerDriverInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockKontainerDriverInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockKontainerDriverInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *KontainerDriverInterfaceMock) List(opts metav1.ListOptions) (*v3.KontainerDriverList, error) {
	if mock.ListFunc == nil {
		panic("KontainerDriverInterfaceMock.ListFunc: method is nil but KontainerDriverInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockKontainerDriverInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockKontainerDriverInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.ListCalls())
func (mock *KontainerDriverInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockKontainerDriverInterfaceMockList.RLock()
	calls = mock.calls.List
	lockKontainerDriverInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *KontainerDriverInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.KontainerDriverList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("KontainerDriverInterfaceMock.ListNamespacedFunc: method is nil but KontainerDriverInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockKontainerDriverInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockKontainerDriverInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.ListNamespacedCalls())
func (mock *KontainerDriverInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockKontainerDriverInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockKontainerDriverInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *KontainerDriverInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("KontainerDriverInterfaceMock.ObjectClientFunc: method is nil but KontainerDriverInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockKontainerDriverInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockKontainerDriverInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.ObjectClientCalls())
func (mock *KontainerDriverInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockKontainerDriverInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockKontainerDriverInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *KontainerDriverInterfaceMock) Update(in1 *v3.KontainerDriver) (*v3.KontainerDriver, error) {
	if mock.UpdateFunc == nil {
		panic("KontainerDriverInterfaceMock.UpdateFunc: method is nil but KontainerDriverInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.KontainerDriver
	}{
		In1: in1,
	}
	lockKontainerDriverInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockKontainerDriverInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.UpdateCalls())
func (mock *KontainerDriverInterfaceMock) UpdateCalls() []struct {
	In1 *v3.KontainerDriver
} {
	var calls []struct {
		In1 *v3.KontainerDriver
	}
	lockKontainerDriverInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockKontainerDriverInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *KontainerDriverInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("KontainerDriverInterfaceMock.WatchFunc: method is nil but KontainerDriverInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockKontainerDriverInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockKontainerDriverInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//
//	len(mockedKontainerDriverInterface.WatchCalls())
func (mock *KontainerDriverInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockKontainerDriverInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockKontainerDriverInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockKontainerDriversGetterMockKontainerDrivers sync.RWMutex
)

// Ensure, that KontainerDriversGetterMock does implement v31.KontainerDriversGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.KontainerDriversGetter = &KontainerDriversGetterMock{}

// KontainerDriversGetterMock is a mock implementation of v31.KontainerDriversGetter.
//
//	    func TestSomethingThatUsesKontainerDriversGetter(t *testing.T) {
//
//	        // make and configure a mocked v31.KontainerDriversGetter
//	        mockedKontainerDriversGetter := &KontainerDriversGetterMock{
//	            KontainerDriversFunc: func(namespace string) v31.KontainerDriverInterface {
//		               panic("mock out the KontainerDrivers method")
//	            },
//	        }
//
//	        // use mockedKontainerDriversGetter in code that requires v31.KontainerDriversGetter
//	        // and then make assertions.
//
//	    }
type KontainerDriversGetterMock struct {
	// KontainerDriversFunc mocks the KontainerDrivers method.
	KontainerDriversFunc func(namespace string) v31.KontainerDriverInterface

	// calls tracks calls to the methods.
	calls struct {
		// KontainerDrivers holds details about calls to the KontainerDrivers method.
		KontainerDrivers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// KontainerDrivers calls KontainerDriversFunc.
func (mock *KontainerDriversGetterMock) KontainerDrivers(namespace string) v31.KontainerDriverInterface {
	if mock.KontainerDriversFunc == nil {
		panic("KontainerDriversGetterMock.KontainerDriversFunc: method is nil but KontainerDriversGetter.KontainerDrivers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockKontainerDriversGetterMockKontainerDrivers.Lock()
	mock.calls.KontainerDrivers = append(mock.calls.KontainerDrivers, callInfo)
	lockKontainerDriversGetterMockKontainerDrivers.Unlock()
	return mock.KontainerDriversFunc(namespace)
}

// KontainerDriversCalls gets all the calls that were made to KontainerDrivers.
// Check the length with:
//
//	len(mockedKontainerDriversGetter.KontainerDriversCalls())
func (mock *KontainerDriversGetterMock) KontainerDriversCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockKontainerDriversGetterMockKontainerDrivers.RLock()
	calls = mock.calls.KontainerDrivers
	lockKontainerDriversGetterMockKontainerDrivers.RUnlock()
	return calls
}
